/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.impl.ui.Hyperlink;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class Group
implements KeymapGroup {
    private Group myParent;
    private final @NlsActions.ActionText String myName;
    private final String myId;
    private final Icon myIcon;
    private final ArrayList<Object> myChildren;
    private final Set<String> myIds = new HashSet<String>();

    public Group(@NlsActions.ActionText String name, String id2, Icon icon2) {
        this.myName = name;
        this.myId = id2;
        this.myIcon = icon2;
        this.myChildren = new ArrayList();
    }

    public Group(@NlsActions.ActionText String name, Icon icon2) {
        this(name, null, icon2);
    }

    @NlsActions.ActionText
    public String getName() {
        return this.myName;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public String getId() {
        return this.myId;
    }

    public void addActionId(String id2) {
        if (this.myChildren.contains(id2)) {
            return;
        }
        this.myChildren.add(id2);
    }

    public void addQuickList(QuickList list2) {
        this.myChildren.add(list2);
    }

    public void addHyperlink(Hyperlink link2) {
        this.myChildren.add(link2);
    }

    public void addGroup(KeymapGroup keymapGroup) {
        Group group2 = (Group)keymapGroup;
        if (this.myChildren.contains(group2)) {
            return;
        }
        this.myChildren.add(group2);
        group2.myParent = this;
    }

    public void addSeparator() {
        this.myChildren.add(Separator.getInstance());
    }

    public boolean containsId(String id2) {
        return this.myIds.contains(id2);
    }

    public Set<String> initIds() {
        for (Object child2 : this.myChildren) {
            if (child2 instanceof String) {
                this.myIds.add((String)child2);
                continue;
            }
            if (child2 instanceof QuickList) {
                this.myIds.add(((QuickList)child2).getActionId());
                continue;
            }
            if (!(child2 instanceof Group)) continue;
            Group childGroup = (Group)child2;
            this.myIds.addAll(childGroup.initIds());
            if (childGroup.myId == null) continue;
            this.myIds.add(childGroup.myId);
        }
        return this.myIds;
    }

    public ArrayList<Object> getChildren() {
        return this.myChildren;
    }

    public int getSize() {
        return this.myChildren.size();
    }

    public void normalizeSeparators() {
        while (this.myChildren.size() > 0 && this.myChildren.get(0) instanceof Separator) {
            this.myChildren.remove(0);
        }
        while (this.myChildren.size() > 0 && this.myChildren.get(this.myChildren.size() - 1) instanceof Separator) {
            this.myChildren.remove(this.myChildren.size() - 1);
        }
        for (int i2 = 1; i2 < this.myChildren.size() - 1; ++i2) {
            if (!(this.myChildren.get(i2) instanceof Separator) || !(this.myChildren.get(i2 + 1) instanceof Separator)) continue;
            this.myChildren.remove(i2);
            --i2;
        }
    }

    public String getActionQualifiedPath(String id2) {
        Group cur = this.myParent;
        StringBuilder answer = new StringBuilder();
        while (cur != null && !cur.isRoot()) {
            answer.insert(0, cur.getName() + " | ");
            cur = cur.myParent;
        }
        String suffix = this.calcActionQualifiedPath(id2);
        if (StringUtil.isEmpty((String)suffix)) {
            return null;
        }
        answer.append(suffix);
        return answer.toString();
    }

    private String calcActionQualifiedPath(String id2) {
        if (!this.isRoot() && StringUtil.equals((CharSequence)id2, (CharSequence)this.myId)) {
            return this.getName();
        }
        for (Object child2 : this.myChildren) {
            String path;
            if (child2 instanceof QuickList) {
                child2 = ((QuickList)child2).getActionId();
            }
            if (child2 instanceof String) {
                if (!id2.equals(child2)) continue;
                AnAction action2 = ActionManager.getInstance().getActionOrStub(id2);
                String path2 = action2 != null ? action2.getTemplatePresentation().getText() : id2;
                return !this.isRoot() ? this.getName() + " | " + path2 : path2;
            }
            if (!(child2 instanceof Group) || (path = ((Group)child2).calcActionQualifiedPath(id2)) == null) continue;
            return !this.isRoot() ? this.getName() + " | " + path : path;
        }
        return null;
    }

    public boolean isRoot() {
        return this.myParent == null;
    }

    public String getQualifiedPath() {
        StringBuilder path = new StringBuilder(64);
        Group group2 = this;
        while (group2 != null && !group2.isRoot()) {
            if (path.length() > 0) {
                path.insert(0, " | ");
            }
            path.insert(0, group2.getName());
            group2 = group2.myParent;
        }
        return path.toString();
    }

    public void addAll(Group group2) {
        for (Object o : group2.getChildren()) {
            if (o instanceof String) {
                this.addActionId((String)o);
                continue;
            }
            if (o instanceof QuickList) {
                this.addQuickList((QuickList)o);
                continue;
            }
            if (o instanceof Group) {
                this.addGroup((Group)o);
                continue;
            }
            if (!(o instanceof Separator)) continue;
            this.addSeparator();
        }
    }

    public ActionGroup constructActionGroup(boolean popup2) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group2 = new DefaultActionGroup(this.getName(), popup2);
        AnAction groupToRestorePresentation = null;
        if (this.getName() != null) {
            groupToRestorePresentation = actionManager.getAction(this.getName());
        } else if (this.getId() != null) {
            groupToRestorePresentation = actionManager.getAction(this.getId());
        }
        if (groupToRestorePresentation != null) {
            group2.copyFrom(groupToRestorePresentation);
        }
        for (Object o : this.myChildren) {
            if (o instanceof String) {
                group2.add(actionManager.getAction((String)o));
                continue;
            }
            if (o instanceof Separator) {
                group2.addSeparator();
                continue;
            }
            if (!(o instanceof Group)) continue;
            group2.add((AnAction)((Group)o).constructActionGroup(popup2));
        }
        return group2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Group)) {
            return false;
        }
        Group group2 = (Group)object;
        if (group2.getName() != null && this.getName() != null) {
            return group2.getName().equals(this.getName());
        }
        if (this.getChildren() != null && group2.getChildren() != null) {
            if (this.getChildren().size() != group2.getChildren().size()) {
                return false;
            }
            for (int i2 = 0; i2 < this.getChildren().size(); ++i2) {
                if (this.getChildren().get(i2).equals(group2.getChildren().get(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.getName() != null ? this.getName().hashCode() : 0;
    }

    public String toString() {
        return this.getName();
    }
}

