/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HistoryEntry {
    @NonNls
    static final String TAG = "entry";
    static final String FILE_ATTR = "file";
    @NonNls
    private static final String PROVIDER_ELEMENT = "provider";
    @NonNls
    private static final String EDITOR_TYPE_ID_ATTR = "editor-type-id";
    @NonNls
    private static final String SELECTED_ATTR_VALUE = "selected";
    @NonNls
    private static final String STATE_ELEMENT = "state";
    @NotNull
    private final VirtualFilePointer myFilePointer;
    private static final Element EMPTY_ELEMENT = new Element("state");
    @Nullable
    private FileEditorProvider mySelectedProvider;
    @NotNull
    private final Map<FileEditorProvider, FileEditorState> myProviderToState;
    @Nullable
    private final Disposable myDisposable;

    private HistoryEntry(@NotNull VirtualFilePointer filePointer, @Nullable FileEditorProvider selectedProvider, @Nullable Disposable disposable2) {
        if (filePointer == null) {
            HistoryEntry.$$$reportNull$$$0(0);
        }
        this.myProviderToState = CollectionFactory.createSmallMemoryFootprintMap();
        this.myFilePointer = filePointer;
        this.mySelectedProvider = selectedProvider;
        this.myDisposable = disposable2;
    }

    @NotNull
    static HistoryEntry createLight(@NotNull VirtualFile file2, FileEditorProvider @NotNull [] providers, FileEditorState @NotNull [] states, @NotNull FileEditorProvider selectedProvider) {
        if (file2 == null) {
            HistoryEntry.$$$reportNull$$$0(1);
        }
        if (selectedProvider == null) {
            HistoryEntry.$$$reportNull$$$0(2);
        }
        if (providers == null) {
            HistoryEntry.$$$reportNull$$$0(3);
        }
        if (states == null) {
            HistoryEntry.$$$reportNull$$$0(4);
        }
        LightFilePointer pointer = new LightFilePointer(file2);
        HistoryEntry entry = new HistoryEntry(pointer, selectedProvider, null);
        for (int i2 = 0; i2 < providers.length; ++i2) {
            entry.putState(providers[i2], states[i2]);
        }
        HistoryEntry historyEntry = entry;
        if (historyEntry == null) {
            HistoryEntry.$$$reportNull$$$0(5);
        }
        return historyEntry;
    }

    @NotNull
    static HistoryEntry createLight(@NotNull Project project, @NotNull Element e) throws InvalidDataException {
        if (project == null) {
            HistoryEntry.$$$reportNull$$$0(6);
        }
        if (e == null) {
            HistoryEntry.$$$reportNull$$$0(7);
        }
        EntryData entryData = HistoryEntry.parseEntry(project, e);
        LightFilePointer pointer = new LightFilePointer(entryData.url);
        HistoryEntry entry = new HistoryEntry(pointer, entryData.selectedProvider, null);
        for (Pair<FileEditorProvider, FileEditorState> state : entryData.providerStates) {
            entry.putState((FileEditorProvider)state.first, (FileEditorState)state.second);
        }
        HistoryEntry historyEntry = entry;
        if (historyEntry == null) {
            HistoryEntry.$$$reportNull$$$0(8);
        }
        return historyEntry;
    }

    @NotNull
    static HistoryEntry createHeavy(@NotNull Project project, @NotNull VirtualFile file2, FileEditorProvider @NotNull [] providers, FileEditorState @NotNull [] states, @NotNull FileEditorProvider selectedProvider) {
        if (project == null) {
            HistoryEntry.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            HistoryEntry.$$$reportNull$$$0(10);
        }
        if (selectedProvider == null) {
            HistoryEntry.$$$reportNull$$$0(11);
        }
        if (providers == null) {
            HistoryEntry.$$$reportNull$$$0(12);
        }
        if (states == null) {
            HistoryEntry.$$$reportNull$$$0(13);
        }
        if (project.isDisposed()) {
            return HistoryEntry.createLight(file2, providers, states, selectedProvider);
        }
        Disposable disposable2 = Disposer.newDisposable();
        VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(file2, disposable2, null);
        HistoryEntry entry = new HistoryEntry(pointer, selectedProvider, disposable2);
        for (int i2 = 0; i2 < providers.length; ++i2) {
            FileEditorProvider provider2 = providers[i2];
            FileEditorState state = states[i2];
            if (provider2 == null || state == null) continue;
            entry.putState(provider2, state);
        }
        HistoryEntry historyEntry = entry;
        if (historyEntry == null) {
            HistoryEntry.$$$reportNull$$$0(14);
        }
        return historyEntry;
    }

    @NotNull
    static HistoryEntry createHeavy(@NotNull Project project, @NotNull Element e) throws InvalidDataException {
        if (project == null) {
            HistoryEntry.$$$reportNull$$$0(15);
        }
        if (e == null) {
            HistoryEntry.$$$reportNull$$$0(16);
        }
        if (project.isDisposed()) {
            return HistoryEntry.createLight(project, e);
        }
        EntryData entryData = HistoryEntry.parseEntry(project, e);
        Disposable disposable2 = Disposer.newDisposable();
        VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(entryData.url, disposable2, null);
        HistoryEntry entry = new HistoryEntry(pointer, entryData.selectedProvider, disposable2);
        for (Pair<FileEditorProvider, FileEditorState> state : entryData.providerStates) {
            entry.putState((FileEditorProvider)state.first, (FileEditorState)state.second);
        }
        HistoryEntry historyEntry = entry;
        if (historyEntry == null) {
            HistoryEntry.$$$reportNull$$$0(17);
        }
        return historyEntry;
    }

    @NotNull
    public VirtualFilePointer getFilePointer() {
        VirtualFilePointer virtualFilePointer = this.myFilePointer;
        if (virtualFilePointer == null) {
            HistoryEntry.$$$reportNull$$$0(18);
        }
        return virtualFilePointer;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.myFilePointer.getFile();
    }

    public FileEditorState getState(@NotNull FileEditorProvider provider2) {
        if (provider2 == null) {
            HistoryEntry.$$$reportNull$$$0(19);
        }
        return this.myProviderToState.get(provider2);
    }

    void putState(@NotNull FileEditorProvider provider2, @NotNull FileEditorState state) {
        if (provider2 == null) {
            HistoryEntry.$$$reportNull$$$0(20);
        }
        if (state == null) {
            HistoryEntry.$$$reportNull$$$0(21);
        }
        this.myProviderToState.put(provider2, state);
    }

    @Nullable
    FileEditorProvider getSelectedProvider() {
        return this.mySelectedProvider;
    }

    void setSelectedProvider(@Nullable FileEditorProvider value2) {
        this.mySelectedProvider = value2;
    }

    public void destroy() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    @NotNull
    public Element writeExternal(@NotNull Element element2, @NotNull Project project) {
        if (element2 == null) {
            HistoryEntry.$$$reportNull$$$0(22);
        }
        if (project == null) {
            HistoryEntry.$$$reportNull$$$0(23);
        }
        Element e = new Element(TAG);
        element2.addContent(e);
        e.setAttribute(FILE_ATTR, this.myFilePointer.getUrl());
        for (Map.Entry<FileEditorProvider, FileEditorState> entry : this.myProviderToState.entrySet()) {
            Element providerElement = new Element(PROVIDER_ELEMENT);
            FileEditorProvider provider2 = entry.getKey();
            if (provider2.equals(this.mySelectedProvider)) {
                providerElement.setAttribute(SELECTED_ATTR_VALUE, Boolean.TRUE.toString());
            }
            providerElement.setAttribute(EDITOR_TYPE_ID_ATTR, provider2.getEditorTypeId());
            Element stateElement = new Element(STATE_ELEMENT);
            provider2.writeState(entry.getValue(), project, stateElement);
            if (!JDOMUtil.isEmpty((Element)stateElement)) {
                providerElement.addContent(stateElement);
            }
            e.addContent(providerElement);
        }
        Element element3 = e;
        if (element3 == null) {
            HistoryEntry.$$$reportNull$$$0(24);
        }
        return element3;
    }

    @NotNull
    private static EntryData parseEntry(@NotNull Project project, @NotNull Element e) {
        if (project == null) {
            HistoryEntry.$$$reportNull$$$0(25);
        }
        if (e == null) {
            HistoryEntry.$$$reportNull$$$0(26);
        }
        if (!e.getName().equals(TAG)) {
            throw new IllegalArgumentException("unexpected tag: " + e);
        }
        String url = e.getAttributeValue(FILE_ATTR);
        SmartList providerStates = new SmartList();
        FileEditorProvider selectedProvider = null;
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
        for (Element providerElement : e.getChildren(PROVIDER_ELEMENT)) {
            String typeId = providerElement.getAttributeValue(EDITOR_TYPE_ID_ATTR);
            FileEditorProvider provider2 = FileEditorProviderManager.getInstance().getProvider(typeId);
            if (provider2 == null) continue;
            if (Boolean.parseBoolean(providerElement.getAttributeValue(SELECTED_ATTR_VALUE))) {
                selectedProvider = provider2;
            }
            if (file2 == null) continue;
            Element stateElement = providerElement.getChild(STATE_ELEMENT);
            FileEditorState state = provider2.readState(stateElement == null ? EMPTY_ELEMENT : stateElement, project, file2);
            providerStates.add(Pair.create((Object)provider2, (Object)state));
        }
        return new EntryData(url, (List<Pair<FileEditorProvider, FileEditorState>>)providerStates, selectedProvider);
    }

    void onProviderRemoval(@NotNull FileEditorProvider provider2) {
        if (provider2 == null) {
            HistoryEntry.$$$reportNull$$$0(27);
        }
        if (this.mySelectedProvider == provider2) {
            this.mySelectedProvider = null;
        }
        this.myProviderToState.remove(provider2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 14: 
            case 17: 
            case 18: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 14: 
            case 17: 
            case 18: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointer";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = FILE_ATTR;
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedProvider";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
            case 5: 
            case 8: 
            case 14: 
            case 17: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/HistoryEntry";
                break;
            }
            case 6: 
            case 9: 
            case 15: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 16: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 19: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROVIDER_ELEMENT;
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = STATE_ELEMENT;
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/HistoryEntry";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLight";
                break;
            }
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeavy";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePointer";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "writeExternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLight";
                break;
            }
            case 5: 
            case 8: 
            case 14: 
            case 17: 
            case 18: 
            case 24: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createHeavy";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "putState";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parseEntry";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "onProviderRemoval";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 14: 
            case 17: 
            case 18: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class EntryData {
        @NotNull
        private final String url;
        @NotNull
        private final List<Pair<FileEditorProvider, FileEditorState>> providerStates;
        @Nullable
        private final FileEditorProvider selectedProvider;

        EntryData(@NotNull String url, @NotNull List<Pair<FileEditorProvider, FileEditorState>> providerStates, @Nullable FileEditorProvider selectedProvider) {
            if (url == null) {
                EntryData.$$$reportNull$$$0(0);
            }
            if (providerStates == null) {
                EntryData.$$$reportNull$$$0(1);
            }
            this.url = url;
            this.providerStates = providerStates;
            this.selectedProvider = selectedProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "url";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "providerStates";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/fileEditor/impl/HistoryEntry$EntryData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

