/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification.callback;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.settings.AbstractExternalSystemConfigurable;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenExternalSystemSettingsCallback
extends NotificationListener.Adapter {
    public static final String ID = "#open_external_system_settings";
    private final Project myProject;
    @NotNull
    private final ProjectSystemId mySystemId;
    @Nullable
    private final String myLinkedProjectPath;

    public OpenExternalSystemSettingsCallback(Project project, @NotNull ProjectSystemId systemId) {
        if (systemId == null) {
            OpenExternalSystemSettingsCallback.$$$reportNull$$$0(0);
        }
        this(project, systemId, null);
    }

    public OpenExternalSystemSettingsCallback(Project project, @NotNull ProjectSystemId systemId, @Nullable String linkedProjectPath) {
        if (systemId == null) {
            OpenExternalSystemSettingsCallback.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.mySystemId = systemId;
        this.myLinkedProjectPath = linkedProjectPath;
    }

    protected void hyperlinkActivated(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
        ExternalSystemManager manager;
        if (notification2 == null) {
            OpenExternalSystemSettingsCallback.$$$reportNull$$$0(2);
        }
        if (event == null) {
            OpenExternalSystemSettingsCallback.$$$reportNull$$$0(3);
        }
        if (this.myLinkedProjectPath == null || !((manager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.mySystemId)) instanceof ExternalSystemConfigurableAware)) {
            ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, this.mySystemId.getReadableName());
            return;
        }
        Configurable configurable2 = ((ExternalSystemConfigurableAware)manager).getConfigurable(this.myProject);
        if (configurable2 instanceof AbstractExternalSystemConfigurable) {
            ShowSettingsUtil.getInstance().editConfigurable(this.myProject, configurable2, () -> ((AbstractExternalSystemConfigurable)configurable2).selectProject(this.myLinkedProjectPath));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/notification/callback/OpenExternalSystemSettingsCallback";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hyperlinkActivated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

