/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autolink;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.externalSystem.autoimport.AsyncFileChangeListenerBase;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemProjectLinkListener;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemUnlinkedProjectAware;
import com.intellij.openapi.externalSystem.autolink.UnlinkedProjectNotificationAware;
import com.intellij.openapi.externalSystem.autolink.UnlinkedProjectStartupActivity$sam$java_util_concurrent_Callable$0;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J4\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012H\u0002J&\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0002J.\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001c*\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/externalSystem/autolink/UnlinkedProjectStartupActivity;", "Lcom/intellij/openapi/startup/StartupActivity$Background;", "()V", "backgroundExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "createExtensionDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "unlinkedProjectAware", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemUnlinkedProjectAware;", "runActivity", "", "showNotificationIfUnlinkedProjectsFound", "externalProjectPath", "", "collectBuildFiles", "Lkotlin/Function0;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "buildFiles", "", "possibleBuildFiles", "showNotificationWhenBuildToolPluginEnabled", "showNotificationWhenNewBuildFileCreated", "showNotificationWhenNonEmptyProjectUnlinked", "getBuildFiles", "", "NewBuildFilesListener", "intellij.platform.externalSystem.impl"})
public final class UnlinkedProjectStartupActivity
implements StartupActivity.Background {
    private final ExecutorService backgroundExecutor;

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = object.getPath()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.guessProjectDir()?.path ?: return");
        Object externalProjectPath = object;
        this.showNotificationWhenNonEmptyProjectUnlinked(project);
        this.showNotificationWhenBuildToolPluginEnabled(project, (String)externalProjectPath);
        this.showNotificationWhenNewBuildFileCreated(project, (String)externalProjectPath);
        if (!ExternalSystemUtil.isNewProject(project)) {
            this.showNotificationIfUnlinkedProjectsFound(project, (String)externalProjectPath);
        }
    }

    private final void showNotificationIfUnlinkedProjectsFound(Project project, String externalProjectPath) {
        ExternalSystemUnlinkedProjectAware.Companion.getEP_NAME().forEachExtensionSafe((Consumer)new Consumer<ExternalSystemUnlinkedProjectAware>(this, project, externalProjectPath){
            final /* synthetic */ UnlinkedProjectStartupActivity this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $externalProjectPath;

            public final void accept(ExternalSystemUnlinkedProjectAware it) {
                ExternalSystemUnlinkedProjectAware externalSystemUnlinkedProjectAware = it;
                Intrinsics.checkNotNullExpressionValue((Object)externalSystemUnlinkedProjectAware, (String)"it");
                UnlinkedProjectStartupActivity.access$showNotificationIfUnlinkedProjectsFound(this.this$0, this.$project, this.$externalProjectPath, externalSystemUnlinkedProjectAware);
            }
            {
                this.this$0 = unlinkedProjectStartupActivity;
                this.$project = project;
                this.$externalProjectPath = string;
            }
        });
    }

    private final void showNotificationIfUnlinkedProjectsFound(Project project, String externalProjectPath, Set<? extends VirtualFile> buildFiles) {
        ExternalSystemUnlinkedProjectAware.Companion.getEP_NAME().forEachExtensionSafe((Consumer)new Consumer<ExternalSystemUnlinkedProjectAware>(this, project, externalProjectPath, buildFiles){
            final /* synthetic */ UnlinkedProjectStartupActivity this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $externalProjectPath;
            final /* synthetic */ Set $buildFiles;

            public final void accept(ExternalSystemUnlinkedProjectAware it) {
                ExternalSystemUnlinkedProjectAware externalSystemUnlinkedProjectAware = it;
                Intrinsics.checkNotNullExpressionValue((Object)externalSystemUnlinkedProjectAware, (String)"it");
                UnlinkedProjectStartupActivity.access$showNotificationIfUnlinkedProjectsFound(this.this$0, this.$project, this.$externalProjectPath, this.$buildFiles, externalSystemUnlinkedProjectAware);
            }
            {
                this.this$0 = unlinkedProjectStartupActivity;
                this.$project = project;
                this.$externalProjectPath = string;
                this.$buildFiles = set2;
            }
        });
    }

    private final void showNotificationIfUnlinkedProjectsFound(Project project, String externalProjectPath, ExternalSystemUnlinkedProjectAware unlinkedProjectAware) {
        this.showNotificationIfUnlinkedProjectsFound(project, externalProjectPath, unlinkedProjectAware, (Function0<? extends Collection<? extends VirtualFile>>)((Function0)new Function0<Collection<? extends VirtualFile>>(this, unlinkedProjectAware, project, externalProjectPath){
            final /* synthetic */ UnlinkedProjectStartupActivity this$0;
            final /* synthetic */ ExternalSystemUnlinkedProjectAware $unlinkedProjectAware;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $externalProjectPath;

            @NotNull
            public final Collection<VirtualFile> invoke() {
                return UnlinkedProjectStartupActivity.access$getBuildFiles(this.this$0, this.$unlinkedProjectAware, this.$project, this.$externalProjectPath);
            }
            {
                this.this$0 = unlinkedProjectStartupActivity;
                this.$unlinkedProjectAware = externalSystemUnlinkedProjectAware;
                this.$project = project;
                this.$externalProjectPath = string;
                super(0);
            }
        }));
    }

    private final void showNotificationIfUnlinkedProjectsFound(Project project, String externalProjectPath, Set<? extends VirtualFile> possibleBuildFiles, ExternalSystemUnlinkedProjectAware unlinkedProjectAware) {
        this.showNotificationIfUnlinkedProjectsFound(project, externalProjectPath, unlinkedProjectAware, (Function0<? extends Collection<? extends VirtualFile>>)((Function0)new Function0<Collection<? extends VirtualFile>>(possibleBuildFiles, unlinkedProjectAware, project){
            final /* synthetic */ Set $possibleBuildFiles;
            final /* synthetic */ ExternalSystemUnlinkedProjectAware $unlinkedProjectAware;
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Collection<VirtualFile> invoke() {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.$possibleBuildFiles;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    VirtualFile it = (VirtualFile)element$iv$iv;
                    boolean bl = false;
                    if (!this.$unlinkedProjectAware.isBuildFile(this.$project, it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$possibleBuildFiles = set2;
                this.$unlinkedProjectAware = externalSystemUnlinkedProjectAware;
                this.$project = project;
                super(0);
            }
        }));
    }

    private final void showNotificationIfUnlinkedProjectsFound(Project project, String externalProjectPath, ExternalSystemUnlinkedProjectAware unlinkedProjectAware, Function0<? extends Collection<? extends VirtualFile>> collectBuildFiles) {
        Disposable extensionDisposable = this.createExtensionDisposable(project, unlinkedProjectAware);
        if (unlinkedProjectAware.isLinkedProject(project, externalProjectPath)) {
            return;
        }
        Object object = collectBuildFiles;
        if (object != null) {
            Function0<? extends Collection<? extends VirtualFile>> function0 = object;
            object = new UnlinkedProjectStartupActivity$sam$java_util_concurrent_Callable$0(function0);
        }
        ReadAction.nonBlocking((Callable)((Callable)object)).expireWith(extensionDisposable).finishOnUiThread(ModalityState.defaultModalityState(), (Consumer)new Consumer<Collection<? extends VirtualFile>>(project, unlinkedProjectAware, externalProjectPath){
            final /* synthetic */ Project $project;
            final /* synthetic */ ExternalSystemUnlinkedProjectAware $unlinkedProjectAware;
            final /* synthetic */ String $externalProjectPath;

            public final void accept(Collection<? extends VirtualFile> buildFiles) {
                Collection<? extends VirtualFile> collection = buildFiles;
                Intrinsics.checkNotNullExpressionValue(collection, (String)"buildFiles");
                Collection<? extends VirtualFile> collection2 = collection;
                boolean bl = false;
                if (!collection2.isEmpty()) {
                    UnlinkedProjectNotificationAware notificationAware = UnlinkedProjectNotificationAware.Companion.getInstance(this.$project);
                    notificationAware.notify(this.$unlinkedProjectAware, this.$externalProjectPath);
                }
            }
            {
                this.$project = project;
                this.$unlinkedProjectAware = externalSystemUnlinkedProjectAware;
                this.$externalProjectPath = string;
            }
        }).submit((Executor)this.backgroundExecutor);
    }

    private final void showNotificationWhenNonEmptyProjectUnlinked(Project project) {
        ExternalSystemUnlinkedProjectAware.Companion.getEP_NAME().forEachExtensionSafe((Consumer)new Consumer<ExternalSystemUnlinkedProjectAware>(this, project){
            final /* synthetic */ UnlinkedProjectStartupActivity this$0;
            final /* synthetic */ Project $project;

            public final void accept(ExternalSystemUnlinkedProjectAware it) {
                ExternalSystemUnlinkedProjectAware externalSystemUnlinkedProjectAware = it;
                Intrinsics.checkNotNullExpressionValue((Object)externalSystemUnlinkedProjectAware, (String)"it");
                UnlinkedProjectStartupActivity.access$showNotificationWhenNonEmptyProjectUnlinked(this.this$0, this.$project, externalSystemUnlinkedProjectAware);
            }
            {
                this.this$0 = unlinkedProjectStartupActivity;
                this.$project = project;
            }
        });
        ExternalSystemUnlinkedProjectAware.Companion.getEP_NAME().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ExternalSystemUnlinkedProjectAware>(this, project){
            final /* synthetic */ UnlinkedProjectStartupActivity this$0;
            final /* synthetic */ Project $project;

            public void extensionAdded(@NotNull ExternalSystemUnlinkedProjectAware extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                UnlinkedProjectStartupActivity.access$showNotificationWhenNonEmptyProjectUnlinked(this.this$0, this.$project, extension);
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
            }
        }, (Disposable)project);
    }

    private final void showNotificationWhenNonEmptyProjectUnlinked(Project project, ExternalSystemUnlinkedProjectAware unlinkedProjectAware) {
        Disposable extensionDisposable = this.createExtensionDisposable(project, unlinkedProjectAware);
        unlinkedProjectAware.subscribe(project, new ExternalSystemProjectLinkListener(this, project){
            final /* synthetic */ UnlinkedProjectStartupActivity this$0;
            final /* synthetic */ Project $project;

            public void onProjectUnlinked(@NotNull String externalProjectPath) {
                Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
                UnlinkedProjectStartupActivity.access$showNotificationIfUnlinkedProjectsFound(this.this$0, this.$project, externalProjectPath);
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
            }

            public void onProjectLinked(@NotNull String externalProjectPath) {
                Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
                ExternalSystemProjectLinkListener.DefaultImpls.onProjectLinked((ExternalSystemProjectLinkListener)this, (String)externalProjectPath);
            }
        }, extensionDisposable);
    }

    private final void showNotificationWhenBuildToolPluginEnabled(Project project, String externalProjectPath) {
        ExternalSystemUnlinkedProjectAware.Companion.getEP_NAME().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ExternalSystemUnlinkedProjectAware>(this, project, externalProjectPath){
            final /* synthetic */ UnlinkedProjectStartupActivity this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $externalProjectPath;

            public void extensionAdded(@NotNull ExternalSystemUnlinkedProjectAware extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                UnlinkedProjectStartupActivity.access$showNotificationIfUnlinkedProjectsFound(this.this$0, this.$project, this.$externalProjectPath, extension);
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
                this.$externalProjectPath = $captured_local_variable$2;
            }
        }, (Disposable)project);
    }

    private final void showNotificationWhenNewBuildFileCreated(Project project, String externalProjectPath) {
        NewBuildFilesListener asyncNewFilesListener = new NewBuildFilesListener(project, externalProjectPath);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
        VirtualFileManager fileManager = virtualFileManager;
        fileManager.addAsyncFileListener((AsyncFileListener)asyncNewFilesListener, (Disposable)project);
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> getBuildFiles(ExternalSystemUnlinkedProjectAware $this$getBuildFiles, Project project, String externalProjectPath) {
        void $this$filterTo$iv$iv;
        LocalFileSystem localFilesSystem = LocalFileSystem.getInstance();
        VirtualFile externalProjectDir = localFilesSystem.findFileByPath(externalProjectPath);
        if (externalProjectDir == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile[] virtualFileArray = externalProjectDir.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"externalProjectDir.children");
        VirtualFile[] $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var11_11 = $this$filterTo$iv$iv;
        int n = ((void)var11_11).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var11_11[j];
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            if (!$this$getBuildFiles.isBuildFile(project, (VirtualFile)v1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Disposable createExtensionDisposable(Project project, ExternalSystemUnlinkedProjectAware unlinkedProjectAware) {
        Disposable disposable2 = ExtensionPointUtil.createExtensionDisposable((Object)unlinkedProjectAware, (ExtensionPointName)ExternalSystemUnlinkedProjectAware.Companion.getEP_NAME());
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"ExtensionPointUtil.creat\u2026kedProjectAware, EP_NAME)");
        Disposable disposable3 = disposable2;
        boolean bl = false;
        boolean bl2 = false;
        Disposable it = disposable3;
        boolean bl3 = false;
        Disposer.register((Disposable)((Disposable)project), (Disposable)it);
        return disposable3;
    }

    public UnlinkedProjectStartupActivity() {
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"UnlinkedProjectTracker.backgroundExecutor", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"AppExecutorUtil.createBo\u2026r.backgroundExecutor\", 1)");
        this.backgroundExecutor = executorService;
    }

    public static final /* synthetic */ void access$showNotificationIfUnlinkedProjectsFound(UnlinkedProjectStartupActivity $this, Project project, String externalProjectPath, ExternalSystemUnlinkedProjectAware unlinkedProjectAware) {
        $this.showNotificationIfUnlinkedProjectsFound(project, externalProjectPath, unlinkedProjectAware);
    }

    public static final /* synthetic */ void access$showNotificationIfUnlinkedProjectsFound(UnlinkedProjectStartupActivity $this, Project project, String externalProjectPath, Set possibleBuildFiles, ExternalSystemUnlinkedProjectAware unlinkedProjectAware) {
        $this.showNotificationIfUnlinkedProjectsFound(project, externalProjectPath, possibleBuildFiles, unlinkedProjectAware);
    }

    public static final /* synthetic */ List access$getBuildFiles(UnlinkedProjectStartupActivity $this, ExternalSystemUnlinkedProjectAware $this$access_u24getBuildFiles, Project project, String externalProjectPath) {
        return $this.getBuildFiles($this$access_u24getBuildFiles, project, externalProjectPath);
    }

    public static final /* synthetic */ void access$showNotificationWhenNonEmptyProjectUnlinked(UnlinkedProjectStartupActivity $this, Project project, ExternalSystemUnlinkedProjectAware unlinkedProjectAware) {
        $this.showNotificationWhenNonEmptyProjectUnlinked(project, unlinkedProjectAware);
    }

    public static final /* synthetic */ void access$showNotificationIfUnlinkedProjectsFound(UnlinkedProjectStartupActivity $this, Project project, String externalProjectPath) {
        $this.showNotificationIfUnlinkedProjectsFound(project, externalProjectPath);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/externalSystem/autolink/UnlinkedProjectStartupActivity$NewBuildFilesListener;", "Lcom/intellij/openapi/externalSystem/autoimport/AsyncFileChangeListenerBase;", "project", "Lcom/intellij/openapi/project/Project;", "externalProjectPath", "", "(Lcom/intellij/openapi/externalSystem/autolink/UnlinkedProjectStartupActivity;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "buildFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "apply", "", "init", "isRelevant", "", "file", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "updateFile", "intellij.platform.externalSystem.impl"})
    public final class NewBuildFilesListener
    extends AsyncFileChangeListenerBase {
        private Set<VirtualFile> buildFiles;
        private final Project project;
        private final String externalProjectPath;

        @Override
        protected void init() {
            this.buildFiles = new HashSet();
        }

        @Override
        protected void apply() {
            Set<VirtualFile> set2 = this.buildFiles;
            if (set2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buildFiles");
            }
            if (set2.isEmpty()) {
                return;
            }
            Set<VirtualFile> set3 = this.buildFiles;
            if (set3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buildFiles");
            }
            UnlinkedProjectStartupActivity.this.showNotificationIfUnlinkedProjectsFound(this.project, this.externalProjectPath, set3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean isRelevant(@NotNull VirtualFile file2, @NotNull VFileEvent event) {
            ExternalSystemUnlinkedProjectAware it;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!(event instanceof VFileCreateEvent)) return false;
            if (!FileUtil.pathsEqual((String)PathUtil.getParentPath((String)file2.getPath()), (String)this.externalProjectPath)) return false;
            List list2 = ExternalSystemUnlinkedProjectAware.Companion.getEP_NAME().getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"EP_NAME.extensionList");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (ExternalSystemUnlinkedProjectAware)element$iv;
                boolean bl = false;
            } while (!it.isBuildFile(this.project, file2));
            return true;
        }

        @Override
        protected void updateFile(@NotNull VirtualFile file2, @NotNull VFileEvent event) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Set<VirtualFile> set2 = this.buildFiles;
            if (set2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buildFiles");
            }
            set2.add(file2);
        }

        public NewBuildFilesListener(@NotNull Project project, String externalProjectPath) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
            this.project = project;
            this.externalProjectPath = externalProjectPath;
        }
    }
}

