/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.BundleBase;
import com.intellij.CommonBundle;
import com.intellij.codeWithMe.ClientId;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.EventWatcher;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.LockKind;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ApplicationActivationStateManager;
import com.intellij.ide.BootstrapBundle;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.ApplicationLoader;
import com.intellij.idea.Main;
import com.intellij.idea.StartupUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityInvokator;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.application.impl.AWTExceptionHandler;
import com.intellij.openapi.application.impl.AnyModalityState;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityInvokatorImpl;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.application.impl.NoSwingUnderWriteAction;
import com.intellij.openapi.application.impl.ReadMostlyRWLock;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressResult;
import com.intellij.openapi.progress.impl.ProgressRunner;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.BitUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PausesStat;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.Restarter;
import com.intellij.util.RunnableCallable;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.containers.Stack;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.EdtInvocationManager;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import sun.awt.AWTAccessor;
import sun.awt.AWTAutoShutdown;

public class ApplicationImpl
extends ComponentManagerImpl
implements ApplicationEx {
    private static final Logger LOG = Logger.getInstance(ApplicationImpl.class);
    public static final boolean USE_SEPARATE_WRITE_THREAD = StartupUtil.isUsingSeparateWriteThread();
    final ReadMostlyRWLock myLock;
    private final ModalityInvokator myInvokator = new ModalityInvokatorImpl();
    private final EventDispatcher<ApplicationListener> myDispatcher = EventDispatcher.create(ApplicationListener.class);
    private final boolean myTestModeFlag;
    private final boolean myHeadlessMode;
    private final boolean myCommandLineMode;
    private final boolean myIsInternal;
    private final Stack<Class<?>> myWriteActionsStack = new Stack();
    private final TransactionGuardImpl myTransactionGuard = new TransactionGuardImpl();
    private int myWriteStackBase;
    private final long myStartTime = System.currentTimeMillis();
    private boolean mySaveAllowed;
    private volatile boolean myExitInProgress;
    private final Disposable myLastDisposable = Disposer.newDisposable();
    private static final int ourDumpThreadsOnLongWriteActionWaiting = Integer.getInteger("dump.threads.on.long.write.action.waiting", 0);
    private final ExecutorService ourThreadExecutorsService = AppExecutorUtil.getAppExecutorService();
    private static final String WAS_EVER_SHOWN = "was.ever.shown";
    private volatile boolean myWriteActionPending;
    private final boolean gatherStatistics;

    private static void lockAcquired(@NotNull Class<?> invokedClass, @NotNull LockKind lockKind) {
        if (invokedClass == null) {
            ApplicationImpl.$$$reportNull$$$0(0);
        }
        if (lockKind == null) {
            ApplicationImpl.$$$reportNull$$$0(1);
        }
        ApplicationImpl.lockAcquired(invokedClass.getName(), lockKind);
    }

    private static void lockAcquired(@NotNull String invokedClassFqn, @NotNull LockKind lockKind) {
        EventWatcher watcher;
        if (invokedClassFqn == null) {
            ApplicationImpl.$$$reportNull$$$0(2);
        }
        if (lockKind == null) {
            ApplicationImpl.$$$reportNull$$$0(3);
        }
        if ((watcher = EventWatcher.getInstance()) != null) {
            watcher.lockAcquired(invokedClassFqn, lockKind);
        }
    }

    public ApplicationImpl(boolean isInternal, boolean isUnitTestMode, boolean isHeadless, boolean isCommandLine) {
        super(null);
        ApplicationManager.setApplication((Application)this, (Disposable)this.myLastDisposable);
        this.registerServiceInstance(TransactionGuard.class, (Object)this.myTransactionGuard, (PluginDescriptor)ComponentManagerImpl.getFakeCorePluginDescriptor());
        this.registerServiceInstance(ApplicationInfo.class, (Object)ApplicationInfoImpl.getShadowInstance(), (PluginDescriptor)ComponentManagerImpl.getFakeCorePluginDescriptor());
        this.registerServiceInstance(Application.class, this, (PluginDescriptor)ComponentManagerImpl.getFakeCorePluginDescriptor());
        boolean strictMode = isUnitTestMode || isInternal;
        BundleBase.assertOnMissedKeys((boolean)strictMode);
        AWTExceptionHandler.register();
        Disposer.setDebugMode((isInternal || isUnitTestMode || Disposer.isDebugDisposerOn() ? 1 : 0) != 0);
        this.myIsInternal = isInternal;
        this.myTestModeFlag = isUnitTestMode;
        this.myHeadlessMode = isHeadless;
        this.myCommandLineMode = isCommandLine;
        boolean bl = this.mySaveAllowed = !isUnitTestMode && !isHeadless;
        if (!isUnitTestMode && !isHeadless) {
            Disposer.register((Disposable)this, (Disposable)Disposer.newDisposable(), (String)"ui");
        }
        this.gatherStatistics = LOG.isDebugEnabled() || this.isUnitTestMode() || this.isInternal();
        Activity activity = StartUpMeasurer.startActivity((String)"AppDelayQueue instantiation");
        Runnable runnable2 = () -> {
            AppScheduledExecutorService service = (AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService();
            Thread thread = service.getPeriodicTasksThread();
            AWTAutoShutdown.getInstance().notifyThreadBusy(thread);
            Disposer.register((Disposable)this, () -> AWTAutoShutdown.getInstance().notifyThreadFree(thread));
        };
        EdtInvocationManager.invokeAndWaitIfNeeded((Runnable)runnable2);
        this.myLock = new ReadMostlyRWLock();
        if (!USE_SEPARATE_WRITE_THREAD || isUnitTestMode) {
            EdtInvocationManager.invokeAndWaitIfNeeded(() -> this.acquireWriteIntentLock(this.getClass()));
        }
        activity.end();
        NoSwingUnderWriteAction.watchForEvents(this);
    }

    @Override
    public void executeByImpatientReader(@NotNull Runnable runnable2) throws ApplicationUtil.CannotRunReadActionException {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(4);
        }
        if (this.isDispatchThread()) {
            runnable2.run();
        } else {
            this.myLock.executeByImpatientReader(runnable2);
        }
    }

    @Override
    public boolean isInImpatientReader() {
        return this.myLock.isInImpatientReader();
    }

    @TestOnly
    public void disposeContainer() {
        this.runWriteAction(() -> {
            this.startDispose();
            Disposer.dispose((Disposable)this);
        });
        Disposer.assertIsEmpty();
    }

    private boolean disposeSelf(boolean checkCanCloseProject) {
        ProjectManagerEx manager = ProjectManagerEx.getInstanceExIfCreated();
        if (manager != null) {
            try {
                if (!manager.closeAndDisposeAllProjects(checkCanCloseProject)) {
                    return false;
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        this.disposeContainer();
        return true;
    }

    @Override
    public boolean holdsReadLock() {
        return this.myLock.isReadLockedByThisThread();
    }

    public boolean isInternal() {
        return this.myIsInternal;
    }

    public boolean isEAP() {
        return ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    public boolean isUnitTestMode() {
        return this.myTestModeFlag;
    }

    public boolean isHeadlessEnvironment() {
        return this.myHeadlessMode;
    }

    public boolean isCommandLine() {
        return this.myCommandLineMode;
    }

    public final boolean isLightEditMode() {
        return Main.isLightEdit();
    }

    @NotNull
    public Future<?> executeOnPooledThread(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(5);
        }
        Future future2 = this.executeOnPooledThread((Callable)new RunnableCallable(action2));
        if (future2 == null) {
            ApplicationImpl.$$$reportNull$$$0(6);
        }
        return future2;
    }

    @NotNull
    public <T> Future<T> executeOnPooledThread(final @NotNull Callable<T> action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(7);
        }
        final Callable actionDecorated = ClientId.decorateCallable(action2);
        Future future2 = this.ourThreadExecutorsService.submit(new Callable<T>(){

            @Override
            public T call() {
                if (ApplicationImpl.this.isDisposed()) {
                    return null;
                }
                try {
                    Object v = actionDecorated.call();
                    return v;
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
                finally {
                    Thread.interrupted();
                }
                return null;
            }

            public String toString() {
                return action2.toString();
            }
        });
        if (future2 == null) {
            ApplicationImpl.$$$reportNull$$$0(8);
        }
        return future2;
    }

    public boolean isDispatchThread() {
        return this.isWriteThread() && EDT.isCurrentThreadEdt();
    }

    public boolean isWriteThread() {
        return this.myLock.isWriteThread();
    }

    @NotNull
    public ModalityInvokator getInvokator() {
        ModalityInvokator modalityInvokator = this.myInvokator;
        if (modalityInvokator == null) {
            ApplicationImpl.$$$reportNull$$$0(9);
        }
        return modalityInvokator;
    }

    public void invokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(10);
        }
        this.invokeLater(runnable2, this.getDisposed());
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull Condition<?> expired) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(11);
        }
        if (expired == null) {
            ApplicationImpl.$$$reportNull$$$0(12);
        }
        this.invokeLater(runnable2, ModalityState.defaultModalityState(), expired);
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState state) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(13);
        }
        if (state == null) {
            ApplicationImpl.$$$reportNull$$$0(14);
        }
        this.invokeLater(runnable2, state, this.getDisposed());
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState state, @NotNull Condition<?> expired) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(15);
        }
        if (state == null) {
            ApplicationImpl.$$$reportNull$$$0(16);
        }
        if (expired == null) {
            ApplicationImpl.$$$reportNull$$$0(17);
        }
        Runnable r = this.myTransactionGuard.wrapLaterInvocation(runnable2, state);
        LaterInvocator.invokeLaterWithCallback(() -> this.runIntendedWriteActionOnCurrentThread(r), state, expired, null, true);
    }

    @Override
    public final void load() {
        List<IdeaPluginDescriptorImpl> plugins = PluginManagerCore.getLoadedPlugins(null);
        this.registerComponents(plugins, null);
        ApplicationLoader.initConfigurationStore(this);
        Executor executor = ApplicationLoader.createExecutorToPreloadServices();
        this.preloadServices(plugins, executor, false).getSyncPreloadedServices().join();
        this.loadComponents(null);
        ApplicationLoader.callAppInitialized(this, executor).join();
    }

    @ApiStatus.Internal
    public final void loadComponents(@Nullable ProgressIndicator indicator) {
        AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Loading application components");
        try {
            if (indicator == null) {
                this.createComponents(null);
            } else {
                ProgressManager.getInstance().runProcess(() -> this.createComponents(indicator), indicator);
            }
            StartUpMeasurer.setCurrentState((LoadingState)LoadingState.COMPONENTS_LOADED);
        }
        finally {
            token.finish();
        }
    }

    public void dispose() {
        ((ApplicationListener)this.myDispatcher.getMulticaster()).applicationExiting();
        ShutDownTracker.getInstance().ensureStopperThreadsFinished();
        super.dispose();
        if (!USE_SEPARATE_WRITE_THREAD || this.isUnitTestMode()) {
            this.invokeLater(() -> this.releaseWriteIntentLock(), ModalityState.NON_MODAL);
        }
        AppScheduledExecutorService service = (AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService();
        service.shutdownAppScheduledExecutorService();
        Disposer.dispose((Disposable)this.myLastDisposable);
        if (this.gatherStatistics) {
            LOG.info(this.writeActionStatistics());
            LOG.info(ActionUtil.ActionPauses.STAT.statistics());
            LOG.info(service.statistics() + "; ProcessIOExecutorService threads: " + ((ProcessIOExecutorService)ProcessIOExecutorService.INSTANCE).getThreadCounter());
        }
    }

    @TestOnly
    @NotNull
    public String writeActionStatistics() {
        String string = ActionPauses.WRITE.statistics();
        if (string == null) {
            ApplicationImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull String progressTitle2, boolean canBeCanceled, boolean shouldShowModalWindow, @Nullable Project project, JComponent parentComponent, String cancelText) {
        if (process2 == null) {
            ApplicationImpl.$$$reportNull$$$0(19);
        }
        if (progressTitle2 == null) {
            ApplicationImpl.$$$reportNull$$$0(20);
        }
        if (this.isDispatchThread() && this.isWriteAccessAllowed()) {
            LOG.debug("Starting process with progress from within write action makes no sense");
            try {
                ProgressManager.getInstance().runProcess(process2, (ProgressIndicator)new EmptyProgressIndicator());
            }
            catch (ProcessCanceledException e) {
                return false;
            }
            return true;
        }
        CompletableFuture<ProgressWindow> progress2 = this.createProgressWindowAsyncIfNeeded(progressTitle2, canBeCanceled, shouldShowModalWindow, project, parentComponent, cancelText);
        ProgressRunner progressRunner = new ProgressRunner(process2).sync().onThread(ProgressRunner.ThreadToUse.POOLED).modal().withProgress(progress2);
        ProgressResult result2 = progressRunner.submitAndGet();
        Throwable exception = result2.getThrowable();
        if (!(exception instanceof ProcessCanceledException)) {
            ExceptionUtil.rethrowUnchecked((Throwable)exception);
        }
        return !result2.isCanceled();
    }

    @Override
    public boolean runProcessWithProgressSynchronouslyInReadAction(@Nullable Project project, @NotNull @NlsContexts.ProgressTitle String progressTitle2, boolean canBeCanceled, @NlsContexts.Button String cancelText, JComponent parentComponent, @NotNull Runnable process2) {
        boolean writeAccessAllowed;
        if (progressTitle2 == null) {
            ApplicationImpl.$$$reportNull$$$0(21);
        }
        if (process2 == null) {
            ApplicationImpl.$$$reportNull$$$0(22);
        }
        if (writeAccessAllowed = this.isWriteAccessAllowed()) {
            throw new IncorrectOperationException("Starting process with progress from within write action makes no sense");
        }
        CompletableFuture<ProgressWindow> progress2 = this.createProgressWindowAsyncIfNeeded(progressTitle2, canBeCanceled, true, project, parentComponent, cancelText);
        ProgressResult result2 = new ProgressRunner(() -> this.runReadAction(process2)).sync().onThread(ProgressRunner.ThreadToUse.POOLED).withProgress(progress2).modal().submitAndGet();
        return !result2.isCanceled();
    }

    public void invokeAndWait(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(23);
        }
        if (modalityState == null) {
            ApplicationImpl.$$$reportNull$$$0(24);
        }
        if (this.isDispatchThread()) {
            runnable2.run();
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.runIntendedWriteActionOnCurrentThread(runnable2);
            return;
        }
        if (this.holdsReadLock()) {
            throw new IllegalStateException("Calling invokeAndWait from read-action leads to possible deadlock.");
        }
        Runnable r = this.myTransactionGuard.wrapLaterInvocation(runnable2, modalityState);
        LaterInvocator.invokeAndWait(() -> this.runIntendedWriteActionOnCurrentThread(r), modalityState, true);
    }

    public void invokeAndWait(@NotNull Runnable runnable2) throws ProcessCanceledException {
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(25);
        }
        this.invokeAndWait(runnable2, ModalityState.defaultModalityState());
    }

    @NotNull
    public ModalityState getCurrentModalityState() {
        ModalityStateEx modalityStateEx = LaterInvocator.getCurrentModalityState();
        if (modalityStateEx == null) {
            ApplicationImpl.$$$reportNull$$$0(26);
        }
        return modalityStateEx;
    }

    @NotNull
    public ModalityState getModalityStateForComponent(@NotNull Component c) {
        Window window;
        if (c == null) {
            ApplicationImpl.$$$reportNull$$$0(27);
        }
        if ((window = ComponentUtil.getWindow((Component)c)) == null) {
            ModalityState modalityState = this.getNoneModalityState();
            if (modalityState == null) {
                ApplicationImpl.$$$reportNull$$$0(28);
            }
            return modalityState;
        }
        ModalityStateEx modalityStateEx = LaterInvocator.modalityStateForWindow(window);
        if (modalityStateEx == null) {
            ApplicationImpl.$$$reportNull$$$0(29);
        }
        return modalityStateEx;
    }

    @NotNull
    public ModalityState getAnyModalityState() {
        AnyModalityState anyModalityState = AnyModalityState.ANY;
        if (anyModalityState == null) {
            ApplicationImpl.$$$reportNull$$$0(30);
        }
        return anyModalityState;
    }

    @NotNull
    public ModalityState getDefaultModalityState() {
        ModalityState modalityState = this.isDispatchThread() ? this.getCurrentModalityState() : CoreProgressManager.getCurrentThreadProgressModality();
        if (modalityState == null) {
            ApplicationImpl.$$$reportNull$$$0(31);
        }
        return modalityState;
    }

    @NotNull
    public ModalityState getNoneModalityState() {
        ModalityState modalityState = ModalityState.NON_MODAL;
        if (modalityState == null) {
            ApplicationImpl.$$$reportNull$$$0(32);
        }
        return modalityState;
    }

    public long getStartTime() {
        return this.myStartTime;
    }

    public long getIdleTime() {
        return IdeEventQueue.getInstance().getIdleTime();
    }

    @Override
    public final void restart(boolean exitConfirmed) {
        int flags = 4;
        if (exitConfirmed) {
            flags |= 2;
        }
        this.exit(flags, true, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    @Override
    public final void restart(boolean exitConfirmed, boolean elevate) {
        int flags = 4;
        if (exitConfirmed) {
            flags |= 2;
        }
        if (elevate) {
            flags |= 8;
        }
        this.exit(flags, true, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public final void exit(boolean force, boolean exitConfirmed, boolean restart) {
        int flags = 4;
        if (force) {
            flags |= 1;
        }
        if (exitConfirmed) {
            flags |= 2;
        }
        this.exit(flags, restart, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public void restart(int flags, String @NotNull [] beforeRestart) {
        if (beforeRestart == null) {
            ApplicationImpl.$$$reportNull$$$0(33);
        }
        this.exit(flags, true, beforeRestart);
    }

    @Override
    public final void exit(int flags) {
        this.exit(flags, false, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    private void exit(int flags, boolean restart, String @NotNull [] beforeRestart) {
        if (beforeRestart == null) {
            ApplicationImpl.$$$reportNull$$$0(34);
        }
        if (!BitUtil.isSet((int)flags, (int)1) && (this.myExitInProgress || !BitUtil.isSet((int)flags, (int)2) && this.getDefaultModalityState() != ModalityState.NON_MODAL)) {
            return;
        }
        this.myExitInProgress = true;
        if (this.isDispatchThread()) {
            this.doExit(flags, restart, beforeRestart);
        } else {
            this.invokeLater(() -> this.doExit(flags, restart, beforeRestart), ModalityState.NON_MODAL);
        }
    }

    @Override
    public final boolean isExitInProgress() {
        return this.myExitInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExit(int flags, boolean restart, String[] beforeRestart) {
        boolean force = BitUtil.isSet((int)flags, (int)1);
        try {
            boolean success;
            if (!force && !ApplicationImpl.confirmExitIfNeeded(BitUtil.isSet((int)flags, (int)2))) {
                return;
            }
            AppLifecycleListener lifecycleListener = (AppLifecycleListener)this.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC);
            lifecycleListener.appClosing();
            if (!force && !this.canExit()) {
                return;
            }
            this.stopServicePreloading();
            if (ApplicationImpl.isInstantShutdownPossible()) {
                for (Frame frame : Frame.getFrames()) {
                    frame.setVisible(false);
                }
            }
            lifecycleListener.appWillBeClosed(restart);
            LifecycleUsageTriggerCollector.onIdeClose(restart);
            if (BitUtil.isSet((int)flags, (int)4)) {
                SaveAndSyncHandler.getInstance().saveSettingsUnderModalProgress((ComponentManager)this);
            }
            if (!(success = this.disposeSelf(!force)) || this.isUnitTestMode() || Boolean.getBoolean("idea.test.guimode")) {
                if (Boolean.getBoolean("idea.test.guimode")) {
                    ApplicationImpl.shutdown();
                }
                return;
            }
            int exitCode = 0;
            if (restart && Restarter.isSupported()) {
                try {
                    Restarter.scheduleRestart(BitUtil.isSet((int)flags, (int)8), beforeRestart);
                }
                catch (Throwable t) {
                    LOG.error("Restart failed", t);
                    Main.showMessage((String)BootstrapBundle.message((String)"restart.failed.title", (Object[])new Object[0]), (Throwable)t);
                    exitCode = 2;
                }
            }
            System.exit(exitCode);
        }
        finally {
            this.myExitInProgress = false;
        }
    }

    private static boolean isInstantShutdownPossible() {
        if (!Registry.is((String)"ide.instant.shutdown")) {
            return false;
        }
        return !ProgressManager.getInstance().hasProgressIndicator();
    }

    @NotNull
    private CompletableFuture<ProgressWindow> createProgressWindowAsyncIfNeeded(@NotNull @NlsContexts.ProgressTitle String progressTitle2, boolean canBeCanceled, boolean shouldShowModalWindow, @Nullable Project project, JComponent parentComponent, @NlsContexts.Button String cancelText) {
        if (progressTitle2 == null) {
            ApplicationImpl.$$$reportNull$$$0(35);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            CompletableFuture<ProgressWindow> completableFuture = CompletableFuture.completedFuture(this.createProgressWindow(progressTitle2, canBeCanceled, shouldShowModalWindow, project, parentComponent, cancelText));
            if (completableFuture == null) {
                ApplicationImpl.$$$reportNull$$$0(36);
            }
            return completableFuture;
        }
        CompletableFuture<ProgressWindow> completableFuture = CompletableFuture.supplyAsync(() -> this.createProgressWindow(progressTitle2, canBeCanceled, shouldShowModalWindow, project, parentComponent, cancelText), this::invokeLater);
        if (completableFuture == null) {
            ApplicationImpl.$$$reportNull$$$0(37);
        }
        return completableFuture;
    }

    @NotNull
    private ProgressWindow createProgressWindow(@NotNull @NlsContexts.ProgressTitle String progressTitle2, boolean canBeCanceled, boolean shouldShowModalWindow, @Nullable Project project, JComponent parentComponent, @NlsContexts.Button String cancelText) {
        if (progressTitle2 == null) {
            ApplicationImpl.$$$reportNull$$$0(38);
        }
        ProgressWindow progress2 = new ProgressWindow(canBeCanceled, !shouldShowModalWindow, project, parentComponent, cancelText);
        Disposer.register((Disposable)this, (Disposable)progress2);
        progress2.setTitle(progressTitle2);
        ProgressWindow progressWindow = progress2;
        if (progressWindow == null) {
            ApplicationImpl.$$$reportNull$$$0(39);
        }
        return progressWindow;
    }

    private static void shutdown() {
        IdeEventQueue.applicationClose();
        ShutDownTracker.getInstance().run();
    }

    private static boolean confirmExitIfNeeded(boolean exitConfirmed) {
        final boolean hasUnsafeBgTasks = ProgressManager.getInstance().hasUnsafeProgressIndicator();
        if (exitConfirmed && !hasUnsafeBgTasks) {
            return true;
        }
        DialogWrapper.DoNotAskOption option2 = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return GeneralSettings.getInstance().isConfirmExit() && ProjectManager.getInstance().getOpenProjects().length > 0;
            }

            public void setToBeShown(boolean value2, int exitCode) {
                GeneralSettings.getInstance().setConfirmExit(value2);
            }

            public boolean canBeHidden() {
                return !hasUnsafeBgTasks;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = IdeBundle.message((String)"do.not.ask.me.again", (Object[])new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl$2", "getDoNotShowMessage"));
            }
        };
        if (!hasUnsafeBgTasks && !option2.isToBeShown()) {
            return true;
        }
        final AtomicBoolean alreadyGone = new AtomicBoolean(false);
        if (hasUnsafeBgTasks) {
            final Runnable dialogRemover = Messages.createMessageDialogRemover(null);
            Runnable task2 = new Runnable(){

                @Override
                public void run() {
                    if (alreadyGone.get()) {
                        return;
                    }
                    if (!ProgressManager.getInstance().hasUnsafeProgressIndicator()) {
                        alreadyGone.set(true);
                        dialogRemover.run();
                    } else {
                        AppExecutorUtil.getAppScheduledExecutorService().schedule(this, 1L, TimeUnit.SECONDS);
                    }
                }
            };
            AppExecutorUtil.getAppScheduledExecutorService().schedule(task2, 1L, TimeUnit.SECONDS);
        }
        String message = ApplicationBundle.message((String)(hasUnsafeBgTasks ? "exit.confirm.prompt.tasks" : "exit.confirm.prompt"), (Object[])new Object[0]);
        exitConfirmed = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)ApplicationBundle.message((String)"exit.confirm.title", (Object[])new Object[0]), (String)message).yesText(ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]))).noText(CommonBundle.getCancelButtonText())).doNotAsk(option2)).guessWindowAndAsk();
        if (alreadyGone.getAndSet(true)) {
            if (!option2.isToBeShown()) {
                return true;
            }
            exitConfirmed = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)ApplicationBundle.message((String)"exit.confirm.title", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"exit.confirm.prompt", (Object[])new Object[0])).yesText(ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]))).doNotAsk(option2)).guessWindowAndAsk();
        }
        return exitConfirmed;
    }

    private boolean canExit() {
        Project[] projects;
        for (ApplicationListener applicationListener : this.myDispatcher.getListeners()) {
            if (applicationListener.canExitApplication()) continue;
            return false;
        }
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceExIfCreated();
        if (projectManager == null) {
            return true;
        }
        for (Project project : projects = projectManager.getOpenProjects()) {
            if (projectManager.canClose(project)) continue;
            return false;
        }
        return true;
    }

    public ThreeState isCurrentWriteOnEdt() {
        Thread writeThread = this.myLock.writeThread;
        if (writeThread == null) {
            return ThreeState.UNSURE;
        }
        if (EDT.isEdt((Thread)writeThread)) {
            return ThreeState.YES;
        }
        return ThreeState.NO;
    }

    public void invokeLaterOnWriteThread(Runnable action2, ModalityState modal) {
        this.invokeLaterOnWriteThread(action2, modal, this.getDisposed());
    }

    public void invokeLaterOnWriteThread(Runnable action2, ModalityState modal, @NotNull Condition<?> expired) {
        if (expired == null) {
            ApplicationImpl.$$$reportNull$$$0(40);
        }
        Runnable r = this.myTransactionGuard.wrapLaterInvocation(action2, modal);
        LaterInvocator.invokeLaterWithCallback(() -> this.runIntendedWriteActionOnCurrentThread(r), modal, expired, null, !USE_SEPARATE_WRITE_THREAD);
    }

    public void invokeLaterOnWriteThread(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(41);
        }
        this.invokeLaterOnWriteThread(action2, ModalityState.defaultModalityState());
    }

    @Override
    public void runIntendedWriteActionOnCurrentThread(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(42);
        }
        if (this.isWriteThread()) {
            action2.run();
        } else {
            this.acquireWriteIntentLock(action2.getClass());
            try {
                action2.run();
            }
            finally {
                this.releaseWriteIntentLock();
            }
        }
    }

    @Override
    public <T, E extends Throwable> T runUnlockingIntendedWrite(@NotNull ThrowableComputable<T, E> action2) throws E {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(43);
        }
        if (this.isWriteThread() && USE_SEPARATE_WRITE_THREAD) {
            this.releaseWriteIntentLock();
            try {
                Object object = action2.compute();
                return (T)object;
            }
            finally {
                this.acquireWriteIntentLock(action2.getClass());
            }
        }
        return (T)action2.compute();
    }

    public void runReadAction(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(44);
        }
        if (this.checkReadAccessAllowedAndNoPendingWrites()) {
            action2.run();
        } else {
            this.acquireReadLock(action2.getClass());
            try {
                action2.run();
            }
            finally {
                this.releaseReadLock();
            }
        }
    }

    public <T> T runReadAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            ApplicationImpl.$$$reportNull$$$0(45);
        }
        if (this.checkReadAccessAllowedAndNoPendingWrites()) {
            return (T)computation.compute();
        }
        this.acquireReadLock(computation.getClass());
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public <T, E extends Throwable> T runReadAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            ApplicationImpl.$$$reportNull$$$0(46);
        }
        if (this.checkReadAccessAllowedAndNoPendingWrites()) {
            return (T)computation.compute();
        }
        this.acquireReadLock(computation.getClass());
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void acquireReadLock(@NotNull Class<?> invokedClass) {
        if (invokedClass == null) {
            ApplicationImpl.$$$reportNull$$$0(47);
        }
        this.myLock.readLock();
        ApplicationImpl.lockAcquired(invokedClass, LockKind.READ);
    }

    private boolean tryAcquireReadLock(@NotNull Class<? extends Runnable> invokedClass) {
        boolean result2;
        if (invokedClass == null) {
            ApplicationImpl.$$$reportNull$$$0(48);
        }
        if (result2 = this.myLock.tryReadLock()) {
            ApplicationImpl.lockAcquired(invokedClass, LockKind.READ);
        }
        return result2;
    }

    private void releaseReadLock() {
        this.myLock.readUnlock();
    }

    private void acquireWriteLock(@NotNull Class<?> invokedClass) {
        if (invokedClass == null) {
            ApplicationImpl.$$$reportNull$$$0(49);
        }
        this.myLock.writeLock();
        ApplicationImpl.lockAcquired(invokedClass, LockKind.WRITE);
    }

    private void releaseWriteLock() {
        this.myLock.writeUnlock();
    }

    private void acquireWriteIntentLock(@NotNull Class<?> invokedClass) {
        if (invokedClass == null) {
            ApplicationImpl.$$$reportNull$$$0(50);
        }
        this.acquireWriteIntentLock(invokedClass.getName());
    }

    @Override
    public void acquireWriteIntentLock(@NotNull String invokedClassFqn) {
        if (invokedClassFqn == null) {
            ApplicationImpl.$$$reportNull$$$0(51);
        }
        this.myLock.writeIntentLock();
        ApplicationImpl.lockAcquired(invokedClassFqn, LockKind.WRITE_INTENT);
    }

    @Override
    public void releaseWriteIntentLock() {
        this.myLock.writeIntentUnlock();
    }

    @Override
    @ApiStatus.Experimental
    public boolean runWriteActionWithNonCancellableProgressInDispatchThread(@NotNull @NlsContexts.ProgressTitle String title, @Nullable Project project, @Nullable JComponent parentComponent, @NotNull Consumer<? super ProgressIndicator> action2) {
        if (title == null) {
            ApplicationImpl.$$$reportNull$$$0(52);
        }
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(53);
        }
        return this.runEdtProgressWriteAction(title, project, parentComponent, null, action2);
    }

    @Override
    @ApiStatus.Experimental
    public boolean runWriteActionWithCancellableProgressInDispatchThread(@NotNull @NlsContexts.ProgressTitle String title, @Nullable Project project, @Nullable JComponent parentComponent, @NotNull Consumer<? super ProgressIndicator> action2) {
        if (title == null) {
            ApplicationImpl.$$$reportNull$$$0(54);
        }
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(55);
        }
        return this.runEdtProgressWriteAction(title, project, parentComponent, IdeBundle.message((String)"action.stop", (Object[])new Object[0]), action2);
    }

    private boolean runEdtProgressWriteAction(@NotNull @NlsContexts.ProgressTitle String title, @Nullable Project project, @Nullable JComponent parentComponent, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String cancelText, @NotNull Consumer<? super ProgressIndicator> action2) {
        if (title == null) {
            ApplicationImpl.$$$reportNull$$$0(56);
        }
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(57);
        }
        if (!USE_SEPARATE_WRITE_THREAD) {
            return (Boolean)this.runWriteActionWithClass(action2.getClass(), () -> {
                PotemkinProgress indicator = new PotemkinProgress(title, project, parentComponent, cancelText);
                indicator.runInSwingThread(() -> action2.accept(indicator));
                return !indicator.isCanceled();
            });
        }
        ProgressWindow progress2 = this.createProgressWindow(title, cancelText != null, true, project, parentComponent, cancelText);
        ProgressResult result2 = new ProgressRunner(() -> this.runWriteAction(() -> action2.accept(progress2))).sync().onThread(ProgressRunner.ThreadToUse.WRITE).withProgress(progress2).modal().submitAndGet();
        if (result2.getThrowable() instanceof RuntimeException) {
            throw (RuntimeException)result2.getThrowable();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends Throwable> T runWriteActionWithClass(@NotNull Class<?> clazz, @NotNull ThrowableComputable<T, E> computable) throws E {
        if (clazz == null) {
            ApplicationImpl.$$$reportNull$$$0(58);
        }
        if (computable == null) {
            ApplicationImpl.$$$reportNull$$$0(59);
        }
        this.startWrite(clazz);
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            this.endWrite(clazz);
        }
    }

    public void runWriteAction(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(60);
        }
        Class<?> clazz = action2.getClass();
        this.startWrite(clazz);
        try {
            action2.run();
        }
        finally {
            this.endWrite(clazz);
        }
    }

    public <T> T runWriteAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            ApplicationImpl.$$$reportNull$$$0(61);
        }
        return this.runWriteActionWithClass(computation.getClass(), () -> computation.compute());
    }

    public <T, E extends Throwable> T runWriteAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            ApplicationImpl.$$$reportNull$$$0(62);
        }
        return this.runWriteActionWithClass(computation.getClass(), computation);
    }

    public boolean hasWriteAction(@NotNull Class<?> actionClass) {
        if (actionClass == null) {
            ApplicationImpl.$$$reportNull$$$0(63);
        }
        this.assertReadAccessAllowed();
        for (int i2 = this.myWriteActionsStack.size() - 1; i2 >= 0; --i2) {
            Class action2 = (Class)this.myWriteActionsStack.get(i2);
            if (actionClass != action2 && !ReflectionUtil.isAssignable(actionClass, (Class)action2)) continue;
            return true;
        }
        return false;
    }

    public void assertReadAccessAllowed() {
        if (!this.isReadAccessAllowed()) {
            LOG.error("Read access is allowed from event dispatch thread or inside read-action only (see com.intellij.openapi.application.Application.runReadAction())", new String[]{"Current thread: " + ApplicationImpl.describe(Thread.currentThread()), "; dispatch thread: " + EventQueue.isDispatchThread() + "; isDispatchThread(): " + this.isDispatchThread(), "SystemEventQueueThread: " + ApplicationImpl.describe(ApplicationImpl.getEventQueueThread())});
        }
    }

    private static String describe(Thread o) {
        return o == null ? "null" : o + " " + System.identityHashCode(o);
    }

    private static Thread getEventQueueThread() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        return AWTAccessor.getEventQueueAccessor().getDispatchThread(eventQueue);
    }

    public boolean isReadAccessAllowed() {
        return this.isWriteThread() || this.myLock.isReadLockedByThisThread();
    }

    private boolean checkReadAccessAllowedAndNoPendingWrites() throws ApplicationUtil.CannotRunReadActionException {
        return this.isWriteThread() || this.myLock.checkReadLockedByThisThreadAndNoPendingWrites();
    }

    public void assertIsDispatchThread() {
        if (this.isDispatchThread()) {
            return;
        }
        if (ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        ApplicationImpl.throwThreadAccessException("Access is allowed from event dispatch thread with IW lock only.");
    }

    public void assertIsNonDispatchThread() {
        if (this.isUnitTestMode() || this.isHeadlessEnvironment()) {
            return;
        }
        if (!this.isDispatchThread()) {
            return;
        }
        if (ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        ApplicationImpl.throwThreadAccessException("Access from event dispatch thread is not allowed.");
    }

    public void assertIsWriteThread() {
        if (this.isWriteThread()) {
            return;
        }
        if (ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        this.assertIsWriteThread("Access is allowed from write thread only.");
    }

    private static void throwThreadAccessException(String message) {
        throw new RuntimeExceptionWithAttachments(message, "EventQueue.isDispatchThread()=" + EventQueue.isDispatchThread() + " Toolkit.getEventQueue()=" + Toolkit.getDefaultToolkit().getSystemEventQueue() + "\nCurrent thread: " + ApplicationImpl.describe(Thread.currentThread()) + "\nSystemEventQueueThread: " + ApplicationImpl.describe(ApplicationImpl.getEventQueueThread()), new Attachment[]{new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString())});
    }

    private void assertIsWriteThread(String message) {
        if (this.isWriteThread()) {
            return;
        }
        throw new RuntimeExceptionWithAttachments(message, "EventQueue.isDispatchThread()=" + EventQueue.isDispatchThread() + " Toolkit.getEventQueue()=" + Toolkit.getDefaultToolkit().getSystemEventQueue() + "\nCurrent thread: " + ApplicationImpl.describe(Thread.currentThread()) + "\nWrite thread (volatile): " + ApplicationImpl.describe(this.myLock.writeThread) + new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString()), new Attachment[0]);
    }

    @Override
    public void assertIsDispatchThread(@Nullable JComponent component2) {
        if (component2 == null) {
            return;
        }
        if (this.isDispatchThread()) {
            return;
        }
        if (Boolean.TRUE.equals(component2.getClientProperty(WAS_EVER_SHOWN))) {
            this.assertIsDispatchThread();
        } else {
            JRootPane root = component2.getRootPane();
            if (root != null) {
                component2.putClientProperty(WAS_EVER_SHOWN, Boolean.TRUE);
                this.assertIsDispatchThread();
            }
        }
    }

    @Override
    public void assertTimeConsuming() {
        if (this.myTestModeFlag || this.myHeadlessMode || ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        LOG.assertTrue(!this.isDispatchThread(), (Object)"This operation is time consuming and must not be called on EDT");
    }

    @Override
    public boolean tryRunReadAction(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(64);
        }
        if (this.checkReadAccessAllowedAndNoPendingWrites()) {
            action2.run();
        } else {
            if (!this.tryAcquireReadLock(action2.getClass())) {
                return false;
            }
            try {
                action2.run();
            }
            finally {
                this.releaseReadLock();
            }
        }
        return true;
    }

    public boolean isActive() {
        if (this.isHeadlessEnvironment()) {
            return true;
        }
        if (this.isDisposed()) {
            return false;
        }
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (activeWindow != null) {
            ApplicationActivationStateManager.updateState(this, activeWindow);
        }
        return ApplicationActivationStateManager.isActive();
    }

    @NotNull
    public AccessToken acquireReadActionLock() {
        return this.checkReadAccessAllowedAndNoPendingWrites() ? AccessToken.EMPTY_ACCESS_TOKEN : new ReadAccessToken();
    }

    @Override
    public boolean isWriteActionPending() {
        return this.myWriteActionPending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWrite(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ApplicationImpl.$$$reportNull$$$0(65);
        }
        if (!this.isWriteAccessAllowed()) {
            this.assertIsWriteThread("Write access is allowed from write thread only");
        }
        boolean writeActionPending = this.myWriteActionPending;
        if (this.gatherStatistics && this.myWriteActionsStack.isEmpty() && !writeActionPending) {
            ActionPauses.WRITE.started();
        }
        this.myWriteActionPending = true;
        try {
            ActivityTracker.getInstance().inc();
            this.fireBeforeWriteActionStart(clazz);
            if (!this.myLock.isWriteLocked()) {
                long elapsed;
                ScheduledFuture<?> reportSlowWrite = ourDumpThreadsOnLongWriteActionWaiting <= 0 ? null : AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> PerformanceWatcher.getInstance().dumpThreads("waiting", true), ourDumpThreadsOnLongWriteActionWaiting, ourDumpThreadsOnLongWriteActionWaiting, TimeUnit.MILLISECONDS);
                long t = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
                this.acquireWriteLock(clazz);
                if (LOG.isDebugEnabled() && (elapsed = System.currentTimeMillis() - t) != 0L) {
                    LOG.debug("Write action wait time: " + elapsed);
                }
                if (reportSlowWrite != null) {
                    reportSlowWrite.cancel(false);
                }
            }
        }
        finally {
            this.myWriteActionPending = writeActionPending;
        }
        this.myWriteActionsStack.push(clazz);
        this.fireWriteActionStarted(clazz);
    }

    private void endWrite(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ApplicationImpl.$$$reportNull$$$0(66);
        }
        try {
            this.fireWriteActionFinished(clazz);
        }
        finally {
            this.myWriteActionsStack.pop();
            if (this.gatherStatistics && this.myWriteActionsStack.isEmpty() && !this.myWriteActionPending) {
                ActionPauses.WRITE.finished("write action (" + clazz + ")");
            }
            if (this.myWriteActionsStack.size() == this.myWriteStackBase) {
                this.releaseWriteLock();
            }
            if (this.myWriteActionsStack.isEmpty()) {
                this.fireAfterWriteActionFinished(clazz);
            }
        }
    }

    @NotNull
    public AccessToken acquireWriteActionLock(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ApplicationImpl.$$$reportNull$$$0(67);
        }
        return new WriteAccessToken(clazz);
    }

    public void assertWriteAccessAllowed() {
        LOG.assertTrue(this.isWriteAccessAllowed(), (Object)"Write access is allowed inside write-action only (see com.intellij.openapi.application.Application.runWriteAction())");
    }

    public boolean isWriteAccessAllowed() {
        return this.isWriteThread() && this.myLock.isWriteLocked();
    }

    @Override
    public boolean isWriteActionInProgress() {
        return this.myLock.isWriteLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void executeSuspendingWriteAction(@Nullable Project project, @NotNull @NlsContexts.DialogTitle String title, @NotNull Runnable runnable2) {
        if (title == null) {
            ApplicationImpl.$$$reportNull$$$0(68);
        }
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(69);
        }
        this.assertIsWriteThread();
        if (!this.myLock.isWriteLocked()) {
            ApplicationImpl.runModalProgress(project, title, runnable2);
            return;
        }
        int prevBase = this.myWriteStackBase;
        this.myWriteStackBase = this.myWriteActionsStack.size();
        try (AccessToken ignored = this.myLock.writeSuspend();){
            ApplicationImpl.runModalProgress(project, title, runnable2);
        }
        finally {
            this.myWriteStackBase = prevBase;
        }
    }

    private static void runModalProgress(@Nullable Project project, @NotNull @NlsContexts.DialogTitle String title, final @NotNull Runnable runnable2) {
        if (title == null) {
            ApplicationImpl.$$$reportNull$$$0(70);
        }
        if (runnable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(71);
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(project, title, false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                runnable2.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/application/impl/ApplicationImpl$4", "run"));
            }
        });
    }

    public void addApplicationListener(@NotNull ApplicationListener l) {
        if (l == null) {
            ApplicationImpl.$$$reportNull$$$0(72);
        }
        this.myDispatcher.addListener((EventListener)l);
    }

    public void addApplicationListener(@NotNull ApplicationListener l, @NotNull Disposable parent) {
        if (l == null) {
            ApplicationImpl.$$$reportNull$$$0(73);
        }
        if (parent == null) {
            ApplicationImpl.$$$reportNull$$$0(74);
        }
        this.myDispatcher.addListener((EventListener)l, parent);
    }

    public void removeApplicationListener(@NotNull ApplicationListener l) {
        if (l == null) {
            ApplicationImpl.$$$reportNull$$$0(75);
        }
        this.myDispatcher.removeListener((EventListener)l);
    }

    private void fireBeforeWriteActionStart(@NotNull Class<?> action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(76);
        }
        ((ApplicationListener)this.myDispatcher.getMulticaster()).beforeWriteActionStart(action2);
    }

    private void fireWriteActionStarted(@NotNull Class<?> action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(77);
        }
        ((ApplicationListener)this.myDispatcher.getMulticaster()).writeActionStarted(action2);
    }

    private void fireWriteActionFinished(@NotNull Class<?> action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(78);
        }
        ((ApplicationListener)this.myDispatcher.getMulticaster()).writeActionFinished(action2);
    }

    private void fireAfterWriteActionFinished(@NotNull Class<?> action2) {
        if (action2 == null) {
            ApplicationImpl.$$$reportNull$$$0(79);
        }
        ((ApplicationListener)this.myDispatcher.getMulticaster()).afterWriteActionFinished(action2);
    }

    public void saveSettings() {
        if (this.mySaveAllowed) {
            StoreUtil.saveSettings((ComponentManager)this, false);
        }
    }

    public void saveAll() {
        StoreUtil.saveDocumentsAndProjectsAndApp(false);
    }

    @Override
    public void setSaveAllowed(boolean value2) {
        this.mySaveAllowed = value2;
    }

    @Override
    public boolean isSaveAllowed() {
        return this.mySaveAllowed;
    }

    public boolean isRestartCapable() {
        return Restarter.isSupported();
    }

    public String toString() {
        return "Application (containerState=" + this.getContainerStateName() + ") " + (this.isUnitTestMode() ? " (Unit test)" : "") + (this.isInternal() ? " (Internal)" : "") + (this.isHeadlessEnvironment() ? " (Headless)" : "") + (this.isCommandLine() ? " (Command line)" : "");
    }

    @ApiStatus.Internal
    @NotNull
    public String activityNamePrefix() {
        return "app ";
    }

    @NotNull
    protected ContainerDescriptor getContainerDescriptor(@NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        if (pluginDescriptor == null) {
            ApplicationImpl.$$$reportNull$$$0(80);
        }
        ContainerDescriptor containerDescriptor = pluginDescriptor.getApp();
        if (containerDescriptor == null) {
            ApplicationImpl.$$$reportNull$$$0(81);
        }
        return containerDescriptor;
    }

    protected void logMessageBusDelivery(@NotNull Topic<?> topic, String messageName, @NotNull Object handler2, long duration) {
        if (topic == null) {
            ApplicationImpl.$$$reportNull$$$0(82);
        }
        if (handler2 == null) {
            ApplicationImpl.$$$reportNull$$$0(83);
        }
        super.logMessageBusDelivery(topic, messageName, handler2, duration);
        if (topic == ProjectManager.TOPIC) {
            long start2 = StartUpMeasurer.getCurrentTime() - duration;
            StartUpMeasurer.addCompletedActivity((long)start2, handler2.getClass(), (ActivityCategory)ActivityCategory.PROJECT_OPEN_HANDLER, null, (long)StartUpMeasurer.MEASURE_THRESHOLD);
        } else if (topic == VirtualFileManager.VFS_CHANGES && TimeUnit.NANOSECONDS.toMillis(duration) > 50L) {
            LOG.info(String.format("LONG VFS PROCESSING. Topic=%s, offender=%s, message=%s, time=%dms", topic.getDisplayName(), handler2.getClass(), messageName, TimeUnit.NANOSECONDS.toMillis(duration)));
        }
    }

    @TestOnly
    void disableEventsUntil(@NotNull Disposable disposable2) {
        if (disposable2 == null) {
            ApplicationImpl.$$$reportNull$$$0(84);
        }
        this.myDispatcher.neuterMultiCasterWhilePerformanceTestIsRunningUntil(disposable2);
    }

    @ApiStatus.Internal
    public boolean getComponentCreated() {
        return ((ComponentManagerImpl.ContainerState)this.getContainerState().get()).compareTo((Enum)ComponentManagerImpl.ContainerState.COMPONENT_CREATED) >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 18: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 39: 
            case 81: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 18: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 39: 
            case 81: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invokedClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lockKind";
                break;
            }
            case 2: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invokedClassFqn";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 23: 
            case 25: 
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 5: 
            case 7: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 64: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 18: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 39: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/ApplicationImpl";
                break;
            }
            case 12: 
            case 17: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 20: 
            case 21: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeRestart";
                break;
            }
            case 45: 
            case 46: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 52: 
            case 54: 
            case 56: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 58: 
            case 65: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionClass";
                break;
            }
            case 72: 
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/ApplicationImpl";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "executeOnPooledThread";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvokator";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "writeActionStatistics";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModalityState";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalityStateForComponent";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnyModalityState";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultModalityState";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoneModalityState";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createProgressWindowAsyncIfNeeded";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createProgressWindow";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "lockAcquired";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeByImpatientReader";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeOnPooledThread";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 18: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 39: 
            case 81: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressSynchronously";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressSynchronouslyInReadAction";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWait";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getModalityStateForComponent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "restart";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "exit";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createProgressWindowAsyncIfNeeded";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createProgressWindow";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterOnWriteThread";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "runIntendedWriteActionOnCurrentThread";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "runUnlockingIntendedWrite";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "runReadAction";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "acquireReadLock";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "tryAcquireReadLock";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "acquireWriteLock";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "acquireWriteIntentLock";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "runWriteActionWithNonCancellableProgressInDispatchThread";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "runWriteActionWithCancellableProgressInDispatchThread";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "runEdtProgressWriteAction";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "runWriteActionWithClass";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "runWriteAction";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "hasWriteAction";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "tryRunReadAction";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "startWrite";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "endWrite";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "acquireWriteActionLock";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "executeSuspendingWriteAction";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "runModalProgress";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "addApplicationListener";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "removeApplicationListener";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeWriteActionStart";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "fireWriteActionStarted";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "fireWriteActionFinished";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterWriteActionFinished";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getContainerDescriptor";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "logMessageBusDelivery";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "disableEventsUntil";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 18: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 39: 
            case 81: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class ReadAccessToken
    extends AccessToken {
        private ReadAccessToken() {
            ApplicationImpl.this.acquireReadLock(Runnable.class);
        }

        public void finish() {
            ApplicationImpl.this.releaseReadLock();
        }
    }

    private class WriteAccessToken
    extends AccessToken {
        @NotNull
        private final Class<?> clazz;

        WriteAccessToken(Class<?> clazz) {
            if (clazz == null) {
                WriteAccessToken.$$$reportNull$$$0(0);
            }
            this.clazz = clazz;
            ApplicationImpl.this.startWrite(clazz);
            this.markThreadNameInStackTrace();
        }

        public void finish() {
            try {
                ApplicationImpl.this.endWrite(this.clazz);
            }
            finally {
                this.unmarkThreadNameInStackTrace();
            }
        }

        private void markThreadNameInStackTrace() {
            String id2 = this.id();
            if (id2 != null) {
                Thread thread = Thread.currentThread();
                thread.setName(thread.getName() + id2);
            }
        }

        private void unmarkThreadNameInStackTrace() {
            String id2 = this.id();
            if (id2 != null) {
                Thread thread = Thread.currentThread();
                String name = thread.getName();
                name = StringUtil.replace((String)name, (String)id2, (String)"");
                thread.setName(name);
            }
        }

        @Nullable
        private String id() {
            Class<?> aClass = ((Object)((Object)this)).getClass();
            String name = aClass.getName();
            name = name.substring(name.lastIndexOf(46) + 1);
            if (!(name = name.substring(name.lastIndexOf(36) + 1)).equals("AccessToken")) {
                return " [" + name + "]";
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/application/impl/ApplicationImpl$WriteAccessToken", "<init>"));
        }
    }

    private static class ActionPauses {
        private static final PausesStat WRITE = new PausesStat("Write action");

        private ActionPauses() {
        }
    }
}

