/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.psi.impl;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.model.psi.impl.PsiElement2Declaration;
import com.intellij.model.search.PsiSymbolDeclarationSearchParameters;
import com.intellij.model.search.PsiSymbolDeclarationSearcher;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayQuery;
import com.intellij.util.Query;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/model/psi/impl/PsiElementDeclarationSearcher;", "Lcom/intellij/model/search/PsiSymbolDeclarationSearcher;", "()V", "collectSearchRequests", "", "Lcom/intellij/util/Query;", "Lcom/intellij/model/psi/PsiSymbolDeclaration;", "parameters", "Lcom/intellij/model/search/PsiSymbolDeclarationSearchParameters;", "fromPomTargetElement", "psi", "Lcom/intellij/pom/PomTargetPsiElement;", "getDeclaration", "Lcom/intellij/psi/PsiElement;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "inGlobalScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "inLocalScope", "Lcom/intellij/psi/search/LocalSearchScope;", "intellij.platform.lang.impl"})
public final class PsiElementDeclarationSearcher
implements PsiSymbolDeclarationSearcher {
    @NotNull
    public Collection<Query<? extends PsiSymbolDeclaration>> collectSearchRequests(@NotNull PsiSymbolDeclarationSearchParameters parameters2) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        PsiElement psiElement = PsiSymbolService.getInstance().extractElementFromSymbol(parameters2.getSymbol());
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"PsiSymbolService.getInst\u2026ol) ?: return emptyList()");
        PsiElement psi = psiElement;
        SearchScope searchScope2 = parameters2.getSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"parameters.searchScope");
        PsiSymbolDeclaration psiSymbolDeclaration = this.getDeclaration(psi, searchScope2);
        if (psiSymbolDeclaration == null) {
            return CollectionsKt.emptyList();
        }
        PsiSymbolDeclaration declaration = psiSymbolDeclaration;
        return CollectionsKt.listOf((Object)new ArrayQuery((Object[])new PsiSymbolDeclaration[]{declaration}));
    }

    private final PsiSymbolDeclaration getDeclaration(PsiElement psi, SearchScope searchScope2) {
        if (searchScope2 instanceof LocalSearchScope) {
            return this.inLocalScope(psi, (LocalSearchScope)searchScope2);
        }
        SearchScope searchScope3 = searchScope2;
        if (searchScope3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.search.GlobalSearchScope");
        }
        return this.inGlobalScope(psi, (GlobalSearchScope)searchScope3);
    }

    private final PsiSymbolDeclaration inLocalScope(PsiElement psi, LocalSearchScope searchScope2) {
        PsiElement[] psiElementArray = searchScope2.getScope();
        int n = psiElementArray.length;
        for (int j = 0; j < n; ++j) {
            PsiFile scopeFile;
            PsiElement scopeElement;
            PsiElement psiElement = scopeElement = psiElementArray[j];
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"scopeElement");
            if (psiElement.getContainingFile() == null) {
                continue;
            }
            TextRange textRange = HighlightUsagesHandler.getNameIdentifierRange(scopeFile, psi);
            if (textRange == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"HighlightUsagesHandler.g\u2026opeFile, psi) ?: continue");
            TextRange declarationRange = textRange;
            return new PsiElement2Declaration(psi, (PsiElement)scopeFile, declarationRange);
        }
        return null;
    }

    private final PsiSymbolDeclaration inGlobalScope(PsiElement psi, GlobalSearchScope searchScope2) {
        PsiFile psiFile = psi.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile containingFile = psiFile;
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (!searchScope2.contains(virtualFile2)) {
            return null;
        }
        PsiElement psiElement = psi;
        return psiElement instanceof PsiFile ? null : (psiElement instanceof PomTargetPsiElement ? this.fromPomTargetElement((PomTargetPsiElement)psi) : PsiElement2Declaration.createFromTargetPsiElement(psi));
    }

    private final PsiSymbolDeclaration fromPomTargetElement(PomTargetPsiElement psi) {
        PomTarget pomTarget = psi.getTarget();
        if (!(pomTarget instanceof PsiTarget)) {
            pomTarget = null;
        }
        PsiTarget psiTarget = (PsiTarget)pomTarget;
        if (psiTarget == null) {
            return null;
        }
        PsiTarget target2 = psiTarget;
        PsiElement psiElement = target2.getNavigationElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"target.navigationElement");
        PsiElement navigationElement = psiElement;
        return PsiElement2Declaration.createFromPom((PomTarget)target2, navigationElement);
    }
}

