/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.editor;

import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import org.jetbrains.annotations.NonNls;

class LargeFileEditorState
implements FileEditorState {
    long caretPageNumber = 0L;
    int caretSymbolOffsetInPage = 0;

    LargeFileEditorState() {
    }

    public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
        if (otherState instanceof LargeFileEditorState) {
            LargeFileEditorState state = (LargeFileEditorState)otherState;
            return this.caretPageNumber == state.caretPageNumber && this.caretSymbolOffsetInPage == state.caretSymbolOffsetInPage;
        }
        return false;
    }

    @NonNls
    public String toString() {
        return "[p" + this.caretPageNumber + ",s" + this.caretSymbolOffsetInPage + "]";
    }
}

