/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.hints.presentation.MenuOnClickPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.internal.InternalActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import kotlin.jvm.functions.Function0;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class AddInlayInternalAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AddInlayInternalAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        EditorImpl editor = (EditorImpl)ObjectUtils.tryCast((Object)e.getData(CommonDataKeys.EDITOR), EditorImpl.class);
        if (editor == null) {
            return;
        }
        List<Caret> carets = editor.getCaretModel().getAllCarets();
        if (carets.isEmpty()) {
            return;
        }
        String inlayText = Messages.showInputDialog((String)"Inlay text:", (String)(carets.size() > 1 ? "Add Inlays" : "Add Inlay"), (Icon)Messages.getInformationIcon());
        if (inlayText == null) {
            return;
        }
        int[] offsets2 = StreamEx.of(carets).mapToInt(Caret::getOffset).toArray();
        InlayModelImpl model2 = editor.getInlayModel();
        for (int offset : offsets2) {
            final AtomicReference<Inlay> ref = new AtomicReference<Inlay>();
            MenuOnClickPresentation presentation2 = new MenuOnClickPresentation(new PresentationFactory(editor).text(inlayText), project, (Function0<? extends List<? extends AnAction>>)((Function0)() -> Collections.singletonList(new AnAction(InternalActionsBundle.messagePointer("action.AddInlayInternalAction.Anonymous.text.remove", new Object[0]), InternalActionsBundle.messagePointer("action.AddInlayInternalAction.Anonymous.description.remove.this.inlay", new Object[0]), AllIcons.Actions.Cancel){

                public void actionPerformed(@NotNull AnActionEvent e1) {
                    Inlay inlay;
                    if (e1 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((inlay = (Inlay)ref.get()) != null) {
                        Disposer.dispose((Disposable)inlay);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/intellij/internal/AddInlayInternalAction$1", "actionPerformed"));
                }
            })));
            Inlay inlay = model2.addInlineElement(offset, new PresentationRenderer(presentation2));
            ref.set(inlay);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddInlayInternalAction.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = e.getPresentation();
        Project project = e.getProject();
        EditorImpl editor = (EditorImpl)ObjectUtils.tryCast((Object)e.getData(CommonDataKeys.EDITOR), EditorImpl.class);
        presentation2.setEnabled(project != null && editor != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/internal/AddInlayInternalAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

