/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.impl.StructureViewWrapperImpl;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionProcessingHelper;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiElement;
import com.intellij.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@com.intellij.openapi.components.State(name="StructureViewFactory", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
public final class StructureViewFactoryImpl
extends StructureViewFactoryEx
implements PersistentStateComponent<State> {
    private static final ExtensionPointName<StructureViewExtension> EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.lang.structureViewExtension");
    private final Project myProject;
    private StructureViewWrapperImpl myStructureViewWrapperImpl;
    private State myState;
    private Runnable myRunWhenInitialized;
    private final Map<Class<? extends PsiElement>, Collection<StructureViewExtension>> myImplExtensions;

    public StructureViewFactoryImpl(@NotNull Project project) {
        if (project == null) {
            StructureViewFactoryImpl.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myRunWhenInitialized = null;
        this.myImplExtensions = new ConcurrentHashMap<Class<? extends PsiElement>, Collection<StructureViewExtension>>();
        this.myProject = project;
        EXTENSION_POINT_NAME.addChangeListener(() -> {
            this.myImplExtensions.clear();
            if (this.myStructureViewWrapperImpl != null) {
                this.myStructureViewWrapperImpl.rebuild();
            }
        }, (Disposable)project);
    }

    @Override
    public StructureViewWrapper getStructureViewWrapper() {
        return this.myStructureViewWrapperImpl;
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            StructureViewFactoryImpl.$$$reportNull$$$0(1);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            StructureViewFactoryImpl.$$$reportNull$$$0(2);
        }
        this.myState = state;
    }

    public void initToolWindow(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            StructureViewFactoryImpl.$$$reportNull$$$0(3);
        }
        this.myStructureViewWrapperImpl = new StructureViewWrapperImpl(this.myProject, toolWindow);
        if (this.myRunWhenInitialized != null) {
            this.myRunWhenInitialized.run();
            this.myRunWhenInitialized = null;
        }
    }

    @Override
    @NotNull
    public Collection<StructureViewExtension> getAllExtensions(@NotNull Class<? extends PsiElement> type) {
        Collection<StructureViewExtension> result2;
        if (type == null) {
            StructureViewFactoryImpl.$$$reportNull$$$0(4);
        }
        if ((result2 = this.myImplExtensions.get(type)) != null) {
            Collection<StructureViewExtension> collection = result2;
            if (collection == null) {
                StructureViewFactoryImpl.$$$reportNull$$$0(5);
            }
            return collection;
        }
        ExtensionPointImpl point = (ExtensionPointImpl)EXTENSION_POINT_NAME.getPoint();
        HashSet<Class<? extends PsiElement>> visitedTypes = new HashSet<Class<? extends PsiElement>>();
        result2 = new ArrayList<StructureViewExtension>();
        for (StructureViewExtension extension : point.getExtensionList()) {
            Class<? extends PsiElement> registeredType = extension.getType();
            if (!ReflectionUtil.isAssignable(registeredType, type) || !visitedTypes.add(registeredType)) continue;
            result2.addAll(ExtensionProcessingHelper.getByGroupingKey((ExtensionPointImpl)point, StructureViewExtension.class, registeredType, StructureViewExtension::getType));
        }
        Collection<StructureViewExtension> oldValue = this.myImplExtensions.putIfAbsent(type, result2);
        Collection<StructureViewExtension> collection = oldValue == null ? result2 : oldValue;
        if (collection == null) {
            StructureViewFactoryImpl.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Override
    public void setActiveAction(String name, boolean state) {
        Collection<String> activeActions = this.collectActiveActions();
        if (state) {
            activeActions.add(name);
        } else {
            activeActions.remove(name);
        }
        this.myState.ACTIVE_ACTIONS = StructureViewFactoryImpl.toString(activeActions);
    }

    private static String toString(Collection<String> activeActions) {
        return StringUtil.join(activeActions, (String)",");
    }

    @NotNull
    public Collection<String> collectActiveActions() {
        return new LinkedHashSet<String>(Arrays.asList(this.myState.ACTIVE_ACTIONS.split(",")));
    }

    @Override
    public boolean isActionActive(String name) {
        return this.collectActiveActions().contains(name);
    }

    @Override
    public void runWhenInitialized(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            StructureViewFactoryImpl.$$$reportNull$$$0(7);
        }
        if (this.myStructureViewWrapperImpl != null) {
            runnable2.run();
        } else {
            this.myRunWhenInitialized = runnable2;
        }
    }

    @NotNull
    public StructureView createStructureView(FileEditor fileEditor, @NotNull StructureViewModel treeModel, @NotNull Project project) {
        if (treeModel == null) {
            StructureViewFactoryImpl.$$$reportNull$$$0(8);
        }
        if (project == null) {
            StructureViewFactoryImpl.$$$reportNull$$$0(9);
        }
        StructureView structureView = this.createStructureView(fileEditor, treeModel, project, true);
        if (structureView == null) {
            StructureViewFactoryImpl.$$$reportNull$$$0(10);
        }
        return structureView;
    }

    @NotNull
    public StructureView createStructureView(FileEditor fileEditor, @NotNull StructureViewModel treeModel, @NotNull Project project, boolean showRootNode) {
        if (treeModel == null) {
            StructureViewFactoryImpl.$$$reportNull$$$0(11);
        }
        if (project == null) {
            StructureViewFactoryImpl.$$$reportNull$$$0(12);
        }
        return new StructureViewComponent(fileEditor, treeModel, project, showRootNode);
    }

    @TestOnly
    public void cleanupForNextTest() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myState = new State();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/impl/StructureViewFactoryImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/impl/StructureViewFactoryImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllExtensions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructureView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initToolWindow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllExtensions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runWhenInitialized";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createStructureView";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class State {
        public boolean AUTOSCROLL_MODE = true;
        public boolean AUTOSCROLL_FROM_SOURCE = false;
        public String ACTIVE_ACTIONS = "";
    }
}

