/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.LinkPanel;
import com.intellij.ide.plugins.MultiPanel;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginEnabledState;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.TagPanel;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.newui.BaselinePanel;
import com.intellij.ide.plugins.newui.ChangeNotesPanel;
import com.intellij.ide.plugins.newui.ErrorComponent;
import com.intellij.ide.plugins.newui.InstallButton;
import com.intellij.ide.plugins.newui.LicensePanel;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.OneLineProgressIndicator;
import com.intellij.ide.plugins.newui.RestartButton;
import com.intellij.ide.plugins.newui.SearchWords;
import com.intellij.ide.plugins.newui.SelectionBasedPluginModelAction;
import com.intellij.ide.plugins.newui.TabbedPaneHeaderComponent;
import com.intellij.ide.plugins.newui.TextHorizontalLayout;
import com.intellij.ide.plugins.newui.UIUtils;
import com.intellij.ide.plugins.newui.UpdateButton;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginDetailsPageComponent
extends MultiPanel {
    private static final String MARKETPLACE_LINK = "https://plugins.jetbrains.com/plugin/index?xmlId=";
    private final MyPluginModel myPluginModel;
    private final LinkListener<Object> mySearchListener;
    private final boolean myMarketplace;
    @NotNull
    private final AsyncProcessIcon myLoadingIcon;
    private JBPanelWithEmptyText myEmptyPanel;
    private OpaquePanel myPanel;
    private JLabel myIconLabel;
    private final JEditorPane myNameComponent;
    private final BaselinePanel myNameAndButtons;
    private JButton myRestartButton;
    private InstallButton myInstallButton;
    private JButton myUpdateButton;
    private JComponent myGearButton;
    private JComponent myErrorComponent;
    private JTextField myVersion;
    private JLabel myEnabledForProject;
    private JLabel myVersionSize;
    private TagPanel myTagPanel;
    private JLabel myDate;
    private JLabel myRating;
    private JLabel myDownloads;
    private JLabel mySize;
    private LinkPanel myVendor;
    private final LicensePanel myLicensePanel;
    private LinkPanel myHomePage;
    private JBScrollPane myBottomScrollPane;
    private JEditorPane myDescriptionComponent;
    private String myDescription;
    private ChangeNotesPanel myChangeNotesPanel;
    private OneLineProgressIndicator myIndicator;
    public IdeaPluginDescriptor myPlugin;
    private IdeaPluginDescriptor myUpdateDescriptor;
    private ListPluginComponent myShowComponent;
    private boolean myRequiresRestart;
    private boolean myPluginIsRequired;

    public PluginDetailsPageComponent(@NotNull MyPluginModel pluginModel, @NotNull LinkListener<Object> searchListener, boolean marketplace) {
        if (pluginModel == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(0);
        }
        if (searchListener == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(1);
        }
        this.myLoadingIcon = new AsyncProcessIcon.BigCentered(IdeBundle.message((String)"progress.text.loading", (Object[])new Object[0]));
        this.myNameComponent = PluginDetailsPageComponent.createNameComponent();
        this.myNameAndButtons = new BaselinePanel();
        this.myLicensePanel = new LicensePanel(false);
        this.myRequiresRestart = true;
        this.myPluginIsRequired = false;
        this.myPluginModel = pluginModel;
        this.mySearchListener = searchListener;
        this.myMarketplace = marketplace;
        this.createPluginPanel();
        this.select(1, true);
        this.setEmptyState(EmptyState.NONE_SELECTED);
    }

    public boolean isShowingPlugin(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(2);
        }
        return this.myPlugin != null && this.myPlugin.getPluginId().equals(pluginDescriptor.getPluginId());
    }

    @Override
    protected JComponent create(Integer key) {
        if (key == 0) {
            return this.myPanel;
        }
        if (key == 1) {
            if (this.myEmptyPanel == null) {
                this.myEmptyPanel = new JBPanelWithEmptyText();
                this.myEmptyPanel.setBorder((Border)new CustomLineBorder(PluginManagerConfigurable.SEARCH_FIELD_BORDER_COLOR, (Insets)JBUI.insets((int)1, (int)0, (int)0, (int)0)));
                this.myEmptyPanel.setOpaque(true);
                this.myEmptyPanel.setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
                this.myLoadingIcon.setOpaque(true);
                this.myLoadingIcon.setPaintPassiveIcon(false);
                this.myEmptyPanel.add((Component)this.myLoadingIcon);
            }
            return this.myEmptyPanel;
        }
        return super.create(key);
    }

    private void createPluginPanel() {
        this.myPanel = new OpaquePanel((LayoutManager)new BorderLayout(0, JBUIScale.scale((int)32)), PluginManagerConfigurable.MAIN_BG_COLOR);
        this.myPanel.setBorder((Border)new CustomLineBorder((Color)new JBColor(0xC5C5C5, 0x515151), (Insets)JBUI.insets((int)1, (int)0, (int)0, (int)0)){

            public Insets getBorderInsets(Component c) {
                return JBUI.insets((int)15, (int)20, (int)0, (int)0);
            }
        });
        this.createHeaderPanel().add(this.createCenterPanel());
        this.createBottomPanel();
    }

    @NotNull
    private JPanel createHeaderPanel() {
        NonOpaquePanel header2 = new NonOpaquePanel((LayoutManager)new BorderLayout(JBUIScale.scale((int)15), 0));
        header2.setBorder((Border)JBUI.Borders.emptyRight((int)20));
        this.myPanel.add((Component)header2, (Object)"North");
        this.myIconLabel = new JLabel();
        this.myIconLabel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        this.myIconLabel.setVerticalAlignment(1);
        this.myIconLabel.setOpaque(false);
        header2.add((Component)this.myIconLabel, "West");
        this.myGearButton = TabbedPaneHeaderComponent.createToolbar(IdeBundle.message((String)"plugin.settings.link.title", (Object[])new Object[0]), this.createGearActions());
        this.myGearButton.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        this.myGearButton.setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
        this.myGearButton.setOpaque(false);
        header2.add((Component)this.myGearButton, "East");
        NonOpaquePanel nonOpaquePanel = header2;
        if (nonOpaquePanel == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(3);
        }
        return nonOpaquePanel;
    }

    @NotNull
    private JPanel createCenterPanel() {
        int offset = PluginManagerConfigurable.offset5();
        NonOpaquePanel centerPanel = new NonOpaquePanel((LayoutManager)((Object)new VerticalLayout(offset)));
        this.myNameAndButtons.setYOffset(JBUIScale.scale((int)3));
        this.myNameAndButtons.add(this.myNameComponent);
        this.createButtons();
        centerPanel.add((Component)((Object)this.myNameAndButtons), "fill_h");
        if (!this.myMarketplace) {
            this.myErrorComponent = ErrorComponent.create((JPanel)centerPanel, "fill_h");
        }
        this.createMetricsPanel((JPanel)centerPanel);
        NonOpaquePanel nonOpaquePanel = centerPanel;
        if (nonOpaquePanel == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(4);
        }
        return nonOpaquePanel;
    }

    @NotNull
    private static JEditorPane createNameComponent() {
        JEditorPane editorPane = new JEditorPane(){
            JLabel myBaselineComponent;

            @Override
            public int getBaseline(int width, int height) {
                if (this.myBaselineComponent == null) {
                    this.myBaselineComponent = new JLabel();
                    this.myBaselineComponent.setFont(this.getFont());
                }
                this.myBaselineComponent.setText(this.getText());
                Dimension size = this.myBaselineComponent.getPreferredSize();
                return this.myBaselineComponent.getBaseline(size.width, size.height);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (size.height == 0) {
                    size.height = this.getMinimumSize().height;
                }
                return size;
            }
        };
        ErrorComponent.convertToLabel(editorPane);
        editorPane.setEditorKit(UIUtil.getHTMLEditorKit());
        Font font = editorPane.getFont();
        if (font != null) {
            editorPane.setFont(font.deriveFont(1, 18.0f));
        }
        editorPane.setText("<html><span>Foo</span></html>");
        editorPane.setMinimumSize(editorPane.getPreferredSize());
        editorPane.setText(null);
        JEditorPane jEditorPane = editorPane;
        if (jEditorPane == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(5);
        }
        return jEditorPane;
    }

    private void createButtons() {
        this.myRestartButton = new RestartButton(this.myPluginModel);
        this.myNameAndButtons.addButtonComponent(this.myRestartButton);
        this.myUpdateButton = new UpdateButton();
        this.myNameAndButtons.addButtonComponent(this.myUpdateButton);
        this.myUpdateButton.addActionListener(e -> this.myPluginModel.installOrUpdatePlugin(this, this.myPlugin, this.myUpdateDescriptor, ModalityState.stateForComponent((Component)this.myUpdateButton)));
        this.myInstallButton = new InstallButton(true);
        this.myNameAndButtons.addButtonComponent(this.myInstallButton);
        this.myInstallButton.addActionListener(e -> this.myPluginModel.installOrUpdatePlugin(this, this.myPlugin, null, ModalityState.stateForComponent((Component)this.myInstallButton)));
        for (Component component2 : this.myNameAndButtons.getButtonComponents()) {
            component2.setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
        }
    }

    public void setOnlyUpdateMode() {
        this.myNameAndButtons.removeButtons();
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)15, (int)20, (int)0, (int)0));
        this.myEmptyPanel.setBorder(null);
    }

    private void createMetricsPanel(@NotNull JPanel centerPanel) {
        if (centerPanel == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(6);
        }
        this.myVersion = new JTextField();
        this.myVersion.putClientProperty("TextFieldWithoutMargins", Boolean.TRUE);
        this.myVersion.setEditable(false);
        PluginDetailsPageComponent.setFont(this.myVersion);
        this.myVersion.setBorder(null);
        this.myVersion.setOpaque(false);
        this.myVersion.setForeground(ListPluginComponent.GRAY_COLOR);
        this.myVersion.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                int caretPosition = PluginDetailsPageComponent.this.myVersion.getCaretPosition();
                PluginDetailsPageComponent.this.myVersion.setSelectionStart(caretPosition);
                PluginDetailsPageComponent.this.myVersion.setSelectionEnd(caretPosition);
            }
        });
        this.myVersionSize = new JLabel();
        PluginDetailsPageComponent.setFont(this.myVersionSize);
        int offset = JBUIScale.scale((int)10);
        NonOpaquePanel panel1 = new NonOpaquePanel((LayoutManager)((Object)new TextHorizontalLayout(offset)));
        centerPanel.add((Component)panel1);
        if (this.myMarketplace) {
            this.myDownloads = ListPluginComponent.createRatingLabel((JPanel)panel1, null, "", AllIcons.Plugins.Downloads, ListPluginComponent.GRAY_COLOR, true);
            this.myRating = ListPluginComponent.createRatingLabel((JPanel)panel1, null, "", AllIcons.Plugins.Rating, ListPluginComponent.GRAY_COLOR, true);
        }
        this.myVendor = new LinkPanel((JPanel)panel1, false, true, null, "fix_label");
        this.myEnabledForProject = new JLabel();
        this.myEnabledForProject.setHorizontalTextPosition(2);
        this.myEnabledForProject.setForeground(ListPluginComponent.GRAY_COLOR);
        PluginDetailsPageComponent.setFont(this.myEnabledForProject);
        TextHorizontalLayout layout = this.myMarketplace ? new TextHorizontalLayout(offset){

            @Override
            public void layoutContainer(Container parent) {
                int baseline;
                super.layoutContainer(parent);
                if (PluginDetailsPageComponent.this.myTagPanel != null && PluginDetailsPageComponent.this.myTagPanel.isVisible() && (baseline = PluginDetailsPageComponent.this.myTagPanel.getBaseline(-1, -1)) != -1) {
                    Rectangle versionBounds = PluginDetailsPageComponent.this.myVersion.getBounds();
                    Dimension versionSize = PluginDetailsPageComponent.this.myVersion.getPreferredSize();
                    int versionY = PluginDetailsPageComponent.this.myTagPanel.getY() + baseline - PluginDetailsPageComponent.this.myVersion.getBaseline(versionSize.width, versionSize.height);
                    PluginDetailsPageComponent.this.myVersion.setBounds(versionBounds.x, versionY, versionBounds.width, versionBounds.height);
                    if (PluginDetailsPageComponent.this.myDate.isVisible()) {
                        Rectangle dateBounds = PluginDetailsPageComponent.this.myDate.getBounds();
                        Dimension dateSize = PluginDetailsPageComponent.this.myDate.getPreferredSize();
                        int dateY = PluginDetailsPageComponent.this.myTagPanel.getY() + baseline - PluginDetailsPageComponent.this.myDate.getBaseline(dateSize.width, dateSize.height);
                        PluginDetailsPageComponent.this.myDate.setBounds(dateBounds.x - JBUIScale.scale((int)4), dateY, dateBounds.width, dateBounds.height);
                    }
                }
            }
        } : new TextHorizontalLayout(JBUIScale.scale((int)7));
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)((Object)layout));
        panel2.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        this.myTagPanel = new TagPanel(this.mySearchListener);
        panel2.add((Component)((Object)this.myTagPanel));
        (this.myMarketplace ? panel2 : panel1).add(this.myVersion);
        panel2.add(this.myEnabledForProject);
        this.myDate = ListPluginComponent.createRatingLabel((JPanel)panel2, "fix_label", "", null, ListPluginComponent.GRAY_COLOR, true);
        centerPanel.add((Component)panel2);
    }

    private void createBottomPanel() {
        OpaquePanel bottomPanel = new OpaquePanel((LayoutManager)((Object)new VerticalLayout(PluginManagerConfigurable.offset5())), PluginManagerConfigurable.MAIN_BG_COLOR);
        bottomPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)15, (int)20));
        this.myBottomScrollPane = new JBScrollPane((Component)bottomPanel);
        this.myBottomScrollPane.getVerticalScrollBar().setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
        this.myBottomScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myPanel.add((Component)this.myBottomScrollPane);
        bottomPanel.add((Component)((Object)this.myLicensePanel));
        this.myLicensePanel.setBorder((Border)JBUI.Borders.emptyBottom((int)20));
        if (this.myMarketplace) {
            this.myHomePage = new LinkPanel((JPanel)bottomPanel, false);
            bottomPanel.add(new JLabel());
        }
        Integer constraints2 = JBUIScale.scale((int)700);
        this.myDescriptionComponent = PluginDetailsPageComponent.createDescriptionComponent(view -> {
            float width = view.getPreferredSpan(0);
            if (width < 0.0f || width > (float)this.myBottomScrollPane.getWidth()) {
                this.myBottomScrollPane.setHorizontalScrollBarPolicy(32);
            }
        });
        bottomPanel.add((Component)this.myDescriptionComponent, constraints2);
        this.myChangeNotesPanel = new ChangeNotesPanel((JPanel)bottomPanel, constraints2, this.myDescriptionComponent);
        JLabel separator = new JLabel();
        separator.setBorder((Border)JBUI.Borders.emptyTop((int)20));
        bottomPanel.add(separator);
        if (this.myMarketplace) {
            this.mySize = new JLabel();
            bottomPanel.add(this.mySize);
        } else {
            this.myHomePage = new LinkPanel((JPanel)bottomPanel, false);
        }
    }

    private static void setFont(@NotNull JComponent component2) {
        if (component2 == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(7);
        }
        component2.setFont(UIUtil.getLabelFont());
        PluginManagerConfigurable.setTinyFont(component2);
    }

    @NotNull
    public static JEditorPane createDescriptionComponent(final @Nullable Consumer<? super View> imageViewHandler) {
        JEditorPane editorPane = new JEditorPane();
        HTMLEditorKit kit = imageViewHandler == null ? UIUtil.getHTMLEditorKit() : new JBHtmlEditorKit(){
            private final ViewFactory myFactory = new JBHtmlEditorKit.JBHtmlFactory(){

                public View create(Element e) {
                    View view = super.create(e);
                    if (view instanceof ImageView) {
                        imageViewHandler.accept(view);
                    }
                    return view;
                }
            };

            public ViewFactory getViewFactory() {
                return this.myFactory;
            }
        };
        StyleSheet sheet = kit.getStyleSheet();
        sheet.addRule("ul {margin-left: 16px}");
        sheet.addRule("a {color: " + ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.linkColor()) + "}");
        editorPane.setEditable(false);
        editorPane.setOpaque(false);
        editorPane.setBorder(null);
        editorPane.setContentType("text/html");
        editorPane.setEditorKit(kit);
        editorPane.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        JEditorPane jEditorPane = editorPane;
        if (jEditorPane == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(8);
        }
        return jEditorPane;
    }

    public void showPlugin(@Nullable ListPluginComponent component2, boolean multiSelection) {
        if (this.myShowComponent == component2 && (component2 == null || this.myUpdateDescriptor == component2.myUpdateDescriptor)) {
            return;
        }
        this.myShowComponent = component2;
        if (this.myIndicator != null) {
            MyPluginModel.removeProgress(this.myPlugin, this.myIndicator);
            this.hideProgress(false, false);
        }
        if (component2 == null) {
            this.myUpdateDescriptor = null;
            this.myPlugin = null;
            this.select(1, true);
            this.setEmptyState(multiSelection ? EmptyState.MULTI_SELECT : EmptyState.NONE_SELECTED);
        } else {
            PluginNode node;
            boolean syncLoading = true;
            IdeaPluginDescriptor descriptor2 = component2.getPluginDescriptor();
            if (descriptor2 instanceof PluginNode && !(node = (PluginNode)descriptor2).detailsLoaded()) {
                syncLoading = false;
                this.startLoading();
                ProcessIOExecutorService.INSTANCE.execute(() -> {
                    component2.myPlugin = MarketplaceRequests.getInstance().loadPluginDetails(node);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (this.myShowComponent == component2) {
                            this.stopLoading();
                            this.showPlugin(component2);
                        }
                    }, ModalityState.stateForComponent((Component)component2));
                });
            }
            if (syncLoading) {
                this.showPlugin(component2);
            }
        }
    }

    @Override
    public ActionCallback select(Integer key, boolean now) {
        if (this.myPlugin instanceof IdeaPluginDescriptorImpl) {
            IdeaPluginDescriptorImpl descriptor2 = PluginDescriptorLoader.tryLoadFullDescriptor((IdeaPluginDescriptorImpl)this.myPlugin);
            if (descriptor2 != null) {
                this.myPluginModel.appendOrUpdateDescriptor(descriptor2);
                this.myRequiresRestart = DynamicPlugins.checkCanUnloadWithoutRestart(descriptor2) != null;
            }
            this.myPluginIsRequired = this.myPluginModel.isRequiredPlugin(this.myPlugin);
        }
        return super.select(key, now);
    }

    private void showPlugin(@NotNull ListPluginComponent component2) {
        if (component2 == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(9);
        }
        this.myPlugin = component2.myPlugin;
        this.myUpdateDescriptor = component2.myUpdateDescriptor;
        this.showPlugin();
        this.select(0, true);
    }

    private void setEmptyState(EmptyState emptyState) {
        StatusText text2 = this.myEmptyPanel.getEmptyText();
        text2.clear();
        this.myLoadingIcon.setVisible(false);
        this.myLoadingIcon.suspend();
        switch (emptyState) {
            case MULTI_SELECT: {
                text2.setText(IdeBundle.message((String)"plugins.configurable.several.plugins", (Object[])new Object[0]));
                text2.appendSecondaryText(IdeBundle.message((String)"plugins.configurable.one.plugin.details", (Object[])new Object[0]), StatusText.DEFAULT_ATTRIBUTES, null);
                break;
            }
            case NONE_SELECTED: {
                text2.setText(IdeBundle.message((String)"plugins.configurable.plugin.details", (Object[])new Object[0]));
                break;
            }
            case PROGRESS: {
                this.myLoadingIcon.setVisible(true);
                this.myLoadingIcon.resume();
            }
        }
    }

    private void showPlugin() {
        String vendor;
        this.myNameComponent.setText("<html><span>" + this.myPlugin.getName() + "</span></html>");
        this.updateIcon();
        this.updateButtons();
        boolean bundled = this.myPlugin.isBundled() && !this.myPlugin.allowBundledUpdate();
        Object version2 = this.myPlugin.getVersion();
        if (bundled) {
            version2 = "bundled" + (String)(StringUtil.isEmptyOrSpaces((String)version2) ? "" : " " + (String)version2);
        }
        if (this.myUpdateDescriptor != null) {
            version2 = PluginManagerConfigurable.getVersion(this.myPlugin, this.myUpdateDescriptor);
        }
        this.myVersion.setText((String)version2);
        this.myVersionSize.setText((String)version2);
        this.myVersion.setPreferredSize(new Dimension(this.myVersionSize.getPreferredSize().width + JBUIScale.scale((int)4), this.myVersionSize.getPreferredSize().height));
        this.myVersion.setVisible(!StringUtil.isEmptyOrSpaces((String)version2));
        this.myTagPanel.setTags(PluginManagerConfigurable.getTags(this.myPlugin));
        if (this.myMarketplace) {
            String rating = PluginManagerConfigurable.getRating(this.myPlugin);
            this.myRating.setText(rating);
            this.myRating.setVisible(rating != null);
            String downloads = PluginManagerConfigurable.getDownloads(this.myPlugin);
            this.myDownloads.setText(downloads);
            this.myDownloads.setVisible(downloads != null);
            String size = PluginManagerConfigurable.getSize(this.myPlugin);
            this.mySize.setText(IdeBundle.message((String)"plugins.configurable.size.0", (Object[])new Object[]{size}));
            this.mySize.setVisible(!StringUtil.isEmptyOrSpaces((String)size));
        } else {
            this.updateEnabledForProject();
        }
        String string = vendor = this.myPlugin.isBundled() ? null : StringUtil.trim((String)this.myPlugin.getVendor());
        if (StringUtil.isEmptyOrSpaces((String)vendor)) {
            this.myVendor.hide();
        } else {
            this.myVendor.show(vendor, () -> this.mySearchListener.linkSelected(null, (Object)(SearchWords.ORGANIZATION.getValue() + (vendor.indexOf(32) == -1 ? vendor : StringUtil.wrapWithDoubleQuote((String)vendor)))));
        }
        this.showLicensePanel();
        if (bundled || !this.isPluginFromMarketplace()) {
            this.myHomePage.hide();
        } else {
            this.myHomePage.show(IdeBundle.message((String)"plugins.configurable.plugin.homepage.link", (Object[])new Object[0]), () -> BrowserUtil.browse((String)(MARKETPLACE_LINK + URLUtil.encodeURIComponent((String)this.myPlugin.getPluginId().getIdString()))));
        }
        String date = PluginManagerConfigurable.getLastUpdatedDate(this.myUpdateDescriptor == null ? this.myPlugin : this.myUpdateDescriptor);
        this.myDate.setText(date);
        this.myDate.setVisible(date != null);
        this.myBottomScrollPane.setHorizontalScrollBarPolicy(31);
        String description = this.getDescription();
        if (description != null && !description.equals(this.myDescription)) {
            this.myDescription = description;
            this.myDescriptionComponent.setText(XmlStringUtil.wrapInHtml((CharSequence)description));
            if (this.myDescriptionComponent.getCaret() != null) {
                this.myDescriptionComponent.setCaretPosition(0);
            }
        }
        this.myDescriptionComponent.setVisible(description != null);
        this.myChangeNotesPanel.show(this.getChangeNotes());
        ApplicationManager.getApplication().invokeLater(() -> {
            IdeEventQueue.getInstance().flushQueue();
            ((JBScrollBar)this.myBottomScrollPane.getVerticalScrollBar()).setCurrentValue(0);
        }, ModalityState.any());
        if (MyPluginModel.isInstallingOrUpdate(this.myPlugin)) {
            this.showProgress();
        } else {
            this.fullRepaint();
        }
    }

    private boolean isPluginFromMarketplace() {
        try {
            List<String> marketplacePlugins2 = MarketplaceRequests.getInstance().getMarketplaceCachedPlugins();
            if (marketplacePlugins2 != null) {
                return marketplacePlugins2.contains(this.myPlugin.getPluginId().getIdString());
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    MarketplaceRequests.getInstance().getMarketplacePlugins(null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private void showLicensePanel() {
        String productCode = this.myPlugin.getProductCode();
        if (this.myPlugin.isBundled() || LicensePanel.isEA2Product(productCode)) {
            this.myLicensePanel.hideWithChildren();
            return;
        }
        if (productCode == null) {
            if (this.myUpdateDescriptor != null && this.myUpdateDescriptor.getProductCode() != null && !LicensePanel.isEA2Product(this.myUpdateDescriptor.getProductCode())) {
                this.myLicensePanel.setText(IdeBundle.message((String)"label.next.plugin.version.is.paid.use.the.trial.for.up.to.30.days.or", (Object[])new Object[0]), true, false);
                this.myLicensePanel.showBuyPlugin(() -> this.myUpdateDescriptor);
                this.myLicensePanel.setVisible(true);
            } else {
                this.myLicensePanel.hideWithChildren();
            }
        } else if (this.myMarketplace) {
            this.myLicensePanel.setText(IdeBundle.message((String)"label.use.the.trial.for.up.to.30.days.or", (Object[])new Object[0]), false, false);
            this.myLicensePanel.showBuyPlugin(() -> this.myPlugin);
            this.myLicensePanel.setVisible(true);
        } else {
            LicensingFacade instance = LicensingFacade.getInstance();
            if (instance == null) {
                this.myLicensePanel.hideWithChildren();
                return;
            }
            String stamp = instance.getConfirmationStamp(productCode);
            if (stamp == null) {
                if (ApplicationManager.getApplication().isEAP()) {
                    this.myTagPanel.setFirstTagTooltip(IdeBundle.message((String)"tooltip.license.not.required.for.eap.version", (Object[])new Object[0]));
                    this.myLicensePanel.hideWithChildren();
                    return;
                }
                this.myLicensePanel.setText(IdeBundle.message((String)"label.text.plugin.no.license", (Object[])new Object[0]), true, false);
            } else {
                this.myLicensePanel.setTextFromStamp(stamp, instance.getExpirationDate(productCode));
            }
            this.myTagPanel.setFirstTagTooltip(this.myLicensePanel.getMessage());
            this.myLicensePanel.setVisible(true);
        }
    }

    public void updateButtons() {
        boolean installedWithoutRestart = InstalledPluginsState.getInstance().wasInstalledWithoutRestart(this.myPlugin.getPluginId());
        if (this.myMarketplace) {
            boolean installed = InstalledPluginsState.getInstance().wasInstalled(this.myPlugin.getPluginId());
            this.myRestartButton.setVisible(installed);
            this.myInstallButton.setEnabled(PluginManagerCore.getPlugin(this.myPlugin.getPluginId()) == null && !installedWithoutRestart, IdeBundle.message((String)"plugins.configurable.installed", (Object[])new Object[0]));
            this.myInstallButton.setVisible(!installed);
            this.myUpdateButton.setVisible(false);
            this.myGearButton.setVisible(false);
        } else {
            this.myInstallButton.setVisible(false);
            boolean uninstalled = this.myPlugin instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)this.myPlugin).isDeleted();
            boolean uninstalledWithoutRestart = InstalledPluginsState.getInstance().wasUninstalledWithoutRestart(this.myPlugin.getPluginId());
            if (!uninstalled) {
                PluginId id2;
                InstalledPluginsState pluginsState = InstalledPluginsState.getInstance();
                boolean bl = uninstalled = pluginsState.wasInstalled(id2 = this.myPlugin.getPluginId()) || pluginsState.wasUpdated(id2);
            }
            if (uninstalled) {
                if (uninstalledWithoutRestart) {
                    this.myRestartButton.setVisible(false);
                    this.myInstallButton.setVisible(true);
                    this.myInstallButton.setEnabled(false, IdeBundle.message((String)"plugins.configurable.uninstalled", (Object[])new Object[0]));
                } else {
                    this.myRestartButton.setVisible(true);
                }
                this.myUpdateButton.setVisible(false);
            } else {
                this.myRestartButton.setVisible(false);
                this.updateEnabledForProject();
                this.myUpdateButton.setVisible(this.myUpdateDescriptor != null && !installedWithoutRestart);
            }
            this.myGearButton.setVisible(!uninstalled);
            this.updateEnableForNameAndIcon();
            this.updateIcon();
            this.updateErrors();
        }
    }

    private void updateIcon() {
        boolean errors = !this.myMarketplace && this.myPluginModel.hasErrors(this.myPlugin);
        this.myIconLabel.setEnabled(this.myMarketplace || this.myPluginModel.isEnabled(this.myPlugin));
        this.myIconLabel.setIcon(this.myPluginModel.getIcon(this.myPlugin, true, errors, false));
        this.myIconLabel.setDisabledIcon(this.myPluginModel.getIcon(this.myPlugin, true, errors, true));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void updateErrors() {
        @Nls Ref enableAction = new Ref();
        String message = this.myPluginModel.getErrorMessage(this.myPlugin, (Ref<? super String>)enableAction);
        if (message != null) {
            ErrorComponent.show(this.myErrorComponent, message, (String)enableAction.get(), enableAction.isNull() ? null : () -> this.handleErrors());
        }
        this.myErrorComponent.setVisible(message != null);
    }

    private void handleErrors() {
        this.myPluginModel.enableRequiredPlugins(this.myPlugin);
        this.updateIcon();
        this.updateEnabledState();
        this.fullRepaint();
    }

    public void showProgress() {
        this.myIndicator = new OneLineProgressIndicator(false);
        this.myIndicator.setCancelRunnable(() -> this.myPluginModel.finishInstall(this.myPlugin, null, false, false, true));
        this.myNameAndButtons.setProgressComponent(null, this.myIndicator.createBaselineWrapper());
        MyPluginModel.addProgress(this.myPlugin, this.myIndicator);
        this.fullRepaint();
    }

    private void fullRepaint() {
        this.doLayout();
        this.revalidate();
        this.repaint();
    }

    public void hideProgress(boolean success) {
        this.hideProgress(success, true);
    }

    private void hideProgress(boolean success, boolean repaint) {
        this.myIndicator = null;
        this.myNameAndButtons.removeProgressComponent();
        if (success) {
            this.updateButtons();
        }
        if (repaint) {
            this.fullRepaint();
        }
    }

    private void updateEnableForNameAndIcon() {
        boolean enabled = this.myPluginModel.isEnabled(this.myPlugin);
        this.myNameComponent.setForeground(enabled ? null : ListPluginComponent.DisabledColor);
        this.myIconLabel.setEnabled(enabled);
    }

    public void updateEnabledState() {
        if (this.myMarketplace || this.myPlugin == null) {
            return;
        }
        this.updateIcon();
        this.updateEnableForNameAndIcon();
        this.updateErrors();
        this.updateEnabledForProject();
        this.myUpdateButton.setVisible(this.myUpdateDescriptor != null);
        this.fullRepaint();
    }

    private void updateEnabledForProject() {
        PluginEnabledState state = this.myPluginModel.getState(this.myPlugin);
        this.myEnabledForProject.setText(state.toString());
        this.myEnabledForProject.setIcon(UIUtils.perProjectIcon(state));
    }

    public void startLoading() {
        this.select(1, true);
        this.setEmptyState(EmptyState.PROGRESS);
        this.fullRepaint();
    }

    public void stopLoading() {
        this.myLoadingIcon.suspend();
        this.myLoadingIcon.setVisible(false);
        this.fullRepaint();
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.updateIconLocation();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.updateIconLocation();
    }

    private void updateIconLocation() {
        if (this.myLoadingIcon.isVisible()) {
            this.myLoadingIcon.updateLocation((JComponent)this);
        }
    }

    @Nullable
    private String getDescription() {
        String description = this.myPlugin.getDescription();
        return StringUtil.isEmptyOrSpaces((String)description) ? null : description;
    }

    @Nullable
    @NlsSafe
    private String getChangeNotes() {
        String notes;
        if (this.myUpdateDescriptor != null && !StringUtil.isEmptyOrSpaces((String)(notes = this.myUpdateDescriptor.getChangeNotes()))) {
            return notes;
        }
        notes = this.myPlugin.getChangeNotes();
        return StringUtil.isEmptyOrSpaces((String)notes) ? null : notes;
    }

    @NotNull
    private DefaultActionGroup createGearActions() {
        DefaultActionGroup result2 = new DefaultActionGroup();
        result2.add((AnAction)new EnableDisableAction(PluginEnabledState.ENABLED));
        result2.add((AnAction)new EnableDisableAction(PluginEnabledState.ENABLED_FOR_PROJECT));
        result2.addSeparator();
        result2.add((AnAction)new EnableDisableAction(PluginEnabledState.DISABLED));
        result2.add((AnAction)new EnableDisableAction(PluginEnabledState.DISABLED_FOR_PROJECT));
        result2.addSeparator();
        result2.add((AnAction)new UninstallAction());
        DefaultActionGroup defaultActionGroup = result2;
        if (defaultActionGroup == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(10);
        }
        return defaultActionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchListener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginDetailsPageComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "centerPanel";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginDetailsPageComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeaderPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createNameComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptionComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createGearActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isShowingPlugin";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMetricsPanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setFont";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showPlugin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class UninstallAction
    extends SelectionBasedPluginModelAction.UninstallAction<PluginDetailsPageComponent> {
        private UninstallAction() {
            super(PluginDetailsPageComponent.this.myPluginModel, PluginDetailsPageComponent.this, List.of(PluginDetailsPageComponent.this));
        }

        @Override
        @Nullable
        protected IdeaPluginDescriptor getPluginDescriptor(@NotNull PluginDetailsPageComponent component2) {
            if (component2 == null) {
                UninstallAction.$$$reportNull$$$0(0);
            }
            return component2.myPlugin;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/plugins/newui/PluginDetailsPageComponent$UninstallAction", "getPluginDescriptor"));
        }
    }

    private final class EnableDisableAction
    extends SelectionBasedPluginModelAction.EnableDisableAction<PluginDetailsPageComponent> {
        private EnableDisableAction(PluginEnabledState newState2) {
            if (newState2 == null) {
                EnableDisableAction.$$$reportNull$$$0(0);
            }
            super(PluginDetailsPageComponent.this.myPluginModel, List.of(PluginDetailsPageComponent.this), newState2);
        }

        @Override
        @Nullable
        protected IdeaPluginDescriptor getPluginDescriptor(@NotNull PluginDetailsPageComponent component2) {
            if (component2 == null) {
                EnableDisableAction.$$$reportNull$$$0(1);
            }
            return PluginDetailsPageComponent.this.myPlugin;
        }

        @Override
        protected boolean isInvisible(@NotNull PluginEnabledState oldState) {
            if (oldState == null) {
                EnableDisableAction.$$$reportNull$$$0(2);
            }
            return super.isInvisible(oldState) || this.myNewState.isPerProject() && PluginDetailsPageComponent.this.myRequiresRestart || !this.myNewState.isEnabled() && PluginDetailsPageComponent.this.myPluginIsRequired;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newState";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldState";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/newui/PluginDetailsPageComponent$EnableDisableAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPluginDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInvisible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum EmptyState {
        NONE_SELECTED,
        MULTI_SELECT,
        PROGRESS;

    }
}

