/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl.dataRules;

import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageDataUtil;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileArrayRule
implements GetDataRule {
    @Nullable
    private static Set<VirtualFile> addFiles(@Nullable Set<VirtualFile> set2, VirtualFile[] files2) {
        for (VirtualFile file2 : files2) {
            set2 = VirtualFileArrayRule.addFile(set2, file2);
        }
        return set2;
    }

    @Nullable
    private static Set<VirtualFile> addFile(@Nullable Set<VirtualFile> set2, @Nullable VirtualFile file2) {
        if (file2 == null) {
            return set2;
        }
        if (set2 == null) {
            set2 = new LinkedHashSet<VirtualFile>();
        }
        set2.add(file2);
        return set2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getData(@NotNull DataProvider dataProvider) {
        if (dataProvider == null) {
            VirtualFileArrayRule.$$$reportNull$$$0(0);
        }
        Set<VirtualFile> result2 = null;
        FileSystemTree fileSystemTree = (FileSystemTree)FileSystemTree.DATA_KEY.getData(dataProvider);
        if (fileSystemTree != null) {
            result2 = VirtualFileArrayRule.addFiles(null, fileSystemTree.getSelectedFiles());
        } else {
            Module selectedModule;
            Module[] selectedModules;
            Project project = (Project)PlatformDataKeys.PROJECT_CONTEXT.getData(dataProvider);
            if (project != null && !project.isDisposed()) {
                result2 = VirtualFileArrayRule.addFiles(null, ProjectRootManager.getInstance((Project)project).getContentRoots());
            }
            if ((selectedModules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataProvider)) != null && selectedModules.length > 0) {
                void var8_12;
                Module[] moduleArray = selectedModules;
                int n = moduleArray.length;
                boolean j = false;
                while (var8_12 < n) {
                    VirtualFile[] selectedModule2 = moduleArray[var8_12];
                    result2 = VirtualFileArrayRule.addFiles(result2, ModuleRootManager.getInstance((Module)selectedModule2).getContentRoots());
                    ++var8_12;
                }
            }
            if ((selectedModule = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataProvider)) != null && !selectedModule.isDisposed()) {
                result2 = VirtualFileArrayRule.addFiles(result2, ModuleRootManager.getInstance((Module)selectedModule).getContentRoots());
            }
        }
        PsiElement[] psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataProvider);
        if (psiElements != null) {
            for (Module module : psiElements) {
                result2 = VirtualFileArrayRule.addFilesFromPsiElement(result2, (PsiElement)module);
            }
        }
        result2 = VirtualFileArrayRule.addFile(result2, (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataProvider));
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataProvider);
        if (psiFile != null) {
            result2 = VirtualFileArrayRule.addFile(result2, psiFile.getVirtualFile());
        }
        if (result2 != null) {
            return VfsUtilCore.toVirtualFileArray(result2);
        }
        PsiElement elem = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataProvider);
        if (elem != null) {
            result2 = VirtualFileArrayRule.addFilesFromPsiElement(null, elem);
        }
        Usage[] usages = (Usage[])UsageView.USAGES_KEY.getData(dataProvider);
        UsageTarget[] usageTargetArray = (UsageTarget[])UsageView.USAGE_TARGETS_KEY.getData(dataProvider);
        if (usages != null || usageTargetArray != null) {
            for (VirtualFile file2 : UsageDataUtil.provideVirtualFileArray((Usage[])usages, (UsageTarget[])usageTargetArray)) {
                result2 = VirtualFileArrayRule.addFile(result2, file2);
            }
        }
        if (result2 == null) {
            Object[] objects = (Object[])dataProvider.getData(PlatformDataKeys.SELECTED_ITEMS.getName());
            if (objects != null) {
                VirtualFile[] files2 = new VirtualFile[objects.length];
                for (Object object : objects) {
                    if (!(object instanceof VirtualFile)) {
                        return null;
                    }
                    files2[i] = (VirtualFile)object;
                }
                return files2;
            }
            return null;
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    private static Set<VirtualFile> addFilesFromPsiElement(Set<VirtualFile> files2, @NotNull PsiElement elem) {
        if (elem == null) {
            VirtualFileArrayRule.$$$reportNull$$$0(1);
        }
        if (elem instanceof PsiDirectory) {
            files2 = VirtualFileArrayRule.addFile(files2, ((PsiDirectory)elem).getVirtualFile());
        } else if (elem instanceof PsiFile) {
            files2 = VirtualFileArrayRule.addFile(files2, ((PsiFile)elem).getVirtualFile());
        } else if (elem instanceof PsiDirectoryContainer) {
            for (PsiDirectory dir : ((PsiDirectoryContainer)elem).getDirectories()) {
                files2 = VirtualFileArrayRule.addFile(files2, dir.getVirtualFile());
            }
        } else {
            PsiFile file2 = elem.getContainingFile();
            if (file2 != null) {
                files2 = VirtualFileArrayRule.addFile(files2, file2.getVirtualFile());
            }
        }
        return files2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/impl/dataRules/VirtualFileArrayRule";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addFilesFromPsiElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

