/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptor;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.FileTemplateTab;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

abstract class FileTemplateTabAsTree
extends FileTemplateTab {
    private final JTree myTree;
    private final FileTemplateNode myRoot = this.initModel();

    protected FileTemplateTabAsTree(@NlsContexts.TabTitle String title) {
        super(title);
        MyTreeModel treeModel = new MyTreeModel(this.myRoot);
        this.myTree = new Tree((TreeModel)treeModel);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.expandPath(TreeUtil.getPathFromRoot((TreeNode)this.myRoot));
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setCellRenderer(new MyTreeCellRenderer());
        this.myTree.expandRow(0);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FileTemplateTabAsTree.this.onTemplateSelected();
            }
        });
        new TreeSpeedSearch(this.myTree);
    }

    protected abstract FileTemplateNode initModel();

    @Override
    public void removeSelected() {
    }

    @Override
    protected void initSelection(FileTemplate selection) {
        if (selection != null) {
            this.selectTemplate(selection);
        } else {
            TreeUtil.promiseSelectFirst((JTree)this.myTree);
        }
    }

    @Override
    public void selectTemplate(FileTemplate template) {
        FileTemplateNode node;
        Object name = template.getName();
        if (!template.getExtension().isEmpty()) {
            name = (String)name + "." + template.getExtension();
        }
        if ((node = (FileTemplateNode)TreeUtil.findNodeWithObject((DefaultMutableTreeNode)this.myRoot, (Object)name)) != null) {
            TreeUtil.selectNode((JTree)this.myTree, (TreeNode)node);
            this.onTemplateSelected();
        }
    }

    @Override
    @Nullable
    public FileTemplate getSelectedTemplate() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        FileTemplateNode node = (FileTemplateNode)selectionPath.getLastPathComponent();
        return this.getTemplate(node);
    }

    @Nullable
    private FileTemplate getTemplate(FileTemplateNode node) {
        String templateName = node.getTemplateName();
        if (templateName == null || this.myTemplates.isEmpty()) {
            return null;
        }
        for (FileTemplateBase template : this.myTemplates) {
            if (!templateName.equals(template.getQualifiedName()) && !templateName.equals(template.getName())) continue;
            return template;
        }
        return null;
    }

    @Override
    public JComponent getComponent() {
        return this.myTree;
    }

    @Override
    public void fireDataChanged() {
    }

    @Override
    public void addTemplate(FileTemplate newTemplate) {
    }

    @Override
    public void insertTemplate(FileTemplate newTemplate, int index) {
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setBorderSelectionColor(null);
            this.setBackgroundSelectionColor(null);
            this.setBackgroundNonSelectionColor(null);
            super.getTreeCellRendererComponent(tree, value2, sel, expanded, leaf, row, hasFocus);
            this.setBackground(UIUtil.getTreeBackground((boolean)sel, (boolean)hasFocus));
            this.setForeground(UIUtil.getTreeForeground((boolean)sel, (boolean)hasFocus));
            if (value2 instanceof FileTemplateNode) {
                FileTemplateNode node = (FileTemplateNode)value2;
                this.setText((String)node.getUserObject());
                this.setIcon(node.getIcon());
                FileTemplate template = FileTemplateTabAsTree.this.getTemplate(node);
                if (template != null && !template.isDefault() && !sel) {
                    this.setForeground(FileTemplateTab.MODIFIED_FOREGROUND);
                }
            }
            return this;
        }
    }

    private static class MyTreeModel
    extends DefaultTreeModel {
        MyTreeModel(FileTemplateNode root) {
            super(root);
        }
    }

    protected static class FileTemplateNode
    extends DefaultMutableTreeNode {
        private final Icon myIcon;
        private final String myTemplateName;

        FileTemplateNode(FileTemplateDescriptor descriptor2) {
            this(descriptor2.getDisplayName(), descriptor2.getIcon(), descriptor2 instanceof FileTemplateGroupDescriptor ? ContainerUtil.map2List((Collection)((FileTemplateGroupDescriptor)descriptor2).getTemplates(), s -> new FileTemplateNode((FileTemplateDescriptor)s)) : Collections.emptyList(), descriptor2 instanceof FileTemplateGroupDescriptor ? null : descriptor2.getFileName());
        }

        FileTemplateNode(String name, Icon icon2, List<? extends FileTemplateNode> children2) {
            this(name, icon2, children2, null);
        }

        FileTemplateNode(Icon icon2, String templateName) {
            this(templateName, icon2, Collections.emptyList(), templateName);
        }

        private FileTemplateNode(String name, Icon icon2, List<? extends FileTemplateNode> children2, String templateName) {
            super(name);
            this.myIcon = icon2;
            this.myTemplateName = templateName;
            for (FileTemplateNode fileTemplateNode : children2) {
                this.add(fileTemplateNode);
            }
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        public String getTemplateName() {
            return this.myTemplateName;
        }
    }
}

