/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.GotoActionAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.Changeable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.OnOffButton;
import com.intellij.util.IconUtil;
import com.intellij.util.Processor;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TopHitSEContributor
implements SearchEverywhereContributor<Object> {
    public static final int TOP_HIT_ELEMENT_PRIORITY = 15000;
    private final Project myProject;
    private final Component myContextComponent;
    private final Consumer<? super String> mySearchStringSetter;

    public TopHitSEContributor(Project project, Component component2, Consumer<? super String> setter) {
        this.myProject = project;
        this.myContextComponent = component2;
        this.mySearchStringSetter = setter;
    }

    @NotNull
    public String getSearchProviderId() {
        String string = TopHitSEContributor.class.getSimpleName();
        if (string == null) {
            TopHitSEContributor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupName() {
        String string = IdeBundle.message((String)"search.everywhere.group.name.top.hit", (Object[])new Object[0]);
        if (string == null) {
            TopHitSEContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int getSortWeight() {
        return 50;
    }

    public boolean showInFindResults() {
        return false;
    }

    public void fetchElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super Object> consumer2) {
        if (pattern == null) {
            TopHitSEContributor.$$$reportNull$$$0(2);
        }
        if (progressIndicator == null) {
            TopHitSEContributor.$$$reportNull$$$0(3);
        }
        if (consumer2 == null) {
            TopHitSEContributor.$$$reportNull$$$0(4);
        }
        this.fill(pattern, consumer2);
    }

    @NotNull
    public List<SearchEverywhereCommandInfo> getSupportedCommands() {
        ArrayList<SearchEverywhereCommandInfo> res2 = new ArrayList<SearchEverywhereCommandInfo>();
        HashSet<String> found = new HashSet<String>();
        for (SearchTopHitProvider provider2 : (SearchTopHitProvider[])SearchTopHitProvider.EP_NAME.getExtensions()) {
            String providerId;
            if (!(provider2 instanceof OptionsSearchTopHitProvider) || found.contains(providerId = ((OptionsSearchTopHitProvider)provider2).getId())) continue;
            found.add(providerId);
            res2.add(new SearchEverywhereCommandInfo(providerId, "", (SearchEverywhereContributor)this));
        }
        ArrayList<SearchEverywhereCommandInfo> arrayList = res2;
        if (arrayList == null) {
            TopHitSEContributor.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public Object getDataForItem(@NotNull Object element2, @NotNull String dataId) {
        if (element2 == null) {
            TopHitSEContributor.$$$reportNull$$$0(6);
        }
        if (dataId == null) {
            TopHitSEContributor.$$$reportNull$$$0(7);
        }
        return null;
    }

    public boolean processSelectedItem(@NotNull Object selected2, int modifiers, @NotNull String text2) {
        if (selected2 == null) {
            TopHitSEContributor.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            TopHitSEContributor.$$$reportNull$$$0(9);
        }
        if (selected2 instanceof BooleanOptionDescription) {
            BooleanOptionDescription option2;
            option2.setOptionState(!(option2 = (BooleanOptionDescription)selected2).isOptionEnabled());
            return false;
        }
        if (selected2 instanceof OptionsTopHitProvider) {
            this.setSearchString(SearchTopHitProvider.getTopHitAccelerator() + ((OptionsTopHitProvider)selected2).getId() + " ");
            return false;
        }
        if (TopHitSEContributor.isActionValue(selected2) || TopHitSEContributor.isSetting(selected2)) {
            GotoActionAction.openOptionOrPerformAction(selected2, "", this.myProject, this.myContextComponent);
            return true;
        }
        return false;
    }

    public int getElementPriority(@NotNull Object element2, @NotNull String searchPattern) {
        if (element2 == null) {
            TopHitSEContributor.$$$reportNull$$$0(10);
        }
        if (searchPattern == null) {
            TopHitSEContributor.$$$reportNull$$$0(11);
        }
        return 15000;
    }

    @NotNull
    public ListCellRenderer<? super Object> getElementsRenderer() {
        return new TopHitRenderer(this.myProject);
    }

    private void fill(@NotNull String pattern, @NotNull Processor<Object> consumer2) {
        if (pattern == null) {
            TopHitSEContributor.$$$reportNull$$$0(12);
        }
        if (consumer2 == null) {
            TopHitSEContributor.$$$reportNull$$$0(13);
        }
        if (pattern.startsWith(SearchTopHitProvider.getTopHitAccelerator()) && !pattern.contains(" ")) {
            return;
        }
        if (this.fillActions(pattern, consumer2)) {
            return;
        }
        this.fillFromExtensions(pattern, consumer2);
    }

    private void fillFromExtensions(@NotNull String pattern, Processor<Object> consumer2) {
        if (pattern == null) {
            TopHitSEContributor.$$$reportNull$$$0(14);
        }
        for (SearchTopHitProvider provider2 : (SearchTopHitProvider[])SearchTopHitProvider.EP_NAME.getExtensions()) {
            boolean[] interrupted = new boolean[]{false};
            provider2.consumeTopHits(pattern, o -> {
                interrupted[0] = !consumer2.process(o);
            }, this.myProject);
            if (!interrupted[0]) continue;
            return;
        }
    }

    private boolean fillActions(String pattern, Processor<Object> consumer2) {
        ActionManager actionManager = ActionManager.getInstance();
        List actions = AbbreviationManager.getInstance().findActions(pattern);
        for (String actionId : actions) {
            AnAction action2 = actionManager.getAction(actionId);
            if (action2 == null || !this.isEnabled(action2) || consumer2.process((Object)action2)) continue;
            return true;
        }
        return false;
    }

    private boolean isEnabled(AnAction action2) {
        Presentation presentation2 = action2.getTemplatePresentation();
        if (ActionUtil.isDumbMode((Project)this.myProject) && !action2.isDumbAware()) {
            return false;
        }
        return presentation2.isEnabled() && presentation2.isVisible() && !StringUtil.isEmpty((String)presentation2.getText());
    }

    private void setSearchString(String str) {
        this.mySearchStringSetter.accept(str);
    }

    private static boolean isActionValue(Object o) {
        return o instanceof AnAction;
    }

    private static boolean isSetting(Object o) {
        return o instanceof OptionDescription;
    }

    @Nls
    private static String getSettingText(OptionDescription value2) {
        Object hit = value2.getHit();
        if (hit == null) {
            hit = value2.getOption();
        }
        if (((String)(hit = StringUtil.unescapeXmlEntities((String)hit))).length() > 60) {
            hit = ((String)hit).substring(0, 60) + "...";
        }
        hit = ((String)hit).replace("  ", " ");
        String text2 = ((String)hit).trim();
        text2 = StringUtil.trimEnd((String)text2, (String)":");
        return text2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/TopHitSEContributor";
                break;
            }
            case 2: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/TopHitSEContributor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedCommands";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fetchElements";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDataForItem";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processSelectedItem";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElementPriority";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fill";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fillFromExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TopHitRenderer
    extends ColoredListCellRenderer<Object> {
        private final Project myProject;

        private TopHitRenderer(Project project) {
            this.myProject = project;
        }

        public Component getListCellRendererComponent(JList<?> list2, Object value2, int index, boolean selected2, boolean hasFocus) {
            Component cmp = super.getListCellRendererComponent(list2, value2, index, selected2, hasFocus);
            if (value2 instanceof BooleanOptionDescription) {
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.setBackground(UIUtil.getListBackground((boolean)selected2, (boolean)true));
                OnOffButton button2 = new OnOffButton();
                button2.setSelected(((BooleanOptionDescription)value2).isOptionEnabled());
                panel2.add(cmp, "Center");
                panel2.add((Component)button2, "East");
                cmp = panel2;
            }
            return cmp;
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                TopHitRenderer.$$$reportNull$$$0(0);
            }
            this.setPaintFocusBorder(false);
            this.setIcon(EmptyIcon.ICON_16);
            ApplicationManager.getApplication().runReadAction(() -> {
                if (TopHitSEContributor.isActionValue(value2)) {
                    AnAction anAction = (AnAction)value2;
                    Presentation templatePresentation = anAction.getTemplatePresentation();
                    Icon icon2 = templatePresentation.getIcon();
                    if (anAction instanceof ActivateToolWindowAction) {
                        String id2 = ((ActivateToolWindowAction)anAction).getToolWindowId();
                        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(id2);
                        if (toolWindow != null) {
                            icon2 = toolWindow.getIcon();
                        }
                    }
                    this.append(String.valueOf(templatePresentation.getText()));
                    if (icon2 != null && icon2.getIconWidth() <= 16 && icon2.getIconHeight() <= 16) {
                        this.setIcon(IconUtil.toSize((Icon)icon2, (int)16, (int)16));
                    }
                } else if (TopHitSEContributor.isSetting(value2)) {
                    String text2 = TopHitSEContributor.getSettingText((OptionDescription)value2);
                    SimpleTextAttributes attrs = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    if (value2 instanceof Changeable && ((Changeable)value2).hasChanged()) {
                        if (selected2) {
                            attrs = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                        } else {
                            SimpleTextAttributes base = SimpleTextAttributes.LINK_BOLD_ATTRIBUTES;
                            attrs = base.derive(1, base.getFgColor(), null, null);
                        }
                    }
                    this.append(text2, attrs);
                } else if (value2 instanceof OptionsTopHitProvider) {
                    this.append(SearchTopHitProvider.getTopHitAccelerator() + ((OptionsTopHitProvider)value2).getId());
                } else {
                    ItemPresentation presentation2 = null;
                    if (value2 instanceof ItemPresentation) {
                        presentation2 = (ItemPresentation)value2;
                    } else if (value2 instanceof NavigationItem) {
                        presentation2 = ((NavigationItem)value2).getPresentation();
                    }
                    if (presentation2 != null) {
                        String text3 = presentation2.getPresentableText();
                        this.append(text3 == null ? value2.toString() : text3);
                        Icon icon3 = presentation2.getIcon(false);
                        if (icon3 != null) {
                            this.setIcon(icon3);
                        }
                    }
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/actions/searcheverywhere/TopHitSEContributor$TopHitRenderer", "customizeCellRenderer"));
        }
    }
}

