/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.models.RevisionProcessingProgress;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.text.DateFormatUtil;

public abstract class FileDifferenceModel {
    protected final Project myProject;
    protected final IdeaGateway myGateway;
    private final boolean isRightContentCurrent;

    protected FileDifferenceModel(Project p, IdeaGateway gw, boolean currentRightContent) {
        this.myProject = p;
        this.myGateway = gw;
        this.isRightContentCurrent = currentRightContent;
    }

    @NlsContexts.DialogTitle
    public String getTitle() {
        Entry e = this.getRightEntry();
        if (e == null) {
            e = this.getLeftEntry();
        }
        if (e == null) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)e.getPath());
    }

    @NlsContexts.Label
    public String getLeftTitle(RevisionProcessingProgress p) {
        if (!this.hasLeftEntry()) {
            return LocalHistoryBundle.message("file.does.not.exist", new Object[0]);
        }
        return FileDifferenceModel.formatTitle(this.getLeftEntry(), this.isLeftContentAvailable(p));
    }

    @NlsContexts.Label
    public String getRightTitle(RevisionProcessingProgress p) {
        if (!this.hasRightEntry()) {
            return LocalHistoryBundle.message("file.does.not.exist", new Object[0]);
        }
        if (!this.isRightContentAvailable(p)) {
            return FileDifferenceModel.formatTitle(this.getRightEntry(), false);
        }
        if (this.isRightContentCurrent) {
            return LocalHistoryBundle.message("current.revision", new Object[0]);
        }
        return FileDifferenceModel.formatTitle(this.getRightEntry(), true);
    }

    @NlsContexts.Label
    private static String formatTitle(Entry e, boolean isAvailable) {
        String result2 = DateFormatUtil.formatDateTime((long)e.getTimestamp()) + " - " + e.getName();
        if (!isAvailable) {
            result2 = result2 + " - " + LocalHistoryBundle.message("content.not.available", new Object[0]);
        }
        return result2;
    }

    protected abstract Entry getLeftEntry();

    protected abstract Entry getRightEntry();

    public DiffContent getLeftDiffContent(RevisionProcessingProgress p) {
        if (!this.hasLeftEntry()) {
            return DiffContentFactory.getInstance().createEmpty();
        }
        if (!this.isLeftContentAvailable(p)) {
            return DiffContentFactory.getInstance().create(LocalHistoryBundle.message("content.not.available", new Object[0]));
        }
        return this.doGetLeftDiffContent(p);
    }

    public DiffContent getRightDiffContent(RevisionProcessingProgress p) {
        if (!this.hasRightEntry()) {
            return DiffContentFactory.getInstance().createEmpty();
        }
        if (!this.isRightContentAvailable(p)) {
            return DiffContentFactory.getInstance().create(LocalHistoryBundle.message("content.not.available", new Object[0]));
        }
        if (this.isRightContentCurrent) {
            return this.getEditableRightDiffContent(p);
        }
        return this.getReadOnlyRightDiffContent(p);
    }

    private boolean hasLeftEntry() {
        return this.getLeftEntry() != null;
    }

    private boolean hasRightEntry() {
        return this.getRightEntry() != null;
    }

    protected abstract boolean isLeftContentAvailable(RevisionProcessingProgress var1);

    protected abstract boolean isRightContentAvailable(RevisionProcessingProgress var1);

    protected abstract DiffContent doGetLeftDiffContent(RevisionProcessingProgress var1);

    protected abstract DiffContent getReadOnlyRightDiffContent(RevisionProcessingProgress var1);

    protected abstract DiffContent getEditableRightDiffContent(RevisionProcessingProgress var1);

    protected Document getDocument() {
        return this.myGateway.getDocument(this.getRightEntry().getPath());
    }
}

