/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class DetectedFrameworksData {
    private static final Logger LOG = Logger.getInstance(DetectedFrameworksData.class);
    private PersistentHashMap<String, TIntHashSet> myExistentFrameworkFiles;
    private final Map<String, TIntHashSet> myNewFiles;
    private final MultiMap<String, DetectedFrameworkDescription> myDetectedFrameworks;
    private final Object myLock;

    public DetectedFrameworksData(@NotNull Project project) {
        if (project == null) {
            DetectedFrameworksData.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myDetectedFrameworks = new MultiMap();
        Path file2 = ProjectUtil.getProjectCachePath((Project)project, (Path)DetectedFrameworksData.getDetectionDirPath(), (boolean)true).resolve("files");
        this.myNewFiles = new THashMap();
        try {
            this.myExistentFrameworkFiles = new PersistentHashMap(file2, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, (DataExternalizer)new TIntHashSetExternalizer());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            PersistentHashMap.deleteFilesStartingWith((File)file2.toFile());
            try {
                this.myExistentFrameworkFiles = new PersistentHashMap(file2, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, (DataExternalizer)new TIntHashSetExternalizer());
            }
            catch (IOException e1) {
                LOG.error((Throwable)e1);
            }
        }
    }

    public void saveDetected() {
        try {
            this.myExistentFrameworkFiles.close();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<VirtualFile> retainNewFiles(@NotNull String detectorId, @NotNull Collection<? extends VirtualFile> files2) {
        if (detectorId == null) {
            DetectedFrameworksData.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            DetectedFrameworksData.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            TIntHashSet oldSet = this.myNewFiles.get(detectorId);
            if (oldSet == null) {
                oldSet = new TIntHashSet();
                this.myNewFiles.put(detectorId, oldSet);
            }
            TIntHashSet existentFilesSet = null;
            try {
                existentFilesSet = (TIntHashSet)this.myExistentFrameworkFiles.get((Object)detectorId);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            ArrayList<VirtualFile> newFiles = new ArrayList<VirtualFile>();
            TIntHashSet newSet = new TIntHashSet();
            for (VirtualFile virtualFile : files2) {
                int fileId = FileBasedIndex.getFileId((VirtualFile)virtualFile);
                if (existentFilesSet != null && existentFilesSet.contains(fileId)) continue;
                newFiles.add(virtualFile);
                newSet.add(fileId);
            }
            if (newSet.equals((Object)oldSet)) {
                return Collections.emptyList();
            }
            this.myNewFiles.put(detectorId, newSet);
            return newFiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDetectorsForDetectedFrameworks() {
        Object object = this.myLock;
        synchronized (object) {
            return new HashSet<String>(this.myDetectedFrameworks.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends DetectedFrameworkDescription> updateFrameworksList(String detectorId, Collection<? extends DetectedFrameworkDescription> frameworks) {
        Object object = this.myLock;
        synchronized (object) {
            Collection oldFrameworks = this.myDetectedFrameworks.remove((Object)detectorId);
            this.myDetectedFrameworks.putValues((Object)detectorId, frameworks);
            if (oldFrameworks != null) {
                frameworks.removeAll(oldFrameworks);
            }
            return frameworks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putExistentFrameworkFiles(String id2, Collection<? extends VirtualFile> files2) {
        Object object = this.myLock;
        synchronized (object) {
            TIntHashSet set2 = null;
            try {
                set2 = (TIntHashSet)this.myExistentFrameworkFiles.get((Object)id2);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            if (set2 == null) {
                set2 = new TIntHashSet();
                try {
                    this.myExistentFrameworkFiles.put((Object)id2, (Object)set2);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
            for (VirtualFile virtualFile : files2) {
                set2.add(FileBasedIndex.getFileId((VirtualFile)virtualFile));
            }
        }
    }

    @NotNull
    private static Path getDetectionDirPath() {
        Path path = PathManagerEx.getAppSystemDir().resolve("frameworks").resolve("detection");
        if (path == null) {
            DetectedFrameworksData.$$$reportNull$$$0(3);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectorId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/impl/DetectedFrameworksData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/impl/DetectedFrameworksData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectionDirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "retainNewFiles";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TIntHashSetExternalizer
    implements DataExternalizer<TIntHashSet> {
        private TIntHashSetExternalizer() {
        }

        public void save(@NotNull DataOutput out, TIntHashSet value2) throws IOException {
            if (out == null) {
                TIntHashSetExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value2.size());
            TIntIterator iterator2 = value2.iterator();
            while (iterator2.hasNext()) {
                out.writeInt(iterator2.next());
            }
        }

        public TIntHashSet read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                TIntHashSetExternalizer.$$$reportNull$$$0(1);
            }
            int size = in.readInt();
            TIntHashSet set2 = new TIntHashSet(size);
            while (size-- > 0) {
                set2.add(in.readInt());
            }
            return set2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/framework/detection/impl/DetectedFrameworksData$TIntHashSetExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

