/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.openapi.application.Experiments;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WSLCommandLineOptions {
    private boolean myLaunchWithWslExe = true;
    private boolean myExecuteCommandInShell = true;
    private boolean mySudo = false;
    private String myRemoteWorkingDirectory;
    private boolean myPassEnvVarsUsingInterop = false;
    private final List<String> myInitShellCommands = new ArrayList<String>();

    public boolean isLaunchWithWslExe() {
        return this.myLaunchWithWslExe && Experiments.getInstance().isFeatureEnabled("wsl.execute.with.wsl.exe");
    }

    @NotNull
    public WSLCommandLineOptions setLaunchWithWslExe(boolean launchWithWslExe) {
        this.myLaunchWithWslExe = launchWithWslExe;
        WSLCommandLineOptions wSLCommandLineOptions = this;
        if (wSLCommandLineOptions == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(0);
        }
        return wSLCommandLineOptions;
    }

    public boolean isExecuteCommandInShell() {
        return this.myExecuteCommandInShell;
    }

    @NotNull
    public WSLCommandLineOptions setExecuteCommandInShell(boolean executeCommandInShell) {
        this.myExecuteCommandInShell = executeCommandInShell;
        WSLCommandLineOptions wSLCommandLineOptions = this;
        if (wSLCommandLineOptions == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(1);
        }
        return wSLCommandLineOptions;
    }

    public boolean isSudo() {
        return this.mySudo;
    }

    @NotNull
    public WSLCommandLineOptions setSudo(boolean sudo) {
        this.mySudo = sudo;
        WSLCommandLineOptions wSLCommandLineOptions = this;
        if (wSLCommandLineOptions == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(2);
        }
        return wSLCommandLineOptions;
    }

    @Nullable
    public String getRemoteWorkingDirectory() {
        return this.myRemoteWorkingDirectory;
    }

    @NotNull
    public WSLCommandLineOptions setRemoteWorkingDirectory(@Nullable String remoteWorkingDirectory) {
        this.myRemoteWorkingDirectory = remoteWorkingDirectory;
        if (remoteWorkingDirectory != null && !remoteWorkingDirectory.startsWith("/")) {
            throw new AssertionError((Object)("Linux path was expected, but got " + remoteWorkingDirectory));
        }
        WSLCommandLineOptions wSLCommandLineOptions = this;
        if (wSLCommandLineOptions == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(3);
        }
        return wSLCommandLineOptions;
    }

    public boolean isPassEnvVarsUsingInterop() {
        return this.myPassEnvVarsUsingInterop;
    }

    @NotNull
    public WSLCommandLineOptions setPassEnvVarsUsingInterop(boolean passEnvVarsUsingInterop) {
        this.myPassEnvVarsUsingInterop = passEnvVarsUsingInterop;
        WSLCommandLineOptions wSLCommandLineOptions = this;
        if (wSLCommandLineOptions == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(4);
        }
        return wSLCommandLineOptions;
    }

    @NotNull
    public List<String> getInitShellCommands() {
        List<String> list2 = this.myInitShellCommands;
        if (list2 == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public WSLCommandLineOptions addInitCommand(@NotNull String initCommand) {
        if (initCommand == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(6);
        }
        this.myInitShellCommands.add(initCommand);
        WSLCommandLineOptions wSLCommandLineOptions = this;
        if (wSLCommandLineOptions == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(7);
        }
        return wSLCommandLineOptions;
    }

    public String toString() {
        return "launchWithWslExe=" + this.myLaunchWithWslExe + ", executeCommandInShell=" + this.myExecuteCommandInShell + ", sudo=" + this.mySudo + ", remoteWorkingDirectory='" + this.myRemoteWorkingDirectory + "', passEnvVarsUsingInterop=" + this.myPassEnvVarsUsingInterop + ", initCommands=" + this.myInitShellCommands;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WSLCommandLineOptions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "setLaunchWithWslExe";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "setExecuteCommandInShell";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setSudo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setRemoteWorkingDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setPassEnvVarsUsingInterop";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitShellCommands";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WSLCommandLineOptions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addInitCommand";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addInitCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

