/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl.statistics;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.ExecutorGroup;
import com.intellij.execution.impl.statistics.FusAwareRunConfiguration;
import com.intellij.execution.impl.statistics.RunConfigurationTypeUsagesCollector;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.internal.statistic.IdeActivity;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.internal.statistic.eventLog.events.ObjectEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunConfigurationUsageTriggerCollector {
    public static final String GROUP = "run.configuration.exec";
    private static final ObjectEventField ADDITIONAL_FIELD = EventFields.createAdditionalDataField((String)"run.configuration.exec", (String)"started");
    private static final StringEventField EXECUTOR = EventFields.StringValidatedByCustomRule((String)"executor", (String)"run_config_executor");
    private static final StringEventField TARGET = EventFields.StringValidatedByCustomRule((String)"target", (String)"run_target");

    @NotNull
    public static IdeActivity trigger(@NotNull Project project, @NotNull ConfigurationFactory factory2, @NotNull Executor executor, @Nullable RunConfiguration runConfiguration) {
        if (project == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(0);
        }
        if (factory2 == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(2);
        }
        ConfigurationType configurationType = factory2.getType();
        IdeActivity ideActivity = new IdeActivity(project, GROUP).startedWithData(data2 -> {
            TargetEnvironmentConfiguration target2;
            String defaultTargetName;
            List<EventPair> eventPairs = RunConfigurationTypeUsagesCollector.createFeatureUsageData(configurationType, factory2);
            ExecutorGroup group2 = ExecutorGroup.getGroupIfProxy((Executor)executor);
            eventPairs.add(EXECUTOR.with((Object)(group2 != null ? group2.getId() : executor.getId())));
            if (runConfiguration instanceof FusAwareRunConfiguration) {
                List<EventPair<?>> additionalData = ((FusAwareRunConfiguration)runConfiguration).getAdditionalUsageData();
                ObjectEventData objectEventData = new ObjectEventData(additionalData);
                eventPairs.add(ADDITIONAL_FIELD.with((Object)objectEventData));
            }
            if (runConfiguration instanceof TargetEnvironmentAwareRunProfile && (defaultTargetName = ((TargetEnvironmentAwareRunProfile)runConfiguration).getDefaultTargetName()) != null && (target2 = (TargetEnvironmentConfiguration)TargetEnvironmentsManager.getInstance((Project)project).getTargets().findByName(defaultTargetName)) != null) {
                eventPairs.add(TARGET.with((Object)target2.getTypeId()));
            }
            eventPairs.forEach(pair -> pair.addData(data2));
        });
        if (ideActivity == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(3);
        }
        return ideActivity;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/statistics/RunConfigurationUsageTriggerCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/statistics/RunConfigurationUsageTriggerCollector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "trigger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "trigger";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RunTargetValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "run_target".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                RunTargetValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                RunTargetValidator.$$$reportNull$$$0(1);
            }
            for (TargetEnvironmentType type : (TargetEnvironmentType[])TargetEnvironmentType.EXTENSION_NAME.getExtensions()) {
                if (!StringUtil.equals((CharSequence)type.getId(), (CharSequence)data2)) continue;
                PluginInfo info = PluginInfoDetectorKt.getPluginInfo(type.getClass());
                ValidationResultType validationResultType = info.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    RunTargetValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                RunTargetValidator.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/statistics/RunConfigurationUsageTriggerCollector$RunTargetValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/statistics/RunConfigurationUsageTriggerCollector$RunTargetValidator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RunConfigurationExecutorUtilValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "run_config_executor".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                RunConfigurationExecutorUtilValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                RunConfigurationExecutorUtilValidator.$$$reportNull$$$0(1);
            }
            for (Executor executor : (Executor[])Executor.EXECUTOR_EXTENSION_NAME.getExtensions()) {
                if (!StringUtil.equals((CharSequence)executor.getId(), (CharSequence)data2)) continue;
                PluginInfo info = PluginInfoDetectorKt.getPluginInfo(executor.getClass());
                ValidationResultType validationResultType = info.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    RunConfigurationExecutorUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                RunConfigurationExecutorUtilValidator.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/statistics/RunConfigurationUsageTriggerCollector$RunConfigurationExecutorUtilValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/statistics/RunConfigurationUsageTriggerCollector$RunConfigurationExecutorUtilValidator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

