/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.SimpleHelper$WhenMappings;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.fragments.MergeWordFragmentImpl;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nH\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0012\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/diff/comparison/SimpleHelper;", "", "leftText", "", "baseText", "rightText", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;Ljava/lang/CharSequence;)V", "getBaseText", "()Ljava/lang/CharSequence;", "last1", "", "last2", "last3", "getLeftText", "newContent", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getRightText", "texts", "", "append", "", "range", "Lcom/intellij/diff/util/MergeRange;", "side", "Lcom/intellij/diff/util/ThreeSide;", "appendBase", "appendConflict", "", "policy", "Lcom/intellij/diff/comparison/ComparisonPolicy;", "execute", "getConflictType", "Lcom/intellij/diff/util/MergeConflictType;", "isUnchangedRange", "nextMergeRange", "end1", "end2", "end3", "intellij.platform.diff.impl"})
final class SimpleHelper {
    private final StringBuilder newContent;
    private int last1;
    private int last2;
    private int last3;
    private final List<CharSequence> texts;
    @NotNull
    private final CharSequence leftText;
    @NotNull
    private final CharSequence baseText;
    @NotNull
    private final CharSequence rightText;

    @Nullable
    public final CharSequence execute(@NotNull ComparisonPolicy policy) {
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        List<MergeWordFragment> list2 = ByWord.compare(this.leftText, this.baseText, this.rightText, policy, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"ByWord.compare(leftText,\u2026ogressIndicator.INSTANCE)");
        List<MergeWordFragment> changes = list2;
        for (MergeWordFragment fragment : changes) {
            MergeRange baseRange = this.nextMergeRange(fragment.getStartOffset(ThreeSide.LEFT), fragment.getStartOffset(ThreeSide.BASE), fragment.getStartOffset(ThreeSide.RIGHT));
            this.appendBase(baseRange);
            MergeRange conflictRange = this.nextMergeRange(fragment.getEndOffset(ThreeSide.LEFT), fragment.getEndOffset(ThreeSide.BASE), fragment.getEndOffset(ThreeSide.RIGHT));
            if (this.appendConflict(conflictRange, policy)) continue;
            return null;
        }
        MergeRange trailingRange = this.nextMergeRange(this.leftText.length(), this.baseText.length(), this.rightText.length());
        this.appendBase(trailingRange);
        return this.newContent.toString();
    }

    private final MergeRange nextMergeRange(int end1, int end2, int end3) {
        MergeRange range2 = new MergeRange(this.last1, end1, this.last2, end2, this.last3, end3);
        this.last1 = end1;
        this.last2 = end2;
        this.last3 = end3;
        return range2;
    }

    private final void appendBase(MergeRange range2) {
        if (range2.isEmpty()) {
            return;
        }
        ComparisonPolicy policy = ComparisonPolicy.DEFAULT;
        if (this.isUnchangedRange(range2, policy)) {
            this.append(range2, ThreeSide.BASE);
        } else {
            MergeConflictType type = this.getConflictType(range2, policy);
            if (type.isChange(Side.LEFT)) {
                this.append(range2, ThreeSide.LEFT);
            } else if (type.isChange(Side.RIGHT)) {
                this.append(range2, ThreeSide.RIGHT);
            } else {
                this.append(range2, ThreeSide.BASE);
            }
        }
    }

    private final boolean appendConflict(MergeRange range2, ComparisonPolicy policy) {
        MergeConflictType type = this.getConflictType(range2, policy);
        if (Intrinsics.areEqual((Object)type.getDiffType(), (Object)TextDiffType.CONFLICT)) {
            return false;
        }
        if (type.isChange(Side.LEFT)) {
            this.append(range2, ThreeSide.LEFT);
        } else {
            this.append(range2, ThreeSide.RIGHT);
        }
        return true;
    }

    private final void append(MergeRange range2, ThreeSide side) {
        switch (SimpleHelper$WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
            case 1: {
                this.newContent.append(this.leftText, range2.start1, range2.end1);
                break;
            }
            case 2: {
                this.newContent.append(this.baseText, range2.start2, range2.end2);
                break;
            }
            case 3: {
                this.newContent.append(this.rightText, range2.start3, range2.end3);
                break;
            }
        }
    }

    private final MergeConflictType getConflictType(MergeRange range2, ComparisonPolicy policy) {
        MergeConflictType mergeConflictType = DiffUtil.getWordMergeType(new MergeWordFragmentImpl(range2), this.texts, policy);
        Intrinsics.checkNotNullExpressionValue((Object)mergeConflictType, (String)"DiffUtil.getWordMergeTyp\u2026pl(range), texts, policy)");
        return mergeConflictType;
    }

    private final boolean isUnchangedRange(MergeRange range2, ComparisonPolicy policy) {
        return DiffUtil.compareWordMergeContents(new MergeWordFragmentImpl(range2), this.texts, policy, ThreeSide.BASE, ThreeSide.LEFT) && DiffUtil.compareWordMergeContents(new MergeWordFragmentImpl(range2), this.texts, policy, ThreeSide.BASE, ThreeSide.RIGHT);
    }

    @NotNull
    public final CharSequence getLeftText() {
        return this.leftText;
    }

    @NotNull
    public final CharSequence getBaseText() {
        return this.baseText;
    }

    @NotNull
    public final CharSequence getRightText() {
        return this.rightText;
    }

    public SimpleHelper(@NotNull CharSequence leftText, @NotNull CharSequence baseText, @NotNull CharSequence rightText) {
        Intrinsics.checkNotNullParameter((Object)leftText, (String)"leftText");
        Intrinsics.checkNotNullParameter((Object)baseText, (String)"baseText");
        Intrinsics.checkNotNullParameter((Object)rightText, (String)"rightText");
        this.leftText = leftText;
        this.baseText = baseText;
        this.rightText = rightText;
        this.newContent = new StringBuilder();
        this.texts = CollectionsKt.listOf((Object[])new CharSequence[]{this.leftText, this.baseText, this.rightText});
    }
}

