/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof;

import com.intellij.diagnostic.hprof.AnalyzerProgressIndicator;
import com.intellij.diagnostic.hprof.action.SystemTempFilenameSupplier;
import com.intellij.diagnostic.hprof.analysis.AnalysisContext;
import com.intellij.diagnostic.hprof.analysis.AnalyzeClassloaderReferencesGraph;
import com.intellij.diagnostic.hprof.analysis.AnalyzeGraph;
import com.intellij.diagnostic.hprof.analysis.HProfAnalysis;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import kotlin.jvm.functions.Function2;

public final class Analyzer {
    public static void main(String[] args) throws IOException {
        String report;
        Function2 analysisCallback;
        AnalyzerProgressIndicator progress2;
        if (args.length == 0 || args.length == 1 && args[0].equals("-v")) {
            System.out.println();
            System.out.println("Usage: " + Analyzer.class.getName() + " [-v] [-plugin <plugin_id>] <hprof file>");
            System.exit(1);
        }
        boolean onlyStrongReferences = false;
        boolean includeClassesAsRoots = true;
        int index = 0;
        if (args[index].equals("-v")) {
            ++index;
            progress2 = new AnalyzerProgressIndicator();
        } else {
            progress2 = new EmptyProgressIndicator(ModalityState.NON_MODAL);
        }
        if (args[index].equals("-plugin")) {
            String pluginId = args[++index];
            analysisCallback = (analysisContext, progressIndicator) -> new AnalyzeClassloaderReferencesGraph((AnalysisContext)analysisContext, pluginId).analyze((ProgressIndicator)progressIndicator);
            onlyStrongReferences = true;
            includeClassesAsRoots = false;
            ++index;
        } else {
            analysisCallback = (analysisContext, progressIndicator) -> new AnalyzeGraph((AnalysisContext)analysisContext).analyze((ProgressIndicator)progressIndicator);
        }
        Path hprofPath = Paths.get(args[index], new String[0]);
        try (FileChannel channel2 = FileChannel.open(hprofPath, StandardOpenOption.READ);){
            HProfAnalysis analysis = new HProfAnalysis(channel2, new SystemTempFilenameSupplier(), (Function2<? super AnalysisContext, ? super ProgressIndicator, String>)analysisCallback);
            analysis.setOnlyStrongReferences(onlyStrongReferences);
            analysis.setIncludeClassesAsRoots(includeClassesAsRoots);
            report = analysis.analyze((ProgressIndicator)progress2);
            progress2.setText("DONE");
        }
        System.out.println(report);
    }
}

