/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.configurationStore.BaseXmlOutputter;
import com.intellij.configurationStore.JbXmlOutputterKt;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 =2\u00020\u0001:\u0001=BK\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u001f\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010$\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J\u0018\u0010(\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*H\u0002J6\u0010+\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0&2\u0006\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u00100\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u0003H\u0002J\u001e\u00102\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u00103\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00104\u001a\u000205H\u0002J\u0018\u00106\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00107\u001a\u00020\u0003H\u0002J.\u00108\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0&2\u0006\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0019H\u0002J\u001e\u00109\u001a\u00020\u00192\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0&2\u0006\u0010.\u001a\u00020\u0019H\u0002J\u001e\u0010:\u001a\u00020\u00192\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0&2\u0006\u0010.\u001a\u00020\u0019H\u0002J \u0010;\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010<\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/configurationStore/JbXmlOutputter;", "Lcom/intellij/configurationStore/BaseXmlOutputter;", "lineSeparator", "", "elementFilter", "Lcom/intellij/openapi/util/JDOMUtil$ElementOutputFilter;", "macroMap", "Lcom/intellij/application/options/ReplacePathToMacroMap;", "macroFilter", "Lcom/intellij/openapi/application/PathMacroFilter;", "isForbidSensitiveData", "", "storageFilePathForDebugPurposes", "(Ljava/lang/String;Lcom/intellij/openapi/util/JDOMUtil$ElementOutputFilter;Lcom/intellij/application/options/ReplacePathToMacroMap;Lcom/intellij/openapi/application/PathMacroFilter;ZLjava/lang/String;)V", "format", "Lorg/jdom/output/Format;", "Lorg/jetbrains/annotations/NotNull;", "checkIsElementContainsSensitiveInformation", "", "element", "Lorg/jdom/Element;", "indent", "out", "Ljava/io/Writer;", "level", "", "logSensitiveInformationError", "name", "elementKind", "parentElement", "newline", "output", "doctype", "Lorg/jdom/DocType;", "doc", "Lorg/jdom/Document;", "printAttributes", "attributes", "", "Lorg/jdom/Attribute;", "printCDATA", "cdata", "Lorg/jdom/CDATA;", "printContentRange", "content", "Lorg/jdom/Content;", "start", "end", "printDeclaration", "encoding", "printElement", "printProcessingInstruction", "pi", "Lorg/jdom/ProcessingInstruction;", "printString", "str", "printTextRange", "skipLeadingWhite", "skipTrailingWhite", "writeContent", "writeLineSeparator", "Companion", "intellij.platform.projectModel.impl"})
public class JbXmlOutputter
extends BaseXmlOutputter {
    private final Format format;
    private final JDOMUtil.ElementOutputFilter elementFilter;
    private final ReplacePathToMacroMap macroMap;
    private final PathMacroFilter macroFilter;
    private final boolean isForbidSensitiveData;
    private final String storageFilePathForDebugPurposes;
    private static final Set<String> reportedSensitiveProblems;
    public static final Companion Companion;

    public final void output(@NotNull Document doc, @NotNull Writer out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        String string = this.format.getEncoding();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format.encoding");
        this.printDeclaration(out, string);
        List content2 = doc.getContent();
        for (Content obj : content2) {
            Content content3 = obj;
            if (content3 instanceof Element) {
                Element element2 = doc.getRootElement();
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"doc.rootElement");
                this.printElement(out, element2, 0);
            } else if (content3 instanceof Comment) {
                JbXmlOutputterKt.access$printComment(out, (Comment)obj);
            } else if (content3 instanceof ProcessingInstruction) {
                this.printProcessingInstruction(out, (ProcessingInstruction)obj);
            } else if (content3 instanceof DocType) {
                DocType docType = doc.getDocType();
                Intrinsics.checkNotNullExpressionValue((Object)docType, (String)"doc.docType");
                this.printDocType(out, docType);
                this.writeLineSeparator(out);
            }
            this.newline(out);
            this.indent(out, 0);
        }
        this.writeLineSeparator(out);
        out.flush();
    }

    private final void writeLineSeparator(Writer out) throws IOException {
        if (this.format.getLineSeparator() != null) {
            out.write(this.format.getLineSeparator());
        }
    }

    public final void output(@NotNull DocType doctype, @NotNull Writer out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)doctype, (String)"doctype");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.printDocType(out, doctype);
        out.flush();
    }

    public final void output(@NotNull Element element2, @NotNull Writer out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.printElement(out, element2, 0);
    }

    private final void printDeclaration(Writer out, String encoding) throws IOException {
        if (!this.format.getOmitDeclaration()) {
            out.write("<?xml version=\"1.0\"");
            if (!this.format.getOmitEncoding()) {
                out.write(" encoding=\"" + encoding + '\"');
            }
            out.write("?>");
            this.writeLineSeparator(out);
        }
    }

    private final void printProcessingInstruction(Writer out, ProcessingInstruction pi) throws IOException {
        String target2 = pi.getTarget();
        boolean piProcessed = false;
        if (!this.format.getIgnoreTrAXEscapingPIs()) {
            if (Intrinsics.areEqual((Object)target2, (Object)"javax.xml.transform.disable-output-escaping")) {
                piProcessed = true;
            } else if (Intrinsics.areEqual((Object)target2, (Object)"javax.xml.transform.enable-output-escaping")) {
                piProcessed = true;
            }
        }
        if (!piProcessed) {
            String string = target2;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"target");
            this.writeProcessingInstruction(out, pi, string);
        }
    }

    private final void printCDATA(Writer out, CDATA cdata) throws IOException {
        String str = null;
        if (this.format.getTextMode() == Format.TextMode.NORMALIZE) {
            String string = cdata.getTextNormalize();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cdata.textNormalize");
            str = string;
        } else {
            String string = cdata.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cdata.text");
            str = string;
            if (this.format.getTextMode() == Format.TextMode.TRIM) {
                String string2 = str;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                str = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            }
        }
        out.write("<![CDATA[");
        out.write(str);
        out.write("]]>");
    }

    private final void printString(Writer out, String str) throws IOException {
        String normalizedString = str;
        if (this.format.getTextMode() == Format.TextMode.NORMALIZE) {
            String string = Text.normalizeString((String)normalizedString);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Text.normalizeString(normalizedString)");
            normalizedString = string;
        } else if (this.format.getTextMode() == Format.TextMode.TRIM) {
            String string = normalizedString;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            normalizedString = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        }
        if (this.macroMap != null) {
            String string = this.macroMap.substitute(normalizedString, SystemInfo.isFileSystemCaseSensitive);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"macroMap.substitute(norm\u2026sFileSystemCaseSensitive)");
            normalizedString = string;
        }
        out.write(Companion.escapeElementEntities(normalizedString));
    }

    public final void printElement(@NotNull Writer out, @NotNull Element element2, int level) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (this.elementFilter != null && !this.elementFilter.accept(element2, level)) {
            return;
        }
        out.write(60);
        JbXmlOutputterKt.access$printQualifiedName(out, element2);
        if (element2.hasAttributes()) {
            List list2 = element2.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"element.attributes");
            this.printAttributes(out, list2);
        }
        if (!this.writeContent(out, element2, level)) {
            return;
        }
        out.write("</");
        JbXmlOutputterKt.access$printQualifiedName(out, element2);
        out.write(62);
    }

    protected boolean writeContent(@NotNull Writer out, @NotNull Element element2, int level) throws IOException {
        List content2;
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (this.isForbidSensitiveData) {
            this.checkIsElementContainsSensitiveInformation(element2);
        }
        List list2 = content2 = element2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"content");
        int start2 = this.skipLeadingWhite(list2, 0);
        int size = content2.size();
        if (start2 >= size) {
            out.write(" />");
            return false;
        }
        out.write(62);
        if (JbXmlOutputterKt.access$nextNonText(content2, start2) < size) {
            this.newline(out);
            this.printContentRange(out, content2, start2, size, level + 1);
            this.newline(out);
            this.indent(out, level);
        } else {
            this.printTextRange(out, content2, start2, size);
        }
        return true;
    }

    private final void printContentRange(Writer out, List<? extends Content> content2, int start2, int end, int level) throws IOException {
        boolean firstNode = false;
        Content next = null;
        int first = 0;
        int index = 0;
        index = start2;
        while (index < end) {
            firstNode = index == start2;
            next = content2.get(index);
            if (next instanceof Text || next instanceof EntityRef) {
                first = this.skipLeadingWhite(content2, index);
                if (first >= (index = JbXmlOutputterKt.access$nextNonText(content2, first))) continue;
                if (!firstNode) {
                    this.newline(out);
                }
                this.indent(out, level);
                this.printTextRange(out, content2, first, index);
                continue;
            }
            if (!firstNode) {
                this.newline(out);
            }
            this.indent(out, level);
            Content content3 = next;
            if (content3 instanceof Comment) {
                JbXmlOutputterKt.access$printComment(out, (Comment)next);
            } else if (content3 instanceof Element) {
                this.printElement(out, (Element)next, level);
            } else if (content3 instanceof ProcessingInstruction) {
                this.printProcessingInstruction(out, (ProcessingInstruction)next);
            }
            ++index;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void printTextRange(Writer out, List<? extends Content> content2, int start2, int end) throws IOException {
        int start3 = this.skipLeadingWhite(content2, start2);
        if (start3 >= content2.size()) {
            return;
        }
        int end2 = this.skipTrailingWhite(content2, end);
        String previous = null;
        int n = start3;
        int n2 = end2;
        while (n < n2) {
            void i2;
            Content node = content2.get((int)i2);
            String next = null;
            Object object = node;
            if (object instanceof Text) {
                next = ((Text)node).getText();
            } else if (object instanceof EntityRef) {
                next = "&" + node.getValue() + ";";
            } else {
                throw (Throwable)new IllegalStateException("Should see only CDATA, Text, or EntityRef");
            }
            object = next;
            boolean bl = false;
            boolean bl2 = false;
            if (!(object == null || object.length() == 0)) {
                if (previous != null && (this.format.getTextMode() == Format.TextMode.NORMALIZE || this.format.getTextMode() == Format.TextMode.TRIM) && (JbXmlOutputterKt.access$endsWithWhite(previous) || JbXmlOutputterKt.access$startsWithWhite(next))) {
                    out.write(32);
                }
                if ((object = node) instanceof CDATA) {
                    this.printCDATA(out, (CDATA)node);
                } else if (object instanceof EntityRef) {
                    JbXmlOutputterKt.access$printEntityRef(out, (EntityRef)node);
                } else {
                    this.printString(out, next);
                }
                previous = next;
            }
            ++i2;
        }
    }

    private final void printAttributes(Writer out, List<? extends Attribute> attributes) throws IOException {
        for (Attribute attribute : attributes) {
            String value2;
            out.write(32);
            JbXmlOutputterKt.access$printQualifiedName(out, attribute);
            out.write(61);
            out.write(34);
            String string = value2 = this.macroMap != null && (this.macroFilter == null || !this.macroFilter.skipPathMacros(attribute)) ? this.macroMap.getAttributeValue(attribute, this.macroFilter, SystemInfo.isFileSystemCaseSensitive, false) : attribute.getValue();
            if (this.isForbidSensitiveData) {
                String string2 = attribute.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"attribute.name");
                if (BaseXmlOutputter.Companion.doesNameSuggestSensitiveInformation(string2)) {
                    this.logSensitiveInformationError('@' + attribute.getName(), "Attribute", attribute.getParent());
                }
            }
            String string3 = value2;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"value");
            out.write(JbXmlOutputterKt.access$escapeAttributeEntities(string3));
            out.write(34);
        }
    }

    private final void newline(Writer out) throws IOException {
        if (this.format.getIndent() != null) {
            this.writeLineSeparator(out);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void indent(Writer out, int level) throws IOException {
        CharSequence charSequence = this.format.getIndent();
        int n = 0;
        boolean bl = false;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        int n2 = 0;
        n = level;
        while (n2 < n) {
            void i2;
            out.write(this.format.getIndent());
            ++i2;
        }
    }

    private final int skipLeadingWhite(List<? extends Content> content2, int start2) {
        int index = start2;
        if (index < 0) {
            index = 0;
        }
        int size = content2.size();
        Format.TextMode textMode = this.format.getTextMode();
        if (textMode == Format.TextMode.TRIM_FULL_WHITE || textMode == Format.TextMode.NORMALIZE || textMode == Format.TextMode.TRIM) {
            while (index < size) {
                if (!JbXmlOutputterKt.access$isAllWhitespace(content2.get(index))) {
                    return index;
                }
                ++index;
            }
        }
        return index;
    }

    private final int skipTrailingWhite(List<? extends Content> content2, int start2) {
        Format.TextMode textMode;
        int index = start2;
        int size = content2.size();
        if (index > size) {
            index = size;
        }
        if ((textMode = this.format.getTextMode()) == Format.TextMode.TRIM_FULL_WHITE || textMode == Format.TextMode.NORMALIZE || textMode == Format.TextMode.TRIM) {
            while (index >= 0 && JbXmlOutputterKt.access$isAllWhitespace(content2.get(index - 1))) {
                --index;
            }
        }
        return index;
    }

    private final void checkIsElementContainsSensitiveInformation(Element element2) {
        String name;
        String string = name = element2.getName();
        Intrinsics.checkNotNull((Object)string);
        if (BaseXmlOutputter.Companion.doesNameSuggestSensitiveInformation(string)) {
            this.logSensitiveInformationError(name, "Element", element2.getParentElement());
        }
        if ((name = element2.getAttributeValue("name")) != null && BaseXmlOutputter.Companion.doesNameSuggestSensitiveInformation(name) && element2.getAttribute("value") != null) {
            this.logSensitiveInformationError("@name=" + name, "Element", element2);
        }
    }

    private final void logSensitiveInformationError(String name, String elementKind, Element parentElement) {
        String parentPath = null;
        if (parentElement == null) {
            parentPath = null;
        } else {
            ArrayList<String> ids = new ArrayList<String>();
            for (Element parent = parentElement; parent != null; parent = parent.getParentElement()) {
                String componentName;
                String parentId = parent.getName();
                if (Intrinsics.areEqual((Object)parentId, (Object)"component") && (componentName = parent.getAttributeValue("name")) != null) {
                    parentId = parentId + '@' + componentName;
                }
                ids.add(parentId);
            }
            if (ids.isEmpty()) {
                parentPath = null;
            } else {
                CollectionsKt.reverse((List)ids);
                parentPath = CollectionsKt.joinToString$default((Iterable)ids, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            }
        }
        String message = elementKind + ' ' + (parentPath == null ? "" : parentPath + '.') + name + " probably contains sensitive information";
        if (this.storageFilePathForDebugPurposes != null) {
            StringBuilder stringBuilder = new StringBuilder().append(message).append(" (file: ");
            String string = FileUtil.toSystemIndependentName((String)SystemProperties.getUserHome());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemIndepen\u2026Properties.getUserHome())");
            message = stringBuilder.append(StringsKt.replace$default((String)this.storageFilePathForDebugPurposes, (String)string, (String)"~", (boolean)false, (int)4, null)).append(')').toString();
        }
        if (reportedSensitiveProblems.add(message)) {
            Logger.getInstance(JbXmlOutputter.class).error(message);
        }
    }

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator, @Nullable JDOMUtil.ElementOutputFilter elementFilter, @Nullable ReplacePathToMacroMap macroMap, @Nullable PathMacroFilter macroFilter, boolean isForbidSensitiveData, @Nullable String storageFilePathForDebugPurposes) {
        Format format;
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        super(lineSeparator);
        this.elementFilter = elementFilter;
        this.macroMap = macroMap;
        this.macroFilter = macroFilter;
        this.isForbidSensitiveData = isForbidSensitiveData;
        this.storageFilePathForDebugPurposes = storageFilePathForDebugPurposes;
        if (Intrinsics.areEqual((Object)JbXmlOutputterKt.access$getDEFAULT_FORMAT$p().getLineSeparator(), (Object)lineSeparator)) {
            format = JbXmlOutputterKt.access$getDEFAULT_FORMAT$p();
        } else {
            Format format2 = JDOMUtil.createFormat((String)lineSeparator);
            format = format2;
            Intrinsics.checkNotNullExpressionValue((Object)format2, (String)"JDOMUtil.createFormat(lineSeparator)");
        }
        this.format = format;
    }

    public /* synthetic */ JbXmlOutputter(String string, JDOMUtil.ElementOutputFilter elementOutputFilter, ReplacePathToMacroMap replacePathToMacroMap, PathMacroFilter pathMacroFilter, boolean bl, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "\n";
        }
        if ((n & 2) != 0) {
            elementOutputFilter = null;
        }
        if ((n & 4) != 0) {
            replacePathToMacroMap = null;
        }
        if ((n & 8) != 0) {
            pathMacroFilter = null;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        this(string, elementOutputFilter, replacePathToMacroMap, pathMacroFilter, bl, string2);
    }

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator, @Nullable JDOMUtil.ElementOutputFilter elementFilter, @Nullable ReplacePathToMacroMap macroMap, @Nullable PathMacroFilter macroFilter, boolean isForbidSensitiveData) {
        this(lineSeparator, elementFilter, macroMap, macroFilter, isForbidSensitiveData, null, 32, null);
    }

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator, @Nullable JDOMUtil.ElementOutputFilter elementFilter, @Nullable ReplacePathToMacroMap macroMap, @Nullable PathMacroFilter macroFilter) {
        this(lineSeparator, elementFilter, macroMap, macroFilter, false, null, 48, null);
    }

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator, @Nullable JDOMUtil.ElementOutputFilter elementFilter, @Nullable ReplacePathToMacroMap macroMap) {
        this(lineSeparator, elementFilter, macroMap, null, false, null, 56, null);
    }

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator, @Nullable JDOMUtil.ElementOutputFilter elementFilter) {
        this(lineSeparator, elementFilter, null, null, false, null, 60, null);
    }

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator) {
        this(lineSeparator, null, null, null, false, null, 62, null);
    }

    @JvmOverloads
    public JbXmlOutputter() {
        this(null, null, null, null, false, null, 63, null);
    }

    static {
        Companion = new Companion(null);
        reportedSensitiveProblems = Collections.synchronizedSet(new HashSet());
    }

    @JvmStatic
    public static final void collapseMacrosAndWrite(@NotNull Element element2, @NotNull ComponentManager project, @NotNull Writer writer) throws IOException {
        Companion.collapseMacrosAndWrite(element2, project, writer);
    }

    @JvmStatic
    @NotNull
    public static final JbXmlOutputter createOutputter(@NotNull ComponentManager project) {
        return Companion.createOutputter(project);
    }

    @JvmStatic
    @NotNull
    public static final String collapseMacrosAndWrite(@NotNull Element element2, @NotNull ComponentManager project) throws IOException {
        return Companion.collapseMacrosAndWrite(element2, project);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\b\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/configurationStore/JbXmlOutputter$Companion;", "", "()V", "reportedSensitiveProblems", "", "", "kotlin.jvm.PlatformType", "", "collapseMacrosAndWrite", "element", "Lorg/jdom/Element;", "project", "Lcom/intellij/openapi/components/ComponentManager;", "", "writer", "Ljava/io/Writer;", "createOutputter", "Lcom/intellij/configurationStore/JbXmlOutputter;", "escapeElementEntities", "str", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        @JvmStatic
        public final void collapseMacrosAndWrite(@NotNull Element element2, @NotNull ComponentManager project, @NotNull Writer writer) throws IOException {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            this.createOutputter(project).output(element2, writer);
        }

        @JvmStatic
        @NotNull
        public final JbXmlOutputter createOutputter(@NotNull ComponentManager project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PathMacroManager pathMacroManager = PathMacroManager.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"PathMacroManager.getInstance(project)");
            PathMacroManager macroManager = pathMacroManager;
            return new JbXmlOutputter(null, null, macroManager.getReplacePathMap(), macroManager.getMacroFilter(), false, null, 51, null);
        }

        @JvmStatic
        @NotNull
        public final String collapseMacrosAndWrite(@NotNull Element element2, @NotNull ComponentManager project) throws IOException {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            StringWriter writer = new StringWriter();
            this.collapseMacrosAndWrite(element2, project, writer);
            String string = writer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.toString()");
            return string;
        }

        @NotNull
        public final String escapeElementEntities(@Nullable String str) {
            String string = str;
            Intrinsics.checkNotNull((Object)string);
            String string2 = JDOMUtil.escapeText((String)string, (boolean)false, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JDOMUtil.escapeText(str!!, false, false)");
            return string2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

