/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.AbstractPerformFixesTask;
import com.intellij.codeInspection.actions.CleanupInspectionUtil;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CleanupInspectionIntention
implements IntentionAction,
HighPriorityAction {
    private final InspectionToolWrapper myToolWrapper;
    private final FileModifier myQuickfix;
    @Nullable
    private final PsiFile myFile;
    private final String myText;

    public CleanupInspectionIntention(@NotNull InspectionToolWrapper toolWrapper, @NotNull FileModifier quickFix, @Nullable PsiFile file2, String text2) {
        if (toolWrapper == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(0);
        }
        if (quickFix == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(1);
        }
        this.myToolWrapper = toolWrapper;
        this.myQuickfix = quickFix;
        this.myFile = file2;
        this.myText = text2;
    }

    public InspectionToolWrapper getToolWrapper() {
        return this.myToolWrapper;
    }

    @NotNull
    public String getText() {
        String string = InspectionsBundle.message((String)"fix.all.inspection.problems.in.file", (Object[])new Object[]{this.myToolWrapper.getDisplayName()});
        if (string == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(4);
        }
        PsiFile targetFile = this.myFile != null ? this.myFile : file2;
        List descriptions = (List)ProgressManager.getInstance().runProcess(() -> {
            InspectionManager inspectionManager = InspectionManager.getInstance((Project)project);
            return InspectionEngine.runInspectionOnFile(targetFile, this.myToolWrapper, inspectionManager.createNewGlobalContext());
        }, (ProgressIndicator)new DaemonProgressIndicator());
        if (descriptions.isEmpty() || !FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)targetFile)) {
            return;
        }
        AbstractPerformFixesTask fixesTask = CleanupInspectionUtil.getInstance().applyFixes(project, LangBundle.message((String)"apply.fixes", (Object[])new Object[0]), descriptions, this.myQuickfix.getClass(), this.myQuickfix.startInWriteAction());
        if (!fixesTask.isApplicableFixFound()) {
            HintManager.getInstance().showErrorHint(editor, LangBundle.message((String)"hint.text.unfortunately.currently.available.for.batch.mode", (Object[])new Object[]{this.myText}));
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(5);
        }
        return !(this.myQuickfix.getClass() == EmptyIntentionAction.class || !this.myQuickfix.startInWriteAction() && !(this.myQuickfix instanceof BatchQuickFix) || editor == null || this.myToolWrapper instanceof LocalInspectionToolWrapper && ((LocalInspectionToolWrapper)this.myToolWrapper).isUnfair());
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/actions/CleanupInspectionIntention";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/actions/CleanupInspectionIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

