/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.impl.LiveTemplateSettingsEditor;
import com.intellij.codeInsight.template.impl.LiveTemplateTree;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateExpandShortcutPanel;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.CompoundScheme;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateListPanel
extends JPanel
implements Disposable {
    private static final String NO_SELECTION = "NoSelection";
    private static final String TEMPLATE_SETTINGS = "TemplateSettings";
    private static final TemplateImpl MOCK_TEMPLATE = new TemplateImpl("mockTemplate-xxx", "mockTemplateGroup-yyy");
    public static final String ABBREVIATION = "<abbreviation>";
    public static final Comparator<TemplateImpl> TEMPLATE_COMPARATOR = new Comparator<TemplateImpl>(){

        @Override
        public int compare(TemplateImpl o1, TemplateImpl o2) {
            int compareKey = this.compareCaseInsensitively(o1.getKey(), o2.getKey());
            return compareKey != 0 ? compareKey : this.compareCaseInsensitively(o1.getGroupName(), o2.getGroupName());
        }

        private int compareCaseInsensitively(String s1, String s2) {
            int result2 = s1.compareToIgnoreCase(s2);
            return result2 != 0 ? result2 : s1.compareTo(s2);
        }
    };
    private CheckboxTree myTree;
    private final List<TemplateGroup> myTemplateGroups = new ArrayList<TemplateGroup>();
    private final TemplateExpandShortcutPanel myExpandByDefaultPanel = new TemplateExpandShortcutPanel(CodeInsightBundle.message((String)"templates.dialog.shortcut.chooser.label", (Object[])new Object[0]));
    private CheckedTreeNode myTreeRoot = new CheckedTreeNode(null);
    private final Alarm myAlarm = new Alarm();
    private boolean myUpdateNeeded = false;
    private static final Logger LOG;
    private final Map<TemplateImpl, Map<TemplateOptionalProcessor, Boolean>> myTemplateOptions = new IdentityHashMap<TemplateImpl, Map<TemplateOptionalProcessor, Boolean>>();
    private final Map<TemplateImpl, TemplateContext> myTemplateContext = new IdentityHashMap<TemplateImpl, TemplateContext>();
    private final JPanel myDetailsPanel = new JPanel(new CardLayout());
    private LiveTemplateSettingsEditor myCurrentTemplateEditor;
    private final JLabel myEmptyCardLabel = new JLabel();
    private final CompoundScheme.MutatorHelper<TemplateGroup, TemplateImpl> mutatorHelper = new CompoundScheme.MutatorHelper();
    private final boolean isTest = ApplicationManager.getApplication().isUnitTestMode();

    public TemplateListPanel() {
        super(new BorderLayout());
        this.myDetailsPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.myEmptyCardLabel.setHorizontalAlignment(0);
        this.myDetailsPanel.add((Component)this.myEmptyCardLabel, NO_SELECTION);
        this.createTemplateEditor(MOCK_TEMPLATE, "Tab", MOCK_TEMPLATE.createOptions(), MOCK_TEMPLATE.createContext());
        this.add((Component)this.myExpandByDefaultPanel, "North");
        Splitter splitter = new Splitter(true, 0.9f);
        splitter.setFirstComponent((JComponent)this.createTable());
        splitter.setSecondComponent((JComponent)this.myDetailsPanel);
        this.add((Component)splitter, "Center");
    }

    public void dispose() {
        this.myCurrentTemplateEditor.dispose();
        this.myAlarm.cancelAllRequests();
    }

    public void reset() {
        this.myTemplateOptions.clear();
        this.myTemplateContext.clear();
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        List<TemplateGroup> groups2 = TemplateListPanel.getSortedGroups(templateSettings);
        this.initTemplates(groups2, templateSettings.getLastSelectedTemplateGroup(), templateSettings.getLastSelectedTemplateKey());
        this.myExpandByDefaultPanel.setSelectedChar(templateSettings.getDefaultShortcutChar());
        UiNotifyConnector.doWhenFirstShown((JComponent)this, () -> this.updateTemplateDetails(false, false));
        this.myUpdateNeeded = true;
    }

    @NotNull
    private static List<TemplateGroup> getSortedGroups(TemplateSettings templateSettings) {
        ArrayList<TemplateGroup> groups2 = new ArrayList<TemplateGroup>(templateSettings.getTemplateGroups());
        groups2.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        ArrayList<TemplateGroup> arrayList = groups2;
        if (arrayList == null) {
            TemplateListPanel.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public void apply() throws ConfigurationException {
        List<TemplateGroup> templateGroups = this.getTemplateGroups();
        for (TemplateGroup templateGroup : templateGroups) {
            HashSet<String> names2 = new HashSet<String>();
            List templates = templateGroup.getElements();
            for (TemplateImpl template : templates) {
                String key = template.getKey();
                if (StringUtil.isEmptyOrSpaces((String)key)) {
                    throw new ConfigurationException(LangBundle.message((String)"dialog.message.live.template.with.empty.abbreviation", (Object[])new Object[]{templateGroup.getName()}));
                }
                if (StringUtil.isEmptyOrSpaces((String)template.getString())) {
                    throw new ConfigurationException(LangBundle.message((String)"dialog.message.live.template.with.empty.text", (Object[])new Object[]{key, templateGroup.getName()}));
                }
                if (names2.add(key)) continue;
                throw new ConfigurationException(LangBundle.message((String)"dialog.message.duplicate.live.templates.in.group", (Object[])new Object[]{key, templateGroup.getName()}));
            }
        }
        for (TemplateGroup templateGroup : templateGroups) {
            for (TemplateImpl template : templateGroup.getElements()) {
                template.applyOptions(this.getTemplateOptions(template));
                template.applyContext(this.getTemplateContext(template));
            }
        }
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        templateSettings.setTemplates(this.mutatorHelper.apply(templateGroups, (original, copied) -> {
            List copiedElements;
            if (original.isModified()) {
                return;
            }
            List originalElements = original.getElements();
            if (!originalElements.equals(copiedElements = copied.getElements())) {
                original.setModified(true);
            } else {
                for (int i2 = 0; i2 < originalElements.size(); ++i2) {
                    if (((TemplateImpl)originalElements.get(i2)).getTemplateContext().getDifference(((TemplateImpl)copiedElements.get(i2)).getTemplateContext()) == null) continue;
                    original.setModified(true);
                    break;
                }
            }
        }));
        templateSettings.setDefaultShortcutChar(this.myExpandByDefaultPanel.getSelectedChar());
    }

    public boolean isModified() {
        List<TemplateImpl> newGroup;
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        if (templateSettings.getDefaultShortcutChar() != this.myExpandByDefaultPanel.getSelectedChar()) {
            if (this.isTest) {
                System.err.println("LiveTemplatesConfig: templateSettings.getDefaultShortcutChar()=" + templateSettings.getDefaultShortcutChar() + "; myExpandByDefaultComponent.getSelectedChar()=" + this.myExpandByDefaultPanel.getSelectedChar());
            }
            return true;
        }
        List<TemplateGroup> originalGroups = TemplateListPanel.getSortedGroups(templateSettings);
        List<TemplateGroup> newGroups = this.getTemplateGroups();
        if (!ContainerUtil.map2Set(originalGroups, CompoundScheme::getName).equals(ContainerUtil.map2Set(newGroups, CompoundScheme::getName))) {
            return true;
        }
        List<TemplateImpl> originalGroup = TemplateListPanel.collectTemplates(originalGroups);
        String msg = this.checkAreEqual(originalGroup, newGroup = TemplateListPanel.collectTemplates(newGroups));
        if (msg == null) {
            return false;
        }
        if (this.isTest) {
            System.err.println("LiveTemplatesConfig: " + msg);
        }
        return true;
    }

    public void editTemplate(TemplateImpl template) {
        this.selectTemplate(template.getGroupName(), template.getKey());
        this.updateTemplateDetails(true, false);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.getTemplate(this.getSingleSelectedIndex()) != null) {
            return this.myCurrentTemplateEditor.getKeyField();
        }
        return null;
    }

    private static List<TemplateImpl> collectTemplates(@NotNull List<? extends TemplateGroup> groups2) {
        if (groups2 == null) {
            TemplateListPanel.$$$reportNull$$$0(1);
        }
        ArrayList<TemplateImpl> result2 = new ArrayList<TemplateImpl>();
        for (TemplateGroup templateGroup : groups2) {
            result2.addAll(templateGroup.getElements());
        }
        result2.sort((o1, o2) -> {
            int groupsEqual = o1.getGroupName().compareToIgnoreCase(o2.getGroupName());
            if (groupsEqual != 0) {
                return groupsEqual;
            }
            return o1.getKey().compareToIgnoreCase(o2.getKey());
        });
        return result2;
    }

    private String checkAreEqual(@NotNull List<? extends TemplateImpl> originalGroup, @NotNull List<? extends TemplateImpl> newGroup) {
        if (originalGroup == null) {
            TemplateListPanel.$$$reportNull$$$0(2);
        }
        if (newGroup == null) {
            TemplateListPanel.$$$reportNull$$$0(3);
        }
        if (originalGroup.size() != newGroup.size()) {
            return "different sizes";
        }
        for (int i2 = 0; i2 < newGroup.size(); ++i2) {
            TemplateImpl t2;
            TemplateImpl t1 = newGroup.get(i2);
            if (!this.templatesDiffer(t1, t2 = originalGroup.get(i2))) continue;
            if (this.isTest) {
                return "Templates differ: new=" + t1 + "; original=" + t2 + "; equals=" + t1.equals(t2) + "; vars=" + t1.getVariables().equals(t2.getVariables()) + "; options=" + this.areOptionsEqual(t1, t2) + "; diff=" + this.getTemplateContext(t1).getDifference(t2.getTemplateContext()) + "\ncontext1=" + this.getTemplateContext(t1) + "\ncontext2=" + this.getTemplateContext(t2);
            }
            return "templates differ";
        }
        return null;
    }

    private boolean areOptionsEqual(@NotNull TemplateImpl newTemplate, @NotNull TemplateImpl originalTemplate) {
        if (newTemplate == null) {
            TemplateListPanel.$$$reportNull$$$0(4);
        }
        if (originalTemplate == null) {
            TemplateListPanel.$$$reportNull$$$0(5);
        }
        Map<TemplateOptionalProcessor, Boolean> templateOptions = this.getTemplateOptions(newTemplate);
        for (TemplateOptionalProcessor processor2 : templateOptions.keySet()) {
            if (processor2.isEnabled(originalTemplate) == templateOptions.get(processor2).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private TemplateContext getTemplateContext(TemplateImpl newTemplate) {
        return this.myTemplateContext.get(newTemplate);
    }

    private Map<TemplateOptionalProcessor, Boolean> getTemplateOptions(@NotNull TemplateImpl newTemplate) {
        if (newTemplate == null) {
            TemplateListPanel.$$$reportNull$$$0(6);
        }
        return this.myTemplateOptions.get(newTemplate);
    }

    private List<TemplateGroup> getTemplateGroups() {
        return this.myTemplateGroups;
    }

    private void createTemplateEditor(TemplateImpl template, String shortcut, Map<TemplateOptionalProcessor, Boolean> options2, TemplateContext context) {
        this.myCurrentTemplateEditor = new LiveTemplateSettingsEditor(template, shortcut, options2, context, () -> {
            DefaultMutableTreeNode node = this.getNode(this.getSingleSelectedIndex());
            if (node != null) {
                ((DefaultTreeModel)this.myTree.getModel()).nodeChanged(node);
                TemplateSettings.getInstance().setLastSelectedTemplate(template.getGroupName(), template.getKey());
            }
        });
        for (Component component2 : this.myDetailsPanel.getComponents()) {
            if (!(component2 instanceof LiveTemplateSettingsEditor)) continue;
            this.myDetailsPanel.remove(component2);
        }
        this.myDetailsPanel.add((Component)this.myCurrentTemplateEditor, TEMPLATE_SETTINGS);
    }

    @Nullable
    private TemplateImpl getTemplate(int row) {
        DefaultMutableTreeNode node;
        CheckboxTree tree = this.myTree;
        TreePath path = ((JTree)((Object)tree)).getPathForRow(row);
        if (path != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof TemplateImpl) {
            return (TemplateImpl)node.getUserObject();
        }
        return null;
    }

    @Nullable
    private TemplateGroup getGroup(int row) {
        DefaultMutableTreeNode node;
        TreePath path = this.myTree.getPathForRow(row);
        if (path != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof TemplateGroup) {
            return (TemplateGroup)node.getUserObject();
        }
        return null;
    }

    private void moveTemplates(Map<TemplateImpl, DefaultMutableTreeNode> map2, @NotNull String newGroupName) {
        if (newGroupName == null) {
            TemplateListPanel.$$$reportNull$$$0(7);
        }
        ArrayList<TreePath> toSelect2 = new ArrayList<TreePath>();
        for (TemplateImpl template : map2.keySet()) {
            DefaultMutableTreeNode oldTemplateNode = map2.get(template);
            TemplateGroup oldGroup = this.getTemplateGroup(template.getGroupName());
            if (oldGroup != null) {
                oldGroup.removeElement(template);
            }
            template.setGroupName(newGroupName);
            this.removeNodeFromParent(oldTemplateNode);
            toSelect2.add(new TreePath(this.registerTemplate(template).getPath()));
        }
        TreeUtil.selectPaths((JTree)((Object)this.myTree), toSelect2);
    }

    @Nullable
    private DefaultMutableTreeNode getNode(int row) {
        CheckboxTree tree = this.myTree;
        TreePath path = ((JTree)((Object)tree)).getPathForRow(row);
        if (path != null) {
            return (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        return null;
    }

    @Nullable
    private TemplateGroup getTemplateGroup(String groupName) {
        for (TemplateGroup group2 : this.myTemplateGroups) {
            if (!group2.getName().equals(groupName)) continue;
            return group2;
        }
        return null;
    }

    private void addTemplate() {
        String defaultGroup = "user";
        DefaultMutableTreeNode node = this.getNode(this.getSingleSelectedIndex());
        if (node != null) {
            if (node.getUserObject() instanceof TemplateImpl) {
                defaultGroup = ((TemplateImpl)node.getUserObject()).getGroupName();
            } else if (node.getUserObject() instanceof TemplateGroup) {
                defaultGroup = ((TemplateGroup)node.getUserObject()).getName();
            }
        }
        this.addTemplate(new TemplateImpl(ABBREVIATION, "", defaultGroup));
    }

    public void addTemplate(TemplateImpl template) {
        this.myTemplateOptions.put(template, template.createOptions());
        this.myTemplateContext.put(template, template.createContext());
        this.registerTemplate(template);
        this.updateTemplateDetails(true, false);
    }

    private void copyRow() {
        int selected2 = this.getSingleSelectedIndex();
        if (selected2 < 0) {
            return;
        }
        TemplateImpl orTemplate = this.getTemplate(selected2);
        LOG.assertTrue(orTemplate != null);
        TemplateImpl template = orTemplate.copy();
        template.setKey(ABBREVIATION);
        this.myTemplateOptions.put(template, new HashMap<TemplateOptionalProcessor, Boolean>(this.getTemplateOptions(orTemplate)));
        this.myTemplateContext.put(template, this.getTemplateContext(orTemplate).createCopy());
        this.registerTemplate(template);
        this.updateTemplateDetails(true, false);
    }

    private int getSingleSelectedIndex() {
        int[] rows = this.myTree.getSelectionRows();
        return rows != null && rows.length == 1 ? rows[0] : -1;
    }

    void removeRows() {
        TreeNode toSelect2 = null;
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (TreePath path : paths) {
            TemplateImpl template;
            TemplateGroup templateGroup;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object o = node.getUserObject();
            if (o instanceof TemplateGroup) {
                this.myTemplateGroups.remove(o);
                this.removeNodeFromParent(node);
                continue;
            }
            if (!(o instanceof TemplateImpl) || (templateGroup = this.getTemplateGroup((template = (TemplateImpl)o).getGroupName())) == null) continue;
            templateGroup.removeElement(template);
            toSelect2 = ((DefaultMutableTreeNode)node.getParent()).getChildAfter(node);
            this.removeNodeFromParent(node);
        }
        if (toSelect2 instanceof DefaultMutableTreeNode) {
            this.setSelectedNode((DefaultMutableTreeNode)toSelect2);
        }
    }

    private JPanel createTable() {
        this.myTreeRoot = new CheckedTreeNode(null);
        this.myTree = new LiveTemplateTree(new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value2 instanceof DefaultMutableTreeNode)) {
                    return;
                }
                if ((value2 = ((DefaultMutableTreeNode)value2).getUserObject()) instanceof TemplateImpl) {
                    TemplateImpl template = (TemplateImpl)value2;
                    TemplateImpl defaultTemplate = TemplateSettings.getInstance().getDefaultTemplate(template);
                    JBColor fgColor = defaultTemplate != null && TemplateListPanel.this.templatesDiffer(template, defaultTemplate) ? JBColor.BLUE : null;
                    this.getTextRenderer().append(template.getKey(), new SimpleTextAttributes(0, (Color)fgColor));
                    String description = template.getDescription();
                    if (StringUtil.isNotEmpty((String)description)) {
                        this.getTextRenderer().append(" (" + description + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                } else if (value2 instanceof TemplateGroup) {
                    this.getTextRenderer().append(((TemplateGroup)value2).getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
            }
        }, this.myTreeRoot, this);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                TemplateSettings templateSettings = TemplateSettings.getInstance();
                TemplateImpl template = TemplateListPanel.this.getTemplate(TemplateListPanel.this.getSingleSelectedIndex());
                if (template != null) {
                    templateSettings.setLastSelectedTemplate(template.getGroupName(), template.getKey());
                } else {
                    templateSettings.setLastSelectedTemplate(null, null);
                    TemplateListPanel.this.showEmptyCard();
                }
                if (TemplateListPanel.this.myUpdateNeeded) {
                    TemplateListPanel.this.myAlarm.cancelAllRequests();
                    TemplateListPanel.this.myAlarm.addRequest(() -> TemplateListPanel.this.updateTemplateDetails(false, false), 100);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$3", "valueChanged"));
            }
        });
        this.myTree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(@Nullable ActionEvent event) {
                TemplateListPanel.this.myCurrentTemplateEditor.focusKey();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.installPopup();
        DnDSupport.createBuilder((JComponent)((Object)this.myTree)).setBeanProvider((Function)((NullableFunction)dnDActionInfo -> {
            Point point = dnDActionInfo.getPoint();
            if (this.myTree.getPathForLocation(point.x, point.y) == null) {
                return null;
            }
            Map<TemplateImpl, DefaultMutableTreeNode> templates = this.getSelectedTemplates();
            return !templates.isEmpty() ? new DnDDragStartBean(templates) : null;
        })).setDisposableParent((Disposable)this).setTargetChecker(new DnDTargetChecker(){

            public boolean update(DnDEvent event) {
                Set<String> oldGroupNames = TemplateListPanel.getAllGroups((Map)event.getAttachedObject());
                TemplateGroup group2 = TemplateListPanel.this.getDropGroup(event);
                boolean differentGroup = group2 != null && !oldGroupNames.contains(group2.getName());
                event.setDropPossible(differentGroup, "");
                return true;
            }
        }).setDropHandler(new DnDDropHandler(){

            public void drop(DnDEvent event) {
                TemplateListPanel.this.moveTemplates((Map)event.getAttachedObject(), Objects.requireNonNull(TemplateListPanel.this.getDropGroup(event)).getName());
            }
        }).setImageProvider((Function)((NullableFunction)dnDActionInfo -> {
            Point point = dnDActionInfo.getPoint();
            TreePath path = this.myTree.getPathForLocation(point.x, point.y);
            return path == null ? null : new DnDImage((Image)DnDAwareTree.getDragImage((Tree)this.myTree, (TreePath)path, (Point)point).first);
        })).install();
        if (this.myTemplateGroups.size() > 0) {
            this.myTree.setSelectionInterval(0, 0);
        }
        return this.initToolbar().createPanel();
    }

    private void showEmptyCard() {
        int[] rows = this.myTree.getSelectionRows();
        boolean multiSelection = rows != null && rows.length > 1;
        this.myEmptyCardLabel.setText(multiSelection ? CodeInsightBundle.message((String)"templates.list.multiple.live.templates.are.selected", (Object[])new Object[0]) : CodeInsightBundle.message((String)"templates.list.no.live.templates.are.selected", (Object[])new Object[0]));
        ((CardLayout)this.myDetailsPanel.getLayout()).show(this.myDetailsPanel, NO_SELECTION);
    }

    private boolean templatesDiffer(@NotNull TemplateImpl template, @NotNull TemplateImpl defaultTemplate) {
        if (template == null) {
            TemplateListPanel.$$$reportNull$$$0(8);
        }
        if (defaultTemplate == null) {
            TemplateListPanel.$$$reportNull$$$0(9);
        }
        template.parseSegments();
        defaultTemplate.parseSegments();
        return !template.equals(defaultTemplate) || !template.getVariables().equals(defaultTemplate.getVariables()) || !this.areOptionsEqual(template, defaultTemplate) || this.getTemplateContext(template).getDifference(defaultTemplate.getTemplateContext()) != null;
    }

    private ToolbarDecorator initToolbar() {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)((Object)this.myTree)).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                TemplateListPanel.this.addTemplateOrGroup(button2);
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                TemplateListPanel.this.removeRows();
            }
        }).disableDownAction().disableUpAction().addExtraAction(new AnActionButton(CodeInsightBundle.messagePointer((String)"action.AnActionButton.Template.list.text.duplicate", (Object[])new Object[0]), AllIcons.Actions.Copy){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                TemplateListPanel.this.copyRow();
            }

            public void updateButton(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(TemplateListPanel.this.getTemplate(TemplateListPanel.this.getSingleSelectedIndex()) != null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateListPanel$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateButton";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).addExtraAction(new AnActionButton(CodeInsightBundle.messagePointer((String)"action.AnActionButton.text.restore.deleted.defaults", (Object[])new Object[0]), AllIcons.Actions.Rollback){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                TemplateSettings.getInstance().reset();
                TemplateListPanel.this.reset();
            }

            public boolean isEnabled() {
                return super.isEnabled() && !TemplateSettings.getInstance().getDeletedTemplates().isEmpty();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$7", "actionPerformed"));
            }
        });
        return decorator.setToolbarPosition(ActionToolbarPosition.RIGHT);
    }

    private void addTemplateOrGroup(AnActionButton button2) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new DumbAwareAction(IdeBundle.messagePointer((String)"action.Anonymous.text.live.template", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    11.$$$reportNull$$$0(0);
                }
                TemplateListPanel.this.addTemplate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$11", "actionPerformed"));
            }
        });
        group2.add((AnAction)new DumbAwareAction(IdeBundle.messagePointer((String)"action.Anonymous.text.template.group", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                String newName2;
                if (e == null) {
                    12.$$$reportNull$$$0(0);
                }
                if ((newName2 = Messages.showInputDialog((Component)((Object)TemplateListPanel.this.myTree), (String)CodeInsightBundle.message((String)"label.enter.the.new.group.name", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"dialog.title.create.new.group", (Object[])new Object[0]), null, (String)"", (InputValidator)new TemplateGroupInputValidator(null))) != null) {
                    TemplateGroup newGroup = new TemplateGroup(newName2);
                    TemplateListPanel.this.setSelectedNode(TemplateListPanel.this.insertNewGroup(newGroup));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$12", "actionPerformed"));
            }
        });
        DataContext context = DataManager.getInstance().getDataContext((Component)button2.getContextComponent());
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group2, context, JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, true, null);
        popup2.show(button2.getPreferredPopupPoint());
    }

    @Nullable
    private TemplateGroup getDropGroup(DnDEvent event) {
        Point point = event.getPointOn((Component)((Object)this.myTree));
        return this.getGroup(this.myTree.getRowForLocation(point.x, point.y));
    }

    private void installPopup() {
        final DumbAwareAction rename2 = new DumbAwareAction(IdeBundle.messagePointer((String)"action.Anonymous.text.rename", (Object[])new Object[0])){

            public void update(@NotNull AnActionEvent e) {
                TemplateGroup templateGroup;
                if (e == null) {
                    13.$$$reportNull$$$0(0);
                }
                boolean enabled = (templateGroup = TemplateListPanel.this.getSingleSelectedGroup()) != null;
                e.getPresentation().setEnabledAndVisible(enabled);
                super.update(e);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    13.$$$reportNull$$$0(1);
                }
                TemplateListPanel.this.renameGroup();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateListPanel$13";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        rename2.registerCustomShortcutSet(ActionManager.getInstance().getAction("RenameElement").getShortcutSet(), (JComponent)((Object)this.myTree));
        final DefaultActionGroup move = new DefaultActionGroup(CodeInsightBundle.message((String)"action.text.move", (Object[])new Object[0]), true){

            public void update(@NotNull AnActionEvent e) {
                Map<TemplateImpl, DefaultMutableTreeNode> templates;
                if (e == null) {
                    14.$$$reportNull$$$0(0);
                }
                boolean enabled = !(templates = TemplateListPanel.this.getSelectedTemplates()).isEmpty();
                e.getPresentation().setEnabledAndVisible(enabled);
                if (enabled) {
                    Set<String> oldGroups = TemplateListPanel.getAllGroups(templates);
                    this.removeAll();
                    for (TemplateGroup group2 : TemplateListPanel.this.getTemplateGroups()) {
                        final String newGroupName = group2.getName();
                        if (oldGroups.contains(newGroupName)) continue;
                        this.add((AnAction)new DumbAwareAction(newGroupName){

                            public void actionPerformed(@NotNull AnActionEvent e) {
                                if (e == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                TemplateListPanel.this.moveTemplates(templates, newGroupName);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$14$1", "actionPerformed"));
                            }
                        });
                    }
                    this.addSeparator();
                    this.add((AnAction)new DumbAwareAction(IdeBundle.messagePointer((String)"action.Anonymous.text.new.group", (Object[])new Object[0])){

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            String newName2;
                            if (e == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            if ((newName2 = Messages.showInputDialog((Component)((Object)TemplateListPanel.this.myTree), (String)CodeInsightBundle.message((String)"label.enter.the.new.group.name", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"dialog.title.move.to.a.new.group", (Object[])new Object[0]), null, (String)"", (InputValidator)new TemplateGroupInputValidator(null))) != null) {
                                TemplateListPanel.this.moveTemplates(templates, newName2);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$14$2", "actionPerformed"));
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$14", "update"));
            }
        };
        final DumbAwareAction changeContext = new DumbAwareAction(IdeBundle.messagePointer((String)"action.Anonymous.text.change.context", (Object[])new Object[0])){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    15.$$$reportNull$$$0(0);
                }
                boolean enabled = !TemplateListPanel.this.getSelectedTemplates().isEmpty();
                e.getPresentation().setEnabled(enabled);
                super.update(e);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    15.$$$reportNull$$$0(1);
                }
                Map<TemplateImpl, DefaultMutableTreeNode> templates = TemplateListPanel.this.getSelectedTemplates();
                TemplateContext context = new TemplateContext();
                Pair<JPanel, CheckboxTree> pair = LiveTemplateSettingsEditor.createPopupContextPanel(EmptyRunnable.INSTANCE, context);
                DialogBuilder builder2 = new DialogBuilder((Component)TemplateListPanel.this);
                builder2.setCenterPanel((JComponent)pair.first);
                builder2.setPreferredFocusComponent((JComponent)pair.second);
                builder2.setTitle(CodeInsightBundle.message((String)"dialog.title.change.context.type.for.selected.templates", (Object[])new Object[0]));
                int result2 = builder2.show();
                if (result2 == 0) {
                    for (TemplateImpl template : templates.keySet()) {
                        TemplateListPanel.this.myTemplateContext.put(template, context);
                    }
                }
                TemplateListPanel.this.updateTemplateDetails(false, true);
                TemplateListPanel.this.myTree.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateListPanel$15";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        final DumbAwareAction revert = new DumbAwareAction(CodeInsightBundle.messagePointer((String)"action.DumbAware.TemplateListPanel.text.restore.defaults", (Object[])new Object[0]), CodeInsightBundle.messagePointer((String)"action.DumbAware.TemplateListPanel.description.restore.default.setting", (Object[])new Object[0]), null){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    16.$$$reportNull$$$0(0);
                }
                boolean enabled = false;
                Map<TemplateImpl, DefaultMutableTreeNode> templates = TemplateListPanel.this.getSelectedTemplates();
                for (TemplateImpl template : templates.keySet()) {
                    TemplateImpl defaultTemplate = TemplateSettings.getInstance().getDefaultTemplate(template);
                    if (defaultTemplate == null || !TemplateListPanel.this.templatesDiffer(template, defaultTemplate)) continue;
                    enabled = true;
                }
                e.getPresentation().setEnabledAndVisible(enabled);
                super.update(e);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    16.$$$reportNull$$$0(1);
                }
                Map<TemplateImpl, DefaultMutableTreeNode> templates = TemplateListPanel.this.getSelectedTemplates();
                for (TemplateImpl template : templates.keySet()) {
                    TemplateImpl defaultTemplate = TemplateSettings.getInstance().getDefaultTemplate(template);
                    if (defaultTemplate == null) continue;
                    TemplateListPanel.this.myTemplateOptions.put(template, defaultTemplate.createOptions());
                    TemplateListPanel.this.myTemplateContext.put(template, defaultTemplate.createContext());
                    template.resetFrom(defaultTemplate);
                }
                TemplateListPanel.this.updateTemplateDetails(false, true);
                TemplateListPanel.this.myTree.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateListPanel$16";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                DefaultActionGroup group2 = new DefaultActionGroup();
                group2.add((AnAction)rename2);
                group2.add((AnAction)move);
                group2.add((AnAction)changeContext);
                group2.add((AnAction)revert);
                group2.add(ActionManager.getInstance().getAction("$Copy"));
                group2.add(ActionManager.getInstance().getAction("$Paste"));
                group2.add(ActionManager.getInstance().getAction("$Delete"));
                ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group2).getComponent().show(comp, x, y);
            }
        });
    }

    @Nullable
    private TemplateGroup getSingleSelectedGroup() {
        return this.getGroup(this.getSingleSelectedIndex());
    }

    @Nullable
    TemplateGroup getSingleContextGroup() {
        int index = this.getSingleSelectedIndex();
        DefaultMutableTreeNode node = this.getNode(index);
        if (node != null && node.getUserObject() instanceof TemplateImpl) {
            node = (DefaultMutableTreeNode)node.getParent();
        }
        return node == null ? null : (TemplateGroup)ObjectUtils.tryCast((Object)node.getUserObject(), TemplateGroup.class);
    }

    private static Set<String> getAllGroups(Map<TemplateImpl, DefaultMutableTreeNode> templates) {
        HashSet<String> oldGroups = new HashSet<String>();
        for (TemplateImpl template : templates.keySet()) {
            oldGroups.add(template.getGroupName());
        }
        return oldGroups;
    }

    Map<TemplateImpl, DefaultMutableTreeNode> getSelectedTemplates() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<TemplateImpl, DefaultMutableTreeNode> templates = new LinkedHashMap<TemplateImpl, DefaultMutableTreeNode>();
        for (TreePath path : paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object o = node.getUserObject();
            if (!(o instanceof TemplateImpl)) {
                return Collections.emptyMap();
            }
            templates.put((TemplateImpl)o, node);
        }
        return templates;
    }

    private void renameGroup() {
        TemplateGroup templateGroup = this.getSingleSelectedGroup();
        if (templateGroup == null) {
            return;
        }
        String oldName = templateGroup.getName();
        String newName2 = Messages.showInputDialog((Component)((Object)this.myTree), (String)CodeInsightBundle.message((String)"label.enter.the.new.group.name", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"dialog.title.rename", (Object[])new Object[0]), null, (String)oldName, (InputValidator)new TemplateGroupInputValidator(oldName));
        if (newName2 != null && !newName2.equals(oldName)) {
            templateGroup.setName(newName2);
            ((DefaultTreeModel)this.myTree.getModel()).nodeChanged(this.getNode(this.getSingleSelectedIndex()));
        }
    }

    private void updateTemplateDetails(boolean focusKey, boolean forceReload) {
        int selected2 = this.getSingleSelectedIndex();
        CardLayout layout = (CardLayout)this.myDetailsPanel.getLayout();
        if (selected2 < 0 || this.getTemplate(selected2) == null) {
            this.showEmptyCard();
        } else {
            TemplateImpl newTemplate = this.getTemplate(selected2);
            if (this.myCurrentTemplateEditor == null || forceReload || this.myCurrentTemplateEditor.getTemplate() != newTemplate) {
                if (this.myCurrentTemplateEditor != null) {
                    this.myCurrentTemplateEditor.dispose();
                }
                this.createTemplateEditor(newTemplate, this.myExpandByDefaultPanel.getSelectedString(), this.getTemplateOptions(newTemplate), this.getTemplateContext(newTemplate));
                this.myCurrentTemplateEditor.resetUi();
                if (focusKey) {
                    this.myCurrentTemplateEditor.focusKey();
                }
            }
            layout.show(this.myDetailsPanel, TEMPLATE_SETTINGS);
        }
    }

    private CheckedTreeNode registerTemplate(TemplateImpl template) {
        TemplateGroup newGroup = this.getTemplateGroup(template.getGroupName());
        if (newGroup == null) {
            newGroup = new TemplateGroup(template.getGroupName());
            this.insertNewGroup(newGroup);
        }
        newGroup.addElement(template);
        CheckedTreeNode node = new CheckedTreeNode((Object)template);
        node.setChecked(!template.isDeactivated());
        DefaultMutableTreeNode child2 = (DefaultMutableTreeNode)this.myTreeRoot.getFirstChild();
        while (child2 != null) {
            if (((TemplateGroup)child2.getUserObject()).getName().equals(template.getGroupName())) {
                int index = TemplateListPanel.getIndexToInsert(child2, template.getKey());
                child2.insert((MutableTreeNode)node, index);
                ((DefaultTreeModel)this.myTree.getModel()).nodesWereInserted(child2, new int[]{index});
                this.setSelectedNode((DefaultMutableTreeNode)node);
            }
            child2 = (DefaultMutableTreeNode)this.myTreeRoot.getChildAfter((TreeNode)child2);
        }
        return node;
    }

    private DefaultMutableTreeNode insertNewGroup(TemplateGroup newGroup) {
        this.myTemplateGroups.add(newGroup);
        int index = TemplateListPanel.getIndexToInsert((DefaultMutableTreeNode)this.myTreeRoot, newGroup.getName());
        CheckedTreeNode groupNode = new CheckedTreeNode((Object)newGroup);
        this.myTreeRoot.insert((MutableTreeNode)groupNode, index);
        ((DefaultTreeModel)this.myTree.getModel()).nodesWereInserted((TreeNode)this.myTreeRoot, new int[]{index});
        return groupNode;
    }

    private static int getIndexToInsert(DefaultMutableTreeNode parent, String key) {
        if (parent.getChildCount() == 0) {
            return 0;
        }
        int res2 = 0;
        DefaultMutableTreeNode child2 = (DefaultMutableTreeNode)parent.getFirstChild();
        while (child2 != null) {
            String key1;
            Object o = child2.getUserObject();
            String string = key1 = o instanceof TemplateImpl ? ((TemplateImpl)o).getKey() : ((TemplateGroup)o).getName();
            if (key1.compareToIgnoreCase(key) > 0) {
                return res2;
            }
            ++res2;
            child2 = (DefaultMutableTreeNode)parent.getChildAfter(child2);
        }
        return res2;
    }

    private void setSelectedNode(DefaultMutableTreeNode node) {
        TreeUtil.selectPath((JTree)((Object)this.myTree), (TreePath)new TreePath(node.getPath()));
    }

    private void removeNodeFromParent(DefaultMutableTreeNode node) {
        TreeNode parent = node.getParent();
        int idx = parent.getIndex(node);
        node.removeFromParent();
        ((DefaultTreeModel)this.myTree.getModel()).nodesWereRemoved(parent, new int[]{idx}, new TreeNode[]{node});
    }

    private void initTemplates(List<? extends TemplateGroup> groups2, String lastSelectedGroup, String lastSelectedKey) {
        this.myTreeRoot.removeAllChildren();
        this.myTemplateGroups.clear();
        this.mutatorHelper.clear();
        for (TemplateGroup templateGroup : groups2) {
            this.myTemplateGroups.add(this.mutatorHelper.copy(templateGroup));
        }
        for (TemplateGroup templateGroup : this.myTemplateGroups) {
            CheckedTreeNode groupNode = new CheckedTreeNode((Object)templateGroup);
            this.addTemplateNodes(templateGroup, groupNode);
            this.myTreeRoot.add((MutableTreeNode)groupNode);
        }
        this.fireStructureChange();
        this.selectTemplate(lastSelectedGroup, lastSelectedKey);
    }

    void selectNode(@NotNull String searchQuery) {
        if (searchQuery == null) {
            TemplateListPanel.$$$reportNull$$$0(10);
        }
        Objects.requireNonNull(SpeedSearchSupply.getSupply((JComponent)((Object)this.myTree), (boolean)true)).findAndSelectElement(searchQuery);
    }

    private void selectTemplate(@Nullable String groupName, @Nullable String templateKey) {
        TreeUtil.traverseDepth((TreeNode)this.myTreeRoot, node -> {
            Object o = ((DefaultMutableTreeNode)node).getUserObject();
            if (templateKey == null && o instanceof TemplateGroup && Objects.equals(groupName, ((TemplateGroup)o).getName()) || o instanceof TemplateImpl && Objects.equals(templateKey, ((TemplateImpl)o).getKey()) && Objects.equals(groupName, ((TemplateImpl)o).getGroupName())) {
                this.setSelectedNode((DefaultMutableTreeNode)node);
                return false;
            }
            return true;
        });
    }

    private void fireStructureChange() {
        ((DefaultTreeModel)this.myTree.getModel()).nodeStructureChanged((TreeNode)this.myTreeRoot);
    }

    private void addTemplateNodes(TemplateGroup group2, CheckedTreeNode groupNode) {
        ArrayList<TemplateImpl> templates = new ArrayList<TemplateImpl>(group2.getElements());
        templates.sort(TEMPLATE_COMPARATOR);
        for (TemplateImpl template : templates) {
            this.myTemplateOptions.put(template, template.createOptions());
            this.myTemplateContext.put(template, template.createContext());
            CheckedTreeNode node = new CheckedTreeNode((Object)template);
            node.setChecked(!template.isDeactivated());
            groupNode.add((MutableTreeNode)node);
        }
    }

    static {
        MOCK_TEMPLATE.setString("");
        LOG = Logger.getInstance(TemplateListPanel.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateListPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalGroup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newGroup";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTemplate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalTemplate";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newGroupName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultTemplate";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedGroups";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateListPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectTemplates";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkAreEqual";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "areOptionsEqual";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateOptions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "moveTemplates";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "templatesDiffer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "selectNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TemplateGroupInputValidator
    implements InputValidator {
        private final String myOldName;

        TemplateGroupInputValidator(String oldName) {
            this.myOldName = oldName;
        }

        public boolean checkInput(String inputString) {
            return StringUtil.isNotEmpty((String)inputString) && (TemplateListPanel.this.getTemplateGroup(inputString) == null || inputString.equals(this.myOldName));
        }

        public boolean canClose(String inputString) {
            return this.checkInput(inputString);
        }
    }
}

