/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.navigation.BaseCtrlMouseInfo;
import com.intellij.codeInsight.navigation.CtrlMouseAction;
import com.intellij.codeInsight.navigation.CtrlMouseDocInfo;
import com.intellij.codeInsight.navigation.CtrlMouseInfo;
import com.intellij.codeInsight.navigation.MultipleTargetElementsInfo;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.SingleTargetElementInfo;
import com.intellij.codeInsight.navigation.action.GotoDeclarationUtil;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationOrUsageHandler2;
import com.intellij.codeInsight.navigation.actions.UiKt;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorActivityManager;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GotoDeclarationAction
extends BaseCodeInsightAction
implements CodeInsightActionHandler,
DumbAware,
CtrlMouseAction {
    private static final Logger LOG = Logger.getInstance(GotoDeclarationAction.class);
    private static List<EventPair<?>> ourCurrentEventData = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile file2;
        if (e == null) {
            GotoDeclarationAction.$$$reportNull$$$0(0);
        }
        Language language = (file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE)) != null ? file2.getLanguage() : null;
        List currentEventData = ContainerUtil.append(ActionsCollectorImpl.actionEventData(e), (Object[])new EventPair[]{EventFields.CurrentFile.with((Object)language)});
        List<EventPair<?>> savedEventData = ourCurrentEventData;
        ourCurrentEventData = currentEventData;
        try {
            super.actionPerformed(e);
        }
        finally {
            ourCurrentEventData = savedEventData;
        }
    }

    @NotNull
    static @NotNull List<@NotNull EventPair<?>> getCurrentEventData() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<EventPair<?>> list2 = Objects.requireNonNull(ourCurrentEventData);
        if (list2 == null) {
            GotoDeclarationAction.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        Object object = Registry.is((String)"ide.symbol.gtd") ? GotoDeclarationOrUsageHandler2.INSTANCE : this;
        if (object == null) {
            GotoDeclarationAction.$$$reportNull$$$0(2);
        }
        return object;
    }

    @Override
    protected boolean isValidForLookup() {
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            GotoDeclarationAction.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            GotoDeclarationAction.$$$reportNull$$$0(5);
        }
        DumbService.getInstance((Project)project).runWithAlternativeResolveEnabled(() -> {
            try {
                int offset = editor.getCaretModel().getOffset();
                Pair pair = (Pair)ActionUtil.underModalProgress((Project)project, (String)CodeInsightBundle.message((String)"progress.title.resolving.reference", (Object[])new Object[0]), () -> GotoDeclarationAction.doSelectCandidate(project, editor, offset));
                FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.declaration");
                PsiElement[] elements2 = (PsiElement[])pair.first;
                PsiElement usage = (PsiElement)pair.second;
                if (elements2.length != 1) {
                    if (elements2.length == 0 && usage != null) {
                        GotoDeclarationAction.startFindUsages(editor, project, usage);
                        return;
                    }
                    GotoDeclarationAction.chooseAmbiguousTarget(project, editor, offset, elements2, file2);
                    return;
                }
                PsiElement element2 = elements2[0];
                if (element2 == usage) {
                    GotoDeclarationAction.startFindUsages(editor, project, element2);
                    return;
                }
                PsiElement navElement = element2.getNavigationElement();
                navElement = TargetElementUtil.getInstance().getGotoDeclarationTarget(element2, navElement);
                if (navElement != null) {
                    GotoDeclarationAction.gotoTargetElement(navElement, editor, file2);
                }
            }
            catch (IndexNotReadyException e) {
                DumbService.getInstance((Project)project).showDumbModeNotification(CodeInsightBundle.message((String)"message.navigation.is.not.available.here.during.index.update", (Object[])new Object[0]));
            }
        });
    }

    @NotNull
    private static Pair<PsiElement[], PsiElement> doSelectCandidate(@NotNull Project project, @NotNull Editor editor, int offset) {
        PsiElement[] elements2;
        if (project == null) {
            GotoDeclarationAction.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(7);
        }
        if ((elements2 = GotoDeclarationAction.findAllTargetElements(project, editor, offset)).length == 0) {
            PsiElement usage = GotoDeclarationAction.suggestCandidates(TargetElementUtil.findReference(editor, offset)).isEmpty() ? GotoDeclarationAction.findElementToShowUsagesOf(editor, offset) : null;
            return new Pair((Object)elements2, (Object)usage);
        }
        if (elements2.length == 1) {
            return new Pair((Object)elements2, (Object)GotoDeclarationAction.findElementToShowUsagesOf(editor, offset));
        }
        return new Pair((Object)elements2, null);
    }

    public static void startFindUsages(@NotNull Editor editor, @NotNull Project project, @NotNull PsiElement element2) {
        if (editor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(8);
        }
        if (project == null) {
            GotoDeclarationAction.$$$reportNull$$$0(9);
        }
        if (element2 == null) {
            GotoDeclarationAction.$$$reportNull$$$0(10);
        }
        GotoDeclarationAction.startFindUsages(editor, project, element2, null);
    }

    public static void startFindUsages(@NotNull Editor editor, @NotNull Project project, @NotNull PsiElement element2, @Nullable RelativePoint point) {
        if (editor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(11);
        }
        if (project == null) {
            GotoDeclarationAction.$$$reportNull$$$0(12);
        }
        if (element2 == null) {
            GotoDeclarationAction.$$$reportNull$$$0(13);
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            AnAction action2 = ActionManager.getInstance().getAction("ShowUsages");
            String name = action2.getTemplatePresentation().getText();
            DumbService.getInstance((Project)project).showDumbModeNotification(ActionUtil.getUnavailableMessage((String)name, (boolean)false));
        } else {
            RelativePoint popupPosition = point != null ? point : JBPopupFactory.getInstance().guessBestPopupLocation(editor);
            ShowUsagesAction.startFindUsages(element2, popupPosition, editor);
        }
    }

    public static PsiElement findElementToShowUsagesOf(@NotNull Editor editor, int offset) {
        if (editor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(14);
        }
        return TargetElementUtil.getInstance().findTargetElement(editor, 2, offset);
    }

    private static void chooseAmbiguousTarget(@NotNull Project project, Editor editor, int offset, PsiElement[] elements2, PsiFile currentFile) {
        if (project == null) {
            GotoDeclarationAction.$$$reportNull$$$0(15);
        }
        if (!EditorActivityManager.getInstance().isVisible(editor)) {
            return;
        }
        PsiElementProcessor navigateProcessor = element2 -> {
            GotoDeclarationAction.gotoTargetElement(element2, editor, currentFile);
            return true;
        };
        boolean found = GotoDeclarationAction.chooseAmbiguousTarget(project, editor, offset, (PsiElementProcessor<? super PsiElement>)navigateProcessor, CodeInsightBundle.message((String)"declaration.navigation.title", (Object[])new Object[0]), elements2);
        if (!found) {
            UiKt.notifyNowhereToGo(project, editor, currentFile, offset);
        }
    }

    static boolean navigateInCurrentEditor(@NotNull PsiElement element2, @NotNull PsiFile currentFile, @NotNull Editor currentEditor) {
        int offset;
        PsiElement leaf;
        if (element2 == null) {
            GotoDeclarationAction.$$$reportNull$$$0(16);
        }
        if (currentFile == null) {
            GotoDeclarationAction.$$$reportNull$$$0(17);
        }
        if (currentEditor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(18);
        }
        if (element2.getContainingFile() == currentFile && !currentEditor.isDisposed() && (leaf = currentFile.findElementAt(offset = element2.getTextOffset())) != null && PsiTreeUtil.isAncestor((PsiElement)element2, (PsiElement)leaf, (boolean)false)) {
            Project project = element2.getProject();
            CommandProcessor.getInstance().executeCommand(project, () -> {
                IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
                new OpenFileDescriptor(project, currentFile.getViewProvider().getVirtualFile(), offset).navigateIn(currentEditor);
            }, "", null);
            return true;
        }
        return false;
    }

    static void gotoTargetElement(@NotNull PsiElement element2, @NotNull Editor currentEditor, @NotNull PsiFile currentFile) {
        Navigatable navigatable;
        if (element2 == null) {
            GotoDeclarationAction.$$$reportNull$$$0(19);
        }
        if (currentEditor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(20);
        }
        if (currentFile == null) {
            GotoDeclarationAction.$$$reportNull$$$0(21);
        }
        if (GotoDeclarationAction.navigateInCurrentEditor(element2, currentFile, currentEditor)) {
            return;
        }
        Navigatable navigatable2 = navigatable = element2 instanceof Navigatable ? (Navigatable)element2 : EditSourceUtil.getDescriptor((PsiElement)element2);
        if (navigatable != null && navigatable.canNavigate()) {
            navigatable.navigate(true);
        }
    }

    @Deprecated
    public static boolean chooseAmbiguousTarget(@NotNull Editor editor, int offset, @NotNull PsiElementProcessor<? super PsiElement> processor2, @NotNull @NlsContexts.PopupTitle String titlePattern, PsiElement @Nullable [] elements2) {
        Project project;
        if (editor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(22);
        }
        if (processor2 == null) {
            GotoDeclarationAction.$$$reportNull$$$0(23);
        }
        if (titlePattern == null) {
            GotoDeclarationAction.$$$reportNull$$$0(24);
        }
        if ((project = editor.getProject()) == null) {
            return false;
        }
        return GotoDeclarationAction.chooseAmbiguousTarget(project, editor, offset, processor2, titlePattern, elements2);
    }

    public static boolean chooseAmbiguousTarget(@NotNull Project project, @NotNull Editor editor, int offset, @NotNull PsiElementProcessor<? super PsiElement> processor2, @NotNull @NlsContexts.PopupTitle String titlePattern, PsiElement @Nullable [] elements2) {
        if (project == null) {
            GotoDeclarationAction.$$$reportNull$$$0(25);
        }
        if (editor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(26);
        }
        if (processor2 == null) {
            GotoDeclarationAction.$$$reportNull$$$0(27);
        }
        if (titlePattern == null) {
            GotoDeclarationAction.$$$reportNull$$$0(28);
        }
        if (TargetElementUtil.inVirtualSpace(editor, offset)) {
            return false;
        }
        PsiElement[] finalElements = elements2;
        Pair pair = (Pair)ActionUtil.underModalProgress((Project)project, (String)CodeInsightBundle.message((String)"progress.title.resolving.reference", (Object[])new Object[0]), () -> GotoDeclarationAction.doChooseAmbiguousTarget(editor, offset, finalElements));
        elements2 = (PsiElement[])pair.first;
        PsiReference reference2 = (PsiReference)pair.second;
        if (elements2.length == 1) {
            PsiElement element2 = elements2[0];
            LOG.assertTrue(element2 != null);
            processor2.execute(element2);
            return true;
        }
        if (elements2.length > 1) {
            String title;
            if (reference2 == null) {
                title = titlePattern;
            } else {
                TextRange range2 = reference2.getRangeInElement();
                String elementText = reference2.getElement().getText();
                LOG.assertTrue(range2.getStartOffset() >= 0 && range2.getEndOffset() <= elementText.length(), (Object)(Arrays.toString(elements2) + ";" + reference2));
                String refText = range2.substring(elementText);
                title = MessageFormat.format(titlePattern, refText);
            }
            NavigationUtil.getPsiElementPopup((PsiElement[])elements2, (PsiElementListCellRenderer)new DefaultPsiElementCellRenderer(), (String)title, processor2).showInBestPositionFor(editor);
            return true;
        }
        return false;
    }

    @NotNull
    private static Pair<PsiElement[], PsiReference> doChooseAmbiguousTarget(@NotNull Editor editor, int offset, PsiElement @Nullable [] elements2) {
        if (editor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(29);
        }
        PsiReference reference2 = TargetElementUtil.findReference(editor, offset);
        if (elements2 == null || elements2.length == 0) {
            elements2 = reference2 == null ? PsiElement.EMPTY_ARRAY : PsiUtilCore.toPsiElementArray(GotoDeclarationAction.suggestCandidates(reference2));
        }
        return new Pair((Object)elements2, (Object)reference2);
    }

    @NotNull
    private static Collection<PsiElement> suggestCandidates(@Nullable PsiReference reference2) {
        if (reference2 == null) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                GotoDeclarationAction.$$$reportNull$$$0(30);
            }
            return list2;
        }
        Collection<PsiElement> collection = TargetElementUtil.getInstance().getTargetCandidates(reference2);
        if (collection == null) {
            GotoDeclarationAction.$$$reportNull$$$0(31);
        }
        return collection;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    @TestOnly
    public static PsiElement findTargetElement(Project project, Editor editor, int offset) {
        PsiElement[] targets2 = GotoDeclarationAction.findAllTargetElements(project, editor, offset);
        return targets2.length == 1 ? targets2[0] : null;
    }

    @VisibleForTesting
    @NotNull
    public static @NotNull PsiElement @NotNull [] findAllTargetElements(Project project, Editor editor, int offset) {
        if (TargetElementUtil.inVirtualSpace(editor, offset)) {
            if (PsiElement.EMPTY_ARRAY == null) {
                GotoDeclarationAction.$$$reportNull$$$0(32);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] targets2 = GotoDeclarationAction.findTargetElementsNoVS(project, editor, offset, true);
        PsiElement[] psiElementArray = targets2 != null ? targets2 : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            GotoDeclarationAction.$$$reportNull$$$0(33);
        }
        return psiElementArray;
    }

    static @NotNull PsiElement @Nullable [] findTargetElementsFromProviders(@NotNull Project project, @NotNull Editor editor, int offset) {
        if (project == null) {
            GotoDeclarationAction.$$$reportNull$$$0(34);
        }
        if (editor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(35);
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            return null;
        }
        return GotoDeclarationUtil.findTargetElementsFromProviders(editor, offset, file2);
    }

    public static @NotNull PsiElement @Nullable [] findTargetElementsNoVS(Project project, Editor editor, int offset, boolean lookupAccepted) {
        PsiElement element2;
        PsiElement[] fromProviders = GotoDeclarationAction.findTargetElementsFromProviders(project, editor, offset);
        if (fromProviders == null || fromProviders.length > 0) {
            return fromProviders;
        }
        int flags = TargetElementUtil.getInstance().getAllAccepted() & 0xFFFFFFFD;
        if (!lookupAccepted) {
            flags &= 0xFFFFFFF7;
        }
        if ((element2 = TargetElementUtil.getInstance().findTargetElement(editor, flags, offset)) != null) {
            return new PsiElement[]{element2};
        }
        if (editor instanceof EditorWindow) {
            EditorWindow window = (EditorWindow)editor;
            return GotoDeclarationAction.findTargetElementsNoVS(project, window.getDelegate(), window.getDocument().injectedToHost(offset), lookupAccepted);
        }
        return null;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            GotoDeclarationAction.$$$reportNull$$$0(36);
        }
        if (event.getProject() == null || event.getData(EditorGutter.KEY) != null || Boolean.TRUE.equals(event.getData(CommonDataKeys.EDITOR_VIRTUAL_SPACE))) {
            event.getPresentation().setEnabled(false);
            return;
        }
        InputEvent inputEvent = event.getInputEvent();
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor != null && inputEvent instanceof MouseEvent && event.getPlace().equals("mouse shortcut") && !EditorUtil.isPointOverText(editor, new RelativePoint((MouseEvent)inputEvent).getPoint((Component)editor.getContentComponent()))) {
            event.getPresentation().setEnabled(false);
            return;
        }
        for (GotoDeclarationHandler handler2 : GotoDeclarationHandler.EP_NAME.getExtensionList()) {
            String text2 = handler2.getActionText(event.getDataContext());
            if (text2 == null) continue;
            Presentation presentation2 = event.getPresentation();
            presentation2.setText(text2);
            break;
        }
        super.update(event);
    }

    @Override
    @Nullable
    public CtrlMouseInfo getCtrlMouseInfo(@NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        PsiElement identifier;
        if (editor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(37);
        }
        if (file2 == null) {
            GotoDeclarationAction.$$$reportNull$$$0(38);
        }
        if (Registry.is((String)"ide.symbol.gtd")) {
            return GotoDeclarationOrUsageHandler2.getCtrlMouseInfo(editor, file2, offset);
        }
        PsiReference ref = TargetElementUtil.findReference(editor, offset);
        List<Object> resolvedElements = ref == null ? Collections.emptyList() : GotoDeclarationAction.resolve(ref);
        PsiElement resolvedElement = resolvedElements.size() == 1 ? (PsiElement)resolvedElements.get(0) : null;
        PsiElement[] targetElements = GotoDeclarationAction.findTargetElementsNoVS(file2.getProject(), editor, offset, false);
        PsiElement elementAtPointer = file2.findElementAt(TargetElementUtil.adjustOffset(file2, editor.getDocument(), offset));
        if (targetElements != null) {
            if (targetElements.length == 0) {
                return null;
            }
            if (targetElements.length == 1) {
                if (targetElements[0] != resolvedElement && elementAtPointer != null && targetElements[0].isPhysical()) {
                    return ref != null ? new SingleTargetElementInfo(ref, targetElements[0]) : new SingleTargetElementInfo(elementAtPointer, targetElements[0]);
                }
            } else {
                return elementAtPointer != null ? new MultipleTargetElementsInfo(elementAtPointer) : null;
            }
        }
        if (resolvedElements.size() == 1) {
            return new SingleTargetElementInfo(ref, (PsiElement)resolvedElements.get(0));
        }
        if (resolvedElements.size() > 1) {
            return elementAtPointer != null ? new MultipleTargetElementsInfo(ref) : null;
        }
        final PsiElement element2 = GotoDeclarationAction.findElementToShowUsagesOf(editor, offset);
        if (element2 instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)element2).getNameIdentifier()) != null && identifier.isValid()) {
            return new BaseCtrlMouseInfo(identifier){

                @Override
                @NotNull
                public CtrlMouseDocInfo getDocInfo() {
                    String name = UsageViewUtil.getType(element2) + " '" + UsageViewUtil.getShortName(element2) + "'";
                    return new CtrlMouseDocInfo(CodeInsightBundle.message((String)"hint.text.show.usages", (Object[])new Object[]{name}), null, null);
                }

                @Override
                public boolean isValid() {
                    return element2.isValid();
                }
            };
        }
        return null;
    }

    @NotNull
    private static List<PsiElement> resolve(@NotNull PsiReference ref) {
        PsiElement resolvedElement;
        if (ref == null) {
            GotoDeclarationAction.$$$reportNull$$$0(39);
        }
        if ((resolvedElement = ref.resolve()) == null && ref instanceof PsiPolyVariantReference) {
            ResolveResult[] psiElements;
            ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
            for (ResolveResult resolveResult : psiElements = ((PsiPolyVariantReference)ref).multiResolve(false)) {
                if (resolveResult.getElement() == null) continue;
                result2.add(resolveResult.getElement());
            }
            ArrayList<PsiElement> arrayList = result2;
            if (arrayList == null) {
                GotoDeclarationAction.$$$reportNull$$$0(40);
            }
            return arrayList;
        }
        List<Object> list2 = resolvedElement == null ? Collections.emptyList() : Collections.singletonList(resolvedElement);
        if (list2 == null) {
            GotoDeclarationAction.$$$reportNull$$$0(41);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/actions/GotoDeclarationAction";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 25: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 22: 
            case 26: 
            case 29: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentEditor";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titlePattern";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/actions/GotoDeclarationAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentEventData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestCandidates";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllTargetElements";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 41: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doSelectCandidate";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "startFindUsages";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findElementToShowUsagesOf";
                break;
            }
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "chooseAmbiguousTarget";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "navigateInCurrentEditor";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "gotoTargetElement";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doChooseAmbiguousTarget";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElementsFromProviders";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getCtrlMouseInfo";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

