/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.CopyAction;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorCopyPasteHelperImpl;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyHandler
extends EditorActionHandler
implements CopyAction.TransferableProvider {
    private static final Logger LOG = Logger.getInstance(CopyHandler.class);
    private final EditorActionHandler myOriginalAction;

    public CopyHandler(EditorActionHandler originalHandler) {
        this.myOriginalAction = originalHandler;
    }

    public void doExecute(@NotNull Editor editor, Caret caret, DataContext dataContext) {
        EditorEx ex;
        if (editor == null) {
            CopyHandler.$$$reportNull$$$0(0);
        }
        assert (caret == null) : "Invocation of 'copy' operation for specific caret is not supported";
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getComponent()));
        if (project == null) {
            if (this.myOriginalAction != null) {
                this.myOriginalAction.execute(editor, null, dataContext);
            }
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null) {
            if (this.myOriginalAction != null) {
                this.myOriginalAction.execute(editor, null, dataContext);
            }
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection(true)) {
            if (Registry.is((String)"editor.skip.copy.and.cut.for.empty.selection")) {
                return;
            }
            editor.getCaretModel().runForEachCaret(__ -> selectionModel.selectLineAtCaret());
            if (!selectionModel.hasSelection(true)) {
                return;
            }
            editor.getCaretModel().runForEachCaret(__ -> EditorActionUtil.moveCaretToLineStartIgnoringSoftWraps(editor));
        }
        Transferable transferable = CopyHandler.getSelection(editor, project, file2);
        CopyPasteManager.getInstance().setContents(transferable);
        if (editor instanceof EditorEx && (ex = (EditorEx)editor).isStickySelection()) {
            ex.setStickySelection(false);
        }
    }

    @Override
    @Nullable
    public Transferable getSelection(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            CopyHandler.$$$reportNull$$$0(1);
        }
        if ((project = editor.getProject()) == null) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        return CopyHandler.getSelection(editor, project, file2);
    }

    @NotNull
    private static Transferable getSelection(@NotNull Editor editor, @NotNull Project project, @NotNull PsiFile file2) {
        if (editor == null) {
            CopyHandler.$$$reportNull$$$0(2);
        }
        if (project == null) {
            CopyHandler.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            CopyHandler.$$$reportNull$$$0(4);
        }
        CopyHandler.commitDocuments(editor, project);
        SelectionModel selectionModel = editor.getSelectionModel();
        int[] startOffsets = selectionModel.getBlockSelectionStarts();
        int[] endOffsets = selectionModel.getBlockSelectionEnds();
        ArrayList transferableDataList = new ArrayList();
        DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> {
            for (CopyPastePostProcessor processor2 : CopyPastePostProcessor.EP_NAME.getExtensionList()) {
                try {
                    transferableDataList.addAll(processor2.collectTransferableData(file2, editor, startOffsets, endOffsets));
                }
                catch (IndexNotReadyException e) {
                    LOG.debug((Throwable)e);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        });
        String text2 = editor.getCaretModel().supportsMultipleCarets() ? EditorCopyPasteHelperImpl.getSelectedTextForClipboard(editor, transferableDataList) : selectionModel.getSelectedText();
        String rawText = TextBlockTransferable.convertLineSeparators(text2, "\n", transferableDataList);
        String escapedText = null;
        for (CopyPastePreProcessor processor2 : CopyPastePreProcessor.EP_NAME.getExtensionList()) {
            try {
                escapedText = processor2.preprocessOnCopy(file2, startOffsets, endOffsets, rawText);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            if (escapedText == null) continue;
            break;
        }
        return new TextBlockTransferable(escapedText != null ? escapedText : rawText, transferableDataList, escapedText != null ? new RawText(rawText) : null);
    }

    private static void commitDocuments(@NotNull Editor editor, @NotNull Project project) {
        boolean commitAllDocuments;
        if (editor == null) {
            CopyHandler.$$$reportNull$$$0(5);
        }
        if (project == null) {
            CopyHandler.$$$reportNull$$$0(6);
        }
        List postProcessors = ContainerUtil.filter((Collection)CopyPastePostProcessor.EP_NAME.getExtensionList(), p -> p.requiresAllDocumentsToBeCommitted(editor, project));
        List preProcessors = ContainerUtil.filter((Collection)CopyPastePreProcessor.EP_NAME.getExtensionList(), p -> p.requiresAllDocumentsToBeCommitted(editor, project));
        boolean bl = commitAllDocuments = !preProcessors.isEmpty() || !postProcessors.isEmpty();
        if (LOG.isDebugEnabled()) {
            LOG.debug("CommitAllDocuments: " + commitAllDocuments);
            if (commitAllDocuments) {
                String processorNames = StringUtil.join((Iterable)preProcessors, (String)",") + "," + StringUtil.join((Iterable)postProcessors, (String)",");
                LOG.debug("Processors with commitAllDocuments requirement: [" + processorNames + "]");
            }
        }
        if (commitAllDocuments) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        } else {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/CopyHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelection";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "commitDocuments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

