/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ChangesDiffCalculator {
    private static final Logger LOG = Logger.getInstance(ChangesDiffCalculator.class);

    public static List<TextRange> calculateDiff(@NotNull Document beforeDocument, @NotNull Document currentDocument) {
        if (beforeDocument == null) {
            ChangesDiffCalculator.$$$reportNull$$$0(0);
        }
        if (currentDocument == null) {
            ChangesDiffCalculator.$$$reportNull$$$0(1);
        }
        CharSequence beforeText = beforeDocument.getCharsSequence();
        CharSequence currentText = currentDocument.getCharsSequence();
        try {
            ComparisonManager manager = ComparisonManager.getInstance();
            List lineFragments = manager.compareLinesInner(beforeText, currentText, ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
            ArrayList<TextRange> modifiedRanges = new ArrayList<TextRange>();
            for (LineFragment lineFragment : lineFragments) {
                int fragmentStartOffset = lineFragment.getStartOffset2();
                int fragmentEndOffset = lineFragment.getEndOffset2();
                List innerFragments = lineFragment.getInnerFragments();
                if (innerFragments != null) {
                    for (DiffFragment innerFragment : innerFragments) {
                        int innerFragmentStartOffset = fragmentStartOffset + innerFragment.getStartOffset2();
                        int innerFragmentEndOffset = fragmentStartOffset + innerFragment.getEndOffset2();
                        modifiedRanges.add(ChangesDiffCalculator.calculateChangeHighlightRange(currentText, innerFragmentStartOffset, innerFragmentEndOffset));
                    }
                    continue;
                }
                modifiedRanges.add(ChangesDiffCalculator.calculateChangeHighlightRange(currentText, fragmentStartOffset, fragmentEndOffset));
            }
            return modifiedRanges;
        }
        catch (DiffTooBigException e) {
            LOG.info((Throwable)e);
            return Collections.emptyList();
        }
    }

    @NotNull
    private static TextRange calculateChangeHighlightRange(@NotNull CharSequence text2, int startOffset, int endOffset) {
        if (text2 == null) {
            ChangesDiffCalculator.$$$reportNull$$$0(2);
        }
        if (startOffset == endOffset) {
            while (startOffset < text2.length() && text2.charAt(startOffset) == ' ') {
                ++startOffset;
            }
            return new TextRange(startOffset, startOffset);
        }
        int originalStartOffset = startOffset;
        int originalEndOffset = endOffset;
        while (endOffset < text2.length() && ChangesDiffCalculator.rangesEqual(text2, originalStartOffset, originalEndOffset, startOffset + 1, endOffset + 1)) {
            ++startOffset;
            ++endOffset;
        }
        return new TextRange(startOffset, endOffset);
    }

    private static boolean rangesEqual(@NotNull CharSequence text2, int start1, int end1, int start2, int end2) {
        if (text2 == null) {
            ChangesDiffCalculator.$$$reportNull$$$0(3);
        }
        if (end1 - start1 != end2 - start2) {
            return false;
        }
        for (int i2 = start1; i2 < end1; ++i2) {
            if (text2.charAt(i2) == text2.charAt(i2 - start1 + start2)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeDocument";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentDocument";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/ChangesDiffCalculator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateDiff";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateChangeHighlightRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "rangesEqual";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

