/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.Problem;
import com.intellij.analysis.problemsView.toolWindow.HighlightingProblem;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewPanel;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ToggleOptionAction;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

final class ProblemsViewStatsCollector
extends CounterUsagesCollector {
    private static final String UNKNOWN = "unknown";
    private static final List<String> TABS = List.of("CurrentFile", "ProjectErrors", "unknown");
    private static final EventField<String> TAB_NAME = EventFields.String((String)"scope_tab", TABS);
    private static final EventField<Integer> PROBLEMS_COUNT = EventFields.Int((String)"problems_count");
    private static final EventField<Boolean> PREVIEW_ENABLED = EventFields.Boolean((String)"preview");
    private static final EventField<Long> DURATION = EventFields.Long((String)"duration_seconds");
    private static final EventField<Integer> PROBLEM_SEVERITY = EventFields.Int((String)"severity");
    private static final EventLogGroup PROBLEMS_VIEW_GROUP = new EventLogGroup("problems.view.sessions", 1);
    private static final VarargEventId TAB_SHOWN = PROBLEMS_VIEW_GROUP.registerVarargEvent("problems.tab.shown", new EventField[]{TAB_NAME, PROBLEMS_COUNT, PREVIEW_ENABLED});
    private static final VarargEventId TAB_HIDDEN = PROBLEMS_VIEW_GROUP.registerVarargEvent("problems.tab.hidden", new EventField[]{TAB_NAME, PROBLEMS_COUNT, PREVIEW_ENABLED, DURATION});
    private static final VarargEventId PROBLEM_SELECTED = PROBLEMS_VIEW_GROUP.registerVarargEvent("select.item", new EventField[]{TAB_NAME, PROBLEM_SEVERITY});

    ProblemsViewStatsCollector() {
    }

    @NotNull
    private static String tabName(@NotNull ProblemsViewPanel panel2) {
        ToolWindow window;
        if (panel2 == null) {
            ProblemsViewStatsCollector.$$$reportNull$$$0(0);
        }
        if ((window = ProblemsView.getToolWindow(panel2.getProject())) == null) {
            return UNKNOWN;
        }
        ContentManager manager = window.getContentManagerIfCreated();
        if (manager == null) {
            return UNKNOWN;
        }
        Content content2 = manager.getContent((JComponent)((Object)panel2));
        if (content2 == null) {
            return UNKNOWN;
        }
        int index = manager.getIndexOfContent(content2);
        return 0 <= index && index < TABS.size() ? TABS.get(index) : UNKNOWN;
    }

    private static boolean previewEnabled(@NotNull ProblemsViewPanel panel2) {
        ToggleOptionAction.Option option2;
        if (panel2 == null) {
            ProblemsViewStatsCollector.$$$reportNull$$$0(1);
        }
        return (option2 = panel2.getShowPreview()) != null && option2.isSelected();
    }

    private static int problemsCount(@NotNull ProblemsViewPanel panel2) {
        Root root;
        if (panel2 == null) {
            ProblemsViewStatsCollector.$$$reportNull$$$0(2);
        }
        return (root = panel2.getTreeModel().getRoot()) == null ? 0 : root.getProblemCount();
    }

    private static int problemSeverity(@NotNull Problem problem) {
        if (problem == null) {
            ProblemsViewStatsCollector.$$$reportNull$$$0(3);
        }
        HighlightingProblem highlighting = problem instanceof HighlightingProblem ? (HighlightingProblem)problem : null;
        return highlighting != null ? highlighting.getSeverity() : HighlightSeverity.ERROR.myVal;
    }

    static void tabShown(@NotNull ProblemsViewPanel panel2) {
        if (panel2 == null) {
            ProblemsViewStatsCollector.$$$reportNull$$$0(4);
        }
        TAB_SHOWN.log(panel2.getProject(), new EventPair[]{TAB_NAME.with((Object)ProblemsViewStatsCollector.tabName(panel2)), PROBLEMS_COUNT.with((Object)ProblemsViewStatsCollector.problemsCount(panel2)), PREVIEW_ENABLED.with((Object)ProblemsViewStatsCollector.previewEnabled(panel2))});
    }

    static void tabHidden(@NotNull ProblemsViewPanel panel2, long nano) {
        if (panel2 == null) {
            ProblemsViewStatsCollector.$$$reportNull$$$0(5);
        }
        TAB_HIDDEN.log(panel2.getProject(), new EventPair[]{TAB_NAME.with((Object)ProblemsViewStatsCollector.tabName(panel2)), PROBLEMS_COUNT.with((Object)ProblemsViewStatsCollector.problemsCount(panel2)), PREVIEW_ENABLED.with((Object)ProblemsViewStatsCollector.previewEnabled(panel2)), DURATION.with((Object)TimeUnit.NANOSECONDS.toSeconds(nano))});
    }

    static void problemSelected(@NotNull ProblemsViewPanel panel2, @NotNull Problem problem) {
        if (panel2 == null) {
            ProblemsViewStatsCollector.$$$reportNull$$$0(6);
        }
        if (problem == null) {
            ProblemsViewStatsCollector.$$$reportNull$$$0(7);
        }
        PROBLEM_SELECTED.log(panel2.getProject(), new EventPair[]{TAB_NAME.with((Object)ProblemsViewStatsCollector.tabName(panel2)), PROBLEM_SEVERITY.with((Object)ProblemsViewStatsCollector.problemSeverity(problem))});
    }

    public EventLogGroup getGroup() {
        return PROBLEMS_VIEW_GROUP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
        }
        objectArray2[1] = "com/intellij/analysis/problemsView/toolWindow/ProblemsViewStatsCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tabName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "previewEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "problemsCount";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "problemSeverity";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "tabShown";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "tabHidden";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "problemSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

