/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.FileProblem;
import com.intellij.analysis.problemsView.ProblemsProvider;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.util.XmlStringUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u00010B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010'\u001a\u0004\u0018\u00010\u001e2\u0006\u0010(\u001a\u00020\nH\u0002J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0096\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020\nH\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00188@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\fR\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001e8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\fR\u0014\u0010%\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0010\u00a8\u00061"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/HighlightingProblem;", "Lcom/intellij/analysis/problemsView/FileProblem;", "provider", "Lcom/intellij/analysis/problemsView/ProblemsProvider;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "(Lcom/intellij/analysis/problemsView/ProblemsProvider;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;)V", "column", "", "getColumn", "()I", "description", "", "getDescription", "()Ljava/lang/String;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "info", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "getInfo$intellij_platform_lang_impl", "()Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "line", "getLine", "position", "Lcom/intellij/analysis/problemsView/toolWindow/HighlightingProblem$CachedPosition;", "getPosition", "()Lcom/intellij/analysis/problemsView/toolWindow/HighlightingProblem$CachedPosition;", "getProvider", "()Lcom/intellij/analysis/problemsView/ProblemsProvider;", "severity", "getSeverity", "text", "getText", "computePosition", "offset", "equals", "", "other", "", "level", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "hashCode", "CachedPosition", "intellij.platform.lang.impl"})
public final class HighlightingProblem
implements FileProblem {
    private CachedPosition position;
    @NotNull
    private final ProblemsProvider provider;
    @NotNull
    private final VirtualFile file;
    private final RangeHighlighterEx highlighter;

    private final Icon getIcon(HighlightDisplayLevel level) {
        return this.getSeverity() >= level.getSeverity().myVal ? level.getIcon() : null;
    }

    @Nullable
    public final HighlightInfo getInfo$intellij_platform_lang_impl() {
        return HighlightInfo.fromRangeHighlighter(this.highlighter);
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Object object;
        Object object2;
        HighlightInfo highlightInfo = this.getInfo$intellij_platform_lang_impl();
        Object object3 = HighlightDisplayLevel.find((HighlightSeverity)(highlightInfo != null ? highlightInfo.getSeverity() : null));
        if (object3 == null || (object3 = object3.getIcon()) == null) {
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayLevel, (String)"HighlightDisplayLevel.ERROR");
            object3 = object2 = this.getIcon(highlightDisplayLevel);
        }
        if (object3 == null) {
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayLevel, (String)"HighlightDisplayLevel.WARNING");
            object2 = object = this.getIcon(highlightDisplayLevel);
        }
        if (object2 == null) {
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayLevel, (String)"HighlightDisplayLevel.WEAK_WARNING");
            Icon icon2 = highlightDisplayLevel.getIcon();
            object = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"HighlightDisplayLevel.WEAK_WARNING.icon");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getText() {
        Object object;
        int pos;
        int n;
        Object text2;
        block6: {
            int n2;
            Object object2 = this.getInfo$intellij_platform_lang_impl();
            if (object2 == null || (object2 = ((HighlightInfo)object2).getDescription()) == null) {
                return "Invalid";
            }
            text2 = object2;
            CharSequence $this$indexOfFirst$iv = (CharSequence)text2;
            boolean $i$f$indexOfFirst = false;
            n = 0;
            int n3 = $this$indexOfFirst$iv.length();
            while (n < n3) {
                void index$iv;
                char it = $this$indexOfFirst$iv.charAt((int)index$iv);
                boolean bl = false;
                if (StringUtil.isLineBreak((char)it)) {
                    n2 = index$iv;
                    break block6;
                }
                ++index$iv;
            }
            n2 = pos = -1;
        }
        if (pos < 0 || StringsKt.startsWith((String)text2, (String)"<html>", (boolean)true)) {
            object = text2;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            Object object3 = text2;
            int n4 = 0;
            n = 0;
            Object object4 = object3;
            if (object4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object4).substring(n4, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            object = stringBuilder.append(string).append("\u2026").toString();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String getDescription() {
        int n;
        Object text2;
        block3: {
            Object object = this.getInfo$intellij_platform_lang_impl();
            if (object == null || (object = ((HighlightInfo)object).getDescription()) == null) {
                return null;
            }
            text2 = object;
            CharSequence $this$indexOfFirst$iv = (CharSequence)text2;
            boolean $i$f$indexOfFirst = false;
            int n2 = 0;
            int n3 = $this$indexOfFirst$iv.length();
            while (n2 < n3) {
                void index$iv;
                char it = $this$indexOfFirst$iv.charAt((int)index$iv);
                boolean bl = false;
                if (StringUtil.isLineBreak((char)it)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        int pos = n;
        return pos < 0 || StringsKt.startsWith((String)text2, (String)"<html>", (boolean)true) ? null : "<html>" + StringUtil.join((String[])StringUtil.splitByLines((String)XmlStringUtil.escapeString((String)text2)), (String)"<br/>");
    }

    public final int getSeverity() {
        HighlightInfo highlightInfo = this.getInfo$intellij_platform_lang_impl();
        return highlightInfo != null && (highlightInfo = highlightInfo.getSeverity()) != null ? ((HighlightSeverity)highlightInfo).myVal : -1;
    }

    public int hashCode() {
        return this.highlighter.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof HighlightingProblem && Intrinsics.areEqual((Object)((HighlightingProblem)other).highlighter, (Object)this.highlighter);
    }

    @Override
    public int getLine() {
        CachedPosition cachedPosition = this.getPosition();
        return cachedPosition != null ? cachedPosition.getLine() : -1;
    }

    @Override
    public int getColumn() {
        CachedPosition cachedPosition = this.getPosition();
        return cachedPosition != null ? cachedPosition.getColumn() : -1;
    }

    private final CachedPosition getPosition() {
        CachedPosition cachedPosition;
        HighlightInfo highlightInfo = this.getInfo$intellij_platform_lang_impl();
        if (highlightInfo != null) {
            int n = highlightInfo.getActualStartOffset();
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            CachedPosition cachedPosition2 = this.position;
            if (cachedPosition2 == null || it != cachedPosition2.getOffset()) {
                this.position = this.computePosition(it);
            }
            cachedPosition = this.position;
        } else {
            cachedPosition = null;
        }
        return cachedPosition;
    }

    private final CachedPosition computePosition(int offset) {
        if (offset < 0) {
            return null;
        }
        Document document = ProblemsView.getDocument(this.getProvider().getProject(), this.getFile());
        if (document == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"ProblemsView.getDocument\u2026ect, file) ?: return null");
        Document document2 = document;
        if (offset > document2.getTextLength()) {
            return null;
        }
        int line = document2.getLineNumber(offset);
        return new CachedPosition(offset, line, offset - document2.getLineStartOffset(line));
    }

    @Override
    @NotNull
    public ProblemsProvider getProvider() {
        return this.provider;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        return this.file;
    }

    public HighlightingProblem(@NotNull ProblemsProvider provider2, @NotNull VirtualFile file2, @NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        this.provider = provider2;
        this.file = file2;
        this.highlighter = highlighter;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/HighlightingProblem$CachedPosition;", "", "offset", "", "line", "column", "(III)V", "getColumn", "()I", "getLine", "getOffset", "intellij.platform.lang.impl"})
    private static final class CachedPosition {
        private final int offset;
        private final int line;
        private final int column;

        public final int getOffset() {
            return this.offset;
        }

        public final int getLine() {
            return this.line;
        }

        public final int getColumn() {
            return this.column;
        }

        public CachedPosition(int offset, int line, int column) {
            this.offset = offset;
            this.line = line;
            this.column = column;
        }
    }
}

