/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.lexer.YAMLGrammarCharUtil;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;

public final class YAMLQuotedTextImpl
extends YAMLScalarImpl
implements YAMLQuotedText {
    private final boolean myIsSingleQuoted;

    public YAMLQuotedTextImpl(@NotNull ASTNode node) {
        if (node == null) {
            YAMLQuotedTextImpl.$$$reportNull$$$0(0);
        }
        super(node);
        ASTNode firstContentNode = this.getFirstContentNode();
        this.myIsSingleQuoted = firstContentNode != null && firstContentNode.getElementType() == YAMLTokenTypes.SCALAR_STRING;
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        ASTNode firstContentNode = this.getFirstContentNode();
        if (firstContentNode == null) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                YAMLQuotedTextImpl.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        TextRange contentRange = TextRange.create((int)firstContentNode.getStartOffset(), (int)this.getTextRange().getEndOffset()).shiftRight(-this.getTextRange().getStartOffset());
        List lines = StringUtil.split((String)contentRange.substring(this.getText()), (String)"\n", (boolean)true, (boolean)false);
        int cumulativeOffset = contentRange.getStartOffset();
        for (int i = 0; i < lines.size(); ++i) {
            int lineStart;
            String line = (String)lines.get(i);
            int lineEnd = line.length();
            if (i == 0) {
                ++lineStart;
            } else {
                for (lineStart = 0; lineStart < line.length() && YAMLGrammarCharUtil.isSpaceLike(line.charAt(lineStart)); ++lineStart) {
                }
            }
            if (i == lines.size() - 1) {
                --lineEnd;
            } else {
                while (lineEnd > lineStart && YAMLGrammarCharUtil.isSpaceLike(line.charAt(lineEnd - 1))) {
                    --lineEnd;
                }
            }
            result.add(TextRange.create((int)lineStart, (int)lineEnd).shiftRight(cumulativeOffset));
            cumulativeOffset += line.length() + 1;
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            YAMLQuotedTextImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected String getRangesJoiner(@NotNull CharSequence text, @NotNull List<TextRange> contentRanges, int indexBefore) {
        TextRange leftRange;
        if (text == null) {
            YAMLQuotedTextImpl.$$$reportNull$$$0(3);
        }
        if (contentRanges == null) {
            YAMLQuotedTextImpl.$$$reportNull$$$0(4);
        }
        if ((leftRange = contentRanges.get(indexBefore)).isEmpty() || !this.isSingleQuote() && text.charAt(leftRange.getEndOffset() - 1) == '\\') {
            return "\n";
        }
        if (contentRanges.get(indexBefore + 1).isEmpty()) {
            return "";
        }
        return " ";
    }

    @Override
    protected List<Pair<TextRange, String>> getDecodeReplacements(@NotNull CharSequence input) {
        if (input == null) {
            YAMLQuotedTextImpl.$$$reportNull$$$0(5);
        }
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        int i = 0;
        while (i + 1 < input.length()) {
            if (this.isSingleQuote() && input.charAt(i) == '\'' && input.charAt(i + 1) == '\'') {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)2), (Object)"'"));
                ++i;
            } else if (!this.isSingleQuote() && input.charAt(i) == '\\') {
                if (input.charAt(i + 1) == '\n') {
                    result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)2), (Object)""));
                    ++i;
                } else {
                    int length = Escaper.findEscapementLength(input, i);
                    int charCode = Escaper.toUnicodeChar(input, i, length);
                    TextRange range = TextRange.create((int)i, (int)Math.min(i + length + 1, input.length()));
                    result.add((Pair<TextRange, String>)Pair.create((Object)range, (Object)Character.toString((char)charCode)));
                    i += range.getLength() - 1;
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        if (input == null) {
            YAMLQuotedTextImpl.$$$reportNull$$$0(6);
        }
        if (this.isSingleQuote()) {
            for (int i = 0; i < input.length(); ++i) {
                if (input.charAt(i) != '\n' || YAMLQuotedTextImpl.isSurroundedByNoSpace(input, i)) continue;
                throw new IllegalArgumentException("Newlines with spaces around are not convertible");
            }
        }
        int indent = YAMLUtil.getIndentToThisElement((PsiElement)this);
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indent);
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        int currentLength = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\n') {
                if (!this.isSingleQuote() && i + 1 < input.length() && YAMLGrammarCharUtil.isSpaceLike(input.charAt(i + 1))) {
                    result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\\n\\\n" + indentString + "\\")));
                } else if (!this.isSingleQuote() && i + 1 < input.length() && input.charAt(i + 1) == '\n') {
                    result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\\\n" + indentString + "\\n")));
                } else {
                    result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\n\n" + indentString)));
                }
                currentLength = 0;
                continue;
            }
            if (currentLength > 60 && (!this.isSingleQuote() || c == ' ' && YAMLQuotedTextImpl.isSurroundedByNoSpace(input, i))) {
                String replacement = this.isSingleQuote() ? "\n" + indentString : (YAMLGrammarCharUtil.isSpaceLike(c) ? "\\\n" + indentString + "\\" : "\\\n" + indentString);
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)(this.isSingleQuote() ? 1 : 0)), (Object)replacement));
                currentLength = 0;
            }
            ++currentLength;
            if (this.isSingleQuote() && c == '\'') {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)"''"));
                continue;
            }
            if (this.isSingleQuote()) continue;
            if (c == '\"') {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)"\\\""));
                continue;
            }
            if (c != '\\') continue;
            result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)"\\\\"));
        }
        return result;
    }

    @Override
    public boolean isMultiline() {
        return this.textContains('\n');
    }

    @Override
    public boolean isSingleQuote() {
        return this.myIsSingleQuoted;
    }

    @Override
    public String toString() {
        return "YAML quoted text";
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            YAMLQuotedTextImpl.$$$reportNull$$$0(7);
        }
        if (visitor instanceof YamlPsiElementVisitor) {
            ((YamlPsiElementVisitor)visitor).visitQuotedText(this);
        } else {
            super.accept(visitor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRanges";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRangesJoiner";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDecodeReplacements";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEncodeReplacements";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Escaper {
        private static final int[][] ONE_LETTER_CONVERSIONS = new int[][]{{48, 0}, {97, 7}, {98, 8}, {116, 9}, {9, 9}, {110, 10}, {118, 11}, {102, 12}, {114, 13}, {101, 27}, {32, 32}, {34, 34}, {47, 47}, {92, 92}, {78, 133}, {95, 160}, {76, 8232}, {80, 8233}};
        private static final NotNullLazyValue<Int2IntMap> ESC_TO_CODE = NotNullLazyValue.createValue(() -> {
            Int2IntOpenHashMap map = new Int2IntOpenHashMap(ONE_LETTER_CONVERSIONS.length);
            for (int[] conversion : ONE_LETTER_CONVERSIONS) {
                map.put(conversion[0], conversion[1]);
            }
            return map;
        });

        private Escaper() {
        }

        static int findEscapementLength(@NotNull CharSequence text, int pos) {
            if (text == null) {
                Escaper.$$$reportNull$$$0(0);
            }
            if (pos + 1 >= text.length() || text.charAt(pos) != '\\') {
                throw new IllegalArgumentException("This is not an escapement start");
            }
            char c = text.charAt(pos + 1);
            if (c == 'x') {
                return 3;
            }
            if (c == 'u') {
                return 5;
            }
            if (c == 'U') {
                return 9;
            }
            return 1;
        }

        static int toUnicodeChar(@NotNull CharSequence text, int pos, int length) {
            if (text == null) {
                Escaper.$$$reportNull$$$0(1);
            }
            if (length > 1) {
                CharSequence s = text.subSequence(pos + 2, Math.min(text.length(), pos + length + 1));
                try {
                    return Integer.parseInt(s.toString(), 16);
                }
                catch (NumberFormatException e) {
                    return 63;
                }
            }
            Integer result = ((Int2IntMap)ESC_TO_CODE.getValue()).get((int)text.charAt(pos + 1));
            return (Integer)ObjectUtils.notNull((Object)result, (Object)text.charAt(pos + 1));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "text";
            objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl$Escaper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findEscapementLength";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toUnicodeChar";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

