/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.i18n.AnnotationContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.util.UastExpressionUtils;

public abstract class NlsInfo {
    @NotNull
    private static final String NLS_CONTEXT = "com.intellij.openapi.util.NlsContext";
    static final String NLS_SAFE = "com.intellij.openapi.util.NlsSafe";
    @NotNull
    private static final Set<String> ANNOTATION_NAMES = Set.of("org.jetbrains.annotations.Nls", "org.jetbrains.annotations.NonNls", "com.intellij.openapi.util.NlsSafe");
    @NotNull
    private final ThreeState myNls;

    private NlsInfo(@NotNull ThreeState nls) {
        if (nls == null) {
            NlsInfo.$$$reportNull$$$0(0);
        }
        this.myNls = nls;
    }

    @NotNull
    public ThreeState getNlsStatus() {
        ThreeState threeState = this.myNls;
        if (threeState == null) {
            NlsInfo.$$$reportNull$$$0(1);
        }
        return threeState;
    }

    public boolean canBeUsedInLocalizedContext() {
        return this instanceof Localized || this instanceof NlsSafe;
    }

    @NotNull
    public static Localized localized() {
        Localized localized = Localized.NLS;
        if (localized == null) {
            NlsInfo.$$$reportNull$$$0(2);
        }
        return localized;
    }

    @NotNull
    public static NonLocalized nonLocalized() {
        NonLocalized nonLocalized = NonLocalized.INSTANCE;
        if (nonLocalized == null) {
            NlsInfo.$$$reportNull$$$0(3);
        }
        return nonLocalized;
    }

    @NotNull
    public static NlsInfo forExpression(@NotNull UExpression expression) {
        if (expression == null) {
            NlsInfo.$$$reportNull$$$0(4);
        }
        return NlsInfo.forExpression(expression, true);
    }

    @NotNull
    static NlsInfo forExpression(@NotNull UExpression expression, boolean allowStringModifications) {
        if (expression == null) {
            NlsInfo.$$$reportNull$$$0(5);
        }
        expression = NlsInfo.goUp(expression, allowStringModifications);
        AnnotationContext context = AnnotationContext.fromExpression(expression);
        return NlsInfo.fromAnnotationContext(expression.getUastParent(), context);
    }

    @NotNull
    public static NlsInfo forType(@NotNull PsiType type) {
        if (type == null) {
            NlsInfo.$$$reportNull$$$0(6);
        }
        return NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)type);
    }

    @NotNull
    public static NlsInfo forModifierListOwner(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NlsInfo.$$$reportNull$$$0(7);
        }
        return NlsInfo.fromAnnotationContext(null, AnnotationContext.fromModifierListOwner(owner));
    }

    @NotNull
    public static Nls.Capitalization getCapitalization(@NotNull PsiModifierListOwner owner) {
        NlsInfo info;
        if (owner == null) {
            NlsInfo.$$$reportNull$$$0(8);
        }
        if ((info = NlsInfo.forModifierListOwner(owner)) instanceof Localized) {
            Nls.Capitalization capitalization = ((Localized)info).getCapitalization();
            if (capitalization == null) {
                NlsInfo.$$$reportNull$$$0(9);
            }
            return capitalization;
        }
        Nls.Capitalization capitalization = Nls.Capitalization.NotSpecified;
        if (capitalization == null) {
            NlsInfo.$$$reportNull$$$0(10);
        }
        return capitalization;
    }

    @NotNull
    private static NlsInfo fromAnnotationContext(UElement parent, AnnotationContext context) {
        PsiMember member;
        ULocalVariable uLocal;
        NlsInfo info = NlsInfo.fromType(context.getType());
        if (info != Unspecified.UNKNOWN) {
            NlsInfo nlsInfo = info;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(11);
            }
            return nlsInfo;
        }
        PsiModifierListOwner owner = context.getOwner();
        if (owner == null) {
            Unspecified unspecified = Unspecified.UNKNOWN;
            if (unspecified == null) {
                NlsInfo.$$$reportNull$$$0(12);
            }
            return unspecified;
        }
        info = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)owner.getModifierList());
        if (info != Unspecified.UNKNOWN) {
            NlsInfo nlsInfo = info;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(13);
            }
            return nlsInfo;
        }
        if (owner instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)owner;
            if (parameter.isVarArgs() && context.getType() instanceof PsiEllipsisType) {
                info = NlsInfo.fromType(((PsiEllipsisType)context.getType()).getComponentType());
            }
        } else if (owner instanceof PsiVariable && (uLocal = (ULocalVariable)UastContextKt.toUElement((PsiElement)owner, ULocalVariable.class)) != null) {
            info = NlsInfo.fromUVariable((UVariable)uLocal);
        }
        if (info instanceof Unspecified) {
            info = context.secondaryItems().map(item -> NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)item.getModifierList())).filter(inf -> inf != Unspecified.UNKNOWN).findFirst().orElse(info);
        }
        if (info == Unspecified.UNKNOWN && (member = (PsiMember)ObjectUtils.tryCast((Object)(owner instanceof PsiParameter ? ((PsiParameter)owner).getDeclarationScope() : owner), PsiMember.class)) != null) {
            info = NlsInfo.fromContainer(member);
        }
        if (info == Unspecified.UNKNOWN && (!(parent instanceof UCallExpression) || owner instanceof PsiParameter)) {
            info = new Unspecified(owner);
        }
        NlsInfo nlsInfo = info;
        if (nlsInfo == null) {
            NlsInfo.$$$reportNull$$$0(14);
        }
        return nlsInfo;
    }

    @NotNull
    private static NlsInfo fromType(PsiType type) {
        if (type == null) {
            Unspecified unspecified = Unspecified.UNKNOWN;
            if (unspecified == null) {
                NlsInfo.$$$reportNull$$$0(15);
            }
            return unspecified;
        }
        Ref result = Ref.create((Object)Unspecified.UNKNOWN);
        InheritanceUtil.processSuperTypes((PsiType)type, (boolean)true, eachType -> {
            NlsInfo info = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)eachType);
            if (info != Unspecified.UNKNOWN) {
                result.set((Object)info);
                return false;
            }
            return !(eachType instanceof PsiClassType) || PsiUtil.resolveClassInClassTypeOnly((PsiType)eachType) instanceof PsiTypeParameter;
        });
        NlsInfo nlsInfo = (NlsInfo)result.get();
        if (nlsInfo == null) {
            NlsInfo.$$$reportNull$$$0(16);
        }
        return nlsInfo;
    }

    @NotNull
    public static UExpression goUp(@NotNull UExpression expression, boolean allowStringTransformation) {
        if (expression == null) {
            NlsInfo.$$$reportNull$$$0(17);
        }
        UExpression parent = expression;
        while (true) {
            UExpression next;
            UExpression lastExpression;
            UExpressionList elvis;
            UElement parentElement;
            if ((parentElement = parent.getUastParent()) instanceof ULocalVariable && parentElement.getUastParent() instanceof UDeclarationsExpression && (elvis = (UExpressionList)ObjectUtils.tryCast((Object)parentElement.getUastParent().getUastParent(), UExpressionList.class)) != null) {
                parentElement = elvis;
            }
            if (parentElement instanceof UExpressionList && (lastExpression = (UExpression)ContainerUtil.getLastItem((List)((UExpressionList)parentElement).getExpressions())) != null && AnnotationContext.expressionsAreEquivalent(parent, lastExpression)) {
                parentElement = parentElement.getUastParent();
            }
            if ((next = (UExpression)ObjectUtils.tryCast((Object)parentElement, UExpression.class)) == null || next instanceof UNamedExpression) {
                UExpression uExpression = parent;
                if (uExpression == null) {
                    NlsInfo.$$$reportNull$$$0(18);
                }
                return uExpression;
            }
            if (next instanceof USwitchClauseExpression) {
                if (((USwitchClauseExpression)next).getCaseValues().contains(AnnotationContext.normalize(parent))) {
                    UExpression uExpression = parent;
                    if (uExpression == null) {
                        NlsInfo.$$$reportNull$$$0(19);
                    }
                    return uExpression;
                }
                UExpressionList switchBody = (UExpressionList)ObjectUtils.tryCast((Object)next.getUastParent(), UExpressionList.class);
                if (switchBody == null) {
                    UExpression uExpression = parent;
                    if (uExpression == null) {
                        NlsInfo.$$$reportNull$$$0(20);
                    }
                    return uExpression;
                }
                USwitchExpression switchExpression = (USwitchExpression)ObjectUtils.tryCast((Object)switchBody.getUastParent(), USwitchExpression.class);
                if (switchExpression == null) {
                    UExpression uExpression = parent;
                    if (uExpression == null) {
                        NlsInfo.$$$reportNull$$$0(21);
                    }
                    return uExpression;
                }
                next = switchExpression;
            }
            ULambdaExpression lambda = (ULambdaExpression)ObjectUtils.tryCast((Object)next, ULambdaExpression.class);
            if (next instanceof UReturnExpression && (lambda = (ULambdaExpression)ObjectUtils.tryCast((Object)((UReturnExpression)next).getJumpTarget(), ULambdaExpression.class)) == null) {
                UExpression uExpression = parent;
                if (uExpression == null) {
                    NlsInfo.$$$reportNull$$$0(22);
                }
                return uExpression;
            }
            if (lambda != null) {
                UCallExpression uastParent = (UCallExpression)ObjectUtils.tryCast((Object)lambda.getUastParent(), UCallExpression.class);
                if (uastParent == null) {
                    UExpression uExpression = parent;
                    if (uExpression == null) {
                        NlsInfo.$$$reportNull$$$0(23);
                    }
                    return uExpression;
                }
                PsiMethod method = uastParent.resolve();
                if (method == null || !NlsInfo.isPassthroughMethod(method, uastParent, (UExpression)lambda)) {
                    UExpression uExpression = parent;
                    if (uExpression == null) {
                        NlsInfo.$$$reportNull$$$0(24);
                    }
                    return uExpression;
                }
                next = uastParent;
            }
            if (next instanceof UQualifiedReferenceExpression && !TypeUtils.isJavaLangString((PsiType)next.getExpressionType()) && !TypeUtils.typeEquals((String)"java.lang.CharSequence", (PsiType)next.getExpressionType())) {
                UExpression uExpression = parent;
                if (uExpression == null) {
                    NlsInfo.$$$reportNull$$$0(25);
                }
                return uExpression;
            }
            if (next instanceof UPolyadicExpression && (!allowStringTransformation || ((UPolyadicExpression)next).getOperator() != UastBinaryOperator.PLUS)) {
                UExpression uExpression = parent;
                if (uExpression == null) {
                    NlsInfo.$$$reportNull$$$0(26);
                }
                return uExpression;
            }
            if (next instanceof UCallExpression && !UastExpressionUtils.isArrayInitializer((UElement)next) && !UastExpressionUtils.isNewArrayWithInitializer((UElement)next)) {
                boolean shouldGoThroughCall;
                PsiMethod method = ((UCallExpression)next).resolve();
                boolean bl = shouldGoThroughCall = TypeUtils.isJavaLangString((PsiType)next.getExpressionType()) && (allowStringTransformation && NlsInfo.isStringProcessingMethod(method) || NlsInfo.isPassthroughMethod(method, (UCallExpression)next, parent));
                if (!shouldGoThroughCall) {
                    UExpression uExpression = parent;
                    if (uExpression == null) {
                        NlsInfo.$$$reportNull$$$0(27);
                    }
                    return uExpression;
                }
            }
            if (next instanceof UIfExpression && AnnotationContext.expressionsAreEquivalent(parent, ((UIfExpression)next).getCondition())) {
                UExpression uExpression = parent;
                if (uExpression == null) {
                    NlsInfo.$$$reportNull$$$0(28);
                }
                return uExpression;
            }
            parent = next;
        }
    }

    static boolean isPassthroughMethod(@Nullable PsiMethod method, @Nullable UCallExpression call, @Nullable UExpression arg) {
        if (method == null) {
            return false;
        }
        PsiType type = method.getReturnType();
        PsiTypeParameter typeParameter = (PsiTypeParameter)ObjectUtils.tryCast((Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)type), PsiTypeParameter.class);
        if (typeParameter != null && typeParameter.getExtendsList().getReferencedTypes().length == 0) {
            PsiParameter[] parameters;
            if (arg == null || call == null) {
                parameters = method.getParameterList().getParameters();
            } else {
                PsiParameter parameter = AnnotationContext.getParameter(method, call, arg);
                if (parameter == null) {
                    return false;
                }
                PsiType parameterType = parameter.getType();
                PsiElement psi = call.getSourcePsi();
                if (psi instanceof PsiMethodCallExpression) {
                    PsiSubstitutor substitutor = ((PsiMethodCallExpression)psi).getMethodExpression().advancedResolve(false).getSubstitutor();
                    parameterType = substitutor.substitute(parameterType);
                }
                if (NlsInfo.fromType(parameterType) != Unspecified.UNKNOWN) {
                    return false;
                }
                parameters = new PsiParameter[]{parameter};
            }
            for (PsiParameter parameter : parameters) {
                PsiType parameterType = parameter.getType();
                if (type.equals(GenericsUtil.getVariableTypeByExpressionType((PsiType)parameterType))) {
                    return true;
                }
                PsiType returnType = GenericsUtil.getVariableTypeByExpressionType((PsiType)LambdaUtil.getFunctionalInterfaceReturnType((PsiType)parameterType));
                if (!type.equals(returnType)) continue;
                return true;
            }
        }
        return NlsInfo.isKotlinPassthroughMethod(method);
    }

    static boolean isStringProcessingMethod(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (!(NlsInfo.forModifierListOwner((PsiModifierListOwner)method) instanceof Unspecified)) {
            return false;
        }
        if (!JavaMethodContractUtil.isPure((PsiMethod)method)) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length == 0) {
            return false;
        }
        for (PsiParameter parameter : parameters) {
            if (NlsInfo.forModifierListOwner((PsiModifierListOwner)parameter) instanceof Unspecified) continue;
            return false;
        }
        return true;
    }

    private static boolean isKotlinPassthroughMethod(PsiMethod method) {
        PsiParameter parameter;
        PsiParameter[] parameters;
        if ((method.getName().equals("let") || method.getName().equals("run")) && method.getModifierList().textMatches((CharSequence)"public inline") && (parameters = method.getParameterList().getParameters()).length == 2 && NlsInfo.isReceiver(method, parameters[0]) && parameters[1].getName().equals("block")) {
            return true;
        }
        if (method.getName().equals("joinToString")) {
            PsiClass aClass = method.getContainingClass();
            return aClass != null && "kotlin.collections.CollectionsKt___CollectionsKt".equals(aClass.getQualifiedName());
        }
        if (method.hasModifierProperty("static") && (parameter = method.getParameterList().getParameter(0)) != null && NlsInfo.isReceiver(method, parameter)) {
            PsiClass aClass = method.getContainingClass();
            return aClass != null && aClass.getQualifiedName() != null && aClass.getQualifiedName().startsWith("kotlin.text.StringsKt__Strings");
        }
        return false;
    }

    @NotNull
    static NlsInfo fromUVariable(@NotNull UVariable owner) {
        if (owner == null) {
            NlsInfo.$$$reportNull$$$0(29);
        }
        for (UAnnotation annotation : owner.getUAnnotations()) {
            NlsInfo info = NlsInfo.fromAnnotation(annotation);
            if (info != Unspecified.UNKNOWN) {
                NlsInfo nlsInfo = info;
                if (nlsInfo == null) {
                    NlsInfo.$$$reportNull$$$0(30);
                }
                return nlsInfo;
            }
            info = NlsInfo.fromMetaAnnotation(annotation);
            if (info == Unspecified.UNKNOWN) continue;
            NlsInfo nlsInfo = info;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(31);
            }
            return nlsInfo;
        }
        Unspecified unspecified = Unspecified.UNKNOWN;
        if (unspecified == null) {
            NlsInfo.$$$reportNull$$$0(32);
        }
        return unspecified;
    }

    @NotNull
    private static NlsInfo fromAnnotationOwner(@Nullable PsiAnnotationOwner owner) {
        if (owner == null) {
            Unspecified unspecified = Unspecified.UNKNOWN;
            if (unspecified == null) {
                NlsInfo.$$$reportNull$$$0(33);
            }
            return unspecified;
        }
        if (owner instanceof PsiModifierList) {
            NlsInfo nlsInfo = (NlsInfo)CachedValuesManager.getCachedValue((PsiElement)((PsiModifierList)owner), () -> CachedValueProvider.Result.create((Object)NlsInfo.computeFromAnnotationOwner(owner), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(34);
            }
            return nlsInfo;
        }
        return NlsInfo.computeFromAnnotationOwner(owner);
    }

    @NotNull
    private static NlsInfo computeFromAnnotationOwner(@NotNull PsiAnnotationOwner owner) {
        PsiAnnotation annotation;
        PsiElement parent;
        if (owner == null) {
            NlsInfo.$$$reportNull$$$0(35);
        }
        for (PsiAnnotation annotation2 : owner.getAnnotations()) {
            NlsInfo info = NlsInfo.fromAnnotation(annotation2);
            if (info != Unspecified.UNKNOWN) {
                NlsInfo nlsInfo = info;
                if (nlsInfo == null) {
                    NlsInfo.$$$reportNull$$$0(36);
                }
                return nlsInfo;
            }
            UAnnotation uAnnotation = (UAnnotation)UastContextKt.toUElement((PsiElement)annotation2, UAnnotation.class);
            if (uAnnotation == null || (info = NlsInfo.fromMetaAnnotation(uAnnotation)) == Unspecified.UNKNOWN) continue;
            NlsInfo nlsInfo = info;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(37);
            }
            return nlsInfo;
        }
        if (owner instanceof PsiModifierList && (parent = ((PsiModifierList)owner).getParent()) instanceof PsiModifierListOwner && (annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)((PsiModifierListOwner)parent), ANNOTATION_NAMES, (boolean)false)) != null) {
            return NlsInfo.fromAnnotation(annotation);
        }
        Unspecified unspecified = Unspecified.UNKNOWN;
        if (unspecified == null) {
            NlsInfo.$$$reportNull$$$0(38);
        }
        return unspecified;
    }

    @NotNull
    private static NlsInfo fromMetaAnnotation(@NotNull UAnnotation annotation) {
        PsiClass annotationClass;
        if (annotation == null) {
            NlsInfo.$$$reportNull$$$0(39);
        }
        if ((annotationClass = annotation.resolve()) == null) {
            Unspecified unspecified = Unspecified.UNKNOWN;
            if (unspecified == null) {
                NlsInfo.$$$reportNull$$$0(40);
            }
            return unspecified;
        }
        NlsInfo baseInfo = Unspecified.UNKNOWN;
        String prefix = "";
        String suffix = "";
        for (PsiAnnotation metaAnno : annotationClass.getAnnotations()) {
            if (metaAnno.hasQualifiedName(NLS_CONTEXT)) {
                prefix = StringUtil.notNullize((String)AnnotationUtil.getStringAttributeValue((PsiAnnotation)metaAnno, (String)"prefix"));
                suffix = StringUtil.notNullize((String)AnnotationUtil.getStringAttributeValue((PsiAnnotation)metaAnno, (String)"suffix"));
                continue;
            }
            NlsInfo info = NlsInfo.fromAnnotation(metaAnno);
            if (info == Unspecified.UNKNOWN) continue;
            baseInfo = info;
        }
        if (baseInfo instanceof Localized) {
            Localized localized = ((Localized)baseInfo).withPrefixAndSuffix(prefix, suffix).withAnnotation(annotation);
            if (localized == null) {
                NlsInfo.$$$reportNull$$$0(41);
            }
            return localized;
        }
        Unspecified unspecified = baseInfo;
        if (unspecified == null) {
            NlsInfo.$$$reportNull$$$0(42);
        }
        return unspecified;
    }

    @NotNull
    private static NlsInfo fromAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            NlsInfo.$$$reportNull$$$0(43);
        }
        return NlsInfo.fromAnnotationInfo(annotation.getQualifiedName(), () -> (UExpression)UastContextKt.toUElement((PsiElement)annotation.findAttributeValue("capitalization"), UExpression.class));
    }

    @NotNull
    private static NlsInfo fromAnnotation(@NotNull UAnnotation annotation) {
        if (annotation == null) {
            NlsInfo.$$$reportNull$$$0(44);
        }
        return NlsInfo.fromAnnotationInfo(annotation.getQualifiedName(), () -> annotation.findAttributeValue("capitalization"));
    }

    @NotNull
    private static NlsInfo fromAnnotationInfo(String qualifiedName, Supplier<UExpression> capitalization) {
        if (qualifiedName == null) {
            Unspecified unspecified = Unspecified.UNKNOWN;
            if (unspecified == null) {
                NlsInfo.$$$reportNull$$$0(45);
            }
            return unspecified;
        }
        if (qualifiedName.equals("org.jetbrains.annotations.NonNls") || qualifiedName.equals("org.jetbrains.annotations.PropertyKey")) {
            NonLocalized nonLocalized = NonLocalized.INSTANCE;
            if (nonLocalized == null) {
                NlsInfo.$$$reportNull$$$0(46);
            }
            return nonLocalized;
        }
        if (qualifiedName.equals(NLS_SAFE) || qualifiedName.equals("org.intellij.lang.annotations.RegExp")) {
            NlsSafe nlsSafe = NlsSafe.INSTANCE;
            if (nlsSafe == null) {
                NlsInfo.$$$reportNull$$$0(47);
            }
            return nlsSafe;
        }
        if (qualifiedName.equals("org.jetbrains.annotations.Nls")) {
            UExpression value = capitalization.get();
            String name = null;
            if (value instanceof UReferenceExpression) {
                name = ((UReferenceExpression)value).getResolvedName();
            }
            if (name != null) {
                if (Nls.Capitalization.Title.name().equals(name)) {
                    Localized localized = Localized.NLS_TITLE;
                    if (localized == null) {
                        NlsInfo.$$$reportNull$$$0(48);
                    }
                    return localized;
                }
                if (Nls.Capitalization.Sentence.name().equals(name)) {
                    Localized localized = Localized.NLS_SENTENCE;
                    if (localized == null) {
                        NlsInfo.$$$reportNull$$$0(49);
                    }
                    return localized;
                }
            }
            Localized localized = Localized.NLS;
            if (localized == null) {
                NlsInfo.$$$reportNull$$$0(50);
            }
            return localized;
        }
        Unspecified unspecified = Unspecified.UNKNOWN;
        if (unspecified == null) {
            NlsInfo.$$$reportNull$$$0(51);
        }
        return unspecified;
    }

    private static boolean isReceiver(PsiMethod method, PsiParameter param) {
        return param.getName().equals("$receiver") || param.getName().equals("$this$" + method.getName());
    }

    @NotNull
    private static NlsInfo fromContainer(@NotNull PsiMember member) {
        if (member == null) {
            NlsInfo.$$$reportNull$$$0(52);
        }
        for (PsiClass containingClass = member.getContainingClass(); containingClass != null; containingClass = containingClass.getContainingClass()) {
            NlsInfo classInfo = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)containingClass.getModifierList());
            if (classInfo == Unspecified.UNKNOWN) continue;
            NlsInfo nlsInfo = classInfo;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(53);
            }
            return nlsInfo;
        }
        PsiFile containingFile = member.getContainingFile();
        if (containingFile instanceof PsiClassOwner) {
            String packageName = ((PsiClassOwner)containingFile).getPackageName();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)member.getProject()).findPackage(packageName);
            if (aPackage != null) {
                NlsInfo info = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)aPackage.getAnnotationList());
                if (info != Unspecified.UNKNOWN) {
                    NlsInfo nlsInfo = info;
                    if (nlsInfo == null) {
                        NlsInfo.$$$reportNull$$$0(54);
                    }
                    return nlsInfo;
                }
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aPackage, ANNOTATION_NAMES, (boolean)false);
                if (annotation != null) {
                    return NlsInfo.fromAnnotation(annotation);
                }
            }
        }
        Unspecified unspecified = Unspecified.UNKNOWN;
        if (unspecified == null) {
            NlsInfo.$$$reportNull$$$0(55);
        }
        return unspecified;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nls";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/NlsInfo";
                break;
            }
            case 4: 
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 8: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 39: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/NlsInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNlsStatus";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "localized";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "nonLocalized";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapitalization";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "fromAnnotationContext";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "fromType";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "goUp";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "fromUVariable";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "fromAnnotationOwner";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "computeFromAnnotationOwner";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMetaAnnotation";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "fromAnnotationInfo";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "fromContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forModifierListOwner";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCapitalization";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "goUp";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "fromUVariable";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "computeFromAnnotationOwner";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "fromMetaAnnotation";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "fromAnnotation";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "fromContainer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Unspecified
    extends NlsInfo {
        private static final Unspecified UNKNOWN = new Unspecified(null);
        @Nullable
        private final PsiModifierListOwner myCandidate;

        private Unspecified(@Nullable PsiModifierListOwner candidate) {
            super(ThreeState.UNSURE);
            this.myCandidate = candidate;
        }

        @Nullable
        public PsiModifierListOwner getAnnotationCandidate() {
            return this.myCandidate;
        }
    }

    public static final class NonLocalized
    extends NlsInfo {
        private static final NonLocalized INSTANCE = new NonLocalized();

        private NonLocalized() {
            super(ThreeState.NO);
        }
    }

    public static final class NlsSafe
    extends NlsInfo {
        private static final NlsSafe INSTANCE = new NlsSafe();

        private NlsSafe() {
            super(ThreeState.NO);
        }
    }

    public static final class Localized
    extends NlsInfo {
        private static final Localized NLS = new Localized(Nls.Capitalization.NotSpecified, "", "", null);
        private static final Localized NLS_TITLE = new Localized(Nls.Capitalization.Title, "", "", null);
        private static final Localized NLS_SENTENCE = new Localized(Nls.Capitalization.Sentence, "", "", null);
        @NotNull
        private final Nls.Capitalization myCapitalization;
        @NotNull
        @NonNls
        private final String myPrefix;
        @NotNull
        @NonNls
        private final String mySuffix;
        private final String myAnnotationName;

        private Localized(@NotNull Nls.Capitalization capitalization, @NotNull @NonNls String prefix, @NotNull @NonNls String suffix, @Nullable @NonNls String annotationName) {
            if (capitalization == null) {
                Localized.$$$reportNull$$$0(0);
            }
            if (prefix == null) {
                Localized.$$$reportNull$$$0(1);
            }
            if (suffix == null) {
                Localized.$$$reportNull$$$0(2);
            }
            super(ThreeState.YES);
            this.myCapitalization = capitalization;
            this.myPrefix = prefix;
            this.mySuffix = suffix;
            this.myAnnotationName = annotationName;
        }

        @NotNull
        public Nls.Capitalization getCapitalization() {
            Nls.Capitalization capitalization = this.myCapitalization;
            if (capitalization == null) {
                Localized.$$$reportNull$$$0(3);
            }
            return capitalization;
        }

        @NotNull
        public String suggestAnnotation(PsiElement context) {
            if (this.myAnnotationName != null && JavaPsiFacade.getInstance((Project)context.getProject()).findClass(this.myAnnotationName, context.getResolveScope()) != null) {
                String string = this.myAnnotationName;
                if (string == null) {
                    Localized.$$$reportNull$$$0(4);
                }
                return string;
            }
            return "org.jetbrains.annotations.Nls";
        }

        @NotNull
        @NonNls
        public String getPrefix() {
            String string = this.myPrefix;
            if (string == null) {
                Localized.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        @NonNls
        public String getSuffix() {
            String string = this.mySuffix;
            if (string == null) {
                Localized.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        private Localized withPrefixAndSuffix(@NotNull String prefix, @NotNull String suffix) {
            if (prefix == null) {
                Localized.$$$reportNull$$$0(7);
            }
            if (suffix == null) {
                Localized.$$$reportNull$$$0(8);
            }
            if (prefix.equals(this.myPrefix) && suffix.equals(this.mySuffix)) {
                Localized localized = this;
                if (localized == null) {
                    Localized.$$$reportNull$$$0(9);
                }
                return localized;
            }
            return new Localized(this.myCapitalization, prefix, suffix, this.myAnnotationName);
        }

        @NotNull
        private Localized withAnnotation(@NotNull UAnnotation annotation) {
            String qualifiedName;
            if (annotation == null) {
                Localized.$$$reportNull$$$0(10);
            }
            if (Objects.equals(qualifiedName = annotation.getQualifiedName(), this.myAnnotationName)) {
                Localized localized = this;
                if (localized == null) {
                    Localized.$$$reportNull$$$0(11);
                }
                return localized;
            }
            return new Localized(this.myCapitalization, this.myPrefix, this.mySuffix, qualifiedName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "capitalization";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suffix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/i18n/NlsInfo$Localized";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/i18n/NlsInfo$Localized";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCapitalization";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestAnnotation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuffix";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPrefixAndSuffix";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withAnnotation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 11: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "withPrefixAndSuffix";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "withAnnotation";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

