/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.incremental.artifacts.ArtifactBasedBuildTarget;
import org.jetbrains.jps.incremental.artifacts.JpsBuilderArtifactService;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;

public abstract class ArtifactBasedBuildTargetType<T extends ArtifactBasedBuildTarget>
extends BuildTargetType<T> {
    protected ArtifactBasedBuildTargetType(String typeId, boolean fileBased) {
        super(typeId, fileBased);
    }

    @Override
    @NotNull
    public List<T> computeAllTargets(@NotNull JpsModel model) {
        if (model == null) {
            ArtifactBasedBuildTargetType.$$$reportNull$$$0(0);
        }
        Collection<JpsArtifact> artifacts = JpsBuilderArtifactService.getInstance().getArtifacts(model, true);
        ArrayList<T> targets = new ArrayList<T>(artifacts.size());
        for (JpsArtifact artifact : artifacts) {
            if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
            targets.add(this.createArtifactBasedTarget(artifact));
        }
        ArrayList<T> arrayList = targets;
        if (arrayList == null) {
            ArtifactBasedBuildTargetType.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public BuildTargetLoader<T> createLoader(@NotNull JpsModel model) {
        if (model == null) {
            ArtifactBasedBuildTargetType.$$$reportNull$$$0(2);
        }
        return new Loader(model);
    }

    protected abstract T createArtifactBasedTarget(JpsArtifact var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/artifacts/ArtifactBasedBuildTargetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/artifacts/ArtifactBasedBuildTargetType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAllTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeAllTargets";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLoader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Loader
    extends BuildTargetLoader<T> {
        private final Map<String, JpsArtifact> myArtifacts = new HashMap<String, JpsArtifact>();

        Loader(JpsModel model) {
            for (JpsArtifact artifact : JpsBuilderArtifactService.getInstance().getArtifacts(model, true)) {
                this.myArtifacts.put(artifact.getName(), artifact);
            }
        }

        @Override
        @Nullable
        public T createTarget(@NotNull String targetId) {
            JpsArtifact artifact;
            if (targetId == null) {
                Loader.$$$reportNull$$$0(0);
            }
            return (artifact = this.myArtifacts.get(targetId)) != null ? (Object)ArtifactBasedBuildTargetType.this.createArtifactBasedTarget(artifact) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "org/jetbrains/jps/incremental/artifacts/ArtifactBasedBuildTargetType$Loader", "createTarget"));
        }
    }
}

