/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectObjectProcedure;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.dependencyView.AnnotationsChangeTracker;
import org.jetbrains.jps.builders.java.dependencyView.BuilderCollectionFactory;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.java.dependencyView.ClassFileRepr;
import org.jetbrains.jps.builders.java.dependencyView.ClassFileReprExternalizer;
import org.jetbrains.jps.builders.java.dependencyView.ClassRepr;
import org.jetbrains.jps.builders.java.dependencyView.ClassfileAnalyzer;
import org.jetbrains.jps.builders.java.dependencyView.CloseableMaplet;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Difference;
import org.jetbrains.jps.builders.java.dependencyView.ElemType;
import org.jetbrains.jps.builders.java.dependencyView.FieldRepr;
import org.jetbrains.jps.builders.java.dependencyView.IntIntMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntIntPersistentMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntIntTransientMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntObjectMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntObjectPersistentMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntObjectTransientMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.LoggerWrapper;
import org.jetbrains.jps.builders.java.dependencyView.MethodRepr;
import org.jetbrains.jps.builders.java.dependencyView.ModulePackageRepr;
import org.jetbrains.jps.builders.java.dependencyView.ModuleRepr;
import org.jetbrains.jps.builders.java.dependencyView.ModuleRequiresRepr;
import org.jetbrains.jps.builders.java.dependencyView.ObjectObjectMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.ObjectObjectPersistentMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.ObjectObjectTransientMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.Proto;
import org.jetbrains.jps.builders.java.dependencyView.ProtoMember;
import org.jetbrains.jps.builders.java.dependencyView.Streamable;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;
import org.jetbrains.jps.builders.java.dependencyView.UsageConstraint;
import org.jetbrains.jps.builders.java.dependencyView.UsageRepr;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.PathStringDescriptor;
import org.jetbrains.jps.javac.Iterators;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.org.objectweb.asm.ClassReader;

public class Mappings {
    private static final Logger LOG = Logger.getInstance(Mappings.class);
    public static final String PROCESS_CONSTANTS_NON_INCREMENTAL_PROPERTY = "compiler.process.constants.non.incremental";
    private boolean myProcessConstantsIncrementally = Boolean.valueOf(System.getProperty("compiler.process.constants.non.incremental", "false")) == false;
    private static final String CLASS_TO_SUBCLASSES = "classToSubclasses.tab";
    private static final String CLASS_TO_CLASS = "classToClass.tab";
    private static final String SHORT_NAMES = "shortNames.tab";
    private static final String SOURCE_TO_CLASS = "sourceToClass.tab";
    private static final String CLASS_TO_SOURCE = "classToSource.tab";
    private static final int DEFAULT_SET_CAPACITY = 32;
    private static final float DEFAULT_SET_LOAD_FACTOR = 0.98f;
    private static final String IMPORT_WILDCARD_SUFFIX = ".*";
    private final boolean myIsDelta;
    private boolean myIsDifferentiated = false;
    private boolean myIsRebuild = false;
    private final TIntHashSet myChangedClasses;
    private final Set<File> myChangedFiles;
    private final Set<Pair<ClassFileRepr, File>> myDeletedClasses;
    private final Set<ClassRepr> myAddedClasses;
    private final Object myLock;
    private final File myRootDir;
    private DependencyContext myContext;
    private final int myInitName;
    private final int myEmptyName;
    private final int myObjectClassName;
    private LoggerWrapper<Integer> myDebugS;
    private IntIntMultiMaplet myClassToSubclasses;
    private IntIntMultiMaplet myClassToClassDependency;
    private ObjectObjectMultiMaplet<String, ClassFileRepr> myRelativeSourceFilePathToClasses;
    private IntObjectMultiMaplet<String> myClassToRelativeSourceFilePath;
    private IntIntMultiMaplet myShortClassNameIndex;
    private IntIntTransientMultiMaplet myRemovedSuperClasses;
    private IntIntTransientMultiMaplet myAddedSuperClasses;
    @Nullable
    private Collection<String> myRemovedFiles;
    private final PathRelativizerService myRelativizer;
    private final LinkedBlockingQueue<Runnable> myPostPasses = new LinkedBlockingQueue();
    private static final ClassRepr MOCK_CLASS = null;
    private static final MethodRepr MOCK_METHOD = null;

    public PathRelativizerService getRelativizer() {
        return this.myRelativizer;
    }

    private Mappings(Mappings base) throws IOException {
        this.myLock = base.myLock;
        this.myIsDelta = true;
        this.myChangedClasses = new TIntHashSet(32, 0.98f);
        this.myChangedFiles = FileCollectionFactory.createCanonicalFileSet();
        this.myDeletedClasses = new HashSet<Pair<ClassFileRepr, File>>(32, 0.98f);
        this.myAddedClasses = new HashSet<ClassRepr>(32, 0.98f);
        this.myRootDir = new File(FileUtil.toSystemIndependentName((String)base.myRootDir.getAbsolutePath()) + File.separatorChar + "myDelta");
        this.myContext = base.myContext;
        this.myInitName = this.myContext.get("<init>");
        this.myEmptyName = this.myContext.get("");
        this.myObjectClassName = this.myContext.get("java/lang/Object");
        this.myDebugS = base.myDebugS;
        this.myRelativizer = base.myRelativizer;
        this.createImplementation();
    }

    public Mappings(File rootDir, PathRelativizerService relativizer) throws IOException {
        this.myLock = new Object();
        this.myIsDelta = false;
        this.myChangedClasses = null;
        this.myChangedFiles = null;
        this.myDeletedClasses = null;
        this.myAddedClasses = null;
        this.myRootDir = rootDir;
        this.myRelativizer = relativizer;
        this.createImplementation();
        this.myInitName = this.myContext.get("<init>");
        this.myEmptyName = this.myContext.get("");
        this.myObjectClassName = this.myContext.get("java/lang/Object");
    }

    private void createImplementation() throws IOException {
        try {
            if (!this.myIsDelta) {
                this.myContext = new DependencyContext(this.myRootDir, this.myRelativizer);
                this.myDebugS = this.myContext.getLogger(LOG);
            }
            this.myRemovedSuperClasses = this.myIsDelta ? new IntIntTransientMultiMaplet() : null;
            this.myAddedSuperClasses = this.myIsDelta ? new IntIntTransientMultiMaplet() : null;
            BuilderCollectionFactory<String> fileCollectionFactory = new BuilderCollectionFactory<String>(){

                @Override
                public Collection<String> create() {
                    return new THashSet(FileUtil.PATH_HASHING_STRATEGY);
                }
            };
            if (this.myIsDelta) {
                this.myClassToSubclasses = new IntIntTransientMultiMaplet();
                this.myClassToClassDependency = new IntIntTransientMultiMaplet();
                this.myShortClassNameIndex = null;
                this.myRelativeSourceFilePathToClasses = new ObjectObjectTransientMultiMaplet(FileUtil.PATH_HASHING_STRATEGY, () -> new THashSet(5, 0.98f));
                this.myClassToRelativeSourceFilePath = new IntObjectTransientMultiMaplet<String>(fileCollectionFactory);
            } else {
                this.myClassToSubclasses = new IntIntPersistentMultiMaplet(DependencyContext.getTableFile(this.myRootDir, CLASS_TO_SUBCLASSES), (KeyDescriptor<Integer>)EnumeratorIntegerDescriptor.INSTANCE);
                this.myClassToClassDependency = new IntIntPersistentMultiMaplet(DependencyContext.getTableFile(this.myRootDir, CLASS_TO_CLASS), (KeyDescriptor<Integer>)EnumeratorIntegerDescriptor.INSTANCE);
                this.myShortClassNameIndex = new IntIntPersistentMultiMaplet(DependencyContext.getTableFile(this.myRootDir, SHORT_NAMES), (KeyDescriptor<Integer>)EnumeratorIntegerDescriptor.INSTANCE);
                this.myRelativeSourceFilePathToClasses = new ObjectObjectPersistentMultiMaplet<String, ClassFileRepr>(DependencyContext.getTableFile(this.myRootDir, SOURCE_TO_CLASS), (KeyDescriptor)PathStringDescriptor.INSTANCE, (DataExternalizer)new ClassFileReprExternalizer(this.myContext), () -> new THashSet(5, 0.98f)){

                    @Override
                    @NotNull
                    protected String debugString(String path) {
                        String string = SystemInfo.isFileSystemCaseSensitive ? path : path.toLowerCase(Locale.US);
                        if (string == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/Mappings$2", "debugString"));
                    }
                };
                this.myClassToRelativeSourceFilePath = new IntObjectPersistentMultiMaplet<String>(DependencyContext.getTableFile(this.myRootDir, CLASS_TO_SOURCE), (KeyDescriptor<Integer>)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer<String>)PathStringDescriptor.INSTANCE, fileCollectionFactory);
            }
        }
        catch (Throwable e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
    }

    public void setProcessConstantsIncrementally(boolean processInc) {
        this.myProcessConstantsIncrementally = processInc;
    }

    public String valueOf(int name) {
        return this.myContext.getValue(name);
    }

    public int getName(String string) {
        return this.myContext.get(string);
    }

    public Mappings createDelta() {
        Object object = this.myLock;
        synchronized (object) {
            try {
                return new Mappings(this);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }
    }

    private void compensateRemovedContent(@NotNull Collection<? extends File> compiled, @NotNull Collection<? extends File> compiledWithErrors) {
        if (compiled == null) {
            Mappings.$$$reportNull$$$0(0);
        }
        if (compiledWithErrors == null) {
            Mappings.$$$reportNull$$$0(1);
        }
        for (File file : compiled) {
            String relative;
            if (compiledWithErrors.contains(file) || this.myRelativeSourceFilePathToClasses.containsKey(relative = this.toRelative(file))) continue;
            this.myRelativeSourceFilePathToClasses.put(relative, new HashSet());
        }
    }

    @Nullable
    private ClassRepr getClassReprByName(@Nullable File source, int qName) {
        ClassFileRepr reprByName = this.getReprByName(source, qName);
        return reprByName instanceof ClassRepr ? (ClassRepr)reprByName : null;
    }

    @Nullable
    private ClassFileRepr getReprByName(@Nullable File source, int qName) {
        Iterable<File> sources;
        Iterable<File> iterable = sources = source != null ? Collections.singleton(source) : this.classToSourceFileGet(qName);
        if (sources != null) {
            for (File src : sources) {
                Collection<ClassFileRepr> reprs = this.sourceFileToClassesGet(src);
                if (reprs == null) continue;
                for (ClassFileRepr repr : reprs) {
                    if (repr.name != qName) continue;
                    return repr;
                }
            }
        }
        return null;
    }

    private Collection<ClassFileRepr> sourceFileToClassesGet(File unchangedSource) {
        return this.myRelativeSourceFilePathToClasses.get(this.toRelative(unchangedSource));
    }

    @NotNull
    private String toRelative(File file) {
        String string = this.myRelativizer.toRelative(file.getAbsolutePath());
        if (string == null) {
            Mappings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private Iterable<File> classToSourceFileGet(int qName) {
        Collection<String> get = this.myClassToRelativeSourceFilePath.get(qName);
        return get == null ? null : Iterators.map(get, s -> this.toFull((String)s));
    }

    @NotNull
    private File toFull(String relativePath) {
        return new File(this.myRelativizer.toFull(relativePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() throws IOException {
        if (this.myRootDir != null) {
            Object object = this.myLock;
            synchronized (object) {
                this.close();
                FileUtil.delete((File)this.myRootDir);
                this.createImplementation();
            }
        }
    }

    public IntIntTransientMultiMaplet getRemovedSuperClasses() {
        return this.myRemovedSuperClasses;
    }

    public IntIntTransientMultiMaplet getAddedSuperClasses() {
        return this.myAddedSuperClasses;
    }

    private void runPostPasses() {
        Set<Pair<ClassFileRepr, File>> deleted = this.myDeletedClasses;
        if (deleted != null) {
            for (Pair<ClassFileRepr, File> pair : deleted) {
                int deletedClassName = ((ClassFileRepr)pair.first).name;
                Iterable<File> sources = this.classToSourceFileGet(deletedClassName);
                if (sources != null && !Iterators.isEmpty(sources)) continue;
                this.myChangedClasses.remove(deletedClassName);
            }
        }
        Runnable pass = this.myPostPasses.poll();
        while (pass != null) {
            pass.run();
            pass = this.myPostPasses.poll();
        }
    }

    void affectAll(int className, @NotNull File sourceFile, Collection<? super File> affectedFiles, Collection<? extends File> alreadyCompiledFiles, @Nullable DependentFilesFilter filter) {
        TIntHashSet dependants;
        if (sourceFile == null) {
            Mappings.$$$reportNull$$$0(3);
        }
        if ((dependants = this.myClassToClassDependency.get(className)) != null) {
            dependants.forEach(depClass -> {
                Iterable<File> allSources = this.classToSourceFileGet(depClass);
                if (allSources == null || Iterators.isEmpty(allSources)) {
                    return true;
                }
                boolean shouldAffect = false;
                for (File depFile : allSources) {
                    if (FileUtil.filesEqual((File)depFile, (File)sourceFile) || alreadyCompiledFiles.contains(depFile) || filter != null && !filter.accept(depFile)) continue;
                    shouldAffect = true;
                    break;
                }
                if (shouldAffect) {
                    for (File depFile : allSources) {
                        if (FileUtil.filesEqual((File)depFile, (File)sourceFile)) continue;
                        affectedFiles.add(depFile);
                    }
                }
                return true;
            });
        }
    }

    private static boolean isVisibleIn(ClassRepr c, ProtoMember m, ClassRepr scope) {
        boolean privacy = m.isPrivate() && c.name != scope.name;
        boolean packageLocality = m.isPackageLocal() && !c.getPackageName().equals(scope.getPackageName());
        return !privacy && !packageLocality;
    }

    private boolean isEmpty(int s) {
        return s == this.myEmptyName;
    }

    @NotNull
    private TIntHashSet getAllSubclasses(int root) {
        TIntHashSet tIntHashSet = this.addAllSubclasses(root, new TIntHashSet(32, 0.98f));
        if (tIntHashSet == null) {
            Mappings.$$$reportNull$$$0(4);
        }
        return tIntHashSet;
    }

    private TIntHashSet addAllSubclasses(int root, TIntHashSet acc) {
        if (!acc.add(root)) {
            return acc;
        }
        TIntHashSet directSubclasses = this.myClassToSubclasses.get(root);
        if (directSubclasses != null) {
            directSubclasses.forEach(s -> {
                this.addAllSubclasses(s, acc);
                return true;
            });
        }
        return acc;
    }

    private boolean incrementalDecision(int owner, Proto member, Collection<? super File> affectedFiles, Collection<? extends File> currentlyCompiled, final @Nullable DependentFilesFilter filter) {
        boolean isField = member instanceof FieldRepr;
        Util self = new Util();
        if (member.isPublic()) {
            Mappings.debug("Public access, switching to a non-incremental mode");
            return false;
        }
        final Set toRecompile = FileCollectionFactory.createCanonicalFileSet();
        if (member.isProtected()) {
            Mappings.debug("Protected access, softening non-incremental decision: adding all relevant subclasses for a recompilation");
            this.debug("Root class: ", owner);
            TIntHashSet propagated = self.propagateFieldAccess(isField ? member.name : this.myEmptyName, owner);
            propagated.forEach(className -> {
                Iterable<File> fileNames = this.classToSourceFileGet(className);
                if (fileNames != null) {
                    if (this.myDebugS.isDebugEnabled()) {
                        for (File fileName : fileNames) {
                            this.debug("Adding ", fileName);
                        }
                    }
                    ContainerUtil.addAll((Collection)toRecompile, fileNames);
                }
                return true;
            });
        }
        final String packageName = ClassRepr.getPackageName(this.myContext.getValue(isField ? owner : member.name));
        Mappings.debug("Softening non-incremental decision: adding all package classes for a recompilation");
        this.debug("Package name: ", packageName);
        this.myClassToRelativeSourceFilePath.forEachEntry(new TIntObjectProcedure<Collection<String>>(){

            public boolean execute(int className, Collection<String> relFilePaths) {
                if (ClassRepr.getPackageName(Mappings.this.myContext.getValue(className)).equals(packageName)) {
                    for (String rel : relFilePaths) {
                        File file = Mappings.this.toFull(rel);
                        if (filter != null && !filter.accept(file)) continue;
                        Mappings.this.debug("Adding: ", rel);
                        toRecompile.add(file);
                    }
                }
                return true;
            }
        });
        toRecompile.removeAll(currentlyCompiled);
        Iterator it = toRecompile.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            if (file.exists()) continue;
            it.remove();
        }
        affectedFiles.addAll(toRecompile);
        return true;
    }

    public void differentiateOnRebuild(Mappings delta) {
        new Differential(delta).differentiate();
    }

    public void differentiateOnNonIncrementalMake(Mappings delta, Collection<String> removed, Collection<? extends File> filesToCompile) {
        new Differential(delta, removed, filesToCompile).differentiate();
    }

    public boolean differentiateOnIncrementalMake(Mappings delta, Collection<String> removed, Collection<? extends File> filesToCompile, Collection<? extends File> compiledWithErrors, Collection<? extends File> compiledFiles, Collection<? super File> affectedFiles, @NotNull DependentFilesFilter filter) {
        if (filter == null) {
            Mappings.$$$reportNull$$$0(5);
        }
        return new Differential(delta, removed, filesToCompile, compiledWithErrors, compiledFiles, affectedFiles, filter).differentiate();
    }

    private void cleanupBackDependency(int className, @Nullable Set<? extends UsageRepr.Usage> usages, IntIntMultiMaplet buffer) {
        ClassFileRepr repr;
        if (usages == null && (repr = this.getReprByName(null, className)) != null) {
            usages = repr.getUsages();
        }
        if (usages != null) {
            for (UsageRepr.Usage usage : usages) {
                buffer.put(usage.getOwner(), className);
            }
        }
    }

    private void cleanupRemovedClass(Mappings delta, @NotNull ClassFileRepr cr, File sourceFile, Set<? extends UsageRepr.Usage> usages, IntIntMultiMaplet dependenciesTrashBin) {
        ClassRepr _cr;
        int className;
        Iterable<File> _currentlyMapped;
        if (cr == null) {
            Mappings.$$$reportNull$$$0(6);
        }
        if ((_currentlyMapped = this.classToSourceFileGet(className = cr.name)) == null) {
            return;
        }
        List currentlyMapped = ContainerUtil.collect(_currentlyMapped.iterator());
        if (currentlyMapped.isEmpty()) {
            return;
        }
        if (currentlyMapped.size() == 1) {
            if (!FileUtil.filesEqual((File)sourceFile, (File)((File)currentlyMapped.iterator().next()))) {
                return;
            }
        } else {
            for (File file : currentlyMapped) {
                if (FileUtil.filesEqual((File)sourceFile, (File)file) || !file.exists()) continue;
                return;
            }
        }
        if (cr instanceof ClassRepr) {
            for (Object superSomething : (Object)((ClassRepr)cr).getSupers()) {
                delta.registerRemovedSuperClass(className, (int)superSomething);
            }
        }
        this.cleanupBackDependency(className, usages, dependenciesTrashBin);
        this.myClassToClassDependency.remove(className);
        this.myClassToSubclasses.remove(className);
        this.myClassToRelativeSourceFilePath.remove(className);
        if (cr instanceof ClassRepr && !(_cr = (ClassRepr)cr).isLocal() && !_cr.isAnonymous()) {
            this.myShortClassNameIndex.removeFrom(this.myContext.get(_cr.getShortName()), className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void integrate(Mappings delta) {
        Object object = this.myLock;
        synchronized (object) {
            try {
                assert (delta.isDifferentiated());
                Collection<String> removed = delta.myRemovedFiles;
                delta.runPostPasses();
                IntIntTransientMultiMaplet dependenciesTrashBin = new IntIntTransientMultiMaplet();
                if (removed != null) {
                    for (String string : removed) {
                        File deletedFile = new File(string);
                        Set fileClasses = (Set)this.sourceFileToClassesGet(deletedFile);
                        if (fileClasses == null) continue;
                        for (ClassFileRepr aClass2 : fileClasses) {
                            this.cleanupRemovedClass(delta, aClass2, deletedFile, aClass2.getUsages(), dependenciesTrashBin);
                        }
                        this.myRelativeSourceFilePathToClasses.remove(this.myRelativizer.toRelative(string));
                    }
                }
                if (!delta.isRebuild()) {
                    for (Pair pair : delta.getDeletedClasses()) {
                        ClassFileRepr deletedClass = (ClassFileRepr)pair.first;
                        this.cleanupRemovedClass(delta, deletedClass, (File)pair.second, deletedClass.getUsages(), dependenciesTrashBin);
                    }
                    for (ClassRepr classRepr : delta.getAddedClasses()) {
                        if (classRepr.isAnonymous() || classRepr.isLocal()) continue;
                        this.myShortClassNameIndex.put(this.myContext.get(classRepr.getShortName()), classRepr.name);
                    }
                    TIntHashSet superClasses = new TIntHashSet();
                    IntIntTransientMultiMaplet intIntTransientMultiMaplet = delta.getAddedSuperClasses();
                    IntIntTransientMultiMaplet removedSuperClasses = delta.getRemovedSuperClasses();
                    Mappings.addAllKeys(superClasses, intIntTransientMultiMaplet);
                    Mappings.addAllKeys(superClasses, removedSuperClasses);
                    superClasses.forEach(superClass -> {
                        TIntHashSet added = addedSuperClasses.get(superClass);
                        TIntHashSet removed12 = removedSuperClasses.get(superClass);
                        TIntHashSet old = this.myClassToSubclasses.get(superClass);
                        if (old == null) {
                            if (added != null && !added.isEmpty()) {
                                this.myClassToSubclasses.replace(superClass, added);
                            }
                        } else {
                            int[] addedAsArray;
                            boolean changed = false;
                            int[] nArray = addedAsArray = added != null && !added.isEmpty() ? added.toArray() : null;
                            if (removed12 != null && !removed12.isEmpty()) {
                                if (addedAsArray != null) {
                                    removed12 = (TIntHashSet)removed12.clone();
                                    removed12.removeAll(addedAsArray);
                                }
                                if (!removed12.isEmpty()) {
                                    changed = old.removeAll(removed12.toArray());
                                }
                            }
                            if (addedAsArray != null) {
                                changed |= old.addAll(addedAsArray);
                            }
                            if (changed) {
                                this.myClassToSubclasses.replace(superClass, old);
                            }
                        }
                        return true;
                    });
                    delta.getChangedClasses().forEach(className -> {
                        Collection<String> sourceFiles = delta.myClassToRelativeSourceFilePath.get(className);
                        this.myClassToRelativeSourceFilePath.replace(className, sourceFiles);
                        this.cleanupBackDependency(className, null, dependenciesTrashBin);
                        return true;
                    });
                    delta.getChangedFiles().forEach(fileName -> {
                        String relative = this.toRelative((File)fileName);
                        Collection<ClassFileRepr> classes = delta.myRelativeSourceFilePathToClasses.get(relative);
                        this.myRelativeSourceFilePathToClasses.replace(relative, classes);
                    });
                    final Set unchangedSources = FileCollectionFactory.createCanonicalFileSet();
                    delta.myRelativeSourceFilePathToClasses.forEachEntry(new TObjectObjectProcedure<String, Collection<ClassFileRepr>>(){

                        public boolean execute(String source, Collection<ClassFileRepr> b) {
                            unchangedSources.add(Mappings.this.toFull(source));
                            return true;
                        }
                    });
                    unchangedSources.removeAll(delta.getChangedFiles());
                    if (!unchangedSources.isEmpty()) {
                        unchangedSources.forEach(unchangedSource -> {
                            Collection<ClassFileRepr> updatedClasses = delta.sourceFileToClassesGet((File)unchangedSource);
                            if (updatedClasses != null && !updatedClasses.isEmpty()) {
                                ArrayList<ClassFileRepr> classesToPut = new ArrayList<ClassFileRepr>();
                                TIntHashSet updatedClassNames = new TIntHashSet();
                                for (ClassFileRepr aClass : updatedClasses) {
                                    if (!delta.getChangedClasses().contains(aClass.name)) continue;
                                    classesToPut.add(aClass);
                                    updatedClassNames.add(aClass.name);
                                }
                                Collection<ClassFileRepr> currentClasses = this.sourceFileToClassesGet((File)unchangedSource);
                                if (currentClasses != null) {
                                    for (ClassFileRepr aClass : currentClasses) {
                                        if (updatedClassNames.contains(aClass.name)) continue;
                                        classesToPut.add(aClass);
                                    }
                                }
                                this.myRelativeSourceFilePathToClasses.replace(this.toRelative((File)unchangedSource), classesToPut);
                            }
                        });
                    }
                } else {
                    this.myClassToSubclasses.putAll(delta.myClassToSubclasses);
                    this.myClassToRelativeSourceFilePath.replaceAll(delta.myClassToRelativeSourceFilePath);
                    this.myRelativeSourceFilePathToClasses.replaceAll(delta.myRelativeSourceFilePathToClasses);
                    delta.myRelativeSourceFilePathToClasses.forEachEntry(new TObjectObjectProcedure<String, Collection<ClassFileRepr>>(){

                        public boolean execute(String src, Collection<ClassFileRepr> classes) {
                            for (ClassFileRepr repr : classes) {
                                ClassRepr clsRepr;
                                if (!(repr instanceof ClassRepr) || (clsRepr = (ClassRepr)repr).isAnonymous() || clsRepr.isLocal()) continue;
                                Mappings.this.myShortClassNameIndex.put(Mappings.this.myContext.get(clsRepr.getShortName()), repr.name);
                            }
                            return true;
                        }
                    });
                }
                TIntHashSet affectedClasses = new TIntHashSet();
                Mappings.addAllKeys(affectedClasses, dependenciesTrashBin);
                Mappings.addAllKeys(affectedClasses, delta.myClassToClassDependency);
                affectedClasses.forEach(aClass -> {
                    boolean hasDataToAdd;
                    TIntHashSet now = delta.myClassToClassDependency.get(aClass);
                    TIntHashSet toRemove = dependenciesTrashBin.get(aClass);
                    boolean bl = hasDataToAdd = now != null && !now.isEmpty();
                    if (toRemove != null && !toRemove.isEmpty()) {
                        TIntHashSet current = this.myClassToClassDependency.get(aClass);
                        if (current != null && !current.isEmpty()) {
                            boolean added;
                            TIntHashSet before = new TIntHashSet();
                            Mappings.addAll(before, current);
                            boolean removed1 = current.removeAll(toRemove.toArray());
                            boolean bl2 = added = hasDataToAdd && current.addAll(now.toArray());
                            if (removed1 && !added || !removed1 && added || !before.equals((Object)current)) {
                                this.myClassToClassDependency.replace(aClass, current);
                            }
                        } else if (hasDataToAdd) {
                            this.myClassToClassDependency.put(aClass, now);
                        }
                    } else if (hasDataToAdd) {
                        this.myClassToClassDependency.put(aClass, now);
                    }
                    return true;
                });
            }
            finally {
                delta.close();
            }
        }
    }

    public Callbacks.Backend getCallback() {
        return new Callbacks.Backend(){
            private final Map<String, Pair<Collection<String>, Collection<String>>> myImportRefs = Collections.synchronizedMap(new HashMap());
            private final Map<String, Collection<Callbacks.ConstantRef>> myConstantRefs = Collections.synchronizedMap(new HashMap());

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void associate(String classFileName, Collection<String> sources, ClassReader cr, boolean isGenerated) {
                Object object = Mappings.this.myLock;
                synchronized (object) {
                    int classFileNameS = Mappings.this.myContext.get(classFileName);
                    ClassFileRepr result = new ClassfileAnalyzer(Mappings.this.myContext).analyze(classFileNameS, cr, isGenerated);
                    if (result != null) {
                        int className = result.name;
                        if (result instanceof ClassRepr) {
                            Pair<Collection<String>, Collection<String>> imports;
                            ClassRepr classRepr = (ClassRepr)result;
                            String classNameStr = Mappings.this.myContext.getValue(className);
                            if (this.addConstantUsages(classRepr, this.myConstantRefs.remove(classNameStr))) {
                                classRepr.setHasInlinedConstants(true);
                            }
                            if ((imports = this.myImportRefs.remove(classNameStr)) != null) {
                                this.addImportUsages(classRepr, (Collection)imports.getFirst(), (Collection)imports.getSecond());
                            }
                        }
                        for (String sourceFileName : sources) {
                            String relative = Mappings.this.myRelativizer.toRelative(sourceFileName);
                            Mappings.this.myClassToRelativeSourceFilePath.put(className, relative);
                            Mappings.this.myRelativeSourceFilePathToClasses.put(relative, result);
                        }
                        if (result instanceof ClassRepr) {
                            for (Iterator<UsageRepr.Usage> s : (Iterator<UsageRepr.Usage>)((ClassRepr)result).getSupers()) {
                                Mappings.this.myClassToSubclasses.put((int)s, className);
                            }
                        }
                        for (UsageRepr.Usage u : result.getUsages()) {
                            int owner = u.getOwner();
                            if (owner == className) continue;
                            Mappings.this.myClassToClassDependency.put(owner, className);
                        }
                    }
                }
            }

            @Override
            public void registerImports(String className, Collection<String> classImports, Collection<String> staticImports) {
                String key = className.replace('.', '/');
                if (!classImports.isEmpty() || !staticImports.isEmpty()) {
                    this.myImportRefs.put(key, (Pair<Collection<String>, Collection<String>>)Pair.create(classImports, staticImports));
                } else {
                    this.myImportRefs.remove(key);
                }
            }

            @Override
            public void registerConstantReferences(String className, Collection<Callbacks.ConstantRef> cRefs) {
                String key = className.replace('.', '/');
                if (!cRefs.isEmpty()) {
                    this.myConstantRefs.put(key, cRefs);
                } else {
                    this.myConstantRefs.remove(key);
                }
            }

            private void addImportUsages(ClassRepr repr, Collection<String> classImports, Collection<String> staticImports) {
                for (String anImport : classImports) {
                    if (anImport.endsWith(Mappings.IMPORT_WILDCARD_SUFFIX)) continue;
                    repr.addUsage(UsageRepr.createClassUsage(Mappings.this.myContext, Mappings.this.myContext.get(anImport.replace('.', '/'))));
                }
                for (String anImport : staticImports) {
                    if (anImport.endsWith(Mappings.IMPORT_WILDCARD_SUFFIX)) {
                        int iname = Mappings.this.myContext.get(anImport.substring(0, anImport.length() - Mappings.IMPORT_WILDCARD_SUFFIX.length()).replace('.', '/'));
                        repr.addUsage(UsageRepr.createClassUsage(Mappings.this.myContext, iname));
                        repr.addUsage(UsageRepr.createImportStaticOnDemandUsage(Mappings.this.myContext, iname));
                        continue;
                    }
                    int i = anImport.lastIndexOf(46);
                    if (i <= 0 || i >= anImport.length() - 1) continue;
                    int iname = Mappings.this.myContext.get(anImport.substring(0, i).replace('.', '/'));
                    int memberName = Mappings.this.myContext.get(anImport.substring(i + 1));
                    repr.addUsage(UsageRepr.createClassUsage(Mappings.this.myContext, iname));
                    repr.addUsage(UsageRepr.createImportStaticMemberUsage(Mappings.this.myContext, memberName, iname));
                }
            }

            private boolean addConstantUsages(ClassRepr repr, Collection<Callbacks.ConstantRef> cRefs) {
                boolean addedNewUsages = false;
                if (cRefs != null) {
                    for (Callbacks.ConstantRef ref : cRefs) {
                        int owner = Mappings.this.myContext.get(ref.getOwner().replace('.', '/'));
                        if (repr.name == owner) continue;
                        addedNewUsages |= repr.addUsage(UsageRepr.createFieldUsage(Mappings.this.myContext, Mappings.this.myContext.get(ref.getName()), owner, Mappings.this.myContext.get(ref.getDescriptor())));
                    }
                }
                return addedNewUsages;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Set<ClassRepr> getClasses(String sourceFileName) {
        File f = new File(sourceFileName);
        Object object = this.myLock;
        synchronized (object) {
            Collection<ClassFileRepr> reprs = this.sourceFileToClassesGet(f);
            if (reprs == null || reprs.isEmpty()) {
                return null;
            }
            THashSet result = new THashSet();
            for (ClassFileRepr repr : reprs) {
                if (!(repr instanceof ClassRepr)) continue;
                result.add((ClassRepr)repr);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Collection<File> getClassSources(int className) {
        Object object = this.myLock;
        synchronized (object) {
            Iterable<File> files = this.classToSourceFileGet(className);
            return files == null ? Collections.emptyList() : ContainerUtil.collect(files.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        BuildDataCorruptedException error = null;
        Object object = this.myLock;
        synchronized (object) {
            DependencyContext context;
            for (CloseableMaplet maplet : Arrays.asList(this.myClassToSubclasses, this.myClassToClassDependency, this.myRelativeSourceFilePathToClasses, this.myClassToRelativeSourceFilePath, this.myShortClassNameIndex)) {
                if (maplet == null) continue;
                try {
                    maplet.close();
                }
                catch (BuildDataCorruptedException ex) {
                    if (error != null) continue;
                    error = ex;
                }
            }
            if (!this.myIsDelta && (context = this.myContext) != null) {
                block10: {
                    try {
                        context.close();
                    }
                    catch (BuildDataCorruptedException ex) {
                        if (error != null) break block10;
                        error = ex;
                    }
                }
                this.myContext = null;
            }
        }
        if (error != null) {
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean memoryCachesOnly) {
        Object object = this.myLock;
        synchronized (object) {
            this.myClassToSubclasses.flush(memoryCachesOnly);
            this.myClassToClassDependency.flush(memoryCachesOnly);
            this.myRelativeSourceFilePathToClasses.flush(memoryCachesOnly);
            this.myClassToRelativeSourceFilePath.flush(memoryCachesOnly);
            if (!this.myIsDelta) {
                this.myShortClassNameIndex.flush(memoryCachesOnly);
                DependencyContext context = this.myContext;
                if (context != null) {
                    context.clearMemoryCaches();
                    if (!memoryCachesOnly) {
                        context.flush();
                    }
                }
            }
        }
    }

    private static boolean addAll(TIntHashSet whereToAdd, TIntHashSet whatToAdd) {
        if (whatToAdd.isEmpty()) {
            return false;
        }
        Ref changed = new Ref((Object)Boolean.FALSE);
        whatToAdd.forEach(value -> {
            if (whereToAdd.add(value)) {
                changed.set((Object)Boolean.TRUE);
            }
            return true;
        });
        return (Boolean)changed.get();
    }

    private static void addAllKeys(final TIntHashSet whereToAdd, IntIntMultiMaplet maplet) {
        maplet.forEachEntry(new TIntObjectProcedure<TIntHashSet>(){

            public boolean execute(int key, TIntHashSet b) {
                whereToAdd.add(key);
                return true;
            }
        });
    }

    private void registerAddedSuperClass(int aClass, int superClass) {
        assert (this.myAddedSuperClasses != null);
        this.myAddedSuperClasses.put(superClass, aClass);
    }

    private void registerRemovedSuperClass(int aClass, int superClass) {
        assert (this.myRemovedSuperClasses != null);
        this.myRemovedSuperClasses.put(superClass, aClass);
    }

    private boolean isDifferentiated() {
        return this.myIsDifferentiated;
    }

    private boolean isRebuild() {
        return this.myIsRebuild;
    }

    private void addDeletedClass(ClassFileRepr cr, File fileName) {
        assert (this.myDeletedClasses != null);
        this.myDeletedClasses.add((Pair<ClassFileRepr, File>)Pair.create((Object)cr, (Object)fileName));
        this.addChangedClass(cr.name);
    }

    private void addAddedClass(ClassRepr cr) {
        assert (this.myAddedClasses != null);
        this.myAddedClasses.add(cr);
        this.addChangedClass(cr.name);
    }

    private void addChangedClass(int it) {
        assert (this.myChangedClasses != null && this.myChangedFiles != null);
        this.myChangedClasses.add(it);
        Iterable<File> files = this.classToSourceFileGet(it);
        if (files != null) {
            ContainerUtil.addAll(this.myChangedFiles, files);
        }
    }

    @NotNull
    private Set<Pair<ClassFileRepr, File>> getDeletedClasses() {
        Set<Pair<ClassFileRepr, File>> set = this.myDeletedClasses == null ? Collections.emptySet() : Collections.unmodifiableSet(this.myDeletedClasses);
        if (set == null) {
            Mappings.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    private Set<ClassRepr> getAddedClasses() {
        Set<ClassRepr> set = this.myAddedClasses == null ? Collections.emptySet() : Collections.unmodifiableSet(this.myAddedClasses);
        if (set == null) {
            Mappings.$$$reportNull$$$0(8);
        }
        return set;
    }

    private TIntHashSet getChangedClasses() {
        return this.myChangedClasses;
    }

    private Set<File> getChangedFiles() {
        return this.myChangedFiles;
    }

    private static void debug(String s) {
        LOG.debug(s);
    }

    private void debug(String comment, int s) {
        this.myDebugS.debug(comment, s);
    }

    private void debug(String comment, File f) {
        this.debug(comment, f.getPath());
    }

    private void debug(String comment, String s) {
        this.myDebugS.debug(comment, s);
    }

    private void debug(String comment, boolean s) {
        this.myDebugS.debug(comment, s);
    }

    public void toStream(PrintStream stream) {
        Streamable[] data = new Streamable[]{this.myClassToSubclasses, this.myClassToClassDependency, this.myRelativeSourceFilePathToClasses, this.myClassToRelativeSourceFilePath};
        String[] info = new String[]{"ClassToSubclasses", "ClassToClassDependency", "SourceFileToClasses", "ClassToSourceFile", "SourceFileToAnnotationUsages", "SourceFileToUsages"};
        for (int i = 0; i < data.length; ++i) {
            stream.print("Begin Of ");
            stream.println(info[i]);
            data[i].toStream(this.myContext, stream);
            stream.print("End Of ");
            stream.println(info[i]);
        }
    }

    private static <T> boolean containsAll(Collection<? extends T> collection, Iterable<? extends T> it) {
        for (T file : it) {
            if (collection.contains(file)) continue;
            return false;
        }
        return true;
    }

    private static <T> void removeAll(Collection<? extends T> collection, Iterable<? extends T> it) {
        for (T file : it) {
            collection.remove(file);
        }
    }

    private static <T> Supplier<T> lazy(final Supplier<T> calculation) {
        return new Supplier<T>(){
            Ref<T> calculated;

            @Override
            public T get() {
                return (this.calculated != null ? this.calculated : (this.calculated = new Ref(calculation.get()))).get();
            }
        };
    }

    public void toStream(File outputRoot) {
        Streamable[] data = new Streamable[]{this.myClassToSubclasses, this.myClassToClassDependency, this.myRelativeSourceFilePathToClasses, this.myClassToRelativeSourceFilePath, this.myShortClassNameIndex};
        String[] info = new String[]{"ClassToSubclasses", "ClassToClassDependency", "SourceFileToClasses", "ClassToSourceFile", "ShortClassNameIndex"};
        for (int i = 0; i < data.length; ++i) {
            File file = new File(outputRoot, info[i]);
            FileUtil.createIfDoesntExist((File)file);
            try (PrintStream stream = new PrintStream(file);){
                data[i].toStream(this.myContext, stream);
                continue;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    static /* synthetic */ boolean access$4402(Mappings x0, boolean x1) {
        x0.myIsDifferentiated = x1;
        return x0.myIsDifferentiated;
    }

    static /* synthetic */ boolean access$1900(Mappings x0) {
        return x0.myIsRebuild;
    }

    static /* synthetic */ Set access$4600(Mappings x0) {
        return x0.getAddedClasses();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiled";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiledWithErrors";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/builders/java/dependencyView/Mappings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/Mappings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toRelative";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSubclasses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeletedClasses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddedClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compensateRemovedContent";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "affectAll";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "differentiateOnIncrementalMake";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cleanupRemovedClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class Differential {
        private static final int INLINABLE_FIELD_MODIFIERS_MASK = 16;
        final Mappings myDelta;
        final Collection<? extends File> myFilesToCompile;
        final Collection<? extends File> myCompiledFiles;
        final Collection<? extends File> myCompiledWithErrors;
        final Collection<? super File> myAffectedFiles;
        @Nullable
        final DependentFilesFilter myFilter;
        final Util myFuture;
        final Util myPresent;
        final boolean myEasyMode;
        private final Iterable<AnnotationsChangeTracker> myAnnotationChangeTracker;

        private Differential(Mappings delta) {
            this.myAnnotationChangeTracker = JpsServiceManager.getInstance().getExtensions(AnnotationsChangeTracker.class);
            this.myDelta = delta;
            this.myFilesToCompile = null;
            this.myCompiledFiles = null;
            this.myCompiledWithErrors = null;
            this.myAffectedFiles = null;
            this.myFilter = null;
            this.myFuture = null;
            this.myPresent = null;
            this.myEasyMode = true;
            delta.myIsRebuild = true;
        }

        private Differential(Mappings delta, Collection<String> removed, Collection<? extends File> filesToCompile) {
            this.myAnnotationChangeTracker = JpsServiceManager.getInstance().getExtensions(AnnotationsChangeTracker.class);
            delta.myRemovedFiles = removed;
            this.myDelta = delta;
            this.myFilesToCompile = filesToCompile;
            this.myCompiledFiles = null;
            this.myCompiledWithErrors = null;
            this.myAffectedFiles = null;
            this.myFilter = null;
            this.myFuture = new Util(delta);
            this.myPresent = new Util();
            this.myEasyMode = true;
        }

        private Differential(Mappings delta, Collection<String> removed, Collection<? extends File> filesToCompile, Collection<? extends File> compiledWithErrors, Collection<? extends File> compiledFiles, @NotNull Collection<? super File> affectedFiles, DependentFilesFilter filter) {
            if (filter == null) {
                Differential.$$$reportNull$$$0(0);
            }
            this.myAnnotationChangeTracker = JpsServiceManager.getInstance().getExtensions(AnnotationsChangeTracker.class);
            delta.myRemovedFiles = removed;
            this.myDelta = delta;
            this.myFilesToCompile = filesToCompile;
            this.myCompiledFiles = compiledFiles;
            this.myCompiledWithErrors = compiledWithErrors;
            this.myAffectedFiles = affectedFiles;
            this.myFilter = filter;
            this.myFuture = new Util(delta);
            this.myPresent = new Util();
            this.myEasyMode = false;
        }

        private void processDisappearedClasses() {
            Collection removed;
            if (this.myFilesToCompile != null) {
                this.myDelta.compensateRemovedContent(this.myFilesToCompile, this.myCompiledWithErrors != null ? this.myCompiledWithErrors : Collections.emptySet());
            }
            if (!this.myEasyMode && (removed = this.myDelta.myRemovedFiles) != null) {
                for (String file : removed) {
                    File sourceFile = new File(file);
                    Collection classes = Mappings.this.sourceFileToClassesGet(sourceFile);
                    if (classes == null) continue;
                    for (ClassFileRepr c : classes) {
                        Mappings.this.debug("Affecting usages of removed class ", c.name);
                        Mappings.this.affectAll(c.name, sourceFile, this.myAffectedFiles, this.myCompiledFiles, this.myFilter);
                    }
                }
            }
        }

        private void processAddedMethods(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<MethodRepr> added = diff.methods().added();
            if (added.isEmpty()) {
                return;
            }
            Mappings.debug("Processing added methods: ");
            if (it.isAnnotation()) {
                Mappings.debug("Class is annotation, skipping method analysis");
                return;
            }
            assert (this.myFuture != null);
            assert (this.myPresent != null);
            assert (this.myAffectedFiles != null);
            Supplier oldClassRepr = Mappings.lazy(() -> Mappings.this.getClassReprByName(null, it.name));
            for (MethodRepr m : added) {
                ClassRepr oldRepr;
                Mappings.this.debug("Method: ", m.name);
                if (!m.isPrivate() && (it.isInterface() || it.isAbstract() || m.isAbstract())) {
                    Mappings.debug("Class is abstract, or is interface, or added non-private method is abstract => affecting all subclasses");
                    this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles, null);
                }
                Supplier propagated = Mappings.lazy(() -> this.myFuture.propagateMethodAccess(m, it.name));
                if (!(m.isPrivate() || (oldRepr = (ClassRepr)oldClassRepr.get()) != null && this.myPresent.hasOverriddenMethods(oldRepr, MethodRepr.equalByJavaRules(m), null) || m.myArgumentTypes.length <= 0)) {
                    Mappings.debug("Conservative case on overriding methods, affecting method usages");
                    this.myFuture.affectMethodUsages(m, m.name == Mappings.this.myInitName ? null : (TIntHashSet)propagated.get(), m.createMetaUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                }
                if (m.isPrivate()) continue;
                if (m.isStatic()) {
                    this.myFuture.affectStaticMemberOnDemandUsages(it.name, (TIntHashSet)propagated.get(), state.myAffectedUsages, state.myDependants);
                }
                Collection<MethodRepr> lessSpecific = it.findMethods(this.myFuture.lessSpecific(m));
                Collection<MethodRepr> removed = diff.methods().removed();
                for (MethodRepr mm : lessSpecific) {
                    if (mm.equals(m) || removed.contains(mm)) continue;
                    Mappings.debug("Found less specific method, affecting method usages");
                    this.myFuture.affectMethodUsages(mm, (TIntHashSet)propagated.get(), mm.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                }
                Mappings.debug("Processing affected by specificity methods");
                Collection affectedMethods = this.myFuture.findAllMethodsBySpecificity(m, it);
                MethodRepr.Predicate overrides = MethodRepr.equalByJavaRules(m);
                for (Pair pair : affectedMethods) {
                    MethodRepr method = (MethodRepr)pair.first;
                    ClassRepr methodClass = (ClassRepr)pair.second;
                    if (methodClass == MOCK_CLASS) continue;
                    Boolean inheritorOf = this.myPresent.isInheritorOf(methodClass.name, it.name, null);
                    boolean isInheritor = inheritorOf != null && inheritorOf != false;
                    Mappings.this.debug("Method: ", method.name);
                    Mappings.this.debug("Class : ", methodClass.name);
                    if (overrides.satisfy(method) && isInheritor) {
                        Mappings.debug("Current method overrides that found");
                        Iterable files = Mappings.this.classToSourceFileGet(methodClass.name);
                        if (files == null) continue;
                        ContainerUtil.addAll(this.myAffectedFiles, (Iterable)files);
                        if (!Mappings.this.myDebugS.isDebugEnabled()) continue;
                        for (File file : files) {
                            Mappings.this.debug("Affecting file ", file);
                        }
                        continue;
                    }
                    Mappings.debug("Current method does not override that found");
                    TIntHashSet yetPropagated = this.myPresent.propagateMethodAccess(method, it.name);
                    if (isInheritor) {
                        this.myPresent.appendDependents(methodClass, state.myDependants);
                        this.myFuture.affectMethodUsages(method, yetPropagated, method.createUsage(Mappings.this.myContext, methodClass.name), state.myAffectedUsages, state.myDependants);
                    }
                    Mappings.debug("Affecting method usages for that found");
                    this.myFuture.affectMethodUsages(method, yetPropagated, method.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                }
                TIntHashSet subClasses = Mappings.this.getAllSubclasses(it.name);
                subClasses.forEach(subClass -> {
                    ClassRepr outerClassRepr;
                    int outerClass;
                    ClassRepr r = this.myFuture.classReprByName(subClass);
                    if (r == null) {
                        return true;
                    }
                    Iterable sourceFileNames = Mappings.this.classToSourceFileGet(subClass);
                    if (sourceFileNames != null && !Mappings.containsAll(this.myCompiledFiles, sourceFileNames) && !Mappings.this.isEmpty(outerClass = r.getOuterClassName()) && (outerClassRepr = this.myFuture.classReprByName(outerClass)) != null && (this.myFuture.isMethodVisible(outerClassRepr, m) || this.myFuture.extendsLibraryClass(outerClassRepr, null))) {
                        ContainerUtil.addAll(this.myAffectedFiles, (Iterable)sourceFileNames);
                        for (File sourceFileName : sourceFileNames) {
                            Mappings.this.debug("Affecting file due to local overriding: ", sourceFileName);
                        }
                    }
                    return true;
                });
            }
            Mappings.debug("End of added methods processing");
        }

        private void processRemovedMethods(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<MethodRepr> removed = diff.methods().removed();
            if (removed.isEmpty()) {
                return;
            }
            assert (this.myFuture != null);
            assert (this.myPresent != null);
            assert (this.myAffectedFiles != null);
            assert (this.myCompiledFiles != null);
            Mappings.debug("Processing removed methods:");
            for (MethodRepr m : removed) {
                Mappings.this.debug("Method ", m.name);
                Collection overriddenMethods = this.myFuture.findOverriddenMethods(m, it);
                Supplier propagated = Mappings.lazy(() -> this.myFuture.propagateMethodAccess(m, it.name));
                if (!m.isPrivate() && m.isStatic()) {
                    Mappings.debug("The method was static --- affecting static method import usages");
                    this.myFuture.affectStaticMemberImportUsages(m.name, it.name, (TIntHashSet)propagated.get(), state.myAffectedUsages, state.myDependants);
                }
                if (overriddenMethods.size() == 0) {
                    Mappings.debug("No overridden methods found, affecting method usages");
                    this.myFuture.affectMethodUsages(m, (TIntHashSet)propagated.get(), m.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                } else {
                    boolean clear = true;
                    for (Pair overriden : overriddenMethods) {
                        MethodRepr mm = (MethodRepr)overriden.first;
                        if (mm != MOCK_METHOD && mm.myType.equals(m.myType) && Mappings.this.isEmpty(mm.signature) && Mappings.this.isEmpty(m.signature) && !m.isMoreAccessibleThan(mm)) continue;
                        clear = false;
                        break;
                    }
                    if (!clear) {
                        Mappings.debug("No clearly overridden methods found, affecting method usages");
                        this.myFuture.affectMethodUsages(m, (TIntHashSet)propagated.get(), m.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                    }
                }
                HashSet overridingMethods = new HashSet();
                this.myFuture.addOverridingMethods(m, it, MethodRepr.equalByJavaRules(m), overridingMethods, null);
                for (Pair p2 : overridingMethods) {
                    Iterable fNames = Mappings.this.classToSourceFileGet(((ClassRepr)p2.second).name);
                    if (fNames == null) continue;
                    ContainerUtil.addAll(this.myAffectedFiles, (Iterable)fNames);
                    if (!Mappings.this.myDebugS.isDebugEnabled()) continue;
                    for (File fName : fNames) {
                        Mappings.this.debug("Affecting file by overriding: ", fName);
                    }
                }
                if (m.isAbstract() || m.isStatic()) continue;
                ((TIntHashSet)propagated.get()).forEach(p -> {
                    ClassRepr s;
                    if (p != it.name && (s = this.myFuture.classReprByName(p)) != null) {
                        Iterable sources;
                        Collection overridenInS = this.myFuture.findOverriddenMethods(m, s);
                        overridenInS.addAll(overriddenMethods);
                        boolean allAbstract = true;
                        boolean visited = false;
                        for (Pair pp : overridenInS) {
                            ClassRepr cc = (ClassRepr)pp.second;
                            if (cc == MOCK_CLASS) {
                                visited = true;
                                continue;
                            }
                            if (cc.name == it.name) continue;
                            visited = true;
                            allAbstract = ((MethodRepr)pp.first).isAbstract() || cc.isInterface();
                            if (allAbstract) continue;
                            break;
                        }
                        if (allAbstract && visited && (sources = Mappings.this.classToSourceFileGet(p)) != null && !Mappings.containsAll(this.myCompiledFiles, sources)) {
                            ContainerUtil.addAll(this.myAffectedFiles, (Iterable)sources);
                            Mappings.this.debug("Removed method is not abstract & overrides some abstract method which is not then over-overridden in subclass ", p);
                            for (File source : sources) {
                                Mappings.this.debug("Affecting subclass source file ", source);
                            }
                        }
                    }
                    return true;
                });
            }
            Mappings.debug("End of removed methods processing");
        }

        private void processChangedMethods(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<Pair<MethodRepr, MethodRepr.Diff>> changed = diff.methods().changed();
            if (changed.isEmpty()) {
                return;
            }
            Mappings.debug("Processing changed methods:");
            assert (this.myFuture != null);
            assert (this.myAffectedFiles != null);
            for (Pair<MethodRepr, MethodRepr.Diff> mr : changed) {
                MethodRepr m = (MethodRepr)mr.first;
                MethodRepr.Diff d = (MethodRepr.Diff)mr.second;
                boolean throwsChanged = !d.exceptions().unchanged();
                Mappings.this.debug("Method: ", m.name);
                if (it.isAnnotation()) {
                    if (!d.defaultRemoved()) continue;
                    Mappings.debug("Class is annotation, default value is removed => adding annotation query");
                    TIntHashSet l = new TIntHashSet(32, 0.98f);
                    l.add(m.name);
                    UsageRepr.AnnotationUsage annotationUsage = (UsageRepr.AnnotationUsage)UsageRepr.createAnnotationUsage(Mappings.this.myContext, TypeRepr.createClassType(Mappings.this.myContext, it.name), l, null);
                    state.myAnnotationQuery.add(annotationUsage);
                    continue;
                }
                if (d.base() == 0 && !throwsChanged) continue;
                Supplier propagated = Mappings.lazy(() -> this.myFuture.propagateMethodAccess(m, it.name));
                boolean affected = false;
                boolean constrained = false;
                THashSet usages = new THashSet();
                if (d.packageLocalOn()) {
                    Mappings.debug("Method became package-private, affecting method usages outside the package");
                    this.myFuture.affectMethodUsages(m, (TIntHashSet)propagated.get(), m.createUsage(Mappings.this.myContext, it.name), (Set<? super UsageRepr.Usage>)usages, state.myDependants);
                    for (Object usage : usages) {
                        Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                        Util util = this.myFuture;
                        Objects.requireNonNull(util);
                        map.put((UsageRepr.Usage)usage, util.new Util.PackageConstraint(it.getPackageName()));
                    }
                    state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                    affected = true;
                    constrained = true;
                }
                if ((d.base() & 2) != 0 || (d.base() & 8) != 0 || throwsChanged) {
                    if (!affected) {
                        Object usage;
                        Mappings.debug("Return type, throws list or signature changed --- affecting method usages");
                        this.myFuture.affectMethodUsages(m, (TIntHashSet)propagated.get(), m.createUsage(Mappings.this.myContext, it.name), (Set<? super UsageRepr.Usage>)usages, state.myDependants);
                        LinkedList overridingMethods = new LinkedList();
                        this.myFuture.addOverridingMethods(m, it, MethodRepr.equalByJavaRules(m), overridingMethods, null);
                        usage = overridingMethods.iterator();
                        while (usage.hasNext()) {
                            Iterable fileNames;
                            Pair p = (Pair)usage.next();
                            ClassRepr aClass = (ClassRepr)p.getSecond();
                            if (aClass == MOCK_CLASS || (fileNames = Mappings.this.classToSourceFileGet(aClass.name)) == null) continue;
                            ContainerUtil.addAll(this.myAffectedFiles, (Iterable)fileNames);
                        }
                        state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                        affected = true;
                    }
                } else if ((d.base() & 1) != 0) {
                    if ((d.addedModifiers() & 0x104A) != 0 || (d.removedModifiers() & 8) != 0) {
                        if (!affected) {
                            Mappings.debug("Added {static | private | synthetic | bridge} specifier or removed static specifier --- affecting method usages");
                            this.myFuture.affectMethodUsages(m, (TIntHashSet)propagated.get(), m.createUsage(Mappings.this.myContext, it.name), (Set<? super UsageRepr.Usage>)usages, state.myDependants);
                            state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                            affected = true;
                        }
                        if ((d.addedModifiers() & 8) != 0) {
                            Mappings.debug("Added static specifier --- affecting subclasses");
                            this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles, null);
                            if (!m.isPrivate()) {
                                Mappings.debug("Added static modifier --- affecting static member on-demand import usages");
                                this.myFuture.affectStaticMemberOnDemandUsages(it.name, (TIntHashSet)propagated.get(), state.myAffectedUsages, state.myDependants);
                            }
                        } else if ((d.removedModifiers() & 8) != 0 && !m.isPrivate()) {
                            Mappings.debug("Removed static modifier --- affecting static method import usages");
                            this.myFuture.affectStaticMemberImportUsages(m.name, it.name, (TIntHashSet)propagated.get(), state.myAffectedUsages, state.myDependants);
                        }
                    } else {
                        if ((d.addedModifiers() & 0x10) != 0 || (d.addedModifiers() & 1) != 0 || (d.addedModifiers() & 0x400) != 0) {
                            Mappings.debug("Added final, public or abstract specifier --- affecting subclasses");
                            this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles, null);
                        }
                        if ((d.addedModifiers() & 4) != 0 && (d.removedModifiers() & 2) == 0 && !constrained) {
                            Mappings.debug("Added public or package-private method became protected --- affect method usages with protected constraint");
                            if (!affected) {
                                this.myFuture.affectMethodUsages(m, (TIntHashSet)propagated.get(), m.createUsage(Mappings.this.myContext, it.name), (Set<? super UsageRepr.Usage>)usages, state.myDependants);
                                state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                                affected = true;
                            }
                            for (Object usage : usages) {
                                Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                                Util util = this.myFuture;
                                Objects.requireNonNull(util);
                                map.put((UsageRepr.Usage)usage, util.new Util.InheritanceConstraint(it));
                            }
                            constrained = true;
                        }
                    }
                }
                if ((d.base() & 0x40) == 0) continue;
                EnumSet<AnnotationsChangeTracker.Recompile> toRecompile = EnumSet.noneOf(AnnotationsChangeTracker.Recompile.class);
                for (AnnotationsChangeTracker extension : this.myAnnotationChangeTracker) {
                    if (toRecompile.containsAll(AnnotationsChangeTracker.RECOMPILE_ALL)) break;
                    Set<AnnotationsChangeTracker.Recompile> actions = extension.methodAnnotationsChanged(Mappings.this.myContext, m, d.annotations(), d.parameterAnnotations());
                    if (actions.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                        Mappings.debug("Extension " + extension.getClass().getName() + " requested recompilation because of changes in annotations list --- affecting method usages");
                    }
                    if (actions.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) {
                        Mappings.debug("Extension " + extension.getClass().getName() + " requested recompilation because of changes in method annotations or method parameter annotations list --- affecting subclasses");
                    }
                    toRecompile.addAll(actions);
                }
                if (toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                    this.myFuture.affectMethodUsages(m, (TIntHashSet)propagated.get(), m.createUsage(Mappings.this.myContext, it.name), (Set<? super UsageRepr.Usage>)usages, state.myDependants);
                    state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                    if (constrained) {
                        for (UsageRepr.Usage usage : usages) {
                            state.myUsageConstraints.remove(usage);
                        }
                    }
                }
                if (!toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) continue;
                this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles, null);
            }
            Mappings.debug("End of changed methods processing");
        }

        private boolean processAddedFields(DiffState state, ClassRepr.Diff diff, ClassRepr classRepr) {
            Collection<FieldRepr> added = diff.fields().added();
            if (added.isEmpty()) {
                return true;
            }
            Mappings.debug("Processing added fields");
            assert (this.myFuture != null);
            assert (this.myPresent != null);
            assert (this.myCompiledFiles != null);
            assert (this.myAffectedFiles != null);
            for (FieldRepr f : added) {
                Mappings.this.debug("Field: ", f.name);
                if (!f.isPrivate()) {
                    TIntHashSet subClasses = Mappings.this.getAllSubclasses(classRepr.name);
                    subClasses.forEach(subClass -> {
                        Iterable sourceFileNames;
                        ClassRepr r = this.myFuture.classReprByName(subClass);
                        if (r != null && (sourceFileNames = Mappings.this.classToSourceFileGet(subClass)) != null && !Mappings.containsAll(this.myCompiledFiles, sourceFileNames)) {
                            if (r.isLocal()) {
                                for (File sourceFileName : sourceFileNames) {
                                    Mappings.this.debug("Affecting local subclass (introduced field can potentially hide surrounding method parameters/local variables): ", sourceFileName);
                                    this.myAffectedFiles.add(sourceFileName);
                                }
                            } else {
                                int outerClass = r.getOuterClassName();
                                if (!Mappings.this.isEmpty(outerClass) && this.myFuture.isFieldVisible(outerClass, f)) {
                                    for (File sourceFileName : sourceFileNames) {
                                        Mappings.this.debug("Affecting inner subclass (introduced field can potentially hide surrounding class fields): ", sourceFileName);
                                        this.myAffectedFiles.add(sourceFileName);
                                    }
                                }
                            }
                        }
                        Mappings.this.debug("Affecting field usages referenced from subclass ", subClass);
                        TIntHashSet propagated = this.myFuture.propagateFieldAccess(f.name, subClass);
                        this.myFuture.affectFieldUsages(f, propagated, f.createUsage(Mappings.this.myContext, subClass), state.myAffectedUsages, state.myDependants);
                        if (f.isStatic()) {
                            this.myFuture.affectStaticMemberOnDemandUsages(subClass, propagated, state.myAffectedUsages, state.myDependants);
                        }
                        this.myFuture.appendDependents(subClass, state.myDependants);
                        return true;
                    });
                }
                HashSet overriddenFields = new HashSet();
                this.myFuture.addOverriddenFields(f, classRepr, overriddenFields, null);
                for (Pair p : overriddenFields) {
                    boolean sameKind;
                    FieldRepr ff = (FieldRepr)p.first;
                    ClassRepr cc = (ClassRepr)p.second;
                    if (ff.isPrivate()) continue;
                    boolean bl = sameKind = f.myType.equals(ff.myType) && f.isStatic() == ff.isStatic() && f.isSynthetic() == ff.isSynthetic() && f.isFinal() == ff.isFinal();
                    if (sameKind && !Difference.weakerAccess(f.access, ff.access)) continue;
                    TIntHashSet propagated = this.myPresent.propagateFieldAccess(ff.name, cc.name);
                    HashSet affectedUsages = new HashSet();
                    Mappings.this.debug("Affecting usages of overridden field in class ", cc.name);
                    this.myFuture.affectFieldUsages(ff, propagated, ff.createUsage(Mappings.this.myContext, cc.name), affectedUsages, state.myDependants);
                    if (sameKind) {
                        Util.PackageConstraint constraint = null;
                        if (f.isProtected()) {
                            Util util = this.myFuture;
                            Objects.requireNonNull(util);
                            constraint = util.new Util.InheritanceConstraint(cc);
                        } else if (f.isPackageLocal()) {
                            Util util = this.myFuture;
                            Objects.requireNonNull(util);
                            constraint = util.new Util.PackageConstraint(cc.getPackageName());
                        }
                        if (constraint != null) {
                            for (UsageRepr.Usage usage : affectedUsages) {
                                state.myUsageConstraints.put(usage, constraint);
                            }
                        }
                    }
                    state.myAffectedUsages.addAll(affectedUsages);
                }
            }
            Mappings.debug("End of added fields processing");
            return true;
        }

        private boolean processRemovedFields(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<FieldRepr> removed = diff.fields().removed();
            if (removed.isEmpty()) {
                return true;
            }
            assert (this.myPresent != null);
            Mappings.debug("Processing removed fields:");
            for (FieldRepr f : removed) {
                Mappings.this.debug("Field: ", f.name);
                if (!Mappings.this.myProcessConstantsIncrementally && !f.isPrivate() && (f.access & 0x10) == 16 && f.hasValue()) {
                    Mappings.debug("Field had value and was (non-private) final static => a switch to non-incremental mode requested");
                    if (!Mappings.this.incrementalDecision(it.name, f, this.myAffectedFiles, this.myFilesToCompile, this.myFilter)) {
                        Mappings.debug("End of Differentiate, returning false");
                        return false;
                    }
                }
                TIntHashSet propagated = this.myPresent.propagateFieldAccess(f.name, it.name);
                this.myPresent.affectFieldUsages(f, propagated, f.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                if (f.isPrivate() || !f.isStatic()) continue;
                Mappings.debug("The field was static --- affecting static field import usages");
                this.myPresent.affectStaticMemberImportUsages(f.name, it.name, propagated, state.myAffectedUsages, state.myDependants);
            }
            Mappings.debug("End of removed fields processing");
            return true;
        }

        private boolean processChangedFields(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<Pair<FieldRepr, Difference>> changed = diff.fields().changed();
            if (changed.isEmpty()) {
                return true;
            }
            Mappings.debug("Processing changed fields:");
            assert (this.myFuture != null);
            assert (this.myPresent != null);
            for (Pair<FieldRepr, Difference> f : changed) {
                Difference d = (Difference)f.second;
                FieldRepr field = (FieldRepr)f.first;
                Mappings.this.debug("Field: ", field.name);
                Supplier propagated = Mappings.lazy(() -> this.myFuture.propagateFieldAccess(field.name, it.name));
                if (!field.isPrivate() && (field.access & 0x10) == 16 && d.hadValue()) {
                    boolean valueChanged;
                    int changedModifiers = d.addedModifiers() | d.removedModifiers();
                    boolean harmful = (changedModifiers & 0x18) != 0;
                    boolean accessChanged = (changedModifiers & 7) != 0;
                    boolean becameLessAccessible = accessChanged && d.accessRestricted();
                    boolean bl = valueChanged = (d.base() & 4) != 0;
                    if (harmful || valueChanged || becameLessAccessible) {
                        if (Mappings.this.myProcessConstantsIncrementally) {
                            Mappings.debug("Potentially inlined field changed its access or value => affecting field usages and static member import usages");
                            this.myFuture.affectFieldUsages(field, (TIntHashSet)propagated.get(), field.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                            this.myFuture.affectStaticMemberImportUsages(field.name, it.name, (TIntHashSet)propagated.get(), state.myAffectedUsages, state.myDependants);
                        } else {
                            Mappings.debug("Potentially inlined field changed its access or value => a switch to non-incremental mode requested");
                            if (!Mappings.this.incrementalDecision(it.name, field, this.myAffectedFiles, this.myFilesToCompile, this.myFilter)) {
                                Mappings.debug("End of Differentiate, returning false");
                                return false;
                            }
                        }
                    }
                }
                if (d.base() == 0) continue;
                if ((d.base() & 2) != 0 || (d.base() & 8) != 0) {
                    Mappings.debug("Type or signature changed --- affecting field usages");
                    this.myFuture.affectFieldUsages(field, (TIntHashSet)propagated.get(), field.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                } else if ((d.base() & 1) != 0) {
                    if ((d.addedModifiers() & 8) != 0 || (d.removedModifiers() & 8) != 0 || (d.addedModifiers() & 2) != 0 || (d.addedModifiers() & 0x40) != 0) {
                        Mappings.debug("Added/removed static modifier or added private/volatile modifier --- affecting field usages");
                        this.myFuture.affectFieldUsages(field, (TIntHashSet)propagated.get(), field.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                        if (!field.isPrivate()) {
                            if ((d.addedModifiers() & 8) != 0) {
                                Mappings.debug("Added static modifier --- affecting static member on-demand import usages");
                                this.myFuture.affectStaticMemberOnDemandUsages(it.name, (TIntHashSet)propagated.get(), state.myAffectedUsages, state.myDependants);
                            } else if ((d.removedModifiers() & 8) != 0) {
                                Mappings.debug("Removed static modifier --- affecting static field import usages");
                                this.myFuture.affectStaticMemberImportUsages(field.name, it.name, (TIntHashSet)propagated.get(), state.myAffectedUsages, state.myDependants);
                            }
                        }
                    } else {
                        THashSet usages = new THashSet();
                        if ((d.addedModifiers() & 0x10) != 0) {
                            Mappings.debug("Added final modifier --- affecting field assign usages");
                            this.myFuture.affectFieldUsages(field, (TIntHashSet)propagated.get(), field.createAssignUsage(Mappings.this.myContext, it.name), (Set<? super UsageRepr.Usage>)usages, state.myDependants);
                            state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                        }
                        if ((d.removedModifiers() & 1) != 0) {
                            Mappings.debug("Removed public modifier, affecting field usages with appropriate constraint");
                            this.myFuture.affectFieldUsages(field, (TIntHashSet)propagated.get(), field.createUsage(Mappings.this.myContext, it.name), (Set<? super UsageRepr.Usage>)usages, state.myDependants);
                            state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                            for (UsageRepr.Usage usage : usages) {
                                if ((d.addedModifiers() & 4) != 0) {
                                    Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                                    Util util = this.myFuture;
                                    Objects.requireNonNull(util);
                                    map.put(usage, util.new Util.InheritanceConstraint(it));
                                    continue;
                                }
                                Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                                Util util = this.myFuture;
                                Objects.requireNonNull(util);
                                map.put(usage, util.new Util.PackageConstraint(it.getPackageName()));
                            }
                        } else if ((d.removedModifiers() & 4) != 0 && d.accessRestricted()) {
                            Mappings.debug("Removed protected modifier and the field became less accessible, affecting field usages with package constraint");
                            this.myFuture.affectFieldUsages(field, (TIntHashSet)propagated.get(), field.createUsage(Mappings.this.myContext, it.name), (Set<? super UsageRepr.Usage>)usages, state.myDependants);
                            state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                            for (UsageRepr.Usage usage : usages) {
                                Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                                Util util = this.myFuture;
                                Objects.requireNonNull(util);
                                map.put(usage, util.new Util.PackageConstraint(it.getPackageName()));
                            }
                        }
                    }
                }
                if ((d.base() & 0x40) == 0) continue;
                EnumSet<AnnotationsChangeTracker.Recompile> toRecompile = EnumSet.noneOf(AnnotationsChangeTracker.Recompile.class);
                for (AnnotationsChangeTracker extension : this.myAnnotationChangeTracker) {
                    if (toRecompile.containsAll(AnnotationsChangeTracker.RECOMPILE_ALL)) break;
                    Set<AnnotationsChangeTracker.Recompile> res = extension.fieldAnnotationsChanged(Mappings.this.myContext, field, d.annotations());
                    if (res.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                        Mappings.debug("Extension " + extension.getClass().getName() + " requested recompilation because of changes in annotations list --- affecting field usages");
                    }
                    if (res.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) {
                        Mappings.debug("Extension " + extension.getClass().getName() + " requested recompilation because of changes in field annotations list --- affecting subclasses");
                    }
                    toRecompile.addAll(res);
                }
                if (toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                    THashSet usages = new THashSet();
                    this.myFuture.affectFieldUsages(field, (TIntHashSet)propagated.get(), field.createUsage(Mappings.this.myContext, it.name), (Set<? super UsageRepr.Usage>)usages, state.myDependants);
                    state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                    for (UsageRepr.Usage usage : usages) {
                        state.myUsageConstraints.remove(usage);
                    }
                }
                if (!toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) continue;
                this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles, null);
            }
            Mappings.debug("End of changed fields processing");
            return true;
        }

        private boolean processChangedClasses(DiffState state) {
            Collection<Pair<ClassRepr, ClassRepr.Diff>> changedClasses = state.myClassDiff.changed();
            if (!changedClasses.isEmpty()) {
                Util.FileFilterConstraint fileFilterConstraint;
                Mappings.debug("Processing changed classes:");
                assert (this.myFuture != null);
                assert (this.myPresent != null);
                if (this.myFilter != null) {
                    Util util = this.myPresent;
                    Objects.requireNonNull(util);
                    fileFilterConstraint = util.new Util.FileFilterConstraint(this.myFilter);
                } else {
                    fileFilterConstraint = null;
                }
                Util.FileFilterConstraint fileFilterConstraint2 = fileFilterConstraint;
                for (Pair<ClassRepr, ClassRepr.Diff> changed : changedClasses) {
                    boolean recompileUsages;
                    boolean signatureChanged;
                    ClassRepr changedClass = (ClassRepr)changed.first;
                    ClassRepr.Diff diff = (ClassRepr.Diff)changed.second;
                    this.myDelta.addChangedClass(changedClass.name);
                    Mappings.this.debug("Changed: ", changedClass.name);
                    int addedModifiers = diff.addedModifiers();
                    boolean superClassChanged = (diff.base() & 0x10) != 0;
                    boolean interfacesChanged = !diff.interfaces().unchanged();
                    boolean bl = signatureChanged = (diff.base() & 8) != 0;
                    if (superClassChanged) {
                        this.myDelta.registerRemovedSuperClass(changedClass.name, changedClass.getSuperClass().className);
                        Iterator<TypeRepr.AbstractType> newClass = this.myDelta.getClassReprByName(null, changedClass.name);
                        assert (newClass != null);
                        this.myDelta.registerAddedSuperClass(changedClass.name, ((ClassRepr)((Object)newClass)).getSuperClass().className);
                    }
                    if (interfacesChanged) {
                        for (TypeRepr.AbstractType typ : diff.interfaces().removed()) {
                            this.myDelta.registerRemovedSuperClass(changedClass.name, ((TypeRepr.ClassType)typ).className);
                        }
                        for (TypeRepr.AbstractType typ : diff.interfaces().added()) {
                            this.myDelta.registerAddedSuperClass(changedClass.name, ((TypeRepr.ClassType)typ).className);
                        }
                    }
                    if (this.myEasyMode) continue;
                    TIntHashSet directDeps = this.myPresent.appendDependents(changedClass, state.myDependants);
                    if (superClassChanged || interfacesChanged || signatureChanged) {
                        Mappings.this.debug("Superclass changed: ", superClassChanged);
                        Mappings.this.debug("Interfaces changed: ", interfacesChanged);
                        Mappings.this.debug("Signature changed ", signatureChanged);
                        boolean extendsChanged = superClassChanged && !diff.extendsAdded();
                        boolean interfacesRemoved = interfacesChanged && !diff.interfaces().removed().isEmpty();
                        Mappings.this.debug("Extends changed: ", extendsChanged);
                        Mappings.this.debug("Interfaces removed: ", interfacesRemoved);
                        this.myFuture.affectSubclasses(changedClass.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, extendsChanged || interfacesRemoved || signatureChanged, this.myCompiledFiles, null);
                        if (extendsChanged && directDeps != null) {
                            TypeRepr.ClassType excClass = TypeRepr.createClassType(Mappings.this.myContext, changedClass.name);
                            directDeps.forEach(depClass -> {
                                ClassRepr depClassRepr = this.myPresent.classReprByName(depClass);
                                if (depClassRepr != null) {
                                    this.myPresent.affectMethodUsagesThrowing(depClassRepr, excClass, state.myAffectedUsages, state.myDependants);
                                }
                                return true;
                            });
                        }
                        if (!changedClass.isAnonymous()) {
                            TIntHashSet parents = new TIntHashSet();
                            this.myPresent.collectSupersRecursively(changedClass.name, parents);
                            TIntHashSet futureParents = new TIntHashSet();
                            this.myFuture.collectSupersRecursively(changedClass.name, futureParents);
                            parents.removeAll(futureParents.toArray());
                            parents.remove(Mappings.this.myObjectClassName);
                            if (!parents.isEmpty()) {
                                parents.forEach(className -> {
                                    Mappings.this.debug("Affecting usages in generic type parameter bounds of class: ", className);
                                    UsageRepr.Usage usage = UsageRepr.createClassAsGenericBoundUsage(Mappings.this.myContext, className);
                                    state.myAffectedUsages.add(usage);
                                    if (fileFilterConstraint2 != null) {
                                        state.myUsageConstraints.put(usage, fileFilterConstraint2);
                                    }
                                    this.myPresent.appendDependents(className, state.myDependants);
                                    return true;
                                });
                            }
                        }
                    }
                    if ((diff.addedModifiers() & 0x200) != 0 || (diff.removedModifiers() & 0x200) != 0) {
                        Mappings.debug("Class-to-interface or interface-to-class conversion detected, added class usage to affected usages");
                        state.myAffectedUsages.add(changedClass.createUsage());
                    }
                    if (changedClass.isAnnotation() && changedClass.getRetentionPolicy() == RetentionPolicy.SOURCE) {
                        Mappings.debug("Annotation, retention policy = SOURCE => a switch to non-incremental mode requested");
                        if (!Mappings.this.incrementalDecision(changedClass.getOuterClassName(), changedClass, this.myAffectedFiles, this.myFilesToCompile, this.myFilter)) {
                            Mappings.debug("End of Differentiate, returning false");
                            return false;
                        }
                    }
                    if ((addedModifiers & 4) != 0) {
                        Mappings.debug("Introduction of 'protected' modifier detected, adding class usage + inheritance constraint to affected usages");
                        UsageRepr.Usage usage = changedClass.createUsage();
                        state.myAffectedUsages.add(usage);
                        Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                        Util util = this.myFuture;
                        Objects.requireNonNull(util);
                        map.put(usage, util.new Util.InheritanceConstraint(changedClass));
                    }
                    if (diff.packageLocalOn()) {
                        Mappings.debug("Introduction of 'package-private' access detected, adding class usage + package constraint to affected usages");
                        UsageRepr.Usage usage = changedClass.createUsage();
                        state.myAffectedUsages.add(usage);
                        Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                        Util util = this.myFuture;
                        Objects.requireNonNull(util);
                        map.put(usage, util.new Util.PackageConstraint(changedClass.getPackageName()));
                    }
                    if ((addedModifiers & 0x10) != 0 || (addedModifiers & 2) != 0) {
                        Mappings.debug("Introduction of 'private' or 'final' modifier(s) detected, adding class usage to affected usages");
                        state.myAffectedUsages.add(changedClass.createUsage());
                    }
                    if ((addedModifiers & 0x400) != 0 || (addedModifiers & 8) != 0) {
                        Mappings.debug("Introduction of 'abstract' or 'static' modifier(s) detected, adding class new usage to affected usages");
                        state.myAffectedUsages.add(UsageRepr.createClassNewUsage(Mappings.this.myContext, changedClass.name));
                    }
                    if (!(changedClass.isAnonymous() || Mappings.this.isEmpty(changedClass.getOuterClassName()) || changedClass.isPrivate() || addedModifiers == 0 && diff.removedModifiers() == 0)) {
                        Mappings.debug("Some modifiers (access flags) were changed for non-private inner class, adding class usage to affected usages");
                        state.myAffectedUsages.add(changedClass.createUsage());
                    }
                    if (changedClass.isAnnotation()) {
                        Mappings.debug("Class is annotation, performing annotation-specific analysis");
                        if (diff.retentionChanged()) {
                            Mappings.debug("Retention policy change detected, adding class usage to affected usages");
                            state.myAffectedUsages.add(changedClass.createUsage());
                        } else if (diff.targetAttributeCategoryMightChange()) {
                            Mappings.debug("Annotation's attribute category in bytecode might be affected because of TYPE_USE target, adding class usage to affected usages");
                            state.myAffectedUsages.add(changedClass.createUsage());
                        } else {
                            Collection<ElemType> removedtargets = diff.targets().removed();
                            if (removedtargets.contains((Object)ElemType.LOCAL_VARIABLE)) {
                                Mappings.debug("Removed target contains LOCAL_VARIABLE => a switch to non-incremental mode requested");
                                if (!Mappings.this.incrementalDecision(changedClass.getOuterClassName(), changedClass, this.myAffectedFiles, this.myFilesToCompile, this.myFilter)) {
                                    Mappings.debug("End of Differentiate, returning false");
                                    return false;
                                }
                            }
                            if (!removedtargets.isEmpty()) {
                                Mappings.debug("Removed some annotation targets, adding annotation query");
                                state.myAnnotationQuery.add((UsageRepr.AnnotationUsage)UsageRepr.createAnnotationUsage(Mappings.this.myContext, TypeRepr.createClassType(Mappings.this.myContext, changedClass.name), null, EnumSet.copyOf(removedtargets)));
                            }
                            for (MethodRepr m : diff.methods().added()) {
                                if (m.hasValue()) continue;
                                Mappings.this.debug("Added method with no default value: ", m.name);
                                Mappings.debug("Adding class usage to affected usages");
                                state.myAffectedUsages.add(changedClass.createUsage());
                            }
                        }
                        Mappings.debug("End of annotation-specific analysis");
                    }
                    this.processAddedMethods(state, diff, changedClass);
                    this.processRemovedMethods(state, diff, changedClass);
                    this.processChangedMethods(state, diff, changedClass);
                    if (!this.processAddedFields(state, diff, changedClass)) {
                        return false;
                    }
                    if (!this.processRemovedFields(state, diff, changedClass)) {
                        return false;
                    }
                    if (!this.processChangedFields(state, diff, changedClass)) {
                        return false;
                    }
                    if ((diff.base() & 0x40) == 0) continue;
                    EnumSet<AnnotationsChangeTracker.Recompile> toRecompile = EnumSet.noneOf(AnnotationsChangeTracker.Recompile.class);
                    for (AnnotationsChangeTracker extension : this.myAnnotationChangeTracker) {
                        if (toRecompile.containsAll(AnnotationsChangeTracker.RECOMPILE_ALL)) break;
                        Set<AnnotationsChangeTracker.Recompile> res = extension.classAnnotationsChanged(Mappings.this.myContext, changedClass, diff.annotations());
                        if (res.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                            Mappings.debug("Extension " + extension.getClass().getName() + " requested class usages recompilation because of changes in annotations list --- adding class usage to affected usages");
                        }
                        if (res.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) {
                            Mappings.debug("Extension " + extension.getClass().getName() + " requested subclasses recompilation because of changes in annotations list --- adding subclasses to affected usages");
                        }
                        toRecompile.addAll(res);
                    }
                    if (recompileUsages = toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                        state.myAffectedUsages.add(changedClass.createUsage());
                    }
                    if (!toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) continue;
                    this.myFuture.affectSubclasses(changedClass.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, recompileUsages, this.myCompiledFiles, null);
                }
                Mappings.debug("End of changed classes processing");
            }
            return !this.myEasyMode;
        }

        private void processRemovedClases(DiffState state, @NotNull File fileName) {
            Collection<ClassRepr> removed;
            if (fileName == null) {
                Differential.$$$reportNull$$$0(1);
            }
            if ((removed = state.myClassDiff.removed()).isEmpty()) {
                return;
            }
            assert (this.myPresent != null);
            assert (this.myDelta.myChangedFiles != null);
            this.myDelta.myChangedFiles.add(fileName);
            Mappings.debug("Processing removed classes:");
            for (ClassRepr c : removed) {
                this.myDelta.addDeletedClass(c, fileName);
                if (this.myEasyMode) continue;
                this.myPresent.appendDependents(c, state.myDependants);
                Mappings.this.debug("Adding usages of class ", c.name);
                state.myAffectedUsages.add(c.createUsage());
                Mappings.this.debug("Affecting usages of removed class ", c.name);
                Mappings.this.affectAll(c.name, fileName, this.myAffectedFiles, this.myCompiledFiles, this.myFilter);
            }
            Mappings.debug("End of removed classes processing.");
        }

        private void processAddedClasses(DiffState state) {
            Collection<ClassRepr> addedClasses = state.myClassDiff.added();
            if (addedClasses.isEmpty()) {
                return;
            }
            Mappings.debug("Processing added classes:");
            if (!this.myEasyMode && this.myFilter != null) {
                assert (this.myCompiledFiles != null);
                assert (this.myAffectedFiles != null);
                for (ClassRepr c : addedClasses) {
                    if (c.isLocal() || c.isAnonymous() || !Mappings.this.isEmpty(c.getOuterClassName())) continue;
                    Object candidates = FileCollectionFactory.createCanonicalFileSet();
                    Iterable currentlyMapped = Mappings.this.classToSourceFileGet(c.name);
                    if (currentlyMapped != null) {
                        ContainerUtil.addAll((Collection)candidates, (Iterable)currentlyMapped);
                    }
                    candidates.removeAll(this.myCompiledFiles);
                    Iterable newSources = this.myDelta.classToSourceFileGet(c.name);
                    if (newSources != null) {
                        Mappings.removeAll((Collection)candidates, newSources);
                    }
                    Set nonExistentOrOutOfScope = FileCollectionFactory.createCanonicalFileSet();
                    Iterator iterator = candidates.iterator();
                    while (iterator.hasNext()) {
                        File candidate = (File)iterator.next();
                        if (candidate.exists() && this.myFilter.belongsToCurrentTargetChunk(candidate)) continue;
                        nonExistentOrOutOfScope.add(candidate);
                    }
                    candidates.removeAll(nonExistentOrOutOfScope);
                    if (candidates.isEmpty()) continue;
                    candidates.clear();
                    if (currentlyMapped != null) {
                        ContainerUtil.addAll((Collection)candidates, (Iterable)currentlyMapped);
                    }
                    if (newSources != null) {
                        ContainerUtil.addAll((Collection)candidates, (Iterable)newSources);
                    }
                    candidates.removeAll(nonExistentOrOutOfScope);
                    if (Mappings.this.myDebugS.isDebugEnabled()) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Possibly duplicated classes; Scheduling for recompilation sources: ");
                        Iterator iterator2 = candidates.iterator();
                        while (iterator2.hasNext()) {
                            File file = (File)iterator2.next();
                            msg.append(file.getPath()).append("; ");
                        }
                        Mappings.debug(msg.toString());
                    }
                    this.myAffectedFiles.addAll((Collection<? super File>)candidates);
                    return;
                }
            }
            for (ClassRepr c : addedClasses) {
                Mappings.this.debug("Class name: ", c.name);
                this.myDelta.addAddedClass(c);
                for (int sup : c.getSupers()) {
                    this.myDelta.registerAddedSuperClass(c.name, sup);
                }
                if (this.myEasyMode || c.isAnonymous() || c.isLocal()) continue;
                TIntHashSet toAffect = new TIntHashSet();
                toAffect.add(c.name);
                TIntHashSet classes = Mappings.this.myShortClassNameIndex.get(Mappings.this.myContext.get(c.getShortName()));
                if (classes != null) {
                    toAffect.addAll(classes.toArray());
                }
                toAffect.forEach(qName -> {
                    TIntHashSet depClasses = Mappings.this.myClassToClassDependency.get(qName);
                    if (depClasses != null) {
                        this.affectCorrespondingSourceFiles(depClasses);
                    }
                    return true;
                });
            }
            Mappings.debug("End of added classes processing.");
        }

        private void affectCorrespondingSourceFiles(TIntHashSet toAffect) {
            assert (this.myAffectedFiles != null);
            toAffect.forEach(depClass -> {
                Iterable fNames = Mappings.this.classToSourceFileGet(depClass);
                if (fNames != null) {
                    for (File fName : fNames) {
                        if (this.myFilter != null && !this.myFilter.accept(fName)) continue;
                        Mappings.this.debug("Adding dependent file ", fName);
                        this.myAffectedFiles.add(fName);
                    }
                }
                return true;
            });
        }

        private boolean calculateAffectedFiles(final DiffState state) {
            Mappings.debug("Checking dependent classes:");
            assert (this.myAffectedFiles != null);
            assert (this.myCompiledFiles != null);
            final Ref incrementalMode = new Ref((Object)Boolean.TRUE);
            state.myDependants.forEach(new TIntProcedure(){

                public boolean execute(int depClass) {
                    Iterable depFiles = Mappings.this.classToSourceFileGet(depClass);
                    if (depFiles != null) {
                        for (File depFile : depFiles) {
                            this.processDependentFile(depClass, depFile);
                            if (((Boolean)incrementalMode.get()).booleanValue()) continue;
                            return false;
                        }
                    }
                    return true;
                }

                private void processDependentFile(int depClass, @NotNull File depFile) {
                    Set<UsageRepr.Usage> depUsages;
                    if (depFile == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (Differential.this.myAffectedFiles.contains(depFile)) {
                        return;
                    }
                    Mappings.this.debug("Dependent class: ", depClass);
                    ClassFileRepr repr = Mappings.this.getReprByName(depFile, depClass);
                    if (repr == null) {
                        return;
                    }
                    if (repr instanceof ClassRepr) {
                        ClassRepr clsRepr = (ClassRepr)repr;
                        if (!clsRepr.hasInlinedConstants() && Differential.this.myCompiledFiles.contains(depFile)) {
                            return;
                        }
                        if (clsRepr.isGenerated()) {
                            Mappings.debug("Turning non-incremental for the BuildTarget because dependent class is annotation-processor generated");
                            incrementalMode.set((Object)Boolean.FALSE);
                            return;
                        }
                    }
                    if ((depUsages = repr.getUsages()) == null || depUsages.isEmpty()) {
                        return;
                    }
                    for (UsageRepr.Usage usage : depUsages) {
                        if (usage instanceof UsageRepr.AnnotationUsage) {
                            UsageRepr.AnnotationUsage annotationUsage = (UsageRepr.AnnotationUsage)usage;
                            for (UsageRepr.AnnotationUsage query : state.myAnnotationQuery) {
                                if (!query.satisfies(annotationUsage)) continue;
                                Mappings.debug("Added file due to annotation query");
                                Differential.this.myAffectedFiles.add(depFile);
                                return;
                            }
                            continue;
                        }
                        if (!state.myAffectedUsages.contains(usage)) continue;
                        UsageConstraint constraint = state.myUsageConstraints.get(usage);
                        if (constraint == null) {
                            Mappings.debug("Added file with no constraints");
                            Differential.this.myAffectedFiles.add(depFile);
                            return;
                        }
                        if (!constraint.checkResidence(depClass)) continue;
                        Mappings.debug("Added file with satisfied constraint");
                        Differential.this.myAffectedFiles.add(depFile);
                        return;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depFile", "org/jetbrains/jps/builders/java/dependencyView/Mappings$Differential$1", "processDependentFile"));
                }
            });
            return (Boolean)incrementalMode.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean differentiate() {
            var1_1 = Mappings.access$4300(Mappings.this);
            synchronized (var1_1) {
                block26: {
                    block27: {
                        Mappings.access$4402(this.myDelta, true);
                        if (Mappings.access$1900(this.myDelta)) {
                            return true;
                        }
                        Mappings.access$1200("Begin of Differentiate:");
                        Mappings.access$3700(Mappings.this, "Easy mode: ", this.myEasyMode);
                        this.processDisappearedClasses();
                        newClasses = new ArrayList<E>();
                        Mappings.access$4500(this.myDelta).forEachEntry(new TObjectObjectProcedure<String, Collection<ClassFileRepr>>(){

                            public boolean execute(String relativeFilePath, Collection<ClassFileRepr> content) {
                                File file = Mappings.this.toFull(relativeFilePath);
                                if (Differential.this.myFilesToCompile == null || Differential.this.myFilesToCompile.contains(file)) {
                                    newClasses.add(new FileClasses(file, content));
                                }
                                return true;
                            }
                        });
                        var3_3 = newClasses.iterator();
                        while (true) {
                            if (var3_3.hasNext()) {
                                compiledFile = (FileClasses)var3_3.next();
                                fileName = compiledFile.myFileName;
                                pastClasses = new THashSet();
                                pastModules = new THashSet();
                                past = Mappings.access$2300(Mappings.this, fileName);
                                if (past == null) break block26;
                                var9_11 = past.iterator();
                                break block27;
                            }
                            addedClasses = Mappings.access$4600(this.myDelta);
                            if (!addedClasses.isEmpty()) {
                                addedNames = new TIntHashSet();
                                for (ClassRepr repr : addedClasses) {
                                    addedNames.add(repr.name);
                                }
                                for (FileClasses compiledFile : newClasses) {
                                    for (ClassRepr aClass : compiledFile.myFileClasses) {
                                        for (Object parent : (Iterator<E>)aClass.getSupers()) {
                                            if (!addedNames.contains((int)parent)) continue;
                                            Mappings.access$3600(this.myDelta, aClass.name, (int)parent);
                                        }
                                    }
                                }
                            }
                            Mappings.access$1200("End of Differentiate.");
                            if (this.myEasyMode) {
                                addedNames = false;
                                return addedNames;
                            }
                            if (!Differential.$assertionsDisabled && this.myAffectedFiles == null) {
                                throw new AssertionError();
                            }
                            removed = Mappings.access$2000(this.myDelta);
                            if (removed != null) {
                                for (String r : removed) {
                                    this.myAffectedFiles.remove(new File(r));
                                }
                            }
                            var5_7 = true;
                            return var5_7;
                        }
                        finally {
                            if (this.myFilesToCompile != null) {
                                if (!Differential.$assertionsDisabled && Mappings.access$3800(this.myDelta) == null) {
                                    throw new AssertionError();
                                }
                                Mappings.access$3800(this.myDelta).retainAll(this.myFilesToCompile);
                            }
                        }
                    }
                    while (var9_11.hasNext()) {
                        repr = (ClassFileRepr)var9_11.next();
                        if (repr instanceof ClassRepr) {
                            pastClasses.add((ClassRepr)repr);
                            continue;
                        }
                        pastModules.add((ModuleRepr)repr);
                    }
                }
                state = new DiffState(Difference.make(pastClasses, compiledFile.myFileClasses), Difference.make(pastModules, compiledFile.myFileModules));
                if (!this.myEasyMode) {
                    this.processModules(state, fileName);
                }
                if (!this.processChangedClasses(state) && !this.myEasyMode) {
                    var10_13 = false;
                    return var10_13;
                }
                this.processRemovedClases(state, fileName);
                this.processAddedClasses(state);
                if (this.myEasyMode || this.calculateAffectedFiles(state)) ** continue;
                var10_14 = false;
                return var10_14;
            }
        }

        private void processModules(DiffState state, File fileName) {
            Difference.Specifier<ModuleRepr, ModuleRepr.Diff> modulesDiff = state.myModulesDiff;
            if (modulesDiff.unchanged()) {
                return;
            }
            for (ModuleRepr moduleRepr : modulesDiff.added()) {
                this.myDelta.addChangedClass(moduleRepr.name);
                this.myFuture.affectModule(moduleRepr, this.myAffectedFiles);
            }
            for (ModuleRepr moduleRepr : modulesDiff.removed()) {
                this.myDelta.addDeletedClass(moduleRepr, fileName);
                this.myPresent.affectDependentModules(state, moduleRepr.name, null, true);
            }
            for (Pair pair : modulesDiff.changed()) {
                final ModuleRepr moduleRepr = (ModuleRepr)pair.first;
                ModuleRepr.Diff d = (ModuleRepr.Diff)pair.second;
                boolean affectSelf = false;
                boolean affectDeps = false;
                UsageConstraint constraint = null;
                this.myDelta.addChangedClass(moduleRepr.name);
                if (d.versionChanged()) {
                    final int version = moduleRepr.getVersion();
                    this.myPresent.affectDependentModules(state, moduleRepr.name, new UsageConstraint(){

                        @Override
                        public boolean checkResidence(int dep) {
                            ModuleRepr depModule = Differential.this.myPresent.moduleReprByName(dep);
                            if (depModule != null) {
                                for (ModuleRequiresRepr requires : depModule.getRequires()) {
                                    if (requires.name != moduleRepr.name || requires.getVersion() != version) continue;
                                    return true;
                                }
                            }
                            return false;
                        }
                    }, false);
                }
                Difference.Specifier<ModuleRequiresRepr, ModuleRequiresRepr.Diff> requiresDiff = d.requires();
                for (ModuleRequiresRepr moduleRequiresRepr : requiresDiff.removed()) {
                    affectSelf = true;
                    if (!moduleRequiresRepr.isTransitive()) continue;
                    affectDeps = true;
                    constraint = UsageConstraint.ANY;
                    break;
                }
                for (Pair pair2 : requiresDiff.changed()) {
                    affectSelf |= ((ModuleRequiresRepr.Diff)pair2.second).versionChanged();
                    if (!((ModuleRequiresRepr.Diff)pair2.second).becameNonTransitive()) continue;
                    affectDeps = true;
                    constraint = UsageConstraint.ANY;
                }
                Difference.Specifier<ModulePackageRepr, ModulePackageRepr.Diff> exportsDiff = d.exports();
                if (!affectDeps) {
                    for (ModulePackageRepr modulePackageRepr : exportsDiff.removed()) {
                        affectDeps = true;
                        if (!modulePackageRepr.isQualified()) {
                            constraint = UsageConstraint.ANY;
                            break;
                        }
                        for (Integer name : modulePackageRepr.getModuleNames()) {
                            UsageConstraint matchName = UsageConstraint.exactMatch(name);
                            if (constraint == null) {
                                constraint = matchName;
                                continue;
                            }
                            constraint = constraint.or(matchName);
                        }
                    }
                }
                if (!affectDeps || constraint != UsageConstraint.ANY) {
                    for (Pair<ModulePackageRepr, ModulePackageRepr.Diff> pair3 : exportsDiff.changed()) {
                        Collection<Integer> removedModuleNames = ((ModulePackageRepr.Diff)pair3.second).targetModules().removed();
                        if (!(affectDeps |= !removedModuleNames.isEmpty())) continue;
                        for (Integer name : removedModuleNames) {
                            UsageConstraint matchName = UsageConstraint.exactMatch(name);
                            if (constraint == null) {
                                constraint = matchName;
                                continue;
                            }
                            constraint = constraint.or(matchName);
                        }
                    }
                }
                if (affectSelf) {
                    this.myPresent.affectModule(moduleRepr, this.myAffectedFiles);
                }
                if (!affectDeps) continue;
                this.myPresent.affectDependentModules(state, moduleRepr.name, constraint, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/Mappings$Differential";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processRemovedClases";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class DiffState {
            public final TIntHashSet myDependants = new TIntHashSet(32, 0.98f);
            public final Set<UsageRepr.Usage> myAffectedUsages = new HashSet<UsageRepr.Usage>();
            public final Set<UsageRepr.AnnotationUsage> myAnnotationQuery = new HashSet<UsageRepr.AnnotationUsage>();
            public final Map<UsageRepr.Usage, UsageConstraint> myUsageConstraints = new HashMap<UsageRepr.Usage, UsageConstraint>();
            final Difference.Specifier<ClassRepr, ClassRepr.Diff> myClassDiff;
            final Difference.Specifier<ModuleRepr, ModuleRepr.Diff> myModulesDiff;

            DiffState(Difference.Specifier<ClassRepr, ClassRepr.Diff> classDiff, Difference.Specifier<ModuleRepr, ModuleRepr.Diff> modulesDiff) {
                this.myClassDiff = classDiff;
                this.myModulesDiff = modulesDiff;
            }
        }

        private class FileClasses {
            final File myFileName;
            final Set<ClassRepr> myFileClasses = new THashSet();
            final Set<ModuleRepr> myFileModules = new THashSet();

            FileClasses(File fileName, Collection<ClassFileRepr> fileContent) {
                this.myFileName = fileName;
                for (ClassFileRepr repr : fileContent) {
                    if (repr instanceof ClassRepr) {
                        this.myFileClasses.add((ClassRepr)repr);
                        continue;
                    }
                    this.myFileModules.add((ModuleRepr)repr);
                }
            }
        }
    }

    public static interface DependentFilesFilter {
        public boolean accept(File var1);

        public boolean belongsToCurrentTargetChunk(File var1);
    }

    private final class Util {
        @Nullable
        private final Mappings myMappings;

        private Util() {
            this.myMappings = null;
        }

        private Util(Mappings mappings2) {
            if (mappings2 == null) {
                Util.$$$reportNull$$$0(0);
            }
            this.myMappings = mappings2;
        }

        TIntHashSet appendDependents(ClassFileRepr c, TIntHashSet result) {
            return this.appendDependents(c.name, result);
        }

        @Nullable
        TIntHashSet appendDependents(int className, TIntHashSet result) {
            TIntHashSet depClasses = Mappings.this.myClassToClassDependency.get(className);
            if (depClasses != null) {
                Mappings.addAll(result, depClasses);
            }
            return depClasses;
        }

        void propagateMemberAccessRec(TIntHashSet acc, boolean isField, boolean root, MemberComparator comparator, int reflcass) {
            ClassRepr repr = this.classReprByName(reflcass);
            if (repr != null) {
                TIntHashSet subclasses;
                if (!root) {
                    Set<ProtoMember> members = isField ? repr.getFields() : repr.getMethods();
                    for (ProtoMember m : members) {
                        if (!comparator.isSame(m)) continue;
                        return;
                    }
                    if (!acc.add(reflcass)) {
                        return;
                    }
                }
                if ((subclasses = Mappings.this.myClassToSubclasses.get(reflcass)) != null) {
                    subclasses.forEach(subclass -> {
                        this.propagateMemberAccessRec(acc, isField, false, comparator, subclass);
                        return true;
                    });
                }
            }
        }

        TIntHashSet propagateMemberAccess(boolean isField, MemberComparator comparator, int className) {
            TIntHashSet acc = new TIntHashSet(32, 0.98f);
            this.propagateMemberAccessRec(acc, isField, true, comparator, className);
            return acc;
        }

        TIntHashSet propagateFieldAccess(int name, int className) {
            return this.propagateMemberAccess(true, member -> member.name == name, className);
        }

        TIntHashSet propagateMethodAccess(MethodRepr m, int className) {
            return this.propagateMemberAccess(false, member -> m.equals(member), className);
        }

        MethodRepr.Predicate lessSpecific(final MethodRepr than) {
            return new MethodRepr.Predicate(){

                @Override
                public boolean satisfy(MethodRepr m) {
                    if (m.name == Mappings.this.myInitName || m.name != than.name || m.myArgumentTypes.length != than.myArgumentTypes.length) {
                        return false;
                    }
                    for (int i = 0; i < than.myArgumentTypes.length; ++i) {
                        Boolean subtypeOf = Util.this.isSubtypeOf(than.myArgumentTypes[i], m.myArgumentTypes[i]);
                        if (subtypeOf == null || subtypeOf.booleanValue()) continue;
                        return false;
                    }
                    return true;
                }
            };
        }

        private void addOverridingMethods(MethodRepr m, ClassRepr fromClass, MethodRepr.Predicate predicate, Collection<? super Pair<MethodRepr, ClassRepr>> container, TIntHashSet visitedClasses) {
            if (m.name == Mappings.this.myInitName) {
                return;
            }
            TIntHashSet subClasses = Mappings.this.myClassToSubclasses.get(fromClass.name);
            if (subClasses == null) {
                return;
            }
            if (visitedClasses == null) {
                visitedClasses = new TIntHashSet();
            }
            if (!visitedClasses.add(fromClass.name)) {
                return;
            }
            TIntHashSet _visitedClasses = visitedClasses;
            subClasses.forEach(subClassName -> {
                ClassRepr r = this.classReprByName(subClassName);
                if (r != null) {
                    boolean cont = true;
                    Collection<MethodRepr> methods = r.findMethods(predicate);
                    for (MethodRepr mm : methods) {
                        if (!Mappings.isVisibleIn(fromClass, m, r)) continue;
                        container.add((Pair<MethodRepr, ClassRepr>)Pair.create((Object)mm, (Object)r));
                        cont = false;
                    }
                    if (cont) {
                        this.addOverridingMethods(m, r, predicate, container, _visitedClasses);
                    }
                }
                return true;
            });
        }

        private Collection<Pair<MethodRepr, ClassRepr>> findAllMethodsBySpecificity(MethodRepr m, ClassRepr c) {
            MethodRepr.Predicate predicate = this.lessSpecific(m);
            HashSet<Pair<MethodRepr, ClassRepr>> result = new HashSet<Pair<MethodRepr, ClassRepr>>();
            this.addOverridenMethods(c, predicate, result, null);
            this.addOverridingMethods(m, c, predicate, result, null);
            return result;
        }

        private Collection<Pair<MethodRepr, ClassRepr>> findOverriddenMethods(MethodRepr m, ClassRepr c) {
            if (m.name == Mappings.this.myInitName) {
                return Collections.emptySet();
            }
            HashSet<Pair<MethodRepr, ClassRepr>> result = new HashSet<Pair<MethodRepr, ClassRepr>>();
            this.addOverridenMethods(c, MethodRepr.equalByJavaRules(m), result, null);
            return result;
        }

        private boolean hasOverriddenMethods(ClassRepr fromClass, MethodRepr.Predicate predicate, TIntHashSet visitedClasses) {
            if (visitedClasses == null) {
                visitedClasses = new TIntHashSet();
                visitedClasses.add(fromClass.name);
            }
            for (int superName : fromClass.getSupers()) {
                ClassRepr superClass;
                if (!visitedClasses.add(superName) || superName == Mappings.this.myObjectClassName || (superClass = this.classReprByName(superName)) == null) continue;
                for (MethodRepr mm : superClass.findMethods(predicate)) {
                    if (!Mappings.isVisibleIn(superClass, mm, fromClass)) continue;
                    return true;
                }
                if (!this.hasOverriddenMethods(superClass, predicate, visitedClasses)) continue;
                return true;
            }
            return false;
        }

        private boolean extendsLibraryClass(ClassRepr fromClass, TIntHashSet visitedClasses) {
            if (visitedClasses == null) {
                visitedClasses = new TIntHashSet();
                visitedClasses.add(fromClass.name);
            }
            for (int superName : fromClass.getSupers()) {
                ClassRepr superClass;
                if (!visitedClasses.add(superName) || superName == Mappings.this.myObjectClassName || (superClass = this.classReprByName(superName)) != null && !this.extendsLibraryClass(superClass, visitedClasses)) continue;
                return true;
            }
            return false;
        }

        private void addOverridenMethods(ClassRepr fromClass, MethodRepr.Predicate predicate, Collection<? super Pair<MethodRepr, ClassRepr>> container, TIntHashSet visitedClasses) {
            if (visitedClasses == null) {
                visitedClasses = new TIntHashSet();
                visitedClasses.add(fromClass.name);
            }
            for (int superName : fromClass.getSupers()) {
                if (!visitedClasses.add(superName) || superName == Mappings.this.myObjectClassName) continue;
                ClassRepr superClass = this.classReprByName(superName);
                if (superClass != null) {
                    boolean cont = true;
                    Collection<MethodRepr> methods = superClass.findMethods(predicate);
                    for (MethodRepr mm : methods) {
                        if (!Mappings.isVisibleIn(superClass, mm, fromClass)) continue;
                        container.add((Pair<MethodRepr, ClassRepr>)Pair.create((Object)mm, (Object)superClass));
                        cont = false;
                    }
                    if (!cont) continue;
                    this.addOverridenMethods(superClass, predicate, container, visitedClasses);
                    continue;
                }
                container.add((Pair<MethodRepr, ClassRepr>)Pair.create((Object)MOCK_METHOD, (Object)MOCK_CLASS));
            }
        }

        void addOverriddenFields(FieldRepr f, ClassRepr fromClass, Collection<? super Pair<FieldRepr, ClassRepr>> container, TIntHashSet visitedClasses) {
            if (visitedClasses == null) {
                visitedClasses = new TIntHashSet();
                visitedClasses.add(fromClass.name);
            }
            for (int supername : fromClass.getSupers()) {
                ClassRepr superClass;
                if (!visitedClasses.add(supername) || supername == Mappings.this.myObjectClassName || (superClass = this.classReprByName(supername)) == null) continue;
                FieldRepr ff = superClass.findField(f.name);
                if (ff != null && Mappings.isVisibleIn(superClass, ff, fromClass)) {
                    container.add((Pair<FieldRepr, ClassRepr>)Pair.create((Object)ff, (Object)superClass));
                    continue;
                }
                this.addOverriddenFields(f, superClass, container, visitedClasses);
            }
        }

        boolean hasOverriddenFields(FieldRepr f, ClassRepr fromClass, TIntHashSet visitedClasses) {
            if (visitedClasses == null) {
                visitedClasses = new TIntHashSet();
                visitedClasses.add(fromClass.name);
            }
            for (int supername : fromClass.getSupers()) {
                ClassRepr superClass;
                if (!visitedClasses.add(supername) || supername == Mappings.this.myObjectClassName || (superClass = this.classReprByName(supername)) == null) continue;
                FieldRepr ff = superClass.findField(f.name);
                if (ff != null && Mappings.isVisibleIn(superClass, ff, fromClass)) {
                    return true;
                }
                boolean found = this.hasOverriddenFields(f, superClass, visitedClasses);
                if (!found) continue;
                return true;
            }
            return false;
        }

        @Nullable
        ClassRepr classReprByName(int name) {
            ClassFileRepr r = this.reprByName(name);
            return r instanceof ClassRepr ? (ClassRepr)r : null;
        }

        @Nullable
        ModuleRepr moduleReprByName(int name) {
            ClassFileRepr r = this.reprByName(name);
            return r instanceof ModuleRepr ? (ModuleRepr)r : null;
        }

        @Nullable
        ClassFileRepr reprByName(int name) {
            ClassFileRepr r;
            if (this.myMappings != null && (r = this.myMappings.getReprByName(null, name)) != null) {
                return r;
            }
            return Mappings.this.getReprByName(null, name);
        }

        @Nullable
        private Boolean isInheritorOf(int who, int whom, TIntHashSet visitedClasses) {
            if (who == whom) {
                return Boolean.TRUE;
            }
            ClassRepr repr = this.classReprByName(who);
            if (repr != null) {
                if (visitedClasses == null) {
                    visitedClasses = new TIntHashSet();
                    visitedClasses.add(who);
                }
                for (int s : repr.getSupers()) {
                    Boolean inheritorOf;
                    if (!visitedClasses.add(s) || (inheritorOf = this.isInheritorOf(s, whom, visitedClasses)) == null || !inheritorOf.booleanValue()) continue;
                    return true;
                }
            }
            return null;
        }

        @Nullable
        Boolean isSubtypeOf(TypeRepr.AbstractType who, TypeRepr.AbstractType whom) {
            if (who.equals(whom)) {
                return Boolean.TRUE;
            }
            if (who instanceof TypeRepr.PrimitiveType || whom instanceof TypeRepr.PrimitiveType) {
                return Boolean.FALSE;
            }
            if (who instanceof TypeRepr.ArrayType) {
                if (whom instanceof TypeRepr.ArrayType) {
                    return this.isSubtypeOf(((TypeRepr.ArrayType)who).elementType, ((TypeRepr.ArrayType)whom).elementType);
                }
                String descr = whom.getDescr(Mappings.this.myContext);
                if (descr.equals("Ljava/lang/Cloneable") || descr.equals("Ljava/lang/Object") || descr.equals("Ljava/io/Serializable")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (whom instanceof TypeRepr.ClassType) {
                return this.isInheritorOf(((TypeRepr.ClassType)who).className, ((TypeRepr.ClassType)whom).className, null);
            }
            return Boolean.FALSE;
        }

        boolean isMethodVisible(ClassRepr classRepr, MethodRepr m) {
            return classRepr.findMethods(MethodRepr.equalByJavaRules(m)).size() > 0 || this.hasOverriddenMethods(classRepr, MethodRepr.equalByJavaRules(m), null);
        }

        boolean isFieldVisible(int className, FieldRepr field) {
            ClassRepr r = this.classReprByName(className);
            if (r == null || r.getFields().contains(field)) {
                return true;
            }
            return this.hasOverriddenFields(field, r, null);
        }

        void collectSupersRecursively(int className, @NotNull TIntHashSet container) {
            int[] supers;
            ClassRepr classRepr;
            if (container == null) {
                Util.$$$reportNull$$$0(1);
            }
            if ((classRepr = this.classReprByName(className)) != null && container.addAll(supers = classRepr.getSupers())) {
                for (int aSuper : supers) {
                    this.collectSupersRecursively(aSuper, container);
                }
            }
        }

        void affectSubclasses(int className, Collection<? super File> affectedFiles, Collection<? super UsageRepr.Usage> affectedUsages, TIntHashSet dependants, boolean usages, Collection<? extends File> alreadyCompiledFiles, TIntHashSet visitedClasses) {
            Mappings.this.debug("Affecting subclasses of class: ", className);
            Iterable allSources = Mappings.this.classToSourceFileGet(className);
            if (allSources == null || Iterators.isEmpty((Iterable)allSources)) {
                Mappings.this.debug("No source file detected for class ", className);
                Mappings.debug("End of affectSubclasses");
                return;
            }
            for (File fName : allSources) {
                Mappings.this.debug("Source file name: ", fName);
                if (alreadyCompiledFiles.contains(fName)) continue;
                affectedFiles.add(fName);
            }
            if (usages) {
                Mappings.debug("Class usages affection requested");
                ClassRepr classRepr = this.classReprByName(className);
                if (classRepr != null) {
                    Mappings.this.debug("Added class usage for ", classRepr.name);
                    affectedUsages.add(classRepr.createUsage());
                }
            }
            this.appendDependents(className, dependants);
            TIntHashSet directSubclasses = Mappings.this.myClassToSubclasses.get(className);
            if (directSubclasses != null) {
                if (visitedClasses == null) {
                    visitedClasses = new TIntHashSet();
                    visitedClasses.add(className);
                }
                TIntHashSet _visitedClasses = visitedClasses;
                directSubclasses.forEach(subClass -> {
                    if (_visitedClasses.add(subClass)) {
                        this.affectSubclasses(subClass, affectedFiles, affectedUsages, dependants, usages, alreadyCompiledFiles, _visitedClasses);
                    }
                    return true;
                });
            }
        }

        void affectFieldUsages(FieldRepr field, TIntHashSet classes, UsageRepr.Usage rootUsage, Set<? super UsageRepr.Usage> affectedUsages, TIntHashSet dependents) {
            affectedUsages.add(rootUsage);
            classes.forEach(p -> {
                this.appendDependents(p, dependents);
                Mappings.this.debug("Affect field usage referenced of class ", p);
                affectedUsages.add(rootUsage instanceof UsageRepr.FieldAssignUsage ? field.createAssignUsage(Mappings.this.myContext, p) : field.createUsage(Mappings.this.myContext, p));
                return true;
            });
        }

        void affectStaticMemberImportUsages(int memberName, int ownerName, TIntHashSet classes, Set<? super UsageRepr.Usage> affectedUsages, TIntHashSet dependents) {
            Mappings.this.debug("Affect static member import usage referenced of class ", ownerName);
            affectedUsages.add(UsageRepr.createImportStaticMemberUsage(Mappings.this.myContext, memberName, ownerName));
            classes.forEach(cls -> {
                this.appendDependents(cls, dependents);
                Mappings.this.debug("Affect static member import usage referenced of class ", cls);
                affectedUsages.add(UsageRepr.createImportStaticMemberUsage(Mappings.this.myContext, memberName, cls));
                return true;
            });
        }

        void affectStaticMemberOnDemandUsages(int ownerClass, TIntHashSet classes, Set<? super UsageRepr.Usage> affectedUsages, TIntHashSet dependents) {
            Mappings.this.debug("Affect static member on-demand import usage referenced of class ", ownerClass);
            affectedUsages.add(UsageRepr.createImportStaticOnDemandUsage(Mappings.this.myContext, ownerClass));
            classes.forEach(cls -> {
                this.appendDependents(cls, dependents);
                Mappings.this.debug("Affect static member on-demand import usage referenced of class ", cls);
                affectedUsages.add(UsageRepr.createImportStaticOnDemandUsage(Mappings.this.myContext, cls));
                return true;
            });
        }

        void affectMethodUsagesThrowing(ClassRepr aClass, TypeRepr.ClassType exceptionClass, Set<? super UsageRepr.Usage> affectedUsages, TIntHashSet dependents) {
            boolean shouldAffect = false;
            for (MethodRepr method : aClass.getMethods()) {
                if (!method.myExceptions.contains(exceptionClass)) continue;
                shouldAffect = true;
                affectedUsages.add(method.createUsage(Mappings.this.myContext, aClass.name));
            }
            if (shouldAffect) {
                if (Mappings.this.myDebugS.isDebugEnabled()) {
                    Mappings.this.debug("Affecting usages of methods throwing " + Mappings.this.myContext.getValue(exceptionClass.className) + " exception; class ", aClass.name);
                }
                this.appendDependents(aClass, dependents);
            }
        }

        void affectMethodUsages(MethodRepr method, TIntHashSet subclasses, UsageRepr.Usage rootUsage, Set<? super UsageRepr.Usage> affectedUsages, TIntHashSet dependents) {
            affectedUsages.add(rootUsage);
            if (subclasses != null) {
                subclasses.forEach(p -> {
                    this.appendDependents(p, dependents);
                    Mappings.this.debug("Affect method usage referenced of class ", p);
                    UsageRepr.Usage usage = rootUsage instanceof UsageRepr.MetaMethodUsage ? method.createMetaUsage(Mappings.this.myContext, p) : method.createUsage(Mappings.this.myContext, p);
                    affectedUsages.add(usage);
                    return true;
                });
            }
        }

        void affectModule(ModuleRepr m, Collection<? super File> affectedFiles) {
            Iterable depFiles;
            Iterable iterable = depFiles = this.myMappings != null ? this.myMappings.classToSourceFileGet(m.name) : null;
            if (depFiles == null) {
                depFiles = Mappings.this.classToSourceFileGet(m.name);
            }
            if (depFiles != null) {
                Mappings.this.debug("Affecting module ", m.name);
                ContainerUtil.addAll(affectedFiles, (Iterable)depFiles);
            }
        }

        void affectDependentModules(final Differential.DiffState state, int moduleName, final @Nullable UsageConstraint constraint, final boolean checkTransitive) {
            new Object(){
                final TIntHashSet visited = new TIntHashSet();

                void perform(int modName) {
                    TIntHashSet depNames = Mappings.this.myClassToClassDependency.get(modName);
                    if (depNames != null && !depNames.isEmpty()) {
                        TIntHashSet next = new TIntHashSet();
                        UsageRepr.Usage moduleUsage = UsageRepr.createModuleUsage(Mappings.this.myContext, modName);
                        state.myAffectedUsages.add(moduleUsage);
                        UsageConstraint prevConstraint = state.myUsageConstraints.put(moduleUsage, constraint == null ? UsageConstraint.ANY : constraint);
                        if (prevConstraint != null) {
                            state.myUsageConstraints.put(moduleUsage, prevConstraint.or(constraint));
                        }
                        depNames.forEach(depName -> {
                            ClassFileRepr depRepr;
                            if (this.visited.add(depName) && (depRepr = Util.this.reprByName(depName)) instanceof ModuleRepr) {
                                state2.myDependants.add(depName);
                                if (checkTransitive && ((ModuleRepr)depRepr).requiresTransitevely(modName)) {
                                    next.add(depName);
                                }
                            }
                            return true;
                        });
                        next.forEach(m -> {
                            this.perform(m);
                            return true;
                        });
                    }
                }
            }.perform(moduleName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/Mappings$Util";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectSupersRecursively";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public class InheritanceConstraint
        extends PackageConstraint {
            public final int rootClass;

            public InheritanceConstraint(ClassRepr rootClass) {
                super(rootClass.getPackageName());
                this.rootClass = rootClass.name;
            }

            @Override
            public boolean checkResidence(int residence) {
                Boolean inheritorOf = Util.this.isInheritorOf(residence, this.rootClass, null);
                return (inheritorOf == null || inheritorOf == false) && super.checkResidence(residence);
            }
        }

        public class PackageConstraint
        implements UsageConstraint {
            public final String packageName;

            public PackageConstraint(String packageName) {
                this.packageName = packageName;
            }

            @Override
            public boolean checkResidence(int residence) {
                return !ClassRepr.getPackageName(Mappings.this.myContext.getValue(residence)).equals(this.packageName);
            }
        }

        public class FileFilterConstraint
        implements UsageConstraint {
            @NotNull
            private final DependentFilesFilter myFilter;

            public FileFilterConstraint(DependentFilesFilter filter) {
                if (filter == null) {
                    FileFilterConstraint.$$$reportNull$$$0(0);
                }
                this.myFilter = filter;
            }

            @Override
            public boolean checkResidence(int residence) {
                Iterable fNames = Mappings.this.classToSourceFileGet(residence);
                if (fNames == null || Iterators.isEmpty((Iterable)fNames)) {
                    return true;
                }
                for (File fName : fNames) {
                    if (!this.myFilter.accept(fName)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/jps/builders/java/dependencyView/Mappings$Util$FileFilterConstraint", "<init>"));
            }
        }
    }

    private static interface MemberComparator {
        public boolean isSame(ProtoMember var1);
    }
}

