/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs;

import com.intellij.util.indexing.InvertedIndex;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.jps.backwardRefs.index.CompilerReferenceIndex;

public class CompilerReferenceWriter<Input> {
    protected final CompilerReferenceIndex<Input> myIndex;

    public CompilerReferenceWriter(CompilerReferenceIndex<Input> index) {
        this.myIndex = index;
    }

    public void writeData(int id, Input d) {
        for (InvertedIndex<?, ?, Input> index : this.myIndex.getIndices()) {
            index.mapInputAndPrepareUpdate(id, d).compute();
        }
    }

    public synchronized int enumeratePath(String file) throws IOException {
        return this.myIndex.getFilePathEnumerator().enumerate(file);
    }

    public Throwable getRebuildRequestCause() {
        return this.myIndex.getRebuildRequestCause();
    }

    public void setRebuildCause(Throwable e) {
        this.myIndex.setRebuildRequestCause(e);
    }

    public void processDeletedFiles(Collection<String> files) throws IOException {
        for (String file : files) {
            this.writeData(this.enumeratePath(new File(file).getPath()), null);
        }
    }

    protected void close() {
        this.myIndex.close();
    }
}

