/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.api;

import com.intellij.AbstractBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JpsDynamicBundle
extends AbstractBundle {
    private static final Logger LOG = Logger.getInstance(JpsDynamicBundle.class);
    private static final Method SET_PARENT = JpsDynamicBundle.getSetParentMethod();
    private static final ClassLoader ourLangBundleLoader;

    private static Method getSetParentMethod() {
        try {
            return ReflectionUtil.getDeclaredMethod(ResourceBundle.class, (String)"setParent", (Class[])new Class[]{ResourceBundle.class});
        }
        catch (Throwable e) {
            return null;
        }
    }

    protected JpsDynamicBundle(@NonNls @NotNull String pathToBundle) {
        if (pathToBundle == null) {
            JpsDynamicBundle.$$$reportNull$$$0(0);
        }
        super(pathToBundle);
    }

    protected ResourceBundle findBundle(@NotNull @NonNls String pathToBundle, @NotNull ClassLoader loader, @NotNull ResourceBundle.Control control) {
        ResourceBundle languageBundle;
        if (pathToBundle == null) {
            JpsDynamicBundle.$$$reportNull$$$0(1);
        }
        if (loader == null) {
            JpsDynamicBundle.$$$reportNull$$$0(2);
        }
        if (control == null) {
            JpsDynamicBundle.$$$reportNull$$$0(3);
        }
        ResourceBundle base = super.findBundle(pathToBundle, loader, control);
        ClassLoader languageBundleLoader = ourLangBundleLoader;
        if (languageBundleLoader != null && (languageBundle = super.findBundle(pathToBundle, languageBundleLoader, control)) != null) {
            try {
                if (SET_PARENT != null) {
                    SET_PARENT.invoke((Object)languageBundle, base);
                }
                return languageBundle;
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
        }
        return base;
    }

    static {
        URLClassLoader loader = null;
        try {
            String bundlePath = System.getProperty("jps.language.bundle", null);
            if (bundlePath != null) {
                loader = new URLClassLoader(new URL[]{new File(bundlePath).toURI().toURL()}, null);
            }
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        finally {
            ourLangBundleLoader = loader;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBundle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/api/JpsDynamicBundle";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findBundle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

