/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.fqName;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u0006\u001a\u001c\u0010\u0007\u001a\u00020\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\b\u001a\u001a\u0010\u0007\u001a\u00020\b*\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0002\u001a&\u0010\u0007\u001a\u00020\b*\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\r\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\n2\u0006\u0010\u000f\u001a\u00020\n\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0010"}, d2={"fqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getFqName", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/name/FqName;", "getKotlinFqName", "Lcom/intellij/psi/PsiElement;", "isImported", "", "importPath", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "skipAliasedImports", "imports", "", "excludedFqNames", "alreadyImported", "kotlin.core"})
public final class FqNameUtilKt {
    @Nullable
    public static final FqName getKotlinFqName(@NotNull PsiElement $this$getKotlinFqName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getKotlinFqName, (String)"$this$getKotlinFqName");
        PsiNamedElement element2 = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)$this$getKotlinFqName);
        if (element2 instanceof PsiPackage) {
            object = new FqName(((PsiPackage)element2).getQualifiedName());
        } else if (element2 instanceof PsiClass) {
            String string = ((PsiClass)element2).getQualifiedName();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String p1 = string2;
                boolean bl3 = false;
                object = new FqName(p1);
            } else {
                object = null;
            }
        } else if (element2 instanceof PsiMember) {
            String string = element2.getName();
            if (string != null) {
                String string3;
                String prefix;
                String string4 = string;
                boolean bl = false;
                boolean bl4 = false;
                String name = string4;
                boolean bl5 = false;
                PsiClass psiClass = ((PsiMember)element2).getContainingClass();
                String string5 = prefix = psiClass != null ? psiClass.getQualifiedName() : null;
                if (prefix != null) {
                    string3 = prefix + '.' + name;
                } else {
                    String string6 = name;
                    string3 = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"name");
                }
                object = new FqName(string3);
            } else {
                object = null;
            }
        } else {
            object = element2 instanceof KtNamedDeclaration ? ((KtNamedDeclaration)element2).getFqName() : null;
        }
        return object;
    }

    public static final boolean isImported(@NotNull FqName $this$isImported, @NotNull ImportPath importPath, boolean skipAliasedImports) {
        Intrinsics.checkNotNullParameter((Object)$this$isImported, (String)"$this$isImported");
        Intrinsics.checkNotNullParameter((Object)importPath, (String)"importPath");
        return skipAliasedImports && importPath.hasAlias() ? false : (importPath.isAllUnder() && !$this$isImported.isRoot() ? Intrinsics.areEqual((Object)importPath.getFqName(), (Object)$this$isImported.parent()) : Intrinsics.areEqual((Object)importPath.getFqName(), (Object)$this$isImported));
    }

    public static /* synthetic */ boolean isImported$default(FqName fqName, ImportPath importPath, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return FqNameUtilKt.isImported(fqName, importPath, bl);
    }

    public static final boolean isImported(@NotNull ImportPath $this$isImported, @NotNull ImportPath alreadyImported) {
        Intrinsics.checkNotNullParameter((Object)$this$isImported, (String)"$this$isImported");
        Intrinsics.checkNotNullParameter((Object)alreadyImported, (String)"alreadyImported");
        return $this$isImported.isAllUnder() || $this$isImported.hasAlias() ? Intrinsics.areEqual((Object)$this$isImported, (Object)alreadyImported) : FqNameUtilKt.isImported$default($this$isImported.getFqName(), alreadyImported, false, 2, null);
    }

    private static final boolean isImported(ImportPath $this$isImported, Iterable<ImportPath> imports) {
        boolean bl;
        block3: {
            Iterable<ImportPath> $this$any$iv = imports;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<ImportPath> iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    ImportPath element$iv;
                    ImportPath it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!FqNameUtilKt.isImported($this$isImported, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isImported(@NotNull ImportPath $this$isImported, @NotNull Iterable<ImportPath> imports, @NotNull Iterable<FqName> excludedFqNames) {
        Intrinsics.checkNotNullParameter((Object)$this$isImported, (String)"$this$isImported");
        Intrinsics.checkNotNullParameter(imports, (String)"imports");
        Intrinsics.checkNotNullParameter(excludedFqNames, (String)"excludedFqNames");
        return FqNameUtilKt.isImported($this$isImported, imports) && ($this$isImported.isAllUnder() || !CollectionsKt.contains(excludedFqNames, (Object)$this$isImported.getFqName()));
    }

    @Nullable
    public static final FqName getFqName(@NotNull KotlinType $this$fqName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$fqName, (String)"$this$fqName");
        KotlinType kotlinType = $this$fqName;
        if (kotlinType instanceof AbbreviatedType) {
            object = FqNameUtilKt.getFqName((KotlinType)((AbbreviatedType)$this$fqName).getAbbreviation());
        } else {
            ClassifierDescriptor classifierDescriptor = $this$fqName.getConstructor().getDeclarationDescriptor();
            object = classifierDescriptor != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor)) : null;
        }
        return object;
    }
}

