/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.AbstractKotlinPsiChecker;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.ElementAnnotator;
import org.jetbrains.kotlin.idea.highlighter.FunctionsHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingUtil;
import org.jetbrains.kotlin.idea.highlighter.KotlinPsiCheckerKt;
import org.jetbrains.kotlin.idea.highlighter.PropertiesHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.TypeKindHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.VariablesHighlightingVisitor;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0014J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinPsiChecker;", "Lorg/jetbrains/kotlin/idea/highlighter/AbstractKotlinPsiChecker;", "()V", "annotateElement", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "containingFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "shouldHighlight", "", "file", "shouldSuppressUnusedParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "Companion", "kotlin.core"})
public class KotlinPsiChecker
extends AbstractKotlinPsiChecker {
    private static final Key<Unit> UNRESOLVED_KEY;
    public static final Companion Companion;

    protected boolean shouldHighlight(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return KotlinHighlightingUtil.INSTANCE.shouldHighlight((PsiElement)file);
    }

    protected void annotateElement(@NotNull PsiElement element2, @NotNull KtFile containingFile, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        AnalysisResult analysisResult = ResolutionUtils.analyzeWithAllCompilerChecks((KtFile)containingFile, (KtFile[])new KtFile[0]);
        if (analysisResult.isError()) {
            throw (Throwable)new ProcessCanceledException(analysisResult.getError());
        }
        BindingContext bindingContext = analysisResult.getBindingContext();
        AfterAnalysisHighlightingVisitor[] $this$forEach$iv = Companion.getAfterAnalysisVisitor(holder, bindingContext);
        boolean $i$f$forEach = false;
        AfterAnalysisHighlightingVisitor[] afterAnalysisHighlightingVisitorArray = $this$forEach$iv;
        int n = afterAnalysisHighlightingVisitorArray.length;
        for (int i = 0; i < n; ++i) {
            AfterAnalysisHighlightingVisitor element$iv;
            AfterAnalysisHighlightingVisitor visitor = element$iv = afterAnalysisHighlightingVisitorArray[i];
            boolean bl = false;
            element2.accept((PsiElementVisitor)visitor);
        }
        Diagnostics diagnostics = bindingContext.getDiagnostics();
        Intrinsics.checkNotNullExpressionValue((Object)diagnostics, (String)"bindingContext.diagnostics");
        this.annotateElement(element2, holder, diagnostics);
    }

    protected boolean shouldSuppressUnusedParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return false;
    }

    public final void annotateElement(@NotNull PsiElement element2, @NotNull AnnotationHolder holder, @NotNull Diagnostics diagnostics) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)diagnostics, (String)"diagnostics");
        Set diagnosticsForElement = CollectionsKt.toSet((Iterable)diagnostics.forElement(element2));
        if (element2 instanceof KtNameReferenceExpression) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = (Iterable)diagnostics;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Diagnostic it = (Diagnostic)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.UNRESOLVED_REFERENCE)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            boolean unresolved = bl;
            element2.putUserData(UNRESOLVED_KEY, unresolved ? Unit.INSTANCE : null);
        }
        if (diagnosticsForElement.isEmpty()) {
            return;
        }
        if (KotlinHighlightingUtil.INSTANCE.shouldHighlightErrors(element2)) {
            new ElementAnnotator(element2, holder, (Function1<? super KtParameter, Boolean>)((Function1)new Function1<KtParameter, Boolean>(this){
                final /* synthetic */ KotlinPsiChecker this$0;

                public final boolean invoke(@NotNull KtParameter param) {
                    Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                    return this.this$0.shouldSuppressUnusedParameter(param);
                }
                {
                    this.this$0 = kotlinPsiChecker;
                    super(1);
                }
            })).registerDiagnosticsAnnotations(diagnosticsForElement);
        }
    }

    static {
        Companion = new Companion(null);
        UNRESOLVED_KEY = new Key("KotlinPsiChecker.UNRESOLVED_KEY");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinPsiChecker$Companion;", "", "()V", "UNRESOLVED_KEY", "Lcom/intellij/openapi/util/Key;", "", "createQuickFixes", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getAfterAnalysisVisitor", "", "Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lcom/intellij/lang/annotation/AnnotationHolder;Lorg/jetbrains/kotlin/resolve/BindingContext;)[Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "wasUnresolved", "", "element", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "kotlin.core"})
    public static final class Companion {
        @NotNull
        public final AfterAnalysisHighlightingVisitor[] getAfterAnalysisVisitor(@NotNull AnnotationHolder holder, @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return new AfterAnalysisHighlightingVisitor[]{new PropertiesHighlightingVisitor(holder, bindingContext), new FunctionsHighlightingVisitor(holder, bindingContext), new VariablesHighlightingVisitor(holder, bindingContext), new TypeKindHighlightingVisitor(holder, bindingContext)};
        }

        @NotNull
        public final Collection<IntentionAction> createQuickFixes(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            Collection collection = KotlinPsiCheckerKt.access$createQuickFixes(CollectionsKt.listOfNotNull((Object)diagnostic)).get((Object)diagnostic);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"createQuickFixes(listOfN\u2026(diagnostic))[diagnostic]");
            return collection;
        }

        public final boolean wasUnresolved(@NotNull KtNameReferenceExpression element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            return element2.getUserData(UNRESOLVED_KEY) != null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

