/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrOperatorExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTuple;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClassTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.MethodResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.ExpectedType;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.ExpressionConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GrConstraintFormula;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSessionBuilderKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.MethodCallConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.OperatorExpressionConstraint;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0006\u001a\u0012\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\u0002\u001a\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\u0002\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\u0002\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0002\u001a\u000e\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002\u001a\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\"\u001e\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000*$\b\u0000\u0010\u001e\"\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u001f"}, d2={"ignoreFunctionalExpressions", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/ExpressionPredicate;", "buildTopLevelSession", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSession;", "place", "Lcom/intellij/psi/PsiElement;", "session", "canBeExitPoint", "element", "collectExitPoints", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrStatement;", "constructDefaultInferenceSession", "findExpression", "getArgumentExpectedType", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/ExpectedType;", "expression", "getAssignmentExpectedType", "Lcom/intellij/psi/PsiType;", "getAssignmentOrReturnExpectedType", "getAssignmentOrReturnExpectedTypeAndPosition", "getExpectedType", "getExpectedTypeAndPosition", "getMostTopLevelExpression", "start", "getReturnExpectedType", "isExitPoint", "ExpressionPredicate", "intellij.groovy.psi"})
public final class GroovyInferenceSessionBuilderKt {
    private static final Function1<GrExpression, Boolean> ignoreFunctionalExpressions = ignoreFunctionalExpressions.1.INSTANCE;

    @NotNull
    public static final GroovyInferenceSession buildTopLevelSession(@NotNull PsiElement place, @NotNull GroovyInferenceSession session) {
        GrConstraintFormula grConstraintFormula;
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        GrExpression grExpression = GroovyInferenceSessionBuilderKt.findExpression(place);
        if (grExpression == null) {
            return session;
        }
        GrExpression expression = grExpression;
        if (expression instanceof GrBinaryExpression || expression instanceof GrAssignmentExpression && ((GrAssignmentExpression)expression).isOperatorAssignment()) {
            grConstraintFormula = new OperatorExpressionConstraint((GrOperatorExpression)expression);
        } else if (expression instanceof GrSafeCastExpression && !(((GrSafeCastExpression)expression).getOperand() instanceof GrFunctionalExpression)) {
            GroovyResolveResult groovyResolveResult = ((GrSafeCastExpression)expression).getReference().advancedResolve();
            if (!(groovyResolveResult instanceof GroovyMethodResult)) {
                groovyResolveResult = null;
            }
            GroovyMethodResult groovyMethodResult = (GroovyMethodResult)groovyResolveResult;
            if (groovyMethodResult == null) {
                return session;
            }
            GroovyMethodResult result2 = groovyMethodResult;
            grConstraintFormula = new MethodCallConstraint(null, result2, expression);
        } else {
            GrExpression mostTopLevelExpression = GroovyInferenceSessionBuilderKt.getMostTopLevelExpression(expression);
            ExpectedType typeAndPosition = GroovyInferenceSessionBuilderKt.getExpectedTypeAndPosition(mostTopLevelExpression);
            grConstraintFormula = new ExpressionConstraint(typeAndPosition, mostTopLevelExpression);
        }
        GrConstraintFormula startConstraint = grConstraintFormula;
        session.addConstraint(startConstraint);
        return session;
    }

    public static /* synthetic */ GroovyInferenceSession buildTopLevelSession$default(PsiElement psiElement, GroovyInferenceSession groovyInferenceSession, int n, Object object) {
        if ((n & 2) != 0) {
            groovyInferenceSession = GroovyInferenceSessionBuilderKt.constructDefaultInferenceSession(psiElement);
        }
        return GroovyInferenceSessionBuilderKt.buildTopLevelSession(psiElement, groovyInferenceSession);
    }

    private static final GroovyInferenceSession constructDefaultInferenceSession(PsiElement place) {
        Intrinsics.checkNotNullExpressionValue((Object)PsiTypeParameter.EMPTY_ARRAY, (String)"PsiTypeParameter.EMPTY_ARRAY");
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"PsiSubstitutor.EMPTY");
        return new GroovyInferenceSession(PsiTypeParameter.EMPTY_ARRAY, psiSubstitutor, place, false, null, 16, null);
    }

    @Nullable
    public static final GrExpression findExpression(@NotNull PsiElement place) {
        GrExpression grExpression;
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        PsiElement parent2 = place.getParent();
        if (parent2 instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent2).getLValue() == place) {
            grExpression = (GrExpression)parent2;
        } else if (place instanceof GrIndexProperty) {
            grExpression = (GrExpression)place;
        } else if (parent2 instanceof GrMethodCall) {
            grExpression = (GrExpression)parent2;
        } else if (parent2 instanceof GrNewExpression) {
            grExpression = (GrExpression)parent2;
        } else if (parent2 instanceof GrClassTypeElement) {
            PsiElement psiElement = ((GrClassTypeElement)parent2).getParent();
            if (!(psiElement instanceof GrSafeCastExpression)) {
                psiElement = null;
            }
            grExpression = (GrSafeCastExpression)psiElement;
        } else {
            grExpression = place instanceof GrExpression ? (GrExpression)place : null;
        }
        return grExpression;
    }

    @NotNull
    public static final GrExpression getMostTopLevelExpression(@NotNull GrExpression start) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        GrExpression current = start;
        while (true) {
            PsiElement grandParent;
            PsiElement parent2;
            if ((parent2 = current.getParent()) instanceof GrArgumentList) {
                grandParent = ((GrArgumentList)parent2).getParent();
                if (!(grandParent instanceof GrCallExpression) || !(((GrCallExpression)grandParent).advancedResolve() instanceof MethodResolveResult)) {
                    return current;
                }
            } else {
                return current;
            }
            current = (GrCallExpression)grandParent;
        }
    }

    @Nullable
    public static final PsiType getExpectedType(@NotNull GrExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        ExpectedType expectedType = GroovyInferenceSessionBuilderKt.getExpectedTypeAndPosition(expression);
        return expectedType != null ? expectedType.getType() : null;
    }

    private static final ExpectedType getExpectedTypeAndPosition(GrExpression expression) {
        ExpectedType expectedType = GroovyInferenceSessionBuilderKt.getAssignmentOrReturnExpectedTypeAndPosition(expression);
        if (expectedType == null) {
            expectedType = GroovyInferenceSessionBuilderKt.getArgumentExpectedType(expression);
        }
        return expectedType;
    }

    private static final ExpectedType getAssignmentOrReturnExpectedTypeAndPosition(GrExpression expression) {
        ExpectedType expectedType;
        PsiType psiType = GroovyInferenceSessionBuilderKt.getAssignmentExpectedType(expression);
        if (psiType != null) {
            PsiType psiType2 = psiType;
            boolean bl = false;
            boolean bl2 = false;
            PsiType it = psiType2;
            boolean bl3 = false;
            expectedType = new ExpectedType(it, GrTypeConverter.Position.ASSIGNMENT);
        } else {
            PsiType psiType3 = GroovyInferenceSessionBuilderKt.getReturnExpectedType(expression);
            if (psiType3 != null) {
                PsiType psiType4 = psiType3;
                boolean bl = false;
                boolean bl4 = false;
                PsiType it = psiType4;
                boolean bl5 = false;
                expectedType = new ExpectedType(it, GrTypeConverter.Position.RETURN_VALUE);
            } else {
                expectedType = null;
            }
        }
        return expectedType;
    }

    @Nullable
    public static final PsiType getAssignmentOrReturnExpectedType(@NotNull GrExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        PsiType psiType = GroovyInferenceSessionBuilderKt.getAssignmentExpectedType(expression);
        if (psiType == null) {
            psiType = GroovyInferenceSessionBuilderKt.getReturnExpectedType(expression);
        }
        return psiType;
    }

    @Nullable
    public static final PsiType getAssignmentExpectedType(@NotNull GrExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        PsiElement psiElement = expression.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.parent");
        PsiElement parent2 = psiElement;
        if (parent2 instanceof GrAssignmentExpression && Intrinsics.areEqual((Object)expression, (Object)((GrAssignmentExpression)parent2).getRValue())) {
            PsiElement lValue = PsiUtil.skipParentheses(((GrAssignmentExpression)parent2).getLValue(), false);
            return lValue instanceof GrExpression && !(lValue instanceof GrIndexProperty) ? ((GrExpression)lValue).getNominalType() : null;
        }
        if (parent2 instanceof GrVariable) {
            return ((GrVariable)parent2).getDeclaredType();
        }
        if (parent2 instanceof GrListOrMap) {
            PsiElement pParent = ((GrListOrMap)parent2).getParent();
            if (pParent instanceof GrVariableDeclaration && ((GrVariableDeclaration)pParent).isTuple()) {
                Object[] objectArray = ((GrListOrMap)parent2).getInitializers();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"parent.initializers");
                int index = ArraysKt.indexOf((Object[])objectArray, (Object)expression);
                Object[] objectArray2 = ((GrVariableDeclaration)pParent).getVariables();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"pParent.variables");
                GrVariable grVariable = (GrVariable)ArraysKt.getOrNull((Object[])objectArray2, (int)index);
                return grVariable != null ? grVariable.getDeclaredType() : null;
            }
            if (pParent instanceof GrTupleAssignmentExpression) {
                GrVariable variable;
                Object[] objectArray = ((GrListOrMap)parent2).getInitializers();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"parent.initializers");
                int index = ArraysKt.indexOf((Object[])objectArray, (Object)expression);
                GrTuple grTuple = ((GrTupleAssignmentExpression)pParent).getLValue();
                Intrinsics.checkNotNullExpressionValue((Object)grTuple, (String)"pParent.lValue");
                Object[] objectArray3 = grTuple.getExpressions();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"pParent.lValue.expressions");
                Object[] expressions = objectArray3;
                GrReferenceExpression grReferenceExpression = (GrReferenceExpression)ArraysKt.getOrNull((Object[])expressions, (int)index);
                if (grReferenceExpression == null) {
                    return null;
                }
                GrReferenceExpression lValue = grReferenceExpression;
                PsiElement psiElement2 = lValue.getStaticReference().resolve();
                if (!(psiElement2 instanceof GrVariable)) {
                    psiElement2 = null;
                }
                GrVariable grVariable = variable = (GrVariable)psiElement2;
                return grVariable != null ? grVariable.getDeclaredType() : null;
            }
        }
        return null;
    }

    private static final PsiType getReturnExpectedType(GrExpression expression) {
        PsiElement psiElement = expression.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.parent");
        PsiElement parent2 = psiElement;
        GrMethod parentMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)parent2, GrMethod.class, (boolean)false, (Class[])new Class[]{GrFunctionalExpression.class});
        if (parentMethod == null) {
            return null;
        }
        if (parent2 instanceof GrReturnStatement) {
            return parentMethod.getReturnType();
        }
        if (GroovyInferenceSessionBuilderKt.isExitPoint(expression)) {
            PsiType psiType = parentMethod.getReturnType();
            if (psiType == null) {
                return null;
            }
            PsiType returnType2 = psiType;
            if (TypeConversionUtil.isVoidType((PsiType)returnType2)) {
                return null;
            }
            return returnType2;
        }
        return null;
    }

    private static final ExpectedType getArgumentExpectedType(GrExpression expression) {
        PsiElement psiElement = expression.getParent();
        if (!(psiElement instanceof GrArgumentList)) {
            psiElement = null;
        }
        GrArgumentList grArgumentList = (GrArgumentList)psiElement;
        if (grArgumentList == null) {
            return null;
        }
        GrArgumentList parent2 = grArgumentList;
        PsiElement psiElement2 = parent2.getParent();
        if (!(psiElement2 instanceof GrCallExpression)) {
            psiElement2 = null;
        }
        GrCallExpression grCallExpression = (GrCallExpression)psiElement2;
        if (grCallExpression == null) {
            return null;
        }
        GrCallExpression call = grCallExpression;
        GroovyResolveResult groovyResolveResult = call.advancedResolve();
        if (!(groovyResolveResult instanceof GroovyMethodResult)) {
            groovyResolveResult = null;
        }
        GroovyMethodResult groovyMethodResult = (GroovyMethodResult)groovyResolveResult;
        if (groovyMethodResult == null) {
            return null;
        }
        GroovyMethodResult result2 = groovyMethodResult;
        Object object = result2.getCandidate();
        if (object == null || (object = object.getArgumentMapping()) == null) {
            return null;
        }
        Object mapping2 = object;
        PsiType psiType = result2.getSubstitutor().substitute(mapping2.expectedType(new ExpressionArgument(expression)));
        if (psiType == null) {
            return null;
        }
        PsiType type2 = psiType;
        return new ExpectedType(type2, GrTypeConverter.Position.METHOD_PARAMETER);
    }

    private static final boolean isExitPoint(GrExpression place) {
        return GroovyInferenceSessionBuilderKt.collectExitPoints(place).contains(place);
    }

    private static final List<GrStatement> collectExitPoints(GrExpression place) {
        List<GrStatement> list;
        if (GroovyInferenceSessionBuilderKt.canBeExitPoint(place)) {
            GrControlFlowOwner flowOwner = ControlFlowUtils.findControlFlowOwner(place);
            List<GrStatement> list2 = ControlFlowUtils.collectReturns(flowOwner);
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"ControlFlowUtils.collectReturns(flowOwner)");
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final boolean canBeExitPoint(PsiElement element) {
        for (PsiElement place = element; place != null; place = place.getParent()) {
            if (place instanceof GrMethod || place instanceof GrFunctionalExpression || place instanceof GrClassInitializer) {
                return true;
            }
            if (!(place instanceof GrThrowStatement) && !(place instanceof GrTypeDefinitionBody) && !(place instanceof GroovyFile)) continue;
            return false;
        }
        return false;
    }

    public static final /* synthetic */ Function1 access$getIgnoreFunctionalExpressions$p() {
        return ignoreFunctionalExpressions;
    }
}

