/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ArgumentsInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.FunctionalExpressionFlowUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InvocationKind;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ResolvedVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.DFAFlowInfo;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.InferenceCache;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeAugmenter;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaInstanceUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaState;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;

class TypeDfaInstance
implements DfaInstance<TypeDfaState> {
    private final Instruction[] myFlow;
    private final DFAFlowInfo myFlowInfo;
    private final InferenceCache myCache;
    private final PsiManager myManager;
    private final int lastInterestingInstructionIndex;

    TypeDfaInstance(Instruction @NotNull [] flow, @NotNull DFAFlowInfo flowInfo, @NotNull InferenceCache cache2, @NotNull PsiManager manager) {
        if (flowInfo == null) {
            TypeDfaInstance.$$$reportNull$$$0(0);
        }
        if (cache2 == null) {
            TypeDfaInstance.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            TypeDfaInstance.$$$reportNull$$$0(2);
        }
        if (flow == null) {
            TypeDfaInstance.$$$reportNull$$$0(3);
        }
        this.myFlow = flow;
        this.myManager = manager;
        this.myFlowInfo = flowInfo;
        this.myCache = cache2;
        this.lastInterestingInstructionIndex = flowInfo.getInterestingInstructions().stream().mapToInt(Instruction::num).max().orElse(0);
    }

    @Override
    public void fun(@NotNull TypeDfaState state, @NotNull Instruction instruction) {
        if (state == null) {
            TypeDfaInstance.$$$reportNull$$$0(4);
        }
        if (instruction == null) {
            TypeDfaInstance.$$$reportNull$$$0(5);
        }
        if (instruction instanceof ReadWriteVariableInstruction) {
            this.handleReadWriteVariable(state, (ReadWriteVariableInstruction)instruction);
        } else if (instruction instanceof MixinTypeInstruction) {
            this.handleMixin(state, (MixinTypeInstruction)instruction);
        } else if (instruction instanceof ArgumentsInstruction) {
            this.handleArguments(state, (ArgumentsInstruction)instruction);
        } else if (instruction instanceof NegatingGotoInstruction) {
            TypeDfaInstance.handleNegation(state, (NegatingGotoInstruction)instruction);
        } else if (instruction.getElement() instanceof GrFunctionalExpression) {
            this.handleFunctionalExpression(state, instruction);
        }
    }

    private void handleMixin(@NotNull TypeDfaState state, @NotNull MixinTypeInstruction instruction) {
        VariableDescriptor descriptor;
        if (state == null) {
            TypeDfaInstance.$$$reportNull$$$0(6);
        }
        if (instruction == null) {
            TypeDfaInstance.$$$reportNull$$$0(7);
        }
        if ((descriptor = instruction.getVariableDescriptor()) == null) {
            return;
        }
        this.updateVariableType(state, instruction, descriptor, (Computable<DFAType>)((Computable)() -> {
            ReadWriteVariableInstruction originalInstr = instruction.getInstructionToMixin(this.myFlow);
            assert (originalInstr != null && !originalInstr.isWrite());
            DFAType original = state.getOrCreateVariableType(descriptor);
            original.addMixin(instruction.inferMixinType(), instruction.getConditionInstruction());
            return original;
        }));
    }

    private void handleReadWriteVariable(@NotNull TypeDfaState state, @NotNull ReadWriteVariableInstruction instruction) {
        PsiElement element;
        if (state == null) {
            TypeDfaInstance.$$$reportNull$$$0(8);
        }
        if (instruction == null) {
            TypeDfaInstance.$$$reportNull$$$0(9);
        }
        if ((element = instruction.getElement()) == null) {
            return;
        }
        VariableDescriptor descriptor = instruction.getDescriptor();
        if (instruction.isWrite()) {
            this.updateVariableType(state, instruction, descriptor, (Computable<DFAType>)((Computable)() -> {
                PsiType initializerType = TypeInferenceHelper.getInitializerType(element);
                if (initializerType == null && descriptor instanceof ResolvedVariableDescriptor) {
                    GrVariable variable = ((ResolvedVariableDescriptor)descriptor).getVariable();
                    PsiType augmentedType = TypeAugmenter.Companion.inferAugmentedType(variable);
                    return DFAType.create(augmentedType);
                }
                return DFAType.create(initializerType);
            }));
        }
    }

    private void handleArguments(TypeDfaState state, ArgumentsInstruction instruction) {
        for (Map.Entry<VariableDescriptor, Collection<Argument>> entry : instruction.getArguments().entrySet()) {
            VariableDescriptor descriptor = entry.getKey();
            Collection<Argument> arguments2 = entry.getValue();
            this.handleArgument(state, instruction, descriptor, arguments2);
        }
    }

    private void handleArgument(TypeDfaState state, ArgumentsInstruction instruction, VariableDescriptor descriptor, Collection<Argument> arguments2) {
        this.updateVariableType(state, instruction, descriptor, (Computable<DFAType>)((Computable)() -> {
            GroovyResolveResult[] results;
            DFAType result2 = state.getOrCreateVariableType(descriptor);
            for (GroovyResolveResult variant : results = instruction.getElement().multiResolve(false)) {
                ArgumentMapping<PsiCallParameter> mapping2;
                GroovyMethodCandidate candidate;
                if (!(variant instanceof GroovyMethodResult) || (candidate = ((GroovyMethodResult)variant).getCandidate()) == null || (mapping2 = candidate.getArgumentMapping()) == null) continue;
                for (Argument argument : arguments2) {
                    PsiType parameterType = mapping2.expectedType(argument);
                    if (parameterType == null) continue;
                    PsiType typeToMixin = variant.getSubstitutor().substitute(parameterType);
                    result2.addMixin(typeToMixin, null);
                }
            }
            return result2;
        }));
    }

    private void updateVariableType(@NotNull TypeDfaState state, @NotNull Instruction instruction, @NotNull VariableDescriptor descriptor, @NotNull Computable<DFAType> computation) {
        DFAType existingDfaType;
        if (state == null) {
            TypeDfaInstance.$$$reportNull$$$0(10);
        }
        if (instruction == null) {
            TypeDfaInstance.$$$reportNull$$$0(11);
        }
        if (descriptor == null) {
            TypeDfaInstance.$$$reportNull$$$0(12);
        }
        if (computation == null) {
            TypeDfaInstance.$$$reportNull$$$0(13);
        }
        if (!this.myFlowInfo.getInterestingInstructions().contains(instruction)) {
            state.removeBinding(descriptor);
            return;
        }
        state.restoreBinding(descriptor);
        DFAType type2 = this.myCache.getCachedInferredType(descriptor, instruction);
        if (type2 == null) {
            type2 = this.myFlowInfo.getAcyclicInstructions().contains(instruction) && !this.myFlowInfo.getDependentOnSharedVariables().contains(instruction) ? (DFAType)computation.compute() : TypeInferenceHelper.doInference(state.getBindings(), true, computation);
        }
        if ((existingDfaType = state.getVariableType(descriptor)) != null) {
            type2 = type2.addFlushingType(existingDfaType.getFlushingType(), this.myManager);
        }
        state.putType(descriptor, type2);
    }

    private static void handleNegation(@NotNull TypeDfaState state, @NotNull NegatingGotoInstruction negation) {
        if (state == null) {
            TypeDfaInstance.$$$reportNull$$$0(14);
        }
        if (negation == null) {
            TypeDfaInstance.$$$reportNull$$$0(15);
        }
        for (Map.Entry<VariableDescriptor, DFAType> entry : state.getVarTypes().entrySet()) {
            entry.setValue(entry.getValue().negate(negation));
        }
    }

    private void handleFunctionalExpression(@NotNull TypeDfaState state, @NotNull Instruction instruction) {
        if (state == null) {
            TypeDfaInstance.$$$reportNull$$$0(16);
        }
        if (instruction == null) {
            TypeDfaInstance.$$$reportNull$$$0(17);
        }
        if (!FunctionalExpressionFlowUtil.isNestedFlowProcessingAllowed()) {
            return;
        }
        GrFunctionalExpression block = Objects.requireNonNull((GrFunctionalExpression)instruction.getElement());
        if (PsiUtil.isCompileStatic(block)) {
            return;
        }
        GrControlFlowOwner blockFlowOwner = FunctionalExpressionFlowUtil.getControlFlowOwner(block);
        if (blockFlowOwner == null) {
            return;
        }
        if (!this.myFlowInfo.getInterestingInstructions().contains(instruction)) {
            ControlFlowUtils.getForeignVariableDescriptors(blockFlowOwner).forEach(state::removeBinding);
            return;
        }
        if (instruction.num() > this.lastInterestingInstructionIndex) {
            return;
        }
        ControlFlowUtils.getForeignVariableDescriptors(blockFlowOwner).forEach(state::restoreBinding);
        InvocationKind kind = FunctionalExpressionFlowUtil.getInvocationKind(block);
        Map<VariableDescriptor, DFAType> initialTypes = state.getVarTypes();
        switch (kind) {
            case IN_PLACE_ONCE: {
                this.handleClosureDFAResult(instruction, blockFlowOwner, initialTypes, state::putType);
                break;
            }
            case IN_PLACE_UNKNOWN: {
                this.handleClosureDFAResult(instruction, blockFlowOwner, initialTypes, (descriptor, dfaType) -> {
                    DFAType existingType = state.getVariableType((VariableDescriptor)descriptor);
                    if (existingType != null) {
                        DFAType mergedType = DFAType.create(dfaType, existingType, block.getManager());
                        state.putType((VariableDescriptor)descriptor, mergedType);
                    }
                });
                break;
            }
            case UNKNOWN: {
                this.runWithCycleCheck(instruction, () -> {
                    for (VariableDescriptor descriptor : this.myFlowInfo.getInterestingDescriptors()) {
                        PsiType upperBoundByWrites = TypeDfaInstanceUtilKt.getLeastUpperBoundByAllWrites(blockFlowOwner, initialTypes, descriptor);
                        if (upperBoundByWrites == PsiType.NULL) continue;
                        DFAType existingType = state.getVariableType(descriptor);
                        if (existingType == null) {
                            existingType = DFAType.create(null);
                        }
                        DFAType flushedType = existingType.addFlushingType(upperBoundByWrites, this.myManager);
                        state.putType(descriptor, flushedType);
                    }
                    return null;
                });
            }
        }
    }

    private void handleClosureDFAResult(@NotNull Instruction instruction, @NotNull GrControlFlowOwner block, @NotNull Map<VariableDescriptor, DFAType> initialTypes, @NotNull BiConsumer<? super VariableDescriptor, ? super DFAType> typeConsumer) {
        if (instruction == null) {
            TypeDfaInstance.$$$reportNull$$$0(18);
        }
        if (block == null) {
            TypeDfaInstance.$$$reportNull$$$0(19);
        }
        if (initialTypes == null) {
            TypeDfaInstance.$$$reportNull$$$0(20);
        }
        if (typeConsumer == null) {
            TypeDfaInstance.$$$reportNull$$$0(21);
        }
        InferenceCache blockCache = TypeInferenceHelper.getInferenceCache(block);
        Instruction[] blockFlow = block.getControlFlow();
        Instruction lastBlockInstruction = blockFlow[blockFlow.length - 1];
        this.runWithCycleCheck(instruction, () -> {
            for (VariableDescriptor outerDescriptor : this.myFlowInfo.getInterestingDescriptors()) {
                PsiType descriptorType = blockCache.getInferredType(outerDescriptor, lastBlockInstruction, false, initialTypes);
                if (descriptorType == null) continue;
                typeConsumer.accept(outerDescriptor, DFAType.create(descriptorType));
            }
            return null;
        });
    }

    private void runWithCycleCheck(@NotNull Instruction instruction, @NotNull Computable<?> action) {
        if (instruction == null) {
            TypeDfaInstance.$$$reportNull$$$0(22);
        }
        if (action == null) {
            TypeDfaInstance.$$$reportNull$$$0(23);
        }
        if (this.myFlowInfo.getAcyclicInstructions().contains(instruction)) {
            action.get();
        } else {
            TypeInferenceHelper.doInference(Collections.emptyMap(), false, action);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flowInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "negation";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialTypes";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeConsumer";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeDfaInstance";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fun";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "handleMixin";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "handleReadWriteVariable";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "updateVariableType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "handleNegation";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "handleFunctionalExpression";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "handleClosureDFAResult";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithCycleCheck";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

