/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;

public class GrHighlightExitPointHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    private final PsiElement myTarget;

    protected GrHighlightExitPointHandler(Editor editor, PsiFile file, PsiElement target) {
        super(editor, file);
        this.myTarget = target;
    }

    @NotNull
    public List<PsiElement> getTargets() {
        List<PsiElement> list = Collections.singletonList(this.myTarget);
        if (list == null) {
            GrHighlightExitPointHandler.$$$reportNull$$$0(0);
        }
        return list;
    }

    protected void selectTargets(@NotNull List<? extends PsiElement> targets, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
        if (targets == null) {
            GrHighlightExitPointHandler.$$$reportNull$$$0(1);
        }
        if (selectionConsumer == null) {
            GrHighlightExitPointHandler.$$$reportNull$$$0(2);
        }
        selectionConsumer.consume(targets);
    }

    public void computeUsages(@NotNull List<? extends PsiElement> targets) {
        PsiElement parent2;
        if (targets == null) {
            GrHighlightExitPointHandler.$$$reportNull$$$0(3);
        }
        if (!((parent2 = this.myTarget.getParent()) instanceof GrReturnStatement) && !(parent2 instanceof GrThrowStatement)) {
            return;
        }
        GrControlFlowOwner flowOwner = ControlFlowUtils.findControlFlowOwner(parent2);
        ControlFlowUtils.visitAllExitPoints(flowOwner, new ControlFlowUtils.ExitPointVisitor(){

            @Override
            public boolean visitExitPoint(Instruction instruction, @Nullable GrExpression returnValue) {
                PsiElement returnElement = instruction.getElement();
                if (returnElement != null && GrHighlightExitPointHandler.isCorrectReturn(returnElement)) {
                    TextRange range = returnElement.getTextRange();
                    GrHighlightExitPointHandler.this.myReadUsages.add(range);
                }
                return true;
            }
        });
    }

    private static boolean isCorrectReturn(@Nullable PsiElement e) {
        return e instanceof GrReturnStatement || e instanceof GrThrowStatement || e instanceof GrExpression;
    }

    @Nullable
    public String getFeatureId() {
        return "codeassists.highlight.return";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/findUsages/GrHighlightExitPointHandler";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/findUsages/GrHighlightExitPointHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectTargets";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

