/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.extensions;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.search.GlobalSearchScope;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public abstract class GroovyScriptTypeDetector {
    public static final ExtensionPointName<GroovyScriptTypeDetector> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.scriptTypeDetector");
    private final GroovyScriptType myScriptType;

    protected GroovyScriptTypeDetector(@NotNull GroovyScriptType scriptType) {
        if (scriptType == null) {
            GroovyScriptTypeDetector.$$$reportNull$$$0(0);
        }
        this.myScriptType = scriptType;
    }

    @NotNull
    public final GroovyScriptType getScriptType() {
        GroovyScriptType groovyScriptType = this.myScriptType;
        if (groovyScriptType == null) {
            GroovyScriptTypeDetector.$$$reportNull$$$0(1);
        }
        return groovyScriptType;
    }

    public abstract boolean isSpecificScriptFile(@NotNull GroovyFile var1);

    @Nullable
    public static GroovyScriptType getScriptType(@NotNull GroovyFile file) {
        if (file == null) {
            GroovyScriptTypeDetector.$$$reportNull$$$0(2);
        }
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])EP_NAME.getExtensions()) {
            if (!detector.isSpecificScriptFile(file)) continue;
            return detector.getScriptType();
        }
        return null;
    }

    public static boolean isScriptFile(@NotNull GroovyFile file) {
        if (file == null) {
            GroovyScriptTypeDetector.$$$reportNull$$$0(3);
        }
        return file.isScript() && GroovyScriptTypeDetector.getScriptType(file) != null;
    }

    @NotNull
    public static Icon getIcon(@NotNull GroovyFile file) {
        GroovyScriptType scriptType;
        if (file == null) {
            GroovyScriptTypeDetector.$$$reportNull$$$0(4);
        }
        Icon icon = (scriptType = GroovyScriptTypeDetector.getScriptType(file)) == null ? JetgroovyIcons.Groovy.GroovyFile : scriptType.getScriptIcon();
        if (icon == null) {
            GroovyScriptTypeDetector.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @NotNull
    public static GlobalSearchScope patchResolveScope(@NotNull GroovyFile script, @NotNull GlobalSearchScope scope) {
        GroovyScriptType scriptType;
        if (script == null) {
            GroovyScriptTypeDetector.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            GroovyScriptTypeDetector.$$$reportNull$$$0(7);
        }
        GlobalSearchScope globalSearchScope = (scriptType = GroovyScriptTypeDetector.getScriptType(script)) == null ? scope : scriptType.patchResolveScope(script, scope);
        if (globalSearchScope == null) {
            GroovyScriptTypeDetector.$$$reportNull$$$0(8);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptType";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "patchResolveScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getScriptType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isScriptFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "patchResolveScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

