/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebuggerEvaluator;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.evaluate.quick.XValueHint;
import com.intellij.xdebugger.impl.ui.tree.nodes.EvaluatingExpressionRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.evaluate.Key;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerEvaluator;", "Lcom/intellij/debugger/engine/JavaDebuggerEvaluator;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "stackFrame", "Lcom/intellij/debugger/engine/JavaStackFrame;", "(Lcom/intellij/debugger/engine/DebugProcessImpl;Lcom/intellij/debugger/engine/JavaStackFrame;)V", "types", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/Key;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerEvaluator$EvaluationType;", "evaluate", "", "expression", "Lcom/intellij/xdebugger/XExpression;", "callback", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator$XEvaluationCallback;", "expressionPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "getType", "text", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "EvaluationType", "kotlin.jvm-debugger.util"})
public final class KotlinDebuggerEvaluator
extends JavaDebuggerEvaluator {
    private final HashMap<Key, EvaluationType> types = new HashMap();

    @NotNull
    public final EvaluationType getType(@NotNull TextWithImports text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        EvaluationType evaluationType = this.types.get(new Key(text));
        if (evaluationType == null) {
            evaluationType = EvaluationType.UNKNOWN;
        }
        return evaluationType;
    }

    public void evaluate(@NotNull XExpression expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Key key = new Key(expression);
        EvaluationType type = this.getType(callback);
        if (type != null) {
            ((Map)this.types).put(key, type);
        }
        XDebuggerEvaluator.XEvaluationCallback wrappedCallback2 = new XDebuggerEvaluator.XEvaluationCallback(this, key, callback){
            final /* synthetic */ KotlinDebuggerEvaluator this$0;
            final /* synthetic */ Key $key;
            final /* synthetic */ XDebuggerEvaluator.XEvaluationCallback $callback;

            public void errorOccurred(@NotNull String errorMessage) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                KotlinDebuggerEvaluator.access$getTypes$p(this.this$0).remove(this.$key);
                this.$callback.errorOccurred(errorMessage);
            }

            public void evaluated(@NotNull XValue result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                KotlinDebuggerEvaluator.access$getTypes$p(this.this$0).remove(this.$key);
                this.$callback.evaluated(result);
            }
            {
                this.this$0 = this$0;
                this.$key = $captured_local_variable$1;
                this.$callback = $captured_local_variable$2;
            }
        };
        super.evaluate(expression, wrappedCallback2, expressionPosition);
    }

    private final EvaluationType getType(XDebuggerEvaluator.XEvaluationCallback callback) {
        String name = callback.getClass().getName();
        for (EvaluationType value : EvaluationType.values()) {
            Class<?> clazz;
            if (value.getClazz() == null) {
                continue;
            }
            String string = name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            String string2 = clazz.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"clazz.name");
            if (!StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) continue;
            return value;
        }
        return null;
    }

    public KotlinDebuggerEvaluator(@Nullable DebugProcessImpl debugProcess, @Nullable JavaStackFrame stackFrame) {
        super(debugProcess, stackFrame);
    }

    public static final /* synthetic */ HashMap access$getTypes$p(KotlinDebuggerEvaluator $this) {
        return $this.types;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerEvaluator$EvaluationType;", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;ILjava/lang/Class;)V", "getClazz", "()Ljava/lang/Class;", "WATCH", "WINDOW", "POPUP", "FROM_JAVA", "UNKNOWN", "kotlin.jvm-debugger.util"})
    public static final class EvaluationType
    extends Enum<EvaluationType> {
        public static final /* enum */ EvaluationType WATCH;
        public static final /* enum */ EvaluationType WINDOW;
        public static final /* enum */ EvaluationType POPUP;
        public static final /* enum */ EvaluationType FROM_JAVA;
        public static final /* enum */ EvaluationType UNKNOWN;
        private static final /* synthetic */ EvaluationType[] $VALUES;
        @Nullable
        private final Class<?> clazz;

        static {
            EvaluationType[] evaluationTypeArray = new EvaluationType[5];
            EvaluationType[] evaluationTypeArray2 = evaluationTypeArray;
            evaluationTypeArray[0] = WATCH = new EvaluationType(WatchNodeImpl.class);
            evaluationTypeArray[1] = WINDOW = new EvaluationType(EvaluatingExpressionRootNode.class);
            evaluationTypeArray[2] = POPUP = new EvaluationType(XValueHint.class);
            evaluationTypeArray[3] = FROM_JAVA = new EvaluationType(null);
            evaluationTypeArray[4] = UNKNOWN = new EvaluationType(null);
            $VALUES = evaluationTypeArray;
        }

        @Nullable
        public final Class<?> getClazz() {
            return this.clazz;
        }

        private EvaluationType(Class<?> clazz) {
            this.clazz = clazz;
        }

        public static EvaluationType[] values() {
            return (EvaluationType[])$VALUES.clone();
        }

        public static EvaluationType valueOf(String string) {
            return Enum.valueOf(EvaluationType.class, string);
        }
    }
}

