/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TestDialog;
import com.intellij.openapi.ui.TestInputDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class TestDialogManager {
    private static TestDialog implementation;
    private static TestInputDialog inputImplementation;

    @TestOnly
    public static TestDialog setTestDialog(@Nullable TestDialog newValue) {
        TestDialogManager.checkUnitTestMode();
        TestDialog oldValue = implementation;
        implementation = newValue;
        return oldValue;
    }

    @NotNull
    public static TestDialog getTestImplementation() {
        TestDialog result = implementation;
        TestDialog testDialog = result == null ? TestDialog.DEFAULT : result;
        if (testDialog == null) {
            TestDialogManager.$$$reportNull$$$0(0);
        }
        return testDialog;
    }

    public static TestInputDialog getTestInputImplementation() {
        TestInputDialog result = inputImplementation;
        return result == null ? TestInputDialog.DEFAULT : result;
    }

    @TestOnly
    public static TestInputDialog setTestInputDialog(@Nullable TestInputDialog newValue) {
        TestDialogManager.checkUnitTestMode();
        TestInputDialog oldValue = inputImplementation;
        inputImplementation = newValue;
        return oldValue;
    }

    private static void checkUnitTestMode() {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            Logger.getInstance(Messages.class).assertTrue(application.isUnitTestMode(), (Object)"This method is available for tests only");
        }
    }

    static {
        inputImplementation = TestInputDialog.DEFAULT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/TestDialogManager", "getTestImplementation"));
    }
}

