/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Trinity;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u0015\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0018\u001a\f0\u0019R\b\u0012\u0004\u0012\u00028\u00000\u0000J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/codegen/FrameMapBase;", "T", "", "()V", "<set-?>", "", "currentSize", "getCurrentSize", "()I", "myVarIndex", "Lgnu/trove/TObjectIntHashMap;", "myVarSizes", "enter", "key", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Ljava/lang/Object;Lorg/jetbrains/org/objectweb/asm/Type;)I", "enterTemp", "getIndex", "descriptor", "(Ljava/lang/Object;)I", "leave", "leaveTemp", "", "mark", "Lorg/jetbrains/kotlin/codegen/FrameMapBase$Mark;", "toString", "", "Mark", "backend"})
public class FrameMapBase<T> {
    private final TObjectIntHashMap<T> myVarIndex = new TObjectIntHashMap();
    private final TObjectIntHashMap<T> myVarSizes = new TObjectIntHashMap();
    private int currentSize;

    public final int getCurrentSize() {
        return this.currentSize;
    }

    public int enter(@NotNull T key, @NotNull Type type2) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        int index2 = this.currentSize;
        this.myVarIndex.put(key, index2);
        this.currentSize += type2.getSize();
        this.myVarSizes.put(key, type2.getSize());
        return index2;
    }

    public int leave(@NotNull T key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int size2 = this.myVarSizes.get(key);
        this.currentSize -= size2;
        this.myVarSizes.remove(key);
        int oldIndex = this.myVarIndex.remove(key);
        if (oldIndex != this.currentSize) {
            throw (Throwable)new IllegalStateException("Descriptor can be left only if it is last: " + key);
        }
        return oldIndex;
    }

    public final int enterTemp(@NotNull Type type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        int result2 = this.currentSize;
        this.currentSize += type2.getSize();
        return result2;
    }

    public final void leaveTemp(@NotNull Type type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.currentSize -= type2.getSize();
    }

    public int getIndex(@NotNull T descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, (String)"descriptor");
        return this.myVarIndex.contains(descriptor2) ? this.myVarIndex.get(descriptor2) : -1;
    }

    @NotNull
    public final Mark mark() {
        return new Mark(this.currentSize);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.myVarIndex.size() != this.myVarSizes.size()) {
            return "inconsistent";
        }
        ArrayList descriptors = Lists.newArrayList();
        for (Object descriptor0 : this.myVarIndex.keys()) {
            Object descriptor2;
            if (descriptor0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type T");
            }
            int varIndex = this.myVarIndex.get(descriptor2);
            int varSize = this.myVarSizes.get(descriptor2);
            descriptors.add(Trinity.create((Object)descriptor2, (Object)varIndex, (Object)varSize));
        }
        ArrayList arrayList = descriptors;
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"descriptors");
        List $this$sortBy$iv = arrayList;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            boolean bl = false;
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Trinity left = (Trinity)a;
                    boolean bl2 = false;
                    left = (Trinity)b;
                    Comparable comparable = (Integer)left.second;
                    bl2 = false;
                    Integer n = (Integer)left.second;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
                }
            });
        }
        sb.append("size=").append(this.currentSize);
        boolean first = true;
        for (Trinity t : descriptors) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            StringBuilder stringBuilder2 = sb.append(t.first).append(",i=");
            Object object = t.second;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"t.second");
            StringBuilder stringBuilder3 = stringBuilder2.append(((Number)object).intValue()).append(",s=");
            Object object2 = t.third;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"t.third");
            stringBuilder3.append(((Number)object2).intValue());
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        return string2;
    }

    public static final /* synthetic */ int access$getCurrentSize$p(FrameMapBase $this) {
        return $this.currentSize;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/codegen/FrameMapBase$Mark;", "", "myIndex", "", "(Lorg/jetbrains/kotlin/codegen/FrameMapBase;I)V", "dropTo", "", "backend"})
    public final class Mark {
        private final int myIndex;

        public final void dropTo() {
            ArrayList<Object> descriptorsToDrop = new ArrayList<Object>();
            TObjectIntIterator iterator2 = FrameMapBase.this.myVarIndex.iterator();
            while (iterator2.hasNext()) {
                iterator2.advance();
                if (iterator2.value() < this.myIndex) continue;
                descriptorsToDrop.add(iterator2.key());
            }
            for (Object e : descriptorsToDrop) {
                FrameMapBase.this.myVarIndex.remove(e);
                FrameMapBase.this.myVarSizes.remove(e);
            }
            FrameMapBase.this.currentSize = this.myIndex;
        }

        public Mark(int myIndex) {
            this.myIndex = myIndex;
        }
    }
}

