/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.targets;

import com.intellij.util.Consumer;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsUrlList;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.build.JsBuildMetaInfo;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinCompilerRunner;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.IncrementalJsCache;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProviderFromCache;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumerImpl;
import org.jetbrains.kotlin.jps.build.JpsUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolder;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalJsCache;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.utils.JsLibraryUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\r012\u0006\u00102\u001a\u00020\u001fH\u0002J \u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020-H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u00020-H\u0016J8\u0010@\u001a\u00020-2\u0006\u0010A\u001a\u00020B2\u0016\u0010C\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0001\u0012\u0004\u0012\u00020E0D2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0016J6\u0010J\u001a\u00020-2\u0006\u00106\u001a\u0002072\u0006\u0010K\u001a\u00020E2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020M0\u00112\u0006\u0010N\u001a\u00020O2\u0006\u00108\u001a\u000209H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 R\u0014\u0010!\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010 R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0013R\u0011\u0010$\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001dR\u0014\u0010&\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000fR\u0011\u0010(\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001dR\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0013\u00a8\u0006P"}, d2={"Lorg/jetbrains/kotlin/jps/targets/KotlinJsModuleBuildTarget;", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "Lorg/jetbrains/kotlin/build/JsBuildMetaInfo;", "kotlinContext", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "jpsModuleBuildTarget", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "(Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;Lorg/jetbrains/jps/incremental/ModuleBuildTarget;)V", "buildMetaInfoFactory", "Lorg/jetbrains/kotlin/build/JsBuildMetaInfo$Companion;", "getBuildMetaInfoFactory", "()Lorg/jetbrains/kotlin/build/JsBuildMetaInfo$Companion;", "buildMetaInfoFileName", "", "getBuildMetaInfoFileName", "()Ljava/lang/String;", "dependenciesMetaFiles", "", "getDependenciesMetaFiles", "()Ljava/util/List;", "explicitOutputPath", "getExplicitOutputPath", "friendBuildTargetsMetaFiles", "getFriendBuildTargetsMetaFiles", "globalLookupCacheId", "getGlobalLookupCacheId", "implicitOutputFile", "Ljava/io/File;", "getImplicitOutputFile", "()Ljava/io/File;", "isFirstBuild", "", "()Z", "isIncrementalCompilationEnabled", "libraryFiles", "getLibraryFiles", "outputFile", "getOutputFile", "outputFileBaseName", "getOutputFileBaseName", "outputMetaFile", "getOutputMetaFile", "sourceMapRoots", "getSourceMapRoots", "addDependencyMetaFile", "", "module", "Lorg/jetbrains/jps/model/module/JpsModule;", "result", "", "isTests", "compileModuleChunk", "commonArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "dirtyFilesHolder", "Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "copyJsLibraryFilesIfNeeded", "createCacheStorage", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalJsCache;", "paths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "doAfterBuild", "makeServices", "builder", "Lorg/jetbrains/kotlin/config/Services$Builder;", "incrementalCaches", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCache;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "exceptActualTracer", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "updateCaches", "jpsIncrementalCache", "files", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "kotlin.jps-plugin"})
public final class KotlinJsModuleBuildTarget
extends KotlinModuleBuildTarget<JsBuildMetaInfo> {
    @Override
    @NotNull
    public String getGlobalLookupCacheId() {
        return "js";
    }

    @Override
    public boolean isIncrementalCompilationEnabled() {
        return IncrementalCompilation.isEnabledForJs();
    }

    @NotNull
    public JsBuildMetaInfo.Companion getBuildMetaInfoFactory() {
        return JsBuildMetaInfo.Companion;
    }

    @Override
    @NotNull
    public String getBuildMetaInfoFileName() {
        return "js-build-meta-info.txt";
    }

    public final boolean isFirstBuild() {
        File targetDataRoot;
        BuildDataManager buildDataManager = this.getJpsGlobalContext().getProjectDescriptor().dataManager;
        Intrinsics.checkNotNullExpressionValue((Object)buildDataManager, (String)"jpsGlobalContext.projectDescriptor.dataManager");
        File file2 = targetDataRoot = buildDataManager.getDataPaths().getTargetDataRoot((BuildTarget)this.getJpsModuleBuildTarget());
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"targetDataRoot");
        return !IncrementalJsCache.Companion.hasHeaderFile(file2);
    }

    @Override
    public void makeServices(@NotNull Services.Builder builder, @NotNull Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches, @NotNull LookupTracker lookupTracker, @NotNull ExpectActualTracker exceptActualTracer) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(incrementalCaches, (String)"incrementalCaches");
        Intrinsics.checkNotNullParameter((Object)lookupTracker, (String)"lookupTracker");
        Intrinsics.checkNotNullParameter((Object)exceptActualTracer, (String)"exceptActualTracer");
        super.makeServices(builder, incrementalCaches, lookupTracker, exceptActualTracer);
        boolean bl = false;
        boolean bl2 = false;
        Services.Builder $this$with = builder;
        boolean bl3 = false;
        $this$with.register(IncrementalResultsConsumer.class, new IncrementalResultsConsumerImpl());
        if (this.isIncrementalCompilationEnabled() && !this.isFirstBuild()) {
            JpsIncrementalCache jpsIncrementalCache = incrementalCaches.get(this);
            if (jpsIncrementalCache == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.incremental.IncrementalJsCache");
            }
            IncrementalJsCache cache = (IncrementalJsCache)((Object)jpsIncrementalCache);
            $this$with.register(IncrementalDataProvider.class, new IncrementalDataProviderFromCache(cache));
        }
    }

    @Override
    public boolean compileModuleChunk(@NotNull CommonCompilerArguments commonArguments, @NotNull KotlinDirtySourceFilesHolder dirtyFilesHolder2, @NotNull JpsCompilerEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)commonArguments, (String)"commonArguments");
        Intrinsics.checkNotNullParameter((Object)dirtyFilesHolder2, (String)"dirtyFilesHolder");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        boolean bl = Intrinsics.areEqual(this.getChunk().getRepresentativeTarget(), (Object)this);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        if (this.reportAndSkipCircular(environment)) {
            return false;
        }
        KotlinModuleBuildTarget.SourcesToCompile sources = this.collectSourcesToCompile(dirtyFilesHolder2);
        if (!sources.logFiles()) {
            return false;
        }
        List libraries = CollectionsKt.plus((Collection)this.getLibraryFiles(), (Iterable)this.getDependenciesMetaFiles());
        new JpsKotlinCompilerRunner().runK2JsCompiler(commonArguments, ModuleSettingsKt.getK2JsCompilerArguments(this.getModule()), ModuleSettingsKt.getKotlinCompilerSettings(this.getModule()), environment, (Collection<? extends File>)sources.getAllFiles(), (Collection<? extends File>)sources.getCrossCompiledFiles(), (Collection<? extends File>)this.getSourceMapRoots(), libraries, this.getFriendBuildTargetsMetaFiles(), this.getOutputFile());
        return true;
    }

    @Override
    public void doAfterBuild() {
        this.copyJsLibraryFilesIfNeeded();
    }

    private final void copyJsLibraryFilesIfNeeded() {
        if (ModuleSettingsKt.getKotlinCompilerSettings(this.getModule()).getCopyJsLibraryFiles()) {
            String outputLibraryRuntimeDirectory = new File(this.getOutputDir(), ModuleSettingsKt.getKotlinCompilerSettings(this.getModule()).getOutputDirectoryForJsLibraryFiles()).getAbsolutePath();
            List<String> list = this.getLibraryFiles();
            String string2 = outputLibraryRuntimeDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"outputLibraryRuntimeDirectory");
            JsLibraryUtils.copyJsFilesFromLibraries(list, string2, ModuleSettingsKt.getK2JsCompilerArguments(this.getModule()).getSourceMap());
        }
    }

    private final List<File> getSourceMapRoots() {
        List list;
        CharSequence charSequence = ModuleSettingsKt.getK2JsCompilerArguments(this.getModule()).getSourceMapPrefix();
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            list = CollectionsKt.emptyList();
        } else {
            Iterable $this$filterTo$iv$iv;
            Comparable<URI> comparable;
            URI it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            JpsUrlList jpsUrlList = this.getModule().getContentRootsList();
            Intrinsics.checkNotNullExpressionValue((Object)jpsUrlList, (String)"module.contentRootsList");
            List list2 = jpsUrlList.getUrls();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"module.contentRootsList.urls");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                comparable = URI.create((String)((Object)it));
                collection.add(comparable);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (URI)element$iv$iv;
                boolean bl4 = false;
                URI uRI = it;
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"it");
                if (!Intrinsics.areEqual((Object)uRI.getScheme(), (Object)"file")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (URI)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                URI uRI = it;
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"it");
                comparable = new File(uRI.getPath());
                collection.add(comparable);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getFriendBuildTargetsMetaFiles() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getFriendBuildTargets();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String string2;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv$iv;
            boolean bl2 = false;
            KotlinModuleBuildTarget kotlinModuleBuildTarget = it;
            if (!(kotlinModuleBuildTarget instanceof KotlinJsModuleBuildTarget)) {
                kotlinModuleBuildTarget = null;
            }
            if (((object = (KotlinJsModuleBuildTarget)kotlinModuleBuildTarget) != null && (object = ((KotlinJsModuleBuildTarget)object).getOutputMetaFile()) != null && (object = ((File)object).getAbsoluteFile()) != null ? ((File)object).toString() : null) == null) continue;
            string2 = string2;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final File getOutputFile() {
        File file2;
        String string2 = this.getExplicitOutputPath();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            file2 = new File(it);
        } else {
            file2 = this.getImplicitOutputFile();
        }
        return file2;
    }

    private final String getExplicitOutputPath() {
        return this.isTests() ? ModuleSettingsKt.getTestOutputFilePath(this.getModule()) : ModuleSettingsKt.getProductionOutputFilePath(this.getModule());
    }

    private final File getImplicitOutputFile() {
        String suffix = this.isTests() ? "_test" : "";
        return new File(this.getOutputDir(), this.getModule().getName() + suffix + ".js");
    }

    private final String getOutputFileBaseName() {
        String string2 = this.getOutputFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"outputFile.path");
        return StringsKt.substringBeforeLast$default((String)string2, (String)".", null, (int)2, null);
    }

    @NotNull
    public final File getOutputMetaFile() {
        return new File(this.getOutputFileBaseName() + ".meta.js");
    }

    private final List<String> getLibraryFiles() {
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List result = list;
        boolean bl4 = false;
        JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator = this.getAllDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)jpsJavaDependenciesEnumerator, (String)"allDependencies");
        for (JpsLibrary library : jpsJavaDependenciesEnumerator.getLibraries()) {
            Iterator iterator2 = library.getRoots(JpsOrderRootType.COMPILED).iterator();
            while (iterator2.hasNext()) {
                JpsLibraryRoot root;
                JpsLibraryRoot jpsLibraryRoot = root = (JpsLibraryRoot)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)jpsLibraryRoot, (String)"root");
                String string2 = JpsPathUtil.urlToPath((String)jpsLibraryRoot.getUrl());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JpsPathUtil.urlToPath(root.url)");
                result.add(string2);
            }
        }
        return list;
    }

    private final List<String> getDependenciesMetaFiles() {
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List result = list;
        boolean bl4 = false;
        this.getAllDependencies().processModules((Consumer)new Consumer<JpsModule>(result, this){
            final /* synthetic */ List $result;
            final /* synthetic */ KotlinJsModuleBuildTarget this$0;
            {
                this.$result = list;
                this.this$0 = kotlinJsModuleBuildTarget;
            }

            public final void consume(JpsModule module) {
                if (this.this$0.isTests()) {
                    JpsModule jpsModule = module;
                    Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"module");
                    KotlinJsModuleBuildTarget.access$addDependencyMetaFile(this.this$0, jpsModule, this.$result, true);
                }
                JpsModule jpsModule = module;
                Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"module");
                KotlinJsModuleBuildTarget.access$addDependencyMetaFile(this.this$0, jpsModule, this.$result, false);
            }
        });
        return list;
    }

    private final void addDependencyMetaFile(JpsModule module, List<String> result, boolean isTests) {
        KotlinModuleBuildTarget<?> dependencyBuildTarget = this.getKotlinContext().getTargetsBinding().get(JpsUtilKt.ModuleBuildTarget(module, isTests));
        if (Intrinsics.areEqual(dependencyBuildTarget, (Object)this) ^ true && dependencyBuildTarget instanceof KotlinJsModuleBuildTarget) {
            File metaFile;
            Map<File, KotlinModuleBuildTarget.Source> map2 = dependencyBuildTarget.getSources();
            boolean bl = false;
            if (!map2.isEmpty() && (metaFile = ((KotlinJsModuleBuildTarget)dependencyBuildTarget).getOutputMetaFile()).exists()) {
                String string2 = metaFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"metaFile.absolutePath");
                result.add(string2);
            }
        }
    }

    @Override
    @NotNull
    public JpsIncrementalJsCache createCacheStorage(@NotNull BuildDataPaths paths) {
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        return new JpsIncrementalJsCache(this.getJpsModuleBuildTarget(), paths, this.getKotlinContext().getFileToPathConverter());
    }

    @Override
    public void updateCaches(@NotNull KotlinDirtySourceFilesHolder dirtyFilesHolder2, @NotNull JpsIncrementalCache jpsIncrementalCache, @NotNull List<? extends GeneratedFile> files2, @NotNull ChangesCollector changesCollector, @NotNull JpsCompilerEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)dirtyFilesHolder2, (String)"dirtyFilesHolder");
        Intrinsics.checkNotNullParameter((Object)jpsIncrementalCache, (String)"jpsIncrementalCache");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super.updateCaches(dirtyFilesHolder2, jpsIncrementalCache, files2, changesCollector, environment);
        IncrementalResultsConsumer incrementalResultsConsumer = environment.getServices().get(IncrementalResultsConsumer.class);
        if (incrementalResultsConsumer == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumerImpl");
        }
        IncrementalResultsConsumerImpl incrementalResults = (IncrementalResultsConsumerImpl)incrementalResultsConsumer;
        IncrementalJsCache jsCache = (IncrementalJsCache)((Object)jpsIncrementalCache);
        jsCache.setHeader(incrementalResults.getHeaderMetadata());
        jsCache.compareAndUpdate(incrementalResults, changesCollector);
        jsCache.clearCacheForRemovedClasses(changesCollector);
    }

    public KotlinJsModuleBuildTarget(@NotNull KotlinCompileContext kotlinContext2, @NotNull ModuleBuildTarget jpsModuleBuildTarget) {
        Intrinsics.checkNotNullParameter((Object)kotlinContext2, (String)"kotlinContext");
        Intrinsics.checkNotNullParameter((Object)jpsModuleBuildTarget, (String)"jpsModuleBuildTarget");
        super(kotlinContext2, jpsModuleBuildTarget);
    }

    public static final /* synthetic */ void access$addDependencyMetaFile(KotlinJsModuleBuildTarget $this, JpsModule module, List result, boolean isTests) {
        $this.addDependencyMetaFile(module, result, isTests);
    }
}

