/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector;

import com.intellij.designer.LightToolWindowContent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.uiDesigner.componentTree.ComponentTree;
import com.intellij.uiDesigner.componentTree.ComponentTreeBuilder;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyInspector;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DesignerToolWindow
implements LightToolWindowContent {
    private final MyToolWindowPanel myToolWindowPanel;
    private ComponentTree myComponentTree;
    private ComponentTreeBuilder myComponentTreeBuilder;
    private PropertyInspector myPropertyInspector;

    public DesignerToolWindow(@NotNull Project project) {
        if (project == null) {
            DesignerToolWindow.$$$reportNull$$$0(0);
        }
        this.myToolWindowPanel = new MyToolWindowPanel();
        this.myComponentTree = new ComponentTree(project);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myComponentTree));
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)8));
        scrollPane.setPreferredSize(new Dimension(250, -1));
        this.myComponentTree.initQuickFixManager(scrollPane.getViewport());
        this.myPropertyInspector = new PropertyInspector(project, this.myComponentTree);
        this.myToolWindowPanel.setFirstComponent(scrollPane);
        this.myToolWindowPanel.setSecondComponent(this.myPropertyInspector);
    }

    public void dispose() {
        this.clearTreeBuilder();
        this.myToolWindowPanel.dispose();
        this.myComponentTree = null;
        this.myPropertyInspector = null;
    }

    private void clearTreeBuilder() {
        if (this.myComponentTreeBuilder != null) {
            Disposer.dispose((Disposable)this.myComponentTreeBuilder);
            this.myComponentTreeBuilder = null;
        }
    }

    public void update(GuiEditor designer) {
        this.clearTreeBuilder();
        this.myComponentTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.myComponentTree.setEditor(designer);
        this.myPropertyInspector.setEditor(designer);
        if (designer == null) {
            this.myComponentTree.setFormEditor(null);
        } else {
            this.myComponentTree.setFormEditor(designer.getEditor());
            this.myComponentTreeBuilder = new ComponentTreeBuilder(this.myComponentTree, designer);
        }
    }

    public JComponent getToolWindowPanel() {
        return this.myToolWindowPanel;
    }

    public ComponentTree getComponentTree() {
        return this.myComponentTree;
    }

    public ComponentTreeBuilder getComponentTreeBuilder() {
        return this.myComponentTreeBuilder;
    }

    public void updateComponentTree() {
        if (this.myComponentTreeBuilder != null) {
            this.myComponentTreeBuilder.queueUpdate();
        }
    }

    public PropertyInspector getPropertyInspector() {
        return this.myPropertyInspector;
    }

    public void refreshErrors() {
        if (this.myComponentTree != null) {
            this.myComponentTree.refreshIntentionHint();
            this.myComponentTree.repaint(this.myComponentTree.getVisibleRect());
        }
        if (this.myPropertyInspector != null) {
            this.myPropertyInspector.refreshIntentionHint();
            this.myPropertyInspector.repaint(this.myPropertyInspector.getVisibleRect());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uiDesigner/propertyInspector/DesignerToolWindow", "<init>"));
    }

    private class MyToolWindowPanel
    extends Splitter
    implements DataProvider {
        MyToolWindowPanel() {
            super(true, 0.33f);
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MyToolWindowPanel.$$$reportNull$$$0(0);
            }
            if (GuiEditor.DATA_KEY.is(dataId) && DesignerToolWindow.this.myComponentTree != null) {
                return DesignerToolWindow.this.myComponentTree.getData(dataId);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/uiDesigner/propertyInspector/DesignerToolWindow$MyToolWindowPanel", "getData"));
        }
    }
}

