/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.make;

import com.intellij.compiler.PsiClassWriter;
import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.uiDesigner.actions.PreviewFormAction;
import com.intellij.uiDesigner.compiler.AsmCodeGenerator;
import com.intellij.uiDesigner.compiler.CodeGenerationException;
import com.intellij.uiDesigner.compiler.FormErrorInfo;
import com.intellij.uiDesigner.compiler.NestedFormLoader;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.make.PsiNestedFormLoader;
import com.intellij.util.ArrayUtilRt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class PreviewNestedFormLoader
extends PsiNestedFormLoader {
    private final String myTempPath;
    private final InstrumentationClassFinder myFinder;
    private final Set<String> myGeneratedClasses = new HashSet<String>();

    public PreviewNestedFormLoader(Module module, String tempPath, InstrumentationClassFinder finder) {
        super(module);
        this.myTempPath = tempPath;
        this.myFinder = finder;
    }

    @Override
    public LwRootContainer loadForm(String formFileName) throws Exception {
        LwRootContainer rootContainer = super.loadForm(formFileName);
        if (!this.myGeneratedClasses.contains(formFileName)) {
            this.myGeneratedClasses.add(formFileName);
            String generatedClassName = "FormPreviewFrame" + this.myGeneratedClasses.size();
            PreviewFormAction.setPreviewBindings(rootContainer, generatedClassName);
            this.generateStubClass(rootContainer, generatedClassName);
        }
        return rootContainer;
    }

    private void generateStubClass(LwRootContainer rootContainer, String generatedClassName) throws IOException, CodeGenerationException {
        @NonNls ClassWriter cw = new ClassWriter(2);
        cw.visit(196653, 1, generatedClassName, null, "java/lang/Object", ArrayUtilRt.EMPTY_STRING_ARRAY);
        cw.visitField(1, "myComponent", "Ljavax/swing/JComponent;", null, null);
        @NonNls MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        ByteArrayInputStream bais = new ByteArrayInputStream(cw.toByteArray());
        AsmCodeGenerator acg = new AsmCodeGenerator(rootContainer, this.myFinder, (NestedFormLoader)this, true, (ClassWriter)new PsiClassWriter(this.myModule));
        byte[] data = acg.patchClass((InputStream)bais);
        FormErrorInfo[] errors = acg.getErrors();
        if (errors.length > 0) {
            throw new CodeGenerationException(errors[0].getComponentId(), errors[0].getErrorMessage());
        }
        FileUtil.writeToFile((File)new File(this.myTempPath, generatedClassName + ".class"), (byte[])data);
    }
}

