/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.uiDesigner.ErrorAnalyzer;
import com.intellij.uiDesigner.ErrorInfo;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.GuiFormFileType;
import com.intellij.uiDesigner.PsiPropertiesProvider;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.inspections.FormEditorErrorCollector;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.inspections.FormFileErrorCollector;
import com.intellij.uiDesigner.inspections.FormInspectionTool;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IRootContainer;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import com.intellij.uiDesigner.radComponents.RadComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFormInspection
extends AbstractBaseJavaLocalInspectionTool
implements FormInspectionTool {
    private final String myInspectionKey;

    public BaseFormInspection(@NonNls @NotNull String inspectionKey) {
        if (inspectionKey == null) {
            BaseFormInspection.$$$reportNull$$$0(0);
        }
        this.myInspectionKey = inspectionKey;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = UIDesignerBundle.message("form.inspections.group", new Object[0]);
        if (string == null) {
            BaseFormInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    @NonNls
    public String getShortName() {
        String string = this.myInspectionKey;
        if (string == null) {
            BaseFormInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean isActive(PsiElement psiRoot) {
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)psiRoot.getProject()).getCurrentProfile();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)this.myInspectionKey);
        return key != null && profile.isToolEnabled(key, psiRoot);
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        LwRootContainer rootContainer;
        if (file == null) {
            BaseFormInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            BaseFormInspection.$$$reportNull$$$0(4);
        }
        if (!file.getFileType().equals(GuiFormFileType.INSTANCE)) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)file.getProject());
        if (module == null) {
            return null;
        }
        try {
            rootContainer = Utils.getRootContainer((String)file.getText(), (PropertiesProvider)new PsiPropertiesProvider(module));
        }
        catch (Exception e) {
            return null;
        }
        if (ErrorAnalyzer.isSuppressed((IRootContainer)rootContainer, this, null)) {
            return null;
        }
        FormFileErrorCollector collector = new FormFileErrorCollector(file, manager, isOnTheFly);
        this.startCheckForm((IRootContainer)rootContainer);
        FormEditingUtil.iterate((IComponent)rootContainer, component -> {
            if (!ErrorAnalyzer.isSuppressed((IRootContainer)rootContainer, this, component.getId())) {
                this.checkComponentProperties(module, component, collector);
            }
            return true;
        });
        this.doneCheckForm((IRootContainer)rootContainer);
        return collector.result();
    }

    @Override
    public void startCheckForm(IRootContainer rootContainer) {
    }

    @Override
    public void doneCheckForm(IRootContainer rootContainer) {
    }

    @Override
    public ErrorInfo @Nullable [] checkComponent(@NotNull GuiEditor editor, @NotNull RadComponent component) {
        if (editor == null) {
            BaseFormInspection.$$$reportNull$$$0(5);
        }
        if (component == null) {
            BaseFormInspection.$$$reportNull$$$0(6);
        }
        FormEditorErrorCollector collector = new FormEditorErrorCollector(editor, component);
        this.checkComponentProperties(component.getModule(), component, collector);
        return collector.result();
    }

    protected abstract void checkComponentProperties(Module var1, @NotNull IComponent var2, FormErrorCollector var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionKey";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/inspections/BaseFormInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/inspections/BaseFormInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

