/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.GradleUtil;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.parser.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectBuildModelImpl
implements ProjectBuildModel {
    @NotNull
    private final BuildModelContext myBuildModelContext;
    @Nullable
    private final GradleBuildFile myProjectBuildFile;

    @NotNull
    public static ProjectBuildModel get(@NotNull Project project) {
        if (project == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(0);
        }
        VirtualFile file = GradleUtil.getGradleBuildFile(GradleUtil.getBaseDirPath(project));
        return new ProjectBuildModelImpl(project, file);
    }

    @Nullable
    public static ProjectBuildModel get(@NotNull Project hostProject, @NotNull String compositeRoot) {
        VirtualFile file;
        if (hostProject == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(1);
        }
        if (compositeRoot == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(2);
        }
        if ((file = GradleUtil.getGradleBuildFile(new File(compositeRoot))) == null) {
            return null;
        }
        return new ProjectBuildModelImpl(hostProject, file);
    }

    private ProjectBuildModelImpl(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(3);
        }
        this.myBuildModelContext = BuildModelContext.create(project);
        GradleBuildFile gradleBuildFile = this.myProjectBuildFile = file != null ? new GradleBuildFile(file, project, project.getName(), this.myBuildModelContext) : null;
        if (this.myProjectBuildFile != null) {
            this.myBuildModelContext.setRootProjectFile(this.myProjectBuildFile);
            ApplicationManager.getApplication().runReadAction(() -> {
                GradleBuildModelImpl.populateWithParentModuleSubProjectsProperties(this.myProjectBuildFile, this.myBuildModelContext);
                GradleBuildModelImpl.populateSiblingDslFileWithGradlePropertiesFile(this.myProjectBuildFile, this.myBuildModelContext);
                this.myProjectBuildFile.parse();
            });
            this.myBuildModelContext.putBuildFile(file.getUrl(), this.myProjectBuildFile);
        }
    }

    @Nullable
    public GradleBuildModel getProjectBuildModel() {
        return this.myProjectBuildFile == null ? null : new GradleBuildModelImpl(this.myProjectBuildFile);
    }

    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull Module module) {
        VirtualFile file;
        if (module == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(4);
        }
        return (file = GradleUtil.getGradleBuildFile(module)) == null ? null : this.getModuleBuildModel(file);
    }

    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull File modulePath) {
        VirtualFile file;
        if (modulePath == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(5);
        }
        return (file = GradleUtil.getGradleBuildFile(modulePath)) == null ? null : this.getModuleBuildModel(file);
    }

    @NotNull
    public GradleBuildModel getModuleBuildModel(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(6);
        }
        GradleBuildFile dslFile = this.myBuildModelContext.getOrCreateBuildFile(file, false);
        return new GradleBuildModelImpl(dslFile);
    }

    @Nullable
    public GradleSettingsModel getProjectSettingsModel() {
        VirtualFile virtualFile = null;
        if (this.myProjectBuildFile == null) {
            VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)this.myBuildModelContext.getProject());
            if (projectDir != null) {
                File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)projectDir);
                virtualFile = GradleUtil.getGradleSettingsFile(ioFile);
            }
        } else {
            virtualFile = this.myProjectBuildFile.tryToFindSettingsFile();
        }
        if (virtualFile == null) {
            return null;
        }
        GradleSettingsFile settingsFile = this.myBuildModelContext.getOrCreateSettingsFile(virtualFile);
        return new GradleSettingsModelImpl(settingsFile);
    }

    public void applyChanges() {
        this.runOverProjectTree(file -> {
            file.applyChanges();
            file.saveAllChanges();
        });
    }

    public void resetState() {
        this.runOverProjectTree(GradleDslElementImpl::resetState);
    }

    public void reparse() {
        List<GradleDslFile> files = this.myBuildModelContext.getAllRequestedFiles();
        this.myBuildModelContext.reset();
        files.forEach(GradleDslFile::reparse);
    }

    @NotNull
    public List<GradleBuildModel> getAllIncludedBuildModels() {
        GradleSettingsModel settingsModel;
        ArrayList<GradleBuildModel> allModels = new ArrayList<GradleBuildModel>();
        if (this.myProjectBuildFile != null) {
            allModels.add(new GradleBuildModelImpl(this.myProjectBuildFile));
        }
        if ((settingsModel = this.getProjectSettingsModel()) == null) {
            ArrayList<GradleBuildModel> arrayList = allModels;
            if (arrayList == null) {
                ProjectBuildModelImpl.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        allModels.addAll(settingsModel.modulePaths().stream().map(modulePath -> {
            if (modulePath.equals(":")) {
                return null;
            }
            File moduleDir = settingsModel.moduleDirectory(modulePath);
            if (moduleDir == null) {
                return null;
            }
            VirtualFile file = GradleUtil.getGradleBuildFile(moduleDir);
            if (file == null) {
                return null;
            }
            return this.getModuleBuildModel(file);
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        ArrayList<GradleBuildModel> arrayList = allModels;
        if (arrayList == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private void runOverProjectTree(@NotNull Consumer<GradleDslFile> func) {
        if (func == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(9);
        }
        this.myBuildModelContext.getAllRequestedFiles().forEach(func);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostProject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compositeRoot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/ProjectBuildModelImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/ProjectBuildModelImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllIncludedBuildModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModuleBuildModel";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runOverProjectTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

