/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.ui.content.Content;
import com.intellij.util.PathsList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.CoroutineDebuggerMode;
import org.jetbrains.kotlin.idea.debugger.coroutine.DebuggerConnection$WhenMappings;
import org.jetbrains.kotlin.idea.debugger.coroutine.DebuggerConnectionKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CreateContentParams;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CreateContentParamsProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.XCoroutineView;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\nH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u001cH\u0016J\u001a\u0010)\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010*\u001a\u0004\u0018\u00010'H\u0002J\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-H\u0016J\u0012\u0010/\u001a\u0004\u0018\u00010\u00022\u0006\u00100\u001a\u000201H\u0002R\u0015\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/DebuggerConnection;", "Lcom/intellij/xdebugger/XDebuggerManagerListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "modifyArgs", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/JavaParameters;Z)V", "getConfiguration", "()Lcom/intellij/execution/configurations/RunConfigurationBase;", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "coroutineAgentAttached", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "getParams", "()Lcom/intellij/execution/configurations/JavaParameters;", "getProject", "()Lcom/intellij/openapi/project/Project;", "connect", "", "coroutinesPanelShouldBeShown", "createContent", "Lcom/intellij/ui/content/Content;", "ui", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "createContentParamProvider", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CreateContentParamsProvider;", "determineCoreVersionMode", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerMode;", "kotlinxCoroutinesCore", "", "dispose", "initializeCoroutineAgent", "it", "processStarted", "debugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "processStopped", "registerXCoroutinesPanel", "session", "Lcom/intellij/xdebugger/XDebugSession;", "kotlin.jvm-debugger.coroutines"})
public final class DebuggerConnection
implements XDebuggerManagerListener,
Disposable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private MessageBusConnection connection;
    private final boolean coroutineAgentAttached;
    private final ReadOnlyProperty log$delegate;
    @NotNull
    private final Project project;
    @NotNull
    private final RunConfigurationBase<?> configuration;
    @Nullable
    private final JavaParameters params;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(DebuggerConnection.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0))};
    }

    private final Logger getLog() {
        return (Logger)this.log$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final CoroutineDebuggerMode determineCoreVersionMode(String kotlinxCoroutinesCore) {
        Regex regex = new Regex(".+\\Wkotlinx-coroutines-core(-jvm)?-(\\d[\\w.\\-]+)?\\.jar");
        MatchResult matchResult = regex.matchEntire((CharSequence)kotlinxCoroutinesCore);
        if (matchResult == null) {
            return CoroutineDebuggerMode.DISABLED;
        }
        MatchResult matchResult2 = matchResult;
        DefaultArtifactVersion versionToCompareTo = new DefaultArtifactVersion("1.3.7-255");
        DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion((String)matchResult2.getGroupValues().get(2));
        return artifactVersion.compareTo((ArtifactVersion)versionToCompareTo) > 0 ? CoroutineDebuggerMode.VERSION_1_3_8_AND_UP : CoroutineDebuggerMode.DISABLED;
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeCoroutineAgent(JavaParameters params, String it) {
        ParametersList parametersList = params.getVMParametersList();
        if (parametersList != null) {
            parametersList.add("-javaagent:" + it);
        }
        if (params.isClasspathFile()) {
            void $this$filterTo$iv$iv;
            PathsList pathsList = params.getClassPath();
            Intrinsics.checkNotNullExpressionValue((Object)pathsList, (String)"params.classPath");
            List list = pathsList.getRootDirs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"params.classPath.rootDirs");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it2 = (VirtualFile)element$iv$iv;
                boolean bl = false;
                VirtualFile virtualFile = it2;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                if (!DebuggerConnectionKt.isKotlinStdlib(virtualFile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                VirtualFileSystem fs;
                VirtualFile it3 = (VirtualFile)element$iv;
                boolean bl = false;
                VirtualFile virtualFile = it3;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile.getFileSystem(), (String)"it.fileSystem");
                if (fs instanceof ArchiveFileSystem) {
                    VirtualFile virtualFile2 = ((ArchiveFileSystem)fs).getLocalByEntry(it3);
                    string = virtualFile2 != null ? virtualFile2.getPath() : null;
                } else {
                    string = it3.getPath();
                }
                String path = string;
                it3.putUserData(JdkUtil.AGENT_RUNTIME_CLASSPATH, (Object)path);
            }
        }
    }

    private final void connect() {
        block0: {
            MessageBusConnection messageBusConnection = this.connection = this.project.getMessageBus().connect();
            if (messageBusConnection == null) break block0;
            messageBusConnection.subscribe(XDebuggerManager.TOPIC, (Object)this);
        }
    }

    public void processStarted(@NotNull XDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        DebuggerInvocationUtil.swingInvokeLater((Project)this.project, (Runnable)new Runnable(this, debugProcess){
            final /* synthetic */ DebuggerConnection this$0;
            final /* synthetic */ XDebugProcess $debugProcess;

            public final void run() {
                block1: {
                    if (!(this.$debugProcess instanceof JavaDebugProcess) || Disposer.isDisposed((Disposable)this.this$0) || !DebuggerConnection.access$coroutinesPanelShouldBeShown(this.this$0)) break block1;
                    XDebugSession xDebugSession = ((JavaDebugProcess)this.$debugProcess).getSession();
                    Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"debugProcess.session");
                    Disposable disposable = DebuggerConnection.access$registerXCoroutinesPanel(this.this$0, xDebugSession);
                    if (disposable != null) {
                        Disposable disposable2 = disposable;
                        boolean bl = false;
                        boolean bl2 = false;
                        Disposable it = disposable2;
                        boolean bl3 = false;
                        Disposer.register((Disposable)this.this$0, (Disposable)it);
                    }
                }
            }
            {
                this.this$0 = debuggerConnection;
                this.$debugProcess = xDebugProcess;
            }
        });
    }

    public void processStopped(@NotNull XDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        ApplicationManager.getApplication().invokeLater(new Runnable(this){
            final /* synthetic */ DebuggerConnection this$0;

            public final void run() {
                Disposer.dispose((Disposable)this.this$0);
            }
            {
                this.this$0 = debuggerConnection;
            }
        });
    }

    private final Disposable registerXCoroutinesPanel(XDebugSession session) {
        RunnerLayoutUi runnerLayoutUi = session.getUI();
        if (runnerLayoutUi == null) {
            return null;
        }
        RunnerLayoutUi ui = runnerLayoutUi;
        XDebugSession xDebugSession = session;
        if (xDebugSession == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
        }
        XCoroutineView xCoroutineThreadView = new XCoroutineView(this.project, (XDebugSession)((XDebugSessionImpl)xDebugSession));
        Content framesContent = this.createContent(ui, xCoroutineThreadView);
        framesContent.setCloseable(false);
        ui.addContent(framesContent, 0, PlaceInGrid.right, false);
        session.addSessionListener((XDebugSessionListener)xCoroutineThreadView.debugSessionListener(session));
        session.rebuildViews();
        return xCoroutineThreadView;
    }

    private final boolean coroutinesPanelShouldBeShown() {
        return this.configuration instanceof ExternalSystemRunConfiguration || this.coroutineAgentAttached;
    }

    private final Content createContent(RunnerLayoutUi ui, CreateContentParamsProvider createContentParamProvider) {
        CreateContentParams param = createContentParamProvider.createContentParams();
        Content content = ui.createContent(param.getId(), param.getComponent(), param.getDisplayName(), param.getIcon(), param.getParentComponent());
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"ui.createContent(param.i\u2026n, param.parentComponent)");
        return content;
    }

    public void dispose() {
        MessageBusConnection messageBusConnection = this.connection;
        if (messageBusConnection != null) {
            messageBusConnection.disconnect();
        }
        this.connection = null;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final RunConfigurationBase<?> getConfiguration() {
        return this.configuration;
    }

    @Nullable
    public final JavaParameters getParams() {
        return this.params;
    }

    public DebuggerConnection(@NotNull Project project, @NotNull RunConfigurationBase<?> configuration, @Nullable JavaParameters params, boolean modifyArgs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        this.project = project;
        this.configuration = configuration;
        this.params = params;
        this.log$delegate = ProvidersKt.getLogger();
        boolean agentAttached = false;
        if (this.params instanceof JavaParameters && modifyArgs) {
            String kotlinxCoroutinesCore;
            String string;
            Object object = this.params.getClassPath();
            if (object != null && (object = object.getPathList()) != null) {
                Object v2;
                block8: {
                    Iterable $this$firstOrNull$iv = (Iterable)object;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        String string2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
                        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"kotlinx-coroutines-core", (boolean)false, (int)2, null)) continue;
                        v2 = element$iv;
                        break block8;
                    }
                    v2 = null;
                }
                string = v2;
            } else {
                string = kotlinxCoroutinesCore = null;
            }
            if (kotlinxCoroutinesCore != null) {
                switch (DebuggerConnection$WhenMappings.$EnumSwitchMapping$0[this.determineCoreVersionMode(kotlinxCoroutinesCore).ordinal()]) {
                    case 1: {
                        this.initializeCoroutineAgent(this.params, kotlinxCoroutinesCore);
                        agentAttached = true;
                        break;
                    }
                    default: {
                        this.getLog().debug("CoroutineDebugger disabled.");
                    }
                }
            }
        }
        this.coroutineAgentAttached = agentAttached;
        this.connect();
    }

    public /* synthetic */ DebuggerConnection(Project project, RunConfigurationBase runConfigurationBase, JavaParameters javaParameters, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(project, runConfigurationBase, javaParameters, bl);
    }

    public static final /* synthetic */ boolean access$coroutinesPanelShouldBeShown(DebuggerConnection $this) {
        return $this.coroutinesPanelShouldBeShown();
    }

    public static final /* synthetic */ Disposable access$registerXCoroutinesPanel(DebuggerConnection $this, XDebugSession session) {
        return $this.registerXCoroutinesPanel(session);
    }
}

