/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scripting.gradle;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.core.script.settings.KotlinScriptingSettings;
import org.jetbrains.kotlin.idea.scripting.gradle.GradleImportHelperKt;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRoot;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRootsManager;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.project.GradlePartialResolverPolicy;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0006\u0010\t\u001a\u00020\n\u001a\u0006\u0010\u000b\u001a\u00020\n\u001a\b\u0010\f\u001a\u0004\u0018\u00010\n\u001a\u0006\u0010\r\u001a\u00020\n\u001a\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0018"}, d2={"scriptConfigurationsNeedToBeUpdatedBalloon", "", "getScriptConfigurationsNeedToBeUpdatedBalloon", "()Z", "autoReloadScriptConfigurations", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "configurationsAreMissingAfterRequest", "", "configurationsAreMissingRequestNeeded", "configurationsAreMissingRequestNeededHelp", "getConfigurationsActionText", "getGradleVersion", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "runPartialGradleImport", "", "root", "Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRoot;", "runPartialGradleImportForAllRoots", "scriptConfigurationsAreUpToDate", "scriptConfigurationsNeedToBeUpdated", "kotlin.gradle.gradle-idea"})
public final class GradleImportHelperKt {
    public static final boolean getScriptConfigurationsNeedToBeUpdatedBalloon() {
        return Registry.is((String)"kotlin.gradle.scripts.scriptConfigurationsNeedToBeUpdatedFloatingNotification", (boolean)true);
    }

    public static final void runPartialGradleImportForAllRoots(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$forEach$iv = GradleBuildRootsManager.Companion.getInstance(project).getAllRoots();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleBuildRoot root = (GradleBuildRoot)element$iv;
            boolean bl = false;
            GradleImportHelperKt.runPartialGradleImport(project, root);
        }
    }

    public static final void runPartialGradleImport(@NotNull Project project, @NotNull GradleBuildRoot root) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (root.isImportingInProgress()) {
            return;
        }
        ExternalSystemUtil.refreshProject((String)root.getPathPrefix(), (ImportSpecBuilder)new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID).projectResolverPolicy((ProjectResolverPolicy)new GradlePartialResolverPolicy((Predicate)runPartialGradleImport.1.INSTANCE)));
    }

    @NotNull
    public static final String configurationsAreMissingRequestNeeded() {
        return KotlinIdeaGradleBundle.message("notification.wasNotImportedAfterCreation.text", new Object[0]);
    }

    @NotNull
    public static final String getConfigurationsActionText() {
        return KotlinIdeaGradleBundle.message("action.text.load.script.configurations", new Object[0]);
    }

    @Nullable
    public static final String configurationsAreMissingRequestNeededHelp() {
        return KotlinIdeaGradleBundle.message("notification.wasNotImportedAfterCreation.help", new Object[0]);
    }

    @NotNull
    public static final String configurationsAreMissingAfterRequest() {
        return KotlinIdeaGradleBundle.message("notification.notEvaluatedInLastImport.text", new Object[0]);
    }

    public static final boolean autoReloadScriptConfigurations(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ScriptDefinition scriptDefinition = DefinitionsKt.findScriptDefinition((VirtualFile)file, (Project)project);
        if (scriptDefinition == null) {
            return false;
        }
        ScriptDefinition definition = scriptDefinition;
        return KotlinScriptingSettings.Companion.getInstance(project).autoReloadConfigurations(definition);
    }

    public static final void scriptConfigurationsNeedToBeUpdated(@NotNull Project project, @NotNull VirtualFile file) {
        block0: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!GradleImportHelperKt.autoReloadScriptConfigurations(project, file) || (object = GradleBuildRootsManager.Companion.getInstance(project).getScriptInfo(file)) == null || (object = object.getBuildRoot()) == null) break block0;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            GradleImportHelperKt.runPartialGradleImport(project, (GradleBuildRoot)it);
        }
    }

    public static final boolean scriptConfigurationsAreUpToDate(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    @NotNull
    public static final String getGradleVersion(@NotNull Project project, @NotNull GradleProjectSettings settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        File file = ((GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class)).getGradleHome(project, settings.getExternalProjectPath());
        String string = GradleInstallationManager.getGradleVersion((String)(file != null ? file.getPath() : null));
        if (string == null) {
            GradleVersion gradleVersion = GradleVersion.current();
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"GradleVersion.current()");
            String string2 = gradleVersion.getVersion();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GradleVersion.current().version");
        }
        return string;
    }
}

