/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.klib;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004J$\u0010\u0012\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/klib/KotlinNativeLibraryNameUtil;", "", "()V", "GRADLE_LIBRARY_PREFIX", "", "IDE_LIBRARY_NAME_REGEX", "Lkotlin/text/Regex;", "KOTLIN_NATIVE_LIBRARY_PREFIX", "KOTLIN_NATIVE_LIBRARY_PREFIX_PLUS_SPACE", "buildIDELibraryName", "kotlinVersion", "libraryName", "platforms", "", "starredPlatform", "isGradleLibraryName", "", "ideLibraryName", "parseIDELibraryName", "Lkotlin/Triple;", "kotlin.gradle.gradle-idea"})
public final class KotlinNativeLibraryNameUtil {
    @NonNls
    @NotNull
    public static final String KOTLIN_NATIVE_LIBRARY_PREFIX = "Kotlin/Native";
    @NotNull
    public static final String KOTLIN_NATIVE_LIBRARY_PREFIX_PLUS_SPACE = "Kotlin/Native ";
    @NonNls
    @NotNull
    public static final String GRADLE_LIBRARY_PREFIX = "Gradle: ";
    private static final Regex IDE_LIBRARY_NAME_REGEX;
    public static final KotlinNativeLibraryNameUtil INSTANCE;

    @NotNull
    public final String buildIDELibraryName(@NotNull String kotlinVersion2, @NotNull String libraryName, @NotNull Collection<String> platforms, @Nullable String starredPlatform) {
        String string;
        Intrinsics.checkNotNullParameter((Object)kotlinVersion2, (String)"kotlinVersion");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        Intrinsics.checkNotNullParameter(platforms, (String)"platforms");
        Collection<String> collection = platforms;
        boolean bl = false;
        if (!collection.isEmpty()) {
            boolean bl2 = false;
            bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl5 = false;
            $this$buildString.append(" [");
            CollectionsKt.joinTo$default((Iterable)CollectionsKt.sorted((Iterable)platforms), (Appendable)$this$buildString, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(platforms, starredPlatform){
                final /* synthetic */ Collection $platforms$inlined;
                final /* synthetic */ String $starredPlatform$inlined;
                {
                    this.$platforms$inlined = collection;
                    this.$starredPlatform$inlined = string;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$starredPlatform$inlined) ? (CharSequence)(it + "(*)") : (CharSequence)it;
                }
            }), (int)62, null);
            $this$buildString.append("]");
            String string2 = stringBuilder.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        } else {
            string = "";
        }
        String platformNamePart = string;
        return KOTLIN_NATIVE_LIBRARY_PREFIX_PLUS_SPACE + kotlinVersion2 + " - " + libraryName + platformNamePart;
    }

    public static /* synthetic */ String buildIDELibraryName$default(KotlinNativeLibraryNameUtil kotlinNativeLibraryNameUtil, String string, String string2, Collection collection, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        return kotlinNativeLibraryNameUtil.buildIDELibraryName(string, string2, collection, string3);
    }

    @Nullable
    public final Triple<String, String, String> parseIDELibraryName(@NotNull String ideLibraryName) {
        Intrinsics.checkNotNullParameter((Object)ideLibraryName, (String)"ideLibraryName");
        MatchResult matchResult = IDE_LIBRARY_NAME_REGEX.matchEntire((CharSequence)ideLibraryName);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        MatchGroup matchGroup = match.getGroups().get(1);
        Intrinsics.checkNotNull((Object)matchGroup);
        String kotlinVersion2 = matchGroup.getValue();
        MatchGroup matchGroup2 = match.getGroups().get(2);
        Intrinsics.checkNotNull((Object)matchGroup2);
        String libraryName = matchGroup2.getValue();
        MatchGroup matchGroup3 = match.getGroups().get(4);
        String platformPart = matchGroup3 != null ? matchGroup3.getValue() : null;
        return new Triple((Object)kotlinVersion2, (Object)libraryName, (Object)platformPart);
    }

    public final boolean isGradleLibraryName(@NotNull String ideLibraryName) {
        Intrinsics.checkNotNullParameter((Object)ideLibraryName, (String)"ideLibraryName");
        return StringsKt.startsWith$default((String)ideLibraryName, (String)GRADLE_LIBRARY_PREFIX, (boolean)false, (int)2, null);
    }

    private KotlinNativeLibraryNameUtil() {
    }

    static {
        KotlinNativeLibraryNameUtil kotlinNativeLibraryNameUtil;
        INSTANCE = kotlinNativeLibraryNameUtil = new KotlinNativeLibraryNameUtil();
        IDE_LIBRARY_NAME_REGEX = new Regex("^Kotlin/Native ([^\\s]+) - ([^\\s]+)( \\[([\\w ,()*]+)])?$");
    }
}

